/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.jnr.aqua.AquaUIPainter;

public abstract class AquaButtonIcon
implements Icon,
UIResource {
    protected final Image source;
    protected final boolean isTemplate;
    protected final Map<Key, Image> imageCache;
    protected final AquaButtonExtendedTypes.ColorDefaults colorDefaults;

    public AquaButtonIcon(Image image, boolean bl, AquaButtonExtendedTypes.ColorDefaults colorDefaults) {
        this.source = image;
        this.isTemplate = bl;
        this.colorDefaults = colorDefaults;
        this.imageCache = new HashMap<Key, Image>();
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    @Override
    public int getIconWidth() {
        return this.source.getWidth(null);
    }

    @Override
    public int getIconHeight() {
        return this.source.getHeight(null);
    }

    protected abstract Color getExistingColor();

    protected abstract Key getRenderingKey();

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        boolean bl;
        Key key = this.getRenderingKey();
        Image image = this.imageCache.get(key);
        if (image == null) {
            image = this.createImage(key);
            this.imageCache.put(key, image);
        }
        if (!(bl = graphics.drawImage(image, n, n2, component))) {
            new ImageIcon(image);
            if (!graphics.drawImage(image, n, n2, component)) {
                System.err.println("Button icon not drawn!");
            }
        }
    }

    protected boolean isNonexclusiveStyle(Key key) {
        return false;
    }

    protected Color getTemplateColor(Key key) {
        Object object;
        AquaUIPainter.State state = key.getState();
        boolean bl = this.isNonexclusiveStyle(key);
        if (state != AquaUIPainter.State.DISABLED && state != AquaUIPainter.State.DISABLED_INACTIVE && !bl && (object = this.getExistingColor()) != null && !(object instanceof UIResource)) {
            return object;
        }
        object = key.getButtonState();
        AquaButtonExtendedTypes.WidgetInfo widgetInfo = key.getWidgetInfo();
        return widgetInfo.getForeground(state, (AquaUIPainter.ButtonState)((Object)object), this.colorDefaults, bl, true);
    }

    protected Image createImage(Key key) {
        Image image;
        Color color;
        if (this.isTemplate && (color = this.getTemplateColor(key)) != null && (image = AquaImageFactory.createImageFromTemplate(this.source, color)) != null) {
            return image;
        }
        return this.createImageForKey(key);
    }

    protected Image createImageForKey(Key key) {
        AquaUIPainter.State state = key.getState();
        if (state == AquaUIPainter.State.PRESSED) {
            return AquaImageFactory.generatePressedDarkImage(this.source);
        }
        if (state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE) {
            return AquaImageFactory.generateDisabledLightImage(this.source);
        }
        return this.source;
    }

    public static final class Key {
        private AquaButtonExtendedTypes.WidgetInfo widgetInfo;
        private AquaUIPainter.State state;
        private AquaUIPainter.ButtonState bs;

        public Key(AquaButtonExtendedTypes.WidgetInfo widgetInfo, AquaUIPainter.State state, AquaUIPainter.ButtonState buttonState) {
            this.widgetInfo = widgetInfo;
            this.state = state;
            this.bs = buttonState;
        }

        public AquaButtonExtendedTypes.WidgetInfo getWidgetInfo() {
            return this.widgetInfo;
        }

        public AquaUIPainter.State getState() {
            return this.state;
        }

        public AquaUIPainter.ButtonState getButtonState() {
            return this.bs;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Key key = (Key)object;
            return Objects.equals(this.widgetInfo, key.widgetInfo) && this.state == key.state && this.bs == key.bs;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.widgetInfo, this.state, this.bs});
        }
    }
}

