/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable.ui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.dnd.DragSource;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.CellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.synth.Region;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.treetable.CellEditorContainer;
import org.violetlib.treetable.DefaultTreeTableCellEditor;
import org.violetlib.treetable.DefaultTreeTableCellRenderer;
import org.violetlib.treetable.TreeColumnModel;
import org.violetlib.treetable.TreeTable;
import org.violetlib.treetable.TreeTableCellEditor;
import org.violetlib.treetable.TreeTableCellRenderer;
import org.violetlib.treetable.TreeTableSorter;
import org.violetlib.treetable.ui.InternalTableWithMargins;
import org.violetlib.treetable.ui.TableInterface;
import org.violetlib.treetable.ui.TreeInterface;
import org.violetlib.treetable.ui.TreeTableUI;

public class BasicTreeTableUI
extends TreeTableUI {
    protected TreeTable treeTable;
    private JTree tree;
    private JTable table;
    protected Renderer treeTableCellRenderer;
    protected Editor treeTableCellEditor;
    protected DefaultTreeTableCellRenderer defaultTreeCellRenderer;
    protected Handler handler;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private MouseListener mouseListener;
    private MouseMotionListener mouseMotionListener;
    private List<String> properties;
    private PropertyChangeListener propertyChangeListener;
    private TreePath mouseOverSortPath;
    private int mouseOverSortColumn;
    private boolean paintMouseOverSortPath;
    private int sortWidth = -1;
    private Border ltrBorder;
    private Border rtlBorder;
    private Border noFocusBorder;
    private int treeHandleWidth = -1;

    @Override
    public void installUI(JComponent jComponent) {
        this.treeTable = (TreeTable)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        this.tree = null;
        this.table = null;
        this.treeTable = null;
    }

    protected void installDefaults() {
        AquaUtils.installFont(this.treeTable, "Table.font");
        if (this.treeTable.getAlternateRowColor() == null || this.treeTable.getAlternateRowColor() instanceof UIResource) {
            Color color = UIManager.getColor("Table.alternateRowColor");
            this.treeTable.setAlternateRowColor(color);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installComponents() {
        this.handler = this.createHandler();
        TreeTableCellRenderer treeTableCellRenderer = this.treeTable.getFocusRenderer();
        if (treeTableCellRenderer == null || treeTableCellRenderer instanceof UIResource) {
            this.treeTable.setFocusRenderer(this.createFocusRenderer());
        }
        this.tree = this.createAndConfigureTree();
        this.table = this.createAndConfigureTable();
        this.finishConfiguration(this.tree, this.table);
        this.treeTableCellRenderer = this.createCellRenderer();
        this.treeTableCellEditor = this.createCellEditor();
        this.defaultTreeCellRenderer = new DefaultTreeTableCellRenderer();
        this.tree.setCellRenderer(this.treeTableCellRenderer);
        if (this.treeTable.getRowSorter() != null) {
            this.table.setRowSorter(new RowSorterAdapter());
        }
    }

    protected void uninstallComponents() {
        this.unconfigureTree();
        this.unconfigureTable();
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        if (this.focusListener != null) {
            this.treeTable.addFocusListener(this.focusListener);
        }
        this.keyListener = this.createKeyListener();
        if (this.keyListener != null) {
            this.treeTable.addKeyListener(this.keyListener);
        }
        this.mouseListener = this.createMouseListener();
        if (this.mouseListener != null) {
            this.treeTable.addMouseListener(this.mouseListener);
        }
        this.mouseMotionListener = this.createMouseMotionListener();
        if (this.mouseMotionListener != null) {
            this.treeTable.addMouseMotionListener(this.mouseMotionListener);
        }
        this.properties = this.getProperties();
        if (this.properties == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
            if (this.propertyChangeListener != null) {
                this.treeTable.addPropertyChangeListener(this.propertyChangeListener);
            }
        } else if (!this.properties.isEmpty()) {
            this.propertyChangeListener = this.createPropertyChangeListener();
            if (this.propertyChangeListener != null) {
                for (String string : this.properties) {
                    this.treeTable.addPropertyChangeListener(string, this.propertyChangeListener);
                }
            }
        }
        if (this.propertyChangeListener == null) {
            this.properties = Collections.emptyList();
        }
    }

    protected void uninstallListeners() {
        if (this.focusListener != null) {
            this.treeTable.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (this.keyListener != null) {
            this.treeTable.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
        if (this.mouseListener != null) {
            this.treeTable.removeMouseListener(this.mouseListener);
            this.mouseListener = null;
        }
        if (this.mouseMotionListener != null) {
            this.treeTable.removeMouseMotionListener(this.mouseMotionListener);
            this.mouseMotionListener = null;
        }
        if (this.propertyChangeListener != null) {
            if (this.properties == null) {
                this.treeTable.removePropertyChangeListener(this.propertyChangeListener);
            } else {
                for (String string : this.properties) {
                    this.treeTable.removePropertyChangeListener(string, this.propertyChangeListener);
                }
            }
            this.properties = null;
            this.propertyChangeListener = null;
        }
    }

    public void updateUI() {
        this.sortWidth = -1;
        this.noFocusBorder = null;
        this.ltrBorder = null;
        this.rtlBorder = null;
        this.installDefaults();
        this.tree.updateUI();
        this.table.updateUI();
        this.defaultTreeCellRenderer.updateUI();
        this.updateTreeClientProperties(this.tree);
        this.treeTableCellRenderer = this.createCellRenderer();
        this.tree.setCellRenderer(this.treeTableCellRenderer);
    }

    protected Renderer createCellRenderer() {
        return this.isNimbus() ? new NimbusRenderer() : new Renderer();
    }

    protected Editor createCellEditor() {
        return new Editor();
    }

    protected TreeTableCellRenderer createFocusRenderer() {
        return new FocusRenderer();
    }

    protected JTree createAndConfigureTree() {
        JTree jTree = this.createTree(this.treeTable.getTreeTableModel());
        if (this.treeTable.getSelectionModel() == null) {
            this.treeTable.setSelectionModel(jTree.getSelectionModel());
        } else {
            jTree.setSelectionModel(this.treeTable.getSelectionModel());
        }
        jTree.setOpaque(false);
        jTree.setRowHeight(20);
        jTree.putClientProperty("JTree.lineStyle", "None");
        InputMap inputMap = jTree.getInputMap();
        this.remap(inputMap, 37);
        this.remap(inputMap, 39);
        this.updateTreeClientProperties(jTree);
        return jTree;
    }

    private void updateTreeClientProperties(JTree jTree) {
    }

    private boolean isNimbus() {
        return "Nimbus".equals(UIManager.getLookAndFeel().getName());
    }

    private void remap(InputMap inputMap, int n) {
        Object object = inputMap.get(KeyStroke.getKeyStroke(n, 0));
        if (object != null) {
            inputMap.put(KeyStroke.getKeyStroke(n, 512), object);
        }
    }

    protected JTree createTree(TreeModel treeModel) {
        return new Tree(treeModel);
    }

    protected void unconfigureTree() {
        this.tree.setCellRenderer(null);
        this.tree.setModel(new DefaultTreeModel(null));
        this.tree.setSelectionModel(new DefaultTreeSelectionModel());
        this.tree.setUI(null);
    }

    protected JTable createAndConfigureTable() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        JTable jTable = this.createTable(this.treeTable.getTreeTableModel(), tableColumnModel, this.treeTable.getRowSelectionModel());
        jTable.setOpaque(false);
        jTable.setFillsViewportHeight(true);
        jTable.setShowHorizontalLines(false);
        jTable.setRowMargin(0);
        if (tableColumnModel == null) {
            tableColumnModel = jTable.getColumnModel();
            tableColumnModel.setColumnMargin(this.isNimbus() ? 0 : 3);
            int n = this.treeTable.getTreeColumnModel().getHierarchicalColumn();
            if (n >= 0) {
                tableColumnModel.getColumn(n).setPreferredWidth(150);
            }
            this.treeTable.setColumnModel(tableColumnModel);
        }
        jTable.setShowVerticalLines(false);
        jTable.setRowHeight(20);
        jTable.setColumnModel(new ColumnModelAdapter(tableColumnModel));
        if (OSXSystemProperties.useInsetViewStyle()) {
            jTable.putClientProperty("JTable.viewStyle", "inset");
        }
        return jTable;
    }

    protected void finishConfiguration(JTree jTree, JTable jTable) {
    }

    protected JTable createTable(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
        return new Table(tableModel, tableColumnModel, listSelectionModel);
    }

    protected void unconfigureTable() {
        this.table.setTableHeader(null);
        this.table.setModel(new DefaultTableModel());
        this.table.setColumnModel(new DefaultTableColumnModel());
        this.table.setSelectionModel(new DefaultListSelectionModel());
        this.table.setUI(null);
    }

    protected FocusListener createFocusListener() {
        return this.handler;
    }

    protected KeyListener createKeyListener() {
        return this.handler;
    }

    protected MouseListener createMouseListener() {
        return this.handler;
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.handler;
    }

    protected List<String> getProperties() {
        return Arrays.asList("componentOrientation", "enabled", "rowSorter", "JTree.lineStyle", "columnModel");
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.handler;
    }

    protected Handler createHandler() {
        return new Handler();
    }

    protected JTable getTable() {
        return this.table;
    }

    protected JTree getTree() {
        return this.tree;
    }

    @Override
    public TreeInterface getTreeInterface(TreeTable treeTable) {
        return (TreeInterface)((Object)this.tree);
    }

    @Override
    public TableInterface getTableInterface(TreeTable treeTable) {
        return (TableInterface)((Object)this.table);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = this.tree.getPreferredSize();
        dimension.width = this.table.getPreferredSize().width;
        return dimension;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        try {
            this.paintTable(graphics);
            if (this.treeTable.getRowCount() > 0) {
                this.paintTree(graphics);
                if (this.treeTable.isNodeSortingEnabled()) {
                    this.paintSortIndicators(graphics);
                }
            }
            if (!this.treeTable.isPaintingForPrint()) {
                if (this.treeTable.isFocusOwner()) {
                    this.paintFocus(graphics);
                }
                this.paintDropLines(graphics);
            }
        }
        finally {
            this.treeTableCellRenderer.clearState();
        }
    }

    protected void paintTable(Graphics graphics) {
        this.treeTableCellRenderer.prepareForTable(graphics);
        Graphics graphics2 = graphics.create(0, 0, this.treeTable.getWidth(), this.treeTable.getHeight());
        try {
            this.table.paint(graphics2);
        }
        finally {
            graphics2.dispose();
        }
        if (this.table.isEditing()) {
            int n = this.table.getEditingColumn();
            int n2 = this.table.getEditingRow();
            boolean bl = this.treeTableCellRenderer.isSelected(this.tree.isRowSelected(n2) && this.table.isColumnSelected(n));
            TreeTableCellRenderer treeTableCellRenderer = this.treeTable.getCellRenderer(n2, n);
            Component component = treeTableCellRenderer.getTreeTableCellRendererComponent(this.treeTable, null, bl, false, n2, n);
            CellRendererPane cellRendererPane = (CellRendererPane)this.table.getComponent(0);
            Rectangle rectangle = this.table.getCellRect(n2, n, true);
            cellRendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
            cellRendererPane.removeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintTree(Graphics graphics) {
        Object object;
        Shape shape = graphics.getClip();
        if (this.tree.getWidth() <= 0 || !shape.intersects(this.tree.getBounds())) {
            return;
        }
        JTableHeader jTableHeader = this.table.getTableHeader();
        int n = this.tree.getX();
        int n2 = 0;
        int n3 = this.tree.getWidth();
        if (jTableHeader != null && (object = jTableHeader.getDraggedColumn()) != null) {
            if (((TableColumn)object).getModelIndex() == this.treeTable.getTreeColumnModel().getHierarchicalColumn()) {
                n += jTableHeader.getDraggedDistance();
            } else {
                int n4 = this.table.convertColumnIndexToView(((TableColumn)object).getModelIndex());
                Rectangle rectangle = this.table.getCellRect(0, n4, true);
                int n5 = rectangle.x + jTableHeader.getDraggedDistance();
                int n6 = n5 + rectangle.width;
                if (n >= n5 && n < n6) {
                    n2 = n6 - n;
                    n3 -= n2;
                } else if (n < n5 && n5 < n + this.tree.getWidth()) {
                    n3 -= n + this.tree.getWidth() - n5;
                }
            }
        }
        this.treeTableCellRenderer.prepareForTree();
        object = graphics.create(n, this.tree.getY(), this.tree.getWidth(), this.tree.getHeight());
        try {
            ((Graphics)object).clipRect(n2, 0, n3, this.tree.getHeight());
            this.tree.paint((Graphics)object);
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    protected void paintSortIndicators(Graphics graphics) {
        int n;
        TreePath treePath = this.paintMouseOverSortPath ? this.mouseOverSortPath : null;
        int n2 = this.mouseOverSortColumn;
        SortOrder sortOrder = null;
        for (Map.Entry<TreePath, RowSorter.SortKey> entry : this.treeTable.getSortedPaths().entrySet()) {
            RowSorter.SortKey sortKey;
            TreePath treePath2 = entry.getKey();
            if (!this.tree.isExpanded(treePath2) || (n = this.table.convertColumnIndexToView((sortKey = entry.getValue()).getColumn())) < 0) continue;
            if (treePath != null && n == n2 && treePath.equals(treePath2)) {
                sortOrder = ((RowSorter.SortKey)entry.getValue()).getSortOrder();
                continue;
            }
            this.paintSortIndicator(graphics, treePath2, n, sortKey.getSortOrder());
        }
        if (treePath != null) {
            Map.Entry<TreePath, RowSorter.SortKey> entry;
            RowSorter<? extends TreeModel> rowSorter = this.treeTable.getRowSorter().getRowSorter(treePath);
            if (rowSorter instanceof TreeTableSorter.SortCycle) {
                entry = ((TreeTableSorter.SortCycle)((Object)rowSorter)).getSortCycle();
                if (sortOrder == null) {
                    sortOrder = (SortOrder)((Object)entry.get(0));
                } else {
                    int n3 = entry.indexOf((Object)sortOrder);
                    if (n3 < 0 || ++n3 >= entry.size()) {
                        n3 = 0;
                    }
                    sortOrder = (SortOrder)((Object)entry.get(n3));
                }
            } else {
                SortOrder sortOrder2 = sortOrder = sortOrder == SortOrder.ASCENDING ? SortOrder.DESCENDING : SortOrder.ASCENDING;
            }
            if (sortOrder == SortOrder.UNSORTED) {
                int n4 = this.tree.getRowForPath(treePath);
                Rectangle rectangle = this.table.getCellRect(n4, n2, true);
                int n5 = 2;
                n = this.getSortWidth() - this.getSortMargin() * 2;
                int n6 = rectangle.y + (rectangle.height - n5) / 2;
                int n7 = this.treeTable.getAlignment(this.getRendererComponent(false, false, n4, n2), n4, n2);
                graphics.setColor(Color.GRAY);
                switch (n7) {
                    case 0: 
                    case 2: {
                        graphics.fillRect(rectangle.x + rectangle.width - n - this.getSortMargin(), n6, n, n5);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(rectangle.x + this.getSortMargin(), n6, n, n5);
                    }
                }
            } else {
                entry = null;
                Composite composite = null;
                if (graphics instanceof Graphics2D) {
                    entry = (Graphics2D)graphics;
                    composite = ((Graphics2D)((Object)entry)).getComposite();
                    ((Graphics2D)((Object)entry)).setComposite(AlphaComposite.getInstance(3, 0.5f));
                }
                this.paintSortIndicator(graphics, treePath, this.mouseOverSortColumn, sortOrder);
                if (entry != null) {
                    ((Graphics2D)((Object)entry)).setComposite(composite);
                }
            }
        }
    }

    private void paintSortIndicator(Graphics graphics, TreePath treePath, int n, SortOrder sortOrder) {
        Icon icon;
        switch (sortOrder) {
            default: {
                return;
            }
            case ASCENDING: {
                icon = this.treeTable.getAscendingSortIcon();
                break;
            }
            case DESCENDING: {
                icon = this.treeTable.getDescendingSortIcon();
            }
        }
        int n2 = this.tree.getRowForPath(treePath);
        Rectangle rectangle = this.table.getCellRect(n2, n, true);
        int n3 = rectangle.y + (rectangle.height - icon.getIconHeight()) / 2;
        int n4 = this.treeTable.getAlignment(this.getRendererComponent(false, false, n2, n), n2, n);
        switch (n4) {
            case 0: 
            case 2: {
                icon.paintIcon(this.treeTable, graphics, rectangle.x + rectangle.width - icon.getIconWidth() - this.getSortMargin(), n3);
                break;
            }
            case 4: {
                icon.paintIcon(this.treeTable, graphics, rectangle.x + this.getSortMargin(), n3);
            }
        }
    }

    void setMouseOverSortIndicator(TreePath treePath, int n) {
        TreePath treePath2 = this.mouseOverSortPath;
        int n2 = this.mouseOverSortColumn;
        if (n != n2 || (treePath == null ? treePath2 != null : !treePath.equals(treePath2))) {
            this.mouseOverSortColumn = n;
            this.mouseOverSortPath = treePath;
            this.paintMouseOverSortPath = true;
            if (treePath2 != null) {
                this.repaint(treePath2, n2);
            }
            if (treePath != null) {
                this.repaint(treePath, n);
            }
        }
    }

    private void repaint(TreePath treePath, int n) {
        Rectangle rectangle = this.table.getCellRect(this.tree.getRowForPath(treePath), n, true);
        this.treeTable.repaint(rectangle);
    }

    private Component getRendererComponent(boolean bl, boolean bl2, int n, int n2) {
        TreeTableCellRenderer treeTableCellRenderer = this.treeTable.getCellRenderer(n, n2);
        Object object = this.treeTable.getValueAt(n, n2);
        if (n2 == this.treeTable.getHierarchicalColumn()) {
            TreePath treePath = this.tree.getPathForRow(n);
            return treeTableCellRenderer.getTreeTableCellRendererComponent(this.treeTable, object, bl, bl2, n, n2, this.treeTable.isExpanded(treePath), this.treeTable.isLeaf(treePath));
        }
        return treeTableCellRenderer.getTreeTableCellRendererComponent(this.treeTable, object, bl, bl2, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintFocus(Graphics graphics) {
        TreeTableCellRenderer treeTableCellRenderer = this.treeTable.getFocusRenderer();
        if (treeTableCellRenderer == null) {
            return;
        }
        if (this.treeTable.isColumnFocusEnabled()) {
            Serializable serializable;
            int n = this.treeTable.getLeadSelectionColumn();
            if (n < 0) {
                return;
            }
            int n2 = this.treeTable.getLeadSelectionRow();
            Rectangle rectangle = this.table.getCellRect(n2, n, true);
            Rectangle rectangle2 = null;
            JTableHeader jTableHeader = this.table.getTableHeader();
            if (jTableHeader != null && (serializable = jTableHeader.getDraggedColumn()) != null && jTableHeader.getDraggedDistance() != 0) {
                if (((TableColumn)serializable).getModelIndex() == this.treeTable.getTreeColumnModel().getHierarchicalColumn()) {
                    rectangle.x += jTableHeader.getDraggedDistance();
                } else {
                    int n3 = this.table.convertColumnIndexToView(((TableColumn)serializable).getModelIndex());
                    Rectangle rectangle3 = this.table.getCellRect(n2, n3, true);
                    rectangle3.x += jTableHeader.getDraggedDistance();
                    rectangle2 = rectangle.intersection(rectangle3);
                    rectangle2.x -= rectangle.x;
                }
            }
            if (!graphics.getClip().intersects(rectangle)) {
                return;
            }
            serializable = treeTableCellRenderer.getTreeTableCellRendererComponent(this.treeTable, "", false, true, n2, n);
            ((Component)serializable).setBounds(0, 0, rectangle.width, rectangle.height);
            Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            try {
                if (rectangle2 != null) {
                    if (rectangle2.x == 0) {
                        graphics2.setClip(rectangle2.width, 0, rectangle.width, rectangle.height);
                    } else {
                        graphics2.setClip(0, 0, rectangle2.x, rectangle.height);
                    }
                }
                ((Component)serializable).paint(graphics2);
            }
            finally {
                graphics2.dispose();
            }
        }
        int n = this.tree.getRowForPath(this.tree.getLeadSelectionPath());
        int n4 = this.table.getColumnModel().getColumnCount();
        if (n >= 0 && n4 > 0) {
            Rectangle rectangle = this.table.getCellRect(n, 0, true);
            if (n4 > 1) {
                rectangle.add(this.table.getCellRect(n, n4 - 1, true));
            }
            if (graphics.getClip().intersects(rectangle)) {
                Component component = treeTableCellRenderer.getTreeTableCellRendererComponent(this.treeTable, "", false, true, n, -1);
                component.setBounds(0, 0, rectangle.width, rectangle.height);
                Graphics graphics3 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                try {
                    TableColumn tableColumn;
                    boolean bl = true;
                    JTableHeader jTableHeader = this.table.getTableHeader();
                    if (jTableHeader != null && (tableColumn = jTableHeader.getDraggedColumn()) != null && jTableHeader.getDraggedDistance() != 0) {
                        bl = false;
                        int n5 = this.table.convertColumnIndexToView(tableColumn.getModelIndex());
                        Rectangle rectangle4 = this.table.getCellRect(n, n5, true);
                        if (jTableHeader.getDraggedDistance() < 0) {
                            int n6 = rectangle4.x + rectangle4.width + jTableHeader.getDraggedDistance();
                            graphics3.setClip(0, 0, n6, rectangle.height);
                            component.paint(graphics3);
                            int n7 = rectangle4.x + rectangle4.width;
                            graphics3.setClip(n7, 0, rectangle.width - n7, rectangle.height);
                            component.paint(graphics3);
                        } else {
                            graphics3.setClip(0, 0, rectangle4.x, rectangle.height);
                            component.paint(graphics3);
                            int n8 = rectangle4.x + jTableHeader.getDraggedDistance();
                            graphics3.setClip(n8, 0, rectangle.width - n8, rectangle.height);
                            component.paint(graphics3);
                        }
                    }
                    if (bl) {
                        component.paint(graphics3);
                    }
                }
                finally {
                    graphics3.dispose();
                }
            }
        }
    }

    protected void layoutTable() {
        this.table.setBounds(0, 0, this.treeTable.getWidth(), this.treeTable.getHeight());
    }

    protected void layoutTree() {
        int n = this.treeTable.getHierarchicalColumn();
        if (n < 0 || this.treeTable.getRowCount() == 0) {
            this.tree.setBounds(0, 0, 0, 0);
        } else {
            Rectangle rectangle = this.table.getCellRect(0, n, true);
            int n2 = this.treeTable.getColumnModel().getColumnMargin();
            rectangle.x += n2 / 2;
            rectangle.width -= n2;
            rectangle.height = this.treeTable.getHeight();
            this.tree.setBounds(rectangle);
        }
    }

    @Override
    public void configureCellRenderer(DefaultTreeTableCellRenderer defaultTreeTableCellRenderer, TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        this.treeTableCellRenderer.configureCellRenderer(defaultTreeTableCellRenderer, treeTable, object, bl, bl2, n, n2);
    }

    @Override
    public void configureCellRenderer(DefaultTreeTableCellRenderer defaultTreeTableCellRenderer, TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
        this.treeTableCellRenderer.configureCellRenderer(defaultTreeTableCellRenderer, treeTable, object, bl, bl2, n, n2, bl3, bl4);
    }

    @Override
    public void configureCellEditor(DefaultTreeTableCellEditor defaultTreeTableCellEditor, TreeTable treeTable, Object object, boolean bl, int n, int n2) {
        defaultTreeTableCellEditor.getTableCellEditorComponent(this.table, object, bl, n, n2);
    }

    @Override
    public void configureCellEditor(DefaultTreeTableCellEditor defaultTreeTableCellEditor, TreeTable treeTable, Object object, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
        defaultTreeTableCellEditor.getTreeCellEditorComponent(this.tree, object, bl, bl2, bl3, n);
    }

    @Override
    public TreeTableCellRenderer getDefaultRenderer(TreeTable treeTable, Class<?> clazz) {
        this.treeTableCellRenderer.loadRenderer(clazz);
        return this.treeTableCellRenderer;
    }

    @Override
    public TreeTableCellEditor getDefaultEditor(TreeTable treeTable, Class<?> clazz, int n) {
        this.treeTableCellEditor.loadEditor(clazz, n);
        return this.treeTableCellEditor;
    }

    @Override
    public Rectangle getPathBounds(TreeTable treeTable, TreePath treePath) {
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle != null) {
            rectangle.x += this.tree.getX();
            rectangle.y += this.tree.getY();
        }
        return rectangle;
    }

    @Override
    public TreePath getPathForLocation(TreeTable treeTable, int n, int n2) {
        TreePath treePath = this.tree.getPathForLocation(n - this.tree.getX(), n2 - this.tree.getY());
        if (treePath != null) {
            return treePath;
        }
        int n3 = this.table.rowAtPoint(new Point(n, n2));
        return n3 >= 0 ? this.tree.getPathForRow(n3) : null;
    }

    @Override
    public TreePath getClosestPathForLocation(TreeTable treeTable, int n, int n2) {
        return this.tree.getClosestPathForLocation(n - this.tree.getX(), n2 - this.tree.getY());
    }

    protected boolean hasTreeHandle(TreeTable treeTable, TreePath treePath) {
        return !treeTable.isLeaf(treePath) && (treeTable.getChildCount(treePath) > 0 || treeTable.hasBeenExpanded(treePath));
    }

    static boolean isOverTreeHandle(boolean bl, Rectangle rectangle, int n, int n2) {
        return bl ? n2 < rectangle.x && (n < 0 || n2 > rectangle.x - n) : n2 > rectangle.x + rectangle.width && (n < 0 || n2 < rectangle.x + rectangle.width + n);
    }

    @Override
    public int getDistanceToTreeHandle(TreeTable treeTable, TreePath treePath, int n) {
        int n2;
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (rectangle == null) {
            return 0;
        }
        boolean bl = treeTable.getComponentOrientation().isLeftToRight();
        if (bl ? n < rectangle.x : n > rectangle.x + rectangle.width) {
            boolean bl2 = this.hasTreeHandle(treeTable, treePath);
            if (bl2 && BasicTreeTableUI.isOverTreeHandle(bl, rectangle, this.getTreeHandleWidth(), n)) {
                n2 = 0;
            } else {
                int n3 = n2 = bl ? n - rectangle.x : rectangle.x + rectangle.width - n;
                if (bl2) {
                    n2 += this.getTreeHandleWidth();
                }
            }
        } else {
            n2 = bl ? n - rectangle.x : rectangle.x + rectangle.width - n;
        }
        return n2;
    }

    protected void updateTableAfterExpansion(TreePath treePath, int n) {
        if (n < 0) {
            this.treeTable.processTreeCollapse(treePath, -n);
        } else if (n > 0) {
            this.treeTable.processTreeExpansion(treePath, n);
        }
    }

    protected void scrollToVisible(Rectangle rectangle, int n, int n2) {
        rectangle.x += n;
        rectangle.y += n2;
        this.treeTable.scrollRectToVisible(rectangle);
        rectangle.x -= n;
        rectangle.y -= n2;
    }

    private static Color createColor(Color color) {
        if (color instanceof UIResource) {
            color = new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        }
        return color;
    }

    protected int getSortWidth() {
        if (this.sortWidth < 0) {
            this.sortWidth = this.getSortMargin() * 2 + Math.max(this.treeTable.getAscendingSortIcon().getIconWidth(), this.treeTable.getDescendingSortIcon().getIconWidth());
        }
        return this.sortWidth;
    }

    protected int getSortMargin() {
        return 2;
    }

    private Border getDefaultLTRBorder() {
        if (this.ltrBorder == null) {
            this.ltrBorder = new EmptyBorder(1, 0, 1, 1);
        }
        return this.ltrBorder;
    }

    private Border getDefaultRTLBorder() {
        if (this.rtlBorder == null) {
            this.rtlBorder = new EmptyBorder(1, 1, 1, 0);
        }
        return this.rtlBorder;
    }

    private Border getDefaultNoFocusBorder() {
        if (this.noFocusBorder == null) {
            this.noFocusBorder = UIManager.getBorder("Table.cellNoFocusBorder");
            if (this.noFocusBorder == null) {
                this.noFocusBorder = new EmptyBorder(1, 1, 1, 1);
            }
        }
        return this.noFocusBorder;
    }

    protected int getTreeHandleWidth() {
        return this.treeHandleWidth;
    }

    protected boolean processKeyBinding(JComponent jComponent, KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        if (jComponent instanceof ProcessKeyBinding) {
            return ((ProcessKeyBinding)((Object)jComponent)).processKeyBinding(keyStroke, keyEvent, n, bl);
        }
        return false;
    }

    private void paintDropLines(Graphics graphics) {
        int n;
        int n2;
        TreeTable.DropLocation dropLocation = this.treeTable.getDropLocation();
        if (dropLocation == null || !dropLocation.isInsertRow() && !dropLocation.isInsertColumn()) {
            return;
        }
        Color color = UIManager.getColor("Table.dropLineColor");
        Color color2 = UIManager.getColor("Table.dropLineShortColor");
        if (color == null && color2 == null) {
            return;
        }
        Rectangle rectangle = this.getHDropLineRect(dropLocation);
        if (rectangle != null) {
            n2 = rectangle.x;
            n = rectangle.width;
            if (color != null) {
                this.extendRect(rectangle, true);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        if ((rectangle = this.getVDropLineRect(dropLocation)) != null) {
            n2 = rectangle.y;
            n = rectangle.height;
            if (color != null) {
                this.extendRect(rectangle, false);
                graphics.setColor(color);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    private Rectangle getHDropLineRect(TreeTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertRow()) {
            return null;
        }
        int n = dropLocation.getRow();
        int n2 = dropLocation.getColumn();
        if (n2 >= this.table.getColumnCount()) {
            --n2;
        }
        Rectangle rectangle = this.table.getCellRect(n, n2, true);
        if (n >= this.table.getRowCount()) {
            Rectangle rectangle2 = this.table.getCellRect(--n, n2, true);
            rectangle.y = rectangle2.y + rectangle2.height;
        }
        rectangle.y = rectangle.y == 0 ? -1 : (rectangle.y -= 2);
        rectangle.height = 3;
        return rectangle;
    }

    private Rectangle getVDropLineRect(TreeTable.DropLocation dropLocation) {
        if (!dropLocation.isInsertColumn()) {
            return null;
        }
        boolean bl = this.table.getComponentOrientation().isLeftToRight();
        int n = dropLocation.getColumn();
        Rectangle rectangle = this.table.getCellRect(dropLocation.getRow(), n, true);
        if (n >= this.table.getColumnCount()) {
            rectangle = this.table.getCellRect(dropLocation.getRow(), --n, true);
            if (bl) {
                rectangle.x += rectangle.width;
            }
        } else if (!bl) {
            rectangle.x += rectangle.width;
        }
        rectangle.x = rectangle.x == 0 ? -1 : (rectangle.x -= 2);
        rectangle.width = 3;
        return rectangle;
    }

    private Rectangle extendRect(Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return rectangle;
        }
        if (bl) {
            rectangle.x = 0;
            rectangle.width = this.table.getWidth();
        } else {
            rectangle.y = 0;
            if (this.table.getRowCount() != 0) {
                Rectangle rectangle2 = this.table.getCellRect(this.table.getRowCount() - 1, 0, true);
                rectangle.height = rectangle2.y + rectangle2.height;
            } else {
                rectangle.height = this.table.getHeight();
            }
        }
        return rectangle;
    }

    protected class Handler
    extends MouseAdapter
    implements FocusListener,
    KeyListener,
    PropertyChangeListener {
        private boolean sendDragToTable = true;
        private boolean sortPressed = false;
        private MouseEvent dndArmedEvent;
        private int motionThreshold;
        private String prefix = "";
        private String typedString = "";
        private long lastTime = 0L;
        private long timeFactor = 1000L;

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent);
            if (!keyEvent.isConsumed()) {
                this.changeSelection(keyEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
            if (mouseEvent.isConsumed()) {
                this.sendDragToTable = false;
            } else if (BasicTreeTableUI.this.treeTable.getDragEnabled()) {
                this.motionThreshold = Math.max(10, DragSource.getDragThreshold());
                this.dndArmedEvent = mouseEvent;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicTreeTableUI.this.setMouseOverSortIndicator(null, -1);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
            this.dndArmedEvent = null;
            this.sendDragToTable = true;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicTreeTableUI.this.treeTable.isNodeSortingEnabled() || BasicTreeTableUI.this.treeTable.getRowSorter() == null) {
                BasicTreeTableUI.this.setMouseOverSortIndicator(null, -1);
            } else if (!BasicTreeTableUI.this.treeTable.isEditing()) {
                Point point = mouseEvent.getPoint();
                int n = BasicTreeTableUI.this.table.columnAtPoint(point);
                if (n < 0) {
                    BasicTreeTableUI.this.setMouseOverSortIndicator(null, -1);
                } else {
                    TreePath treePath;
                    BasicTreeTableUI.this.setMouseOverSortIndicator(treePath, (treePath = this.getSortPath(point, n)) == null ? -1 : n);
                }
            }
        }

        private TreePath getSortPath(Point point, int n) {
            int n2 = BasicTreeTableUI.this.table.rowAtPoint(point);
            if (n2 < 0) {
                return null;
            }
            TreePath treePath = BasicTreeTableUI.this.tree.getPathForRow(n2);
            if (BasicTreeTableUI.this.treeTable.isLeaf(treePath) || BasicTreeTableUI.this.treeTable.getChildCount(treePath) == 0) {
                return null;
            }
            Rectangle rectangle = BasicTreeTableUI.this.table.getCellRect(n2, n, true);
            switch (BasicTreeTableUI.this.treeTable.getAlignment(BasicTreeTableUI.this.getRendererComponent(false, false, n2, n), n2, n)) {
                default: {
                    return null;
                }
                case 0: 
                case 2: {
                    if (point.x >= rectangle.x + rectangle.width - BasicTreeTableUI.this.getSortWidth()) break;
                    return null;
                }
                case 4: {
                    if (point.x <= rectangle.x + BasicTreeTableUI.this.getSortWidth()) break;
                    return null;
                }
            }
            return treePath;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (BasicTreeTableUI.this.treeTable.getDragEnabled()) {
                if (this.dndArmedEvent != null) {
                    int n = Math.abs(mouseEvent.getX() - this.dndArmedEvent.getX());
                    int n2 = Math.abs(mouseEvent.getY() - this.dndArmedEvent.getY());
                    if (n > this.motionThreshold || n2 > this.motionThreshold) {
                        int n3;
                        TransferHandler transferHandler = BasicTreeTableUI.this.treeTable.getTransferHandler();
                        int n4 = n3 = transferHandler == null ? 0 : transferHandler.getSourceActions(BasicTreeTableUI.this.treeTable);
                        if (n3 != 0) {
                            int n5 = 2;
                            transferHandler.exportAsDrag(BasicTreeTableUI.this.treeTable, this.dndArmedEvent, n5);
                        }
                    }
                }
            } else if (this.sendDragToTable) {
                this.dispatchMouseEvent(mouseEvent, BasicTreeTableUI.this.table);
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            int n = BasicTreeTableUI.this.treeTable.getConditionForKeyStroke(keyStroke);
            if (n == 0 || n == 1) {
                return;
            }
            if (!this.dispatchToTable(keyEvent) || !this.dispatchKeyEvent(keyEvent, keyStroke, BasicTreeTableUI.this.table)) {
                this.dispatchKeyEvent(keyEvent, keyStroke, BasicTreeTableUI.this.tree);
            }
        }

        private boolean dispatchToTable(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    return false;
                }
                case 35: 
                case 36: 
                case 37: 
                case 39: {
                    return (BasicTreeTableUI.this.treeTable.isColumnFocusEnabled() || BasicTreeTableUI.this.treeTable.getColumnSelectionAllowed()) && BasicTreeTableUI.this.table.getColumnModel().getColumnCount() > 1;
                }
            }
            return true;
        }

        private boolean dispatchKeyEvent(KeyEvent keyEvent, KeyStroke keyStroke, JComponent jComponent) {
            int n = jComponent.getConditionForKeyStroke(keyStroke);
            if ((n == 0 || n == 1) && BasicTreeTableUI.this.processKeyBinding(jComponent, keyStroke, keyEvent, n, !keyStroke.isOnKeyRelease())) {
                keyEvent.consume();
                return true;
            }
            return false;
        }

        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed() || mouseEvent.isPopupTrigger()) {
                return;
            }
            if (this.sortNode(mouseEvent)) {
                return;
            }
            if (!this.dispatchToTree(mouseEvent)) {
                this.dispatchMouseEvent(mouseEvent, BasicTreeTableUI.this.table);
            }
        }

        private boolean sortNode(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                default: {
                    return false;
                }
                case 502: {
                    try {
                        boolean bl = this.sortPressed;
                        return bl;
                    }
                    finally {
                        this.sortPressed = false;
                    }
                }
                case 501: 
            }
            if (BasicTreeTableUI.this.mouseOverSortPath == null) {
                return false;
            }
            TreeTableSorter<? extends TreeModel, ? extends TreeColumnModel> treeTableSorter = BasicTreeTableUI.this.treeTable.getRowSorter();
            if (treeTableSorter == null) {
                return false;
            }
            RowSorter<? extends TreeModel> rowSorter = treeTableSorter.getRowSorter(BasicTreeTableUI.this.mouseOverSortPath);
            if (rowSorter == null) {
                return false;
            }
            rowSorter.toggleSortOrder(BasicTreeTableUI.this.table.convertColumnIndexToModel(BasicTreeTableUI.this.mouseOverSortColumn));
            BasicTreeTableUI.this.paintMouseOverSortPath = false;
            this.sortPressed = true;
            mouseEvent.consume();
            return true;
        }

        private boolean dispatchToTree(MouseEvent mouseEvent) {
            switch (mouseEvent.getID()) {
                case 504: 
                case 505: {
                    return false;
                }
            }
            int n = BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            if (n < 0) {
                return false;
            }
            Point point = mouseEvent.getPoint();
            int n2 = BasicTreeTableUI.this.table.columnAtPoint(point);
            if (n2 != n) {
                return false;
            }
            int n3 = BasicTreeTableUI.this.table.rowAtPoint(point);
            if (n3 < 0) {
                return false;
            }
            TreePath treePath = BasicTreeTableUI.this.tree.getPathForRow(n3);
            if (!BasicTreeTableUI.this.hasTreeHandle(BasicTreeTableUI.this.treeTable, treePath)) {
                return false;
            }
            if (BasicTreeTableUI.isOverTreeHandle(BasicTreeTableUI.this.tree.getComponentOrientation().isLeftToRight(), BasicTreeTableUI.this.tree.getPathBounds(treePath), BasicTreeTableUI.this.getTreeHandleWidth(), mouseEvent.getX() - BasicTreeTableUI.this.tree.getX())) {
                this.dispatchMouseEvent(mouseEvent, BasicTreeTableUI.this.tree);
                mouseEvent.consume();
                return true;
            }
            return false;
        }

        protected void dispatchMouseEvent(MouseEvent mouseEvent, JComponent jComponent) {
            MouseEvent mouseEvent2 = new MouseEvent(jComponent, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - jComponent.getX(), mouseEvent.getY() - jComponent.getY(), mouseEvent.getXOnScreen(), mouseEvent.getYOnScreen(), mouseEvent.getClickCount(), false, mouseEvent.getButton());
            jComponent.dispatchEvent(mouseEvent2);
            if (mouseEvent2.isConsumed()) {
                mouseEvent.consume();
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("rowSorter")) {
                BasicTreeTableUI.this.table.setRowSorter(propertyChangeEvent.getNewValue() == null ? null : new RowSorterAdapter());
            } else if (string.equals("enabled")) {
                boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                BasicTreeTableUI.this.table.setEnabled(bl);
                BasicTreeTableUI.this.tree.setEnabled(bl);
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                BasicTreeTableUI.this.table.setComponentOrientation(componentOrientation);
                BasicTreeTableUI.this.tree.setComponentOrientation(componentOrientation);
                BasicTreeTableUI.this.treeTable.revalidate();
                BasicTreeTableUI.this.treeTable.repaint();
            } else if ("JTree.lineStyle".equals(string)) {
                BasicTreeTableUI.this.tree.putClientProperty("JTree.lineStyle", propertyChangeEvent.getNewValue());
            } else if ("columnModel".equals(string)) {
                BasicTreeTableUI.this.table.setColumnModel(new ColumnModelAdapter((TableColumnModel)propertyChangeEvent.getNewValue()));
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged();
        }

        protected void focusChanged() {
            this.repaintLead();
        }

        private void repaintLead() {
            Rectangle rectangle;
            TreePath treePath = BasicTreeTableUI.this.tree.getLeadSelectionPath();
            if (treePath == null) {
                return;
            }
            int n = BasicTreeTableUI.this.tree.getRowForPath(treePath);
            if (BasicTreeTableUI.this.treeTable.isColumnFocusEnabled()) {
                int n2 = BasicTreeTableUI.this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex();
                if (n2 < 0) {
                    return;
                }
                rectangle = BasicTreeTableUI.this.table.getCellRect(n, n2, true);
            } else {
                rectangle = BasicTreeTableUI.this.table.getCellRect(n, 0, true);
                rectangle.width = BasicTreeTableUI.this.treeTable.getWidth();
            }
            BasicTreeTableUI.this.treeTable.repaint(rectangle);
        }

        protected void changeSelection(KeyEvent keyEvent) {
            int n;
            int n2 = -1;
            if (BasicTreeTableUI.this.treeTable.isColumnFocusEnabled() && (n2 = BasicTreeTableUI.this.treeTable.getLeadSelectionColumn()) >= BasicTreeTableUI.this.treeTable.getColumnCount()) {
                n2 = -1;
            }
            if (n2 < 0 && (n2 = Math.max(0, BasicTreeTableUI.this.treeTable.getHierarchicalColumn())) >= BasicTreeTableUI.this.treeTable.getColumnCount()) {
                return;
            }
            if (BasicTreeTableUI.this.treeTable.getRowCount() == 0 || keyEvent.isAltDown() || keyEvent.isControlDown() || keyEvent.isMetaDown() || this.isNavigationKey(BasicTreeTableUI.this.table, keyEvent)) {
                return;
            }
            boolean bl = true;
            char c = keyEvent.getKeyChar();
            long l = keyEvent.getWhen();
            int n3 = BasicTreeTableUI.this.table.getSelectionModel().getLeadSelectionIndex();
            if (l - this.lastTime < this.timeFactor) {
                this.typedString = this.typedString + c;
                if (this.prefix.length() == 1 && c == this.prefix.charAt(0)) {
                    ++n3;
                } else {
                    this.prefix = this.typedString;
                }
            } else {
                ++n3;
                this.prefix = this.typedString = Character.toString(c);
            }
            this.lastTime = l;
            if (n3 < 0 || n3 >= BasicTreeTableUI.this.table.getRowCount()) {
                bl = false;
                n3 = 0;
            }
            if ((n = BasicTreeTableUI.this.treeTable.getNextMatch(this.prefix, n3, n2, Position.Bias.Forward)) >= 0) {
                BasicTreeTableUI.this.table.changeSelection(n, n2, false, false);
            } else if (bl && (n = BasicTreeTableUI.this.treeTable.getNextMatch(this.prefix, n3, n2, Position.Bias.Forward)) >= 0) {
                BasicTreeTableUI.this.table.changeSelection(n, n2, false, false);
            }
        }

        private boolean isNavigationKey(JTable jTable, KeyEvent keyEvent) {
            InputMap inputMap = jTable.getInputMap(1);
            return inputMap != null && inputMap.get(KeyStroke.getKeyStroke(keyEvent.getKeyCode(), 0)) != null;
        }
    }

    protected class Renderer
    extends CellRendererPane
    implements TreeCellRenderer,
    TableCellRenderer,
    TreeTableCellRenderer {
        protected Component component;
        protected boolean tableColumn = true;
        protected boolean treeColumnSelected;
        protected boolean rowSelectionAllowed;
        protected boolean columnSelectionAllowed;
        protected Object node;
        protected int row;
        protected int column;
        protected Color backgroundColor;
        protected Color alternateRowColor;
        private TableCellRenderer renderer;
        private int left;
        private int right;
        private int top;
        private int bottom;
        private int focusRow;
        private int focusColumn;

        public void loadRenderer(Class<?> clazz) {
            this.renderer = BasicTreeTableUI.this.table.getDefaultRenderer(clazz);
        }

        public void prepareForTable(Graphics graphics) {
            this.prepareBackgroundColors();
            int n = BasicTreeTableUI.this.treeTable.getColumnModel().getColumnMargin();
            int n2 = BasicTreeTableUI.this.treeTable.getRowMargin();
            if (n != 0 || n2 != 0) {
                this.left = n / 2;
                this.right = this.left + n % 2;
                this.top = n2 / 2;
                this.bottom = this.top + n2 % 2;
            } else {
                this.bottom = 0;
                this.top = 0;
                this.right = 0;
                this.left = 0;
            }
            if (BasicTreeTableUI.this.treeTable.getFocusRenderer() != null) {
                this.focusColumn = -1;
                this.focusRow = -1;
            } else {
                this.focusRow = BasicTreeTableUI.this.tree.getLeadSelectionRow();
                this.focusColumn = BasicTreeTableUI.this.treeTable.isColumnFocusEnabled() ? Integer.MIN_VALUE : BasicTreeTableUI.this.treeTable.getLeadSelectionColumn();
            }
        }

        protected void prepareBackgroundColors() {
            this.backgroundColor = BasicTreeTableUI.this.treeTable.getBackground();
            this.alternateRowColor = BasicTreeTableUI.this.treeTable.getAlternateRowColor();
            if (this.alternateRowColor == null) {
                this.alternateRowColor = this.backgroundColor;
            }
        }

        public void prepareForTree() {
            this.tableColumn = false;
            this.column = BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            this.rowSelectionAllowed = BasicTreeTableUI.this.table.getRowSelectionAllowed();
            this.columnSelectionAllowed = BasicTreeTableUI.this.table.getColumnSelectionAllowed();
            this.treeColumnSelected = BasicTreeTableUI.this.table.isColumnSelected(this.column);
        }

        public void clearState() {
            this.renderer = null;
            this.component = null;
            this.node = null;
            this.backgroundColor = null;
            this.alternateRowColor = null;
            this.removeAll();
            this.tableColumn = true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.tableColumn = true;
            this.row = n;
            this.column = n2;
            bl2 = this.isFocused(n, n2);
            this.component = this.getTableComponent(object, bl, bl2, n, n2);
            return this;
        }

        private Component getTableComponent(Object object, boolean bl, boolean bl2, int n, int n2) {
            return BasicTreeTableUI.this.treeTable.getCellRenderer(n, n2).getTreeTableCellRendererComponent(BasicTreeTableUI.this.treeTable, object, bl, bl2, n, n2);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            if (this.tableColumn) {
                this.tableColumn = false;
                this.column = BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            }
            this.node = object;
            this.row = n;
            bl = this.isSelected(bl);
            bl4 = this.isFocused(n, this.column);
            TreeColumnModel treeColumnModel = BasicTreeTableUI.this.treeTable.getTreeColumnModel();
            object = treeColumnModel.getValueAt(object, treeColumnModel.getHierarchicalColumn());
            this.component = this.getTreeComponent(object, bl, bl4, n, this.column, bl2, bl3);
            return this;
        }

        private Component getTreeComponent(Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
            return BasicTreeTableUI.this.treeTable.getCellRenderer(n, n2).getTreeTableCellRendererComponent(BasicTreeTableUI.this.treeTable, object, bl, bl2, n, n2, bl3, bl4);
        }

        boolean isSelected(boolean bl) {
            if (!this.columnSelectionAllowed) {
                return this.rowSelectionAllowed ? bl : false;
            }
            return this.rowSelectionAllowed ? bl && this.treeColumnSelected : this.treeColumnSelected;
        }

        boolean isFocused(int n, int n2) {
            return n == this.focusRow && this.focusColumn < -1 ? true : n2 == this.focusColumn;
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = this.renderer.getTableCellRendererComponent(BasicTreeTableUI.this.table, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                ((JComponent)component).setOpaque(false);
            }
            this.configureCellRenderer(component, bl, n, n2);
            return component;
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
            return BasicTreeTableUI.this.defaultTreeCellRenderer.getTreeTableCellRendererComponent(treeTable, object, bl, bl2, n, n2, bl3, bl4);
        }

        private Dimension getComponentPreferredSize() {
            Dimension dimension = this.component.getPreferredSize();
            if (BasicTreeTableUI.this.treeTable.isNodeSortingEnabled()) {
                switch (BasicTreeTableUI.this.treeTable.getAlignment(this.component, this.row, this.column)) {
                    case 0: {
                        dimension.width += BasicTreeTableUI.this.getSortWidth() * 2;
                        break;
                    }
                    case 2: 
                    case 4: {
                        dimension.width += BasicTreeTableUI.this.getSortWidth();
                    }
                }
            }
            return dimension;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension;
            if (this.tableColumn || BasicTreeTableUI.this.tree.getRowHeight() > 0) {
                return this.getComponentPreferredSize();
            }
            if (!BasicTreeTableUI.this.tree.isRootVisible() && this.row <= 0 && this.node == BasicTreeTableUI.this.treeTable.getTreeModel().getRoot()) {
                return new Dimension(0, 0);
            }
            int n = BasicTreeTableUI.this.treeTable.getRowMargin();
            int n2 = this.column;
            if (n2 >= 0) {
                dimension = this.getComponentPreferredSize();
                dimension.height += n;
            } else {
                dimension = new Dimension(1, n);
            }
            TableColumnModel tableColumnModel = BasicTreeTableUI.this.treeTable.getColumnModel();
            TreeColumnModel treeColumnModel = BasicTreeTableUI.this.treeTable.getTreeColumnModel();
            Object object = this.node;
            int n3 = tableColumnModel.getColumnCount();
            while (--n3 >= 0) {
                if (n3 == n2) continue;
                Object object2 = treeColumnModel.getValueAt(object, tableColumnModel.getColumn(n3).getModelIndex());
                Component component = this.getTableComponent(object2, false, false, this.row, n3);
                dimension.height = Math.max(dimension.height, component.getPreferredSize().height + n);
            }
            return dimension;
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.tableColumn) {
                this.paintTableComponent(graphics, this.component);
            } else {
                this.paintTreeComponent(graphics, this.component);
            }
        }

        void paintComponent(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
            this.paintComponent(graphics, component, null, n += this.left, n2 += this.top, n3 -= this.left + this.right, n4 -= this.top + this.bottom, true);
        }

        void paintComponent(Graphics graphics, Component component, int n) {
            int n2 = BasicTreeTableUI.this.getSortWidth();
            switch (n) {
                case 0: {
                    this.paintComponent(graphics, component, n2, 0, this.getWidth() - n2 - n2, this.getHeight());
                    break;
                }
                case 2: {
                    this.paintComponent(graphics, component, 0, 0, this.getWidth() - n2, this.getHeight());
                    break;
                }
                case 4: {
                    this.paintComponent(graphics, component, n2, 0, this.getWidth() - n2, this.getHeight());
                }
            }
        }

        protected void paintTableComponent(Graphics graphics, Component component) {
            if (this.shouldPaintBackground(component)) {
                graphics.setColor(component.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (BasicTreeTableUI.this.treeTable.isNodeSortingEnabled()) {
                this.paintComponent(graphics, component, BasicTreeTableUI.this.treeTable.getAlignment(component, this.row, this.column));
            } else {
                this.paintComponent(graphics, component, 0, 0, this.getWidth(), this.getHeight());
            }
        }

        protected boolean shouldPaintBackground(Component component) {
            if (component instanceof JComponent) {
                JComponent jComponent = (JComponent)component;
                return jComponent.isOpaque();
            }
            return component.isBackgroundSet();
        }

        protected void paintTreeComponent(Graphics graphics, Component component) {
            int n = 0;
            int n2 = 0;
            int n3 = this.getWidth();
            int n4 = this.getHeight();
            if (this.getX() + n3 > BasicTreeTableUI.this.tree.getWidth()) {
                n3 = BasicTreeTableUI.this.tree.getWidth() - this.getX();
            }
            this.paintComponent(graphics, component, null, n, n2 += this.top, n3, n4 -= this.top + this.bottom, true);
        }

        @Override
        public boolean isOpaque() {
            Container container = this.getParent();
            return container != null ? container.isOpaque() : super.isOpaque();
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        protected void firePropertyChange(String string, Object object, Object object2) {
        }

        @Override
        public void firePropertyChange(String string, byte by, byte by2) {
        }

        @Override
        public void firePropertyChange(String string, char c, char c2) {
        }

        @Override
        public void firePropertyChange(String string, short s, short s2) {
        }

        @Override
        public void firePropertyChange(String string, int n, int n2) {
        }

        @Override
        public void firePropertyChange(String string, long l, long l2) {
        }

        @Override
        public void firePropertyChange(String string, float f, float f2) {
        }

        @Override
        public void firePropertyChange(String string, double d, double d2) {
        }

        @Override
        public void firePropertyChange(String string, boolean bl, boolean bl2) {
        }

        private void configureCellRenderer(Component component, boolean bl, int n, int n2) {
            Color color = null;
            Color color2 = null;
            TreeTable.DropLocation dropLocation = BasicTreeTableUI.this.treeTable.getDropLocation();
            if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == n && dropLocation.getColumn() == n2) {
                color = this.getDropCellForeground();
                color2 = this.getDropCellBackground();
                bl = true;
            }
            if (bl) {
                component.setForeground(color != null ? color : BasicTreeTableUI.this.treeTable.getSelectionForeground());
                component.setBackground(color2 != null ? color2 : BasicTreeTableUI.this.treeTable.getSelectionBackground());
            } else {
                component.setForeground(BasicTreeTableUI.this.treeTable.getForeground());
                if (this.backgroundColor == null) {
                    this.prepareBackgroundColors();
                }
                component.setBackground(n % 2 == 0 ? this.backgroundColor : this.alternateRowColor);
            }
        }

        public boolean configureCellRenderer(DefaultTreeTableCellRenderer defaultTreeTableCellRenderer, TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            defaultTreeTableCellRenderer.setOpaque(false);
            defaultTreeTableCellRenderer.setIcon(null);
            defaultTreeTableCellRenderer.setDisabledIcon(null);
            this.configureCellRenderer(defaultTreeTableCellRenderer, bl, n, n2);
            defaultTreeTableCellRenderer.setFont(treeTable.getFont());
            if (bl2) {
                Border border = null;
                if (bl) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                defaultTreeTableCellRenderer.setBorder(border);
                if (!bl && BasicTreeTableUI.this.table.isCellEditable(n, n2)) {
                    Color color = UIManager.getColor("Table.focusCellForeground");
                    if (color != null) {
                        super.setForeground(color);
                    }
                    if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                        super.setBackground(color);
                    }
                }
            } else {
                defaultTreeTableCellRenderer.setBorder(this.getNoFocusBorder());
            }
            return bl;
        }

        protected Border getNoFocusBorder() {
            return BasicTreeTableUI.this.getDefaultNoFocusBorder();
        }

        protected Color getDropCellForeground() {
            return UIManager.getColor("Table.dropCellForeground");
        }

        protected Color getDropCellBackground() {
            return UIManager.getColor("Table.dropCellBackground");
        }

        public void configureCellRenderer(DefaultTreeTableCellRenderer defaultTreeTableCellRenderer, TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
            defaultTreeTableCellRenderer.setOpaque(false);
            Color color = bl ? treeTable.getSelectionForeground() : treeTable.getForeground();
            defaultTreeTableCellRenderer.setForeground(color);
            Icon icon = treeTable.getIcon(object, bl3, bl4);
            if (!treeTable.isEnabled()) {
                defaultTreeTableCellRenderer.setEnabled(false);
                defaultTreeTableCellRenderer.setDisabledIcon(icon);
            } else {
                defaultTreeTableCellRenderer.setEnabled(true);
                defaultTreeTableCellRenderer.setIcon(icon);
            }
            ComponentOrientation componentOrientation = treeTable.getComponentOrientation();
            defaultTreeTableCellRenderer.setComponentOrientation(componentOrientation);
            defaultTreeTableCellRenderer.setBorder(componentOrientation.isLeftToRight() ? this.getLTRBorder() : this.getRTLBorder());
            defaultTreeTableCellRenderer.setFont(treeTable.getFont());
        }

        protected Border getLTRBorder() {
            return BasicTreeTableUI.this.getDefaultLTRBorder();
        }

        protected Border getRTLBorder() {
            return BasicTreeTableUI.this.getDefaultRTLBorder();
        }
    }

    protected class Editor
    extends AbstractCellEditor
    implements TableCellEditor,
    CellEditorListener,
    TreeTableCellEditor {
        private TreeEditor defaultTreeEditor;
        private TreeEditorContainer treeEditorContainer;
        private transient TreeTableCellEditor treeTableEditor;
        private transient CellEditor defaultEditor;

        protected Editor() {
        }

        public void loadEditor(int n, int n2) {
            this.clearState();
            this.treeTableEditor = BasicTreeTableUI.this.treeTable.getCellEditor(n, n2);
        }

        public void loadEditor(Class<?> clazz, int n) {
            this.treeTableEditor = this;
            if (n == BasicTreeTableUI.this.treeTable.getHierarchicalColumn()) {
                if (this.defaultTreeEditor == null) {
                    this.defaultTreeEditor = new TreeEditor(BasicTreeTableUI.this.table.getDefaultEditor(Object.class));
                }
                this.defaultEditor = this.defaultTreeEditor;
            } else {
                this.defaultEditor = BasicTreeTableUI.this.table.getDefaultEditor(BasicTreeTableUI.this.table.getColumnClass(n));
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Component component;
            boolean bl2;
            boolean bl3 = bl2 = n2 == BasicTreeTableUI.this.treeTable.getHierarchicalColumn();
            if (bl2) {
                TreePath treePath = BasicTreeTableUI.this.tree.getPathForRow(n);
                boolean bl4 = BasicTreeTableUI.this.tree.isExpanded(treePath);
                boolean bl5 = BasicTreeTableUI.this.treeTable.isLeaf(treePath);
                component = this.treeTableEditor.getTreeTableCellEditorComponent(BasicTreeTableUI.this.treeTable, object, bl, n, n2, bl4, bl5);
            } else {
                component = this.treeTableEditor.getTreeTableCellEditorComponent(BasicTreeTableUI.this.treeTable, object, bl, n, n2);
            }
            if (bl2) {
                if (this.treeEditorContainer == null) {
                    this.treeEditorContainer = new TreeEditorContainer();
                }
                this.treeEditorContainer.setState(component, n);
                component = this.treeEditorContainer;
            }
            this.getEditor().addCellEditorListener(this);
            return component;
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2) {
            return ((TableCellEditor)this.defaultEditor).getTableCellEditorComponent(BasicTreeTableUI.this.table, object, bl, n, n2);
        }

        @Override
        public Component getTreeTableCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
            return this.defaultTreeEditor.getTreeTableCellEditorComponent(treeTable, object, bl, n, n2, bl2, bl3);
        }

        private CellEditor getEditor() {
            return this.defaultEditor != null ? this.defaultEditor : this.treeTableEditor;
        }

        @Override
        public void cancelCellEditing() {
            this.getEditor().cancelCellEditing();
        }

        @Override
        public Object getCellEditorValue() {
            return this.getEditor().getCellEditorValue();
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            return this.getEditor().isCellEditable(eventObject);
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            return this.getEditor().shouldSelectCell(eventObject);
        }

        @Override
        public boolean stopCellEditing() {
            return this.getEditor().stopCellEditing();
        }

        @Override
        public void editingCanceled(ChangeEvent changeEvent) {
            this.fireEditingCanceled();
            this.clearState();
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            this.fireEditingStopped();
            this.clearState();
        }

        public void clearState() {
            if (this.treeTableEditor != null) {
                this.getEditor().removeCellEditorListener(this);
                this.treeTableEditor = null;
                this.defaultEditor = null;
                if (this.treeEditorContainer != null) {
                    this.treeEditorContainer.clearState();
                }
                if (this.defaultTreeEditor != null) {
                    this.defaultTreeEditor.clearState();
                }
            }
        }
    }

    private class RowSorterAdapter
    extends RowSorter<TableModel> {
        private RowSorterAdapter() {
        }

        @Override
        public int convertRowIndexToModel(int n) {
            return n;
        }

        @Override
        public int convertRowIndexToView(int n) {
            return n;
        }

        @Override
        public TableModel getModel() {
            return BasicTreeTableUI.this.getTable().getModel();
        }

        @Override
        public int getModelRowCount() {
            return this.getModel().getRowCount();
        }

        @Override
        public int getViewRowCount() {
            return this.getModelRowCount();
        }

        @Override
        public List<? extends RowSorter.SortKey> getSortKeys() {
            return BasicTreeTableUI.this.treeTable.getRowSorter().getSortKeys();
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> list) {
            BasicTreeTableUI.this.treeTable.getRowSorter().setSortKeys(list);
        }

        @Override
        public void toggleSortOrder(int n) {
            BasicTreeTableUI.this.treeTable.getRowSorter().toggleSortOrder(n);
        }

        @Override
        public void allRowsChanged() {
        }

        @Override
        public void modelStructureChanged() {
        }

        @Override
        public void rowsDeleted(int n, int n2) {
        }

        @Override
        public void rowsInserted(int n, int n2) {
        }

        @Override
        public void rowsUpdated(int n, int n2) {
        }

        @Override
        public void rowsUpdated(int n, int n2, int n3) {
        }

        @Override
        public void addRowSorterListener(RowSorterListener rowSorterListener) {
        }

        @Override
        public void removeRowSorterListener(RowSorterListener rowSorterListener) {
        }
    }

    private class NimbusRenderer
    extends Renderer {
        private static final String collapsedSelected = "Tree[Enabled+Selected].collapsedIconPainter";
        private static final String expandedSelected = "Tree[Enabled+Selected].expandedIconPainter";
        private static final String collapsed = "Tree[Enabled].collapsedIconPainter";
        private static final String expanded = "Tree[Enabled].expandedIconPainter";
        private UIDefaults current;
        private UIDefaults rowSelection;
        private UIDefaults columnSelected;
        private UIDefaults noneSelected;
        private boolean focus;
        private int row;
        private int column;
        private TreeTableCellRenderer focusRenderer;

        NimbusRenderer() {
            this.rowSelection = this.current = (UIDefaults)BasicTreeTableUI.this.tree.getClientProperty("Nimbus.Overrides");
            this.rowSelection.put(collapsed, UIManager.get(collapsed));
            this.rowSelection.put(expanded, UIManager.get(expanded));
            this.rowSelection.put(collapsedSelected, UIManager.get(collapsedSelected));
            this.rowSelection.put(expandedSelected, UIManager.get(expandedSelected));
        }

        private UIDefaults getDefaults() {
            if (this.rowSelectionAllowed) {
                if (!this.columnSelectionAllowed || this.treeColumnSelected) {
                    return this.rowSelection;
                }
            } else if (this.columnSelectionAllowed && this.treeColumnSelected) {
                if (this.columnSelected == null) {
                    this.columnSelected = new UIDefaults();
                    this.columnSelected.putAll(this.rowSelection);
                    this.columnSelected.put(collapsed, UIManager.get(collapsedSelected));
                    this.columnSelected.put(expanded, UIManager.get(expandedSelected));
                }
                return this.columnSelected;
            }
            if (this.noneSelected == null) {
                this.noneSelected = new UIDefaults();
                this.noneSelected.putAll(this.rowSelection);
                this.noneSelected.put(collapsedSelected, UIManager.get(collapsed));
                this.noneSelected.put(expandedSelected, UIManager.get(expanded));
            }
            return this.noneSelected;
        }

        @Override
        public void prepareForTable(Graphics graphics) {
            super.prepareForTable(graphics);
            this.focus = false;
        }

        @Override
        protected void prepareBackgroundColors() {
            super.prepareBackgroundColors();
            this.backgroundColor = BasicTreeTableUI.createColor(this.backgroundColor);
            this.alternateRowColor = BasicTreeTableUI.createColor(this.alternateRowColor);
        }

        @Override
        public void prepareForTree() {
            super.prepareForTree();
            if (System.getSecurityManager() != null) {
                return;
            }
            UIDefaults uIDefaults = this.getDefaults();
            if (uIDefaults == this.current) {
                return;
            }
            this.current = uIDefaults;
            this.clearCachedOverrides(BasicTreeTableUI.this.tree, Region.TREE);
            BasicTreeTableUI.this.tree.putClientProperty("Nimbus.Overrides", uIDefaults);
            this.focus = false;
        }

        @Override
        protected Color getDropCellForeground() {
            return BasicTreeTableUI.createColor(super.getDropCellForeground());
        }

        @Override
        protected Color getDropCellBackground() {
            return BasicTreeTableUI.createColor(super.getDropCellBackground());
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTreeTableCellRendererComponent(treeTable, object, bl, bl2, n, n2);
            this.focus = bl2;
            this.row = n;
            this.column = n2;
            return component;
        }

        @Override
        protected void paintTableComponent(Graphics graphics, Component component) {
            super.paintTableComponent(graphics, component);
            if (this.focus && component instanceof JCheckBox) {
                Component component2 = this.getFocusRenderer().getTreeTableCellRendererComponent(BasicTreeTableUI.this.treeTable, "", false, true, this.row, this.column);
                if (BasicTreeTableUI.this.treeTable.isNodeSortingEnabled()) {
                    this.paintComponent(graphics, component2, BasicTreeTableUI.this.treeTable.getAlignment(component, this.row, this.column));
                } else {
                    this.paintComponent(graphics, component2, BasicTreeTableUI.this.table, 0, 0, this.getWidth(), this.getHeight(), true);
                }
            }
        }

        private TreeTableCellRenderer getFocusRenderer() {
            TreeTableCellRenderer treeTableCellRenderer = BasicTreeTableUI.this.treeTable.getFocusRenderer();
            if (treeTableCellRenderer == null) {
                if (this.focusRenderer == null) {
                    this.focusRenderer = new FocusRenderer();
                }
                treeTableCellRenderer = this.focusRenderer;
            }
            return treeTableCellRenderer;
        }

        private void clearCachedOverrides(JComponent jComponent, Object object) {
            try {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                Class<?> clazz = lookAndFeel.getClass();
                Field field = clazz.getDeclaredField("defaults");
                field.setAccessible(true);
                Object object2 = field.get(lookAndFeel);
                Class<?> clazz2 = object2.getClass();
                Field field2 = clazz2.getDeclaredField("m");
                field2.setAccessible(true);
                Map map = (Map)field2.get(object2);
                List list = (List)map.get(object);
                if (list != null) {
                    for (Object e : list) {
                        Class<?> clazz3 = e.getClass();
                        Field field3 = clazz3.getDeclaredField("overridesCache");
                        field3.setAccessible(true);
                        Map map2 = (Map)field3.get(e);
                        if (map2 == null) continue;
                        map2.remove(jComponent);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private class FocusRenderer
    extends DefaultTableCellRenderer.UIResource
    implements TreeTableCellRenderer {
        private FocusRenderer() {
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return super.getTableCellRendererComponent(BasicTreeTableUI.this.table, object, bl, bl2, n, n2);
        }

        @Override
        public Component getTreeTableCellRendererComponent(TreeTable treeTable, Object object, boolean bl, boolean bl2, int n, int n2, boolean bl3, boolean bl4) {
            return super.getTableCellRendererComponent(BasicTreeTableUI.this.table, object, bl, bl2, n, n2);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    private class Tree
    extends JTree
    implements TreeInterface,
    ProcessKeyBinding {
        Tree(TreeModel treeModel) {
            super(treeModel);
        }

        @Override
        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        public Container getParent() {
            return BasicTreeTableUI.this.treeTable.getParent();
        }

        @Override
        public boolean getDragEnabled() {
            return BasicTreeTableUI.this.treeTable.getDragEnabled();
        }

        @Override
        public boolean hasFocus() {
            return false;
        }

        @Override
        public void computeVisibleRect(Rectangle rectangle) {
            BasicTreeTableUI.this.treeTable.computeVisibleRect(rectangle);
            Rectangle2D.intersect(rectangle, this.getBounds(), rectangle);
            rectangle.x -= this.getX();
            rectangle.y -= this.getY();
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
            BasicTreeTableUI.this.treeTable.repaint(l, n + this.getX(), n2 + this.getY(), n3, n4);
        }

        @Override
        public void paintImmediately(int n, int n2, int n3, int n4) {
            BasicTreeTableUI.this.treeTable.paintImmediately(n + this.getX(), n2 + this.getY(), n3, n4);
        }

        @Override
        public void revalidate() {
            BasicTreeTableUI.this.treeTable.revalidate();
        }

        @Override
        public boolean requestFocusInWindow() {
            return BasicTreeTableUI.this.treeTable.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            BasicTreeTableUI.this.treeTable.requestFocus();
        }

        @Override
        public boolean requestFocus(boolean bl) {
            return BasicTreeTableUI.this.treeTable.requestFocus(bl);
        }

        @Override
        public void doLayout() {
            BasicTreeTableUI.this.layoutTree();
            super.doLayout();
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
            BasicTreeTableUI.this.scrollToVisible(rectangle, this.getX(), this.getY());
        }

        @Override
        protected void setExpandedState(TreePath treePath, boolean bl) {
            TreePath treePath2 = treePath;
            if (bl) {
                TreePath treePath3;
                while ((treePath3 = treePath2.getParentPath()) != null && !this.isExpanded(treePath3)) {
                    treePath2 = treePath3;
                }
            }
            int n = this.getRowCount();
            super.setExpandedState(treePath, bl);
            BasicTreeTableUI.this.updateTableAfterExpansion(treePath2, this.getRowCount() - n);
        }

        @Override
        public void setUI(TreeUI treeUI) {
            super.setUI(treeUI);
            if (treeUI instanceof BasicTreeUI) {
                BasicTreeUI basicTreeUI = (BasicTreeUI)treeUI;
                BasicTreeTableUI.this.treeHandleWidth = basicTreeUI.getLeftChildIndent() + basicTreeUI.getRightChildIndent();
            } else {
                BasicTreeTableUI.this.treeHandleWidth = -1;
            }
        }

        @Override
        public Color getBackground() {
            return BasicTreeTableUI.this.treeTable.getBackground();
        }

        @Override
        public Color getForeground() {
            return BasicTreeTableUI.this.treeTable.getForeground();
        }

        @Override
        public Font getFont() {
            return BasicTreeTableUI.this.treeTable.getFont();
        }
    }

    private static class ColumnModelAdapter
    implements TableColumnModel {
        private TableColumnModel delegate;

        ColumnModelAdapter(TableColumnModel tableColumnModel) {
            this.delegate = tableColumnModel;
        }

        @Override
        public int getColumnMargin() {
            return 0;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            this.delegate.addColumn(tableColumn);
        }

        @Override
        public void addColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.delegate.addColumnModelListener(tableColumnModelListener);
        }

        @Override
        public TableColumn getColumn(int n) {
            return this.delegate.getColumn(n);
        }

        @Override
        public int getColumnCount() {
            return this.delegate.getColumnCount();
        }

        @Override
        public int getColumnIndex(Object object) {
            return this.delegate.getColumnIndex(object);
        }

        @Override
        public int getColumnIndexAtX(int n) {
            return this.delegate.getColumnIndexAtX(n);
        }

        @Override
        public Enumeration<TableColumn> getColumns() {
            return this.delegate.getColumns();
        }

        @Override
        public boolean getColumnSelectionAllowed() {
            return this.delegate.getColumnSelectionAllowed();
        }

        @Override
        public int getSelectedColumnCount() {
            return this.delegate.getSelectedColumnCount();
        }

        @Override
        public int[] getSelectedColumns() {
            return this.delegate.getSelectedColumns();
        }

        @Override
        public ListSelectionModel getSelectionModel() {
            return this.delegate.getSelectionModel();
        }

        @Override
        public int getTotalColumnWidth() {
            return this.delegate.getTotalColumnWidth();
        }

        @Override
        public void moveColumn(int n, int n2) {
            this.delegate.moveColumn(n, n2);
        }

        @Override
        public void removeColumn(TableColumn tableColumn) {
            this.delegate.removeColumn(tableColumn);
        }

        @Override
        public void removeColumnModelListener(TableColumnModelListener tableColumnModelListener) {
            this.delegate.removeColumnModelListener(tableColumnModelListener);
        }

        @Override
        public void setColumnMargin(int n) {
            this.delegate.setColumnMargin(n);
        }

        @Override
        public void setColumnSelectionAllowed(boolean bl) {
            this.delegate.setColumnSelectionAllowed(bl);
        }

        @Override
        public void setSelectionModel(ListSelectionModel listSelectionModel) {
            this.delegate.setSelectionModel(listSelectionModel);
        }
    }

    private class Table
    extends InternalTableWithMargins
    implements TableInterface,
    ProcessKeyBinding {
        private RowSorter<? extends TableModel> rowSorter;

        Table(TableModel tableModel, TableColumnModel tableColumnModel, ListSelectionModel listSelectionModel) {
            super(tableModel, tableColumnModel, listSelectionModel);
        }

        @Override
        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        public boolean getDragEnabled() {
            return BasicTreeTableUI.this.treeTable.getDragEnabled();
        }

        @Override
        public Container getParent() {
            return BasicTreeTableUI.this.treeTable.getParent();
        }

        @Override
        public void computeVisibleRect(Rectangle rectangle) {
            BasicTreeTableUI.this.treeTable.computeVisibleRect(rectangle);
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
            BasicTreeTableUI.this.treeTable.repaint(l, n + this.getX(), n2 + this.getY(), n3, n4);
        }

        @Override
        public void paintImmediately(int n, int n2, int n3, int n4) {
            BasicTreeTableUI.this.treeTable.paintImmediately(n + this.getX(), n2 + this.getY(), n3, n4);
        }

        @Override
        public void revalidate() {
            BasicTreeTableUI.this.treeTable.revalidate();
        }

        @Override
        public boolean requestFocusInWindow() {
            return BasicTreeTableUI.this.treeTable.requestFocusInWindow();
        }

        @Override
        public void requestFocus() {
            BasicTreeTableUI.this.treeTable.requestFocus();
        }

        @Override
        public boolean requestFocus(boolean bl) {
            return BasicTreeTableUI.this.treeTable.requestFocus(bl);
        }

        @Override
        public void doLayout() {
            BasicTreeTableUI.this.layoutTable();
            super.doLayout();
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
            BasicTreeTableUI.this.scrollToVisible(rectangle, this.getX(), this.getY());
        }

        @Override
        public boolean hasFocus() {
            return BasicTreeTableUI.this.treeTable.hasFocus();
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            BasicTreeTableUI.this.treeTableCellEditor.loadEditor(n, n2);
            return BasicTreeTableUI.this.treeTableCellEditor;
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            if (super.editCellAt(n, n2, eventObject)) {
                if (n2 == BasicTreeTableUI.this.treeTable.getHierarchicalColumn()) {
                    Rectangle rectangle = BasicTreeTableUI.this.tree.getRowBounds(n);
                    rectangle.x = 0;
                    rectangle.width = BasicTreeTableUI.this.tree.getWidth();
                    BasicTreeTableUI.this.tree.repaint(rectangle);
                }
                return true;
            }
            return false;
        }

        @Override
        public Component prepareEditor(TableCellEditor tableCellEditor, int n, int n2) {
            return super.prepareEditor(tableCellEditor, n, n2);
        }

        @Override
        protected void addImpl(Component component, Object object, int n) {
            if (component instanceof CellRendererPane) {
                super.addImpl(component, object, n);
            } else {
                BasicTreeTableUI.this.treeTable.add(component, object, n);
            }
        }

        @Override
        public void remove(Component component) {
            if (component instanceof CellRendererPane) {
                super.remove(component);
            } else {
                BasicTreeTableUI.this.treeTable.remove(component);
            }
        }

        @Override
        public Color getBackground() {
            return BasicTreeTableUI.this.treeTable.getBackground();
        }

        @Override
        public Color getForeground() {
            return BasicTreeTableUI.this.treeTable.getForeground();
        }

        @Override
        public Font getFont() {
            return BasicTreeTableUI.this.treeTable.getFont();
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            return BasicTreeTableUI.this.treeTableCellRenderer;
        }

        @Override
        public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
            TreeTable treeTable = BasicTreeTableUI.this.treeTable;
            boolean bl = n2 == treeTable.getHierarchicalColumn();
            String string = bl ? "" : this.getValueAt(n, n2);
            boolean bl2 = !this.isPaintingForPrint() && this.isCellSelected(n, n2);
            boolean bl3 = false;
            return tableCellRenderer.getTableCellRendererComponent(this, string, bl2, bl3, n, n2);
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            if (BasicTreeTableUI.this.table == null) {
                if (this.getAutoCreateColumnsFromModel()) {
                    this.createDefaultColumnsFromModel();
                }
            } else {
                super.tableChanged(tableModelEvent);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            super.columnAdded(tableColumnModelEvent);
            if (BasicTreeTableUI.this.tree.getRowHeight() <= 0) {
                BasicTreeTableUI.this.treeTable.invalidateAllRows();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            super.columnMoved(tableColumnModelEvent);
            if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                BasicTreeTableUI.this.tree.doLayout();
            }
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            super.columnRemoved(tableColumnModelEvent);
            if (BasicTreeTableUI.this.tree.getRowHeight() <= 0) {
                BasicTreeTableUI.this.treeTable.invalidateAllRows();
            }
        }

        @Override
        public void createDefaultColumnsFromModel() {
            TableModel tableModel = this.getModel();
            if (tableModel != null) {
                TableColumnModel tableColumnModel = this.getColumnModel();
                while (tableColumnModel.getColumnCount() > 0) {
                    tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
                }
                for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                    this.addColumn(new TreeTableColumn(i));
                }
            }
        }

        @Override
        public RowSorter<? extends TableModel> getRowSorter() {
            return this.rowSorter;
        }

        @Override
        public void setRowSorter(RowSorter<? extends TableModel> rowSorter) {
            RowSorter<? extends TableModel> rowSorter2 = this.getRowSorter();
            this.rowSorter = rowSorter;
            this.firePropertyChange("rowSorter", rowSorter2, rowSorter);
        }

        @Override
        public TransferHandler getTransferHandler() {
            TransferHandler transferHandler = BasicTreeTableUI.this.treeTable.getTransferHandler();
            if (transferHandler != null) {
                return transferHandler;
            }
            return super.getTransferHandler();
        }

        @Override
        public Rectangle getCellBounds(int n, int n2, boolean bl) {
            return super.getCellRect(n, n2, bl);
        }
    }

    protected static interface ProcessKeyBinding {
        public boolean processKeyBinding(KeyStroke var1, KeyEvent var2, int var3, boolean var4);
    }

    private class TreeEditor
    extends CellEditorContainer<TableCellEditor> {
        TreeEditor(TableCellEditor tableCellEditor) {
            super(tableCellEditor);
        }

        @Override
        public Component getCellEditorComponent(TreeTable treeTable, Object object, boolean bl, int n, int n2, boolean bl2, boolean bl3) {
            return ((TableCellEditor)this.editor).getTableCellEditorComponent(BasicTreeTableUI.this.table, object, bl, n, n2);
        }
    }

    private class TreeEditorContainer
    extends Container {
        private Component component;
        private int row;

        TreeEditorContainer() {
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            Rectangle rectangle = BasicTreeTableUI.this.tree.getRowBounds(this.row);
            if (BasicTreeTableUI.this.tree.getComponentOrientation().isLeftToRight()) {
                n = rectangle.x;
                n3 -= rectangle.x;
            } else {
                n3 = rectangle.x + rectangle.width;
            }
            this.component.setBounds(0, 0, n3, n4);
            super.setBounds(n, n2, n3, n4);
        }

        void setState(Component component, int n) {
            this.add(component);
            this.component = component;
            this.row = n;
        }

        void clearState() {
            this.removeAll();
            this.component = null;
        }
    }

    protected static class TreeTableColumn
    extends TableColumn {
        public TreeTableColumn(int n) {
            super(n);
        }

        @Override
        public void setCellRenderer(TableCellRenderer tableCellRenderer) {
            if (tableCellRenderer != null && !(tableCellRenderer instanceof TreeTableCellRenderer)) {
                throw new IllegalArgumentException("renderer must implement TreeTableCellRenderer");
            }
            super.setCellRenderer(tableCellRenderer);
        }

        @Override
        public void setCellEditor(TableCellEditor tableCellEditor) {
            if (tableCellEditor != null && !(tableCellEditor instanceof TreeTableCellEditor)) {
                throw new IllegalArgumentException("editor must implement TreeTableCellEditor");
            }
            super.setCellEditor(tableCellEditor);
        }
    }
}

