/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.InsetterNotInvertibleException;
import org.violetlib.jnr.impl.Insetter1;

public class FloatingInsetter1
implements Insetter1 {
    private final float regionSize;
    @NotNull
    private final Alignment alignment;
    private final float d1;
    private final float d2;

    @NotNull
    public static FloatingInsetter1 createLeftTopAligned(float f, float f2) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        return new FloatingInsetter1(f, Alignment.LEFT, f2, 0.0f);
    }

    @NotNull
    public static FloatingInsetter1 createRightBottomAligned(float f, float f2) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        if (f2 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        return new FloatingInsetter1(f, Alignment.RIGHT, 0.0f, f2);
    }

    @NotNull
    public static FloatingInsetter1 createCentered(float f, float f2, float f3) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        if (f2 < 0.0f || f3 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        return new FloatingInsetter1(f, Alignment.CENTER, f2, f3);
    }

    private FloatingInsetter1(float f, @NotNull Alignment alignment, float f2, float f3) {
        this.regionSize = f;
        this.alignment = alignment;
        this.d1 = f2;
        this.d2 = f3;
    }

    @Override
    public float getRegionOrigin(float f) {
        switch (this.alignment.ordinal()) {
            case 0: {
                return this.d1;
            }
            case 1: {
                return f - (this.regionSize + this.d2);
            }
            case 2: {
                float f2 = f - (this.regionSize + this.d1 + this.d2);
                return this.d1 + f2 / 2.0f;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float getRegionSize(float f) {
        return this.regionSize;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public float getComponentSize(float f) throws InsetterNotInvertibleException {
        return f + this.d1 + this.d2;
    }

    @Override
    public float getFixedInset1() {
        switch (this.alignment.ordinal()) {
            case 0: 
            case 2: {
                return this.d1;
            }
        }
        return -1.0f;
    }

    @Override
    public float getFixedInset2() {
        switch (this.alignment.ordinal()) {
            case 1: 
            case 2: {
                return this.d2;
            }
        }
        return -1.0f;
    }

    @Override
    public float getFixedRegionSize() {
        return this.regionSize;
    }

    private static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

