/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.BigSurLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class MontereyLayoutInfo
extends BigSurLayoutInfo {
    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
        AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            switch (size) {
                case LARGE: {
                    return BasicLayoutInfo.createMinimum(18.0f, 30.0f);
                }
                case REGULAR: {
                    return BasicLayoutInfo.createMinimum(18.0f, 22.0f);
                }
                case SMALL: {
                    return BasicLayoutInfo.createMinimum(14.0f, 18.0f);
                }
                case MINI: {
                    return BasicLayoutInfo.createMinimum(14.0f, 16.0f);
                }
            }
            throw new UnsupportedOperationException("Unsupported size");
        }
        return super.getButtonLayoutInfo(buttonLayoutConfiguration);
    }

    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
            float f = JNRUtils.size(size, 2, 2, 1, 1);
            float f2 = 2.0f;
            float f3 = JNRUtils.size(size, 4, 4, 4, 3);
            LayoutInfo layoutInfo = this.getLayoutInfo(buttonLayoutConfiguration);
            return Insetters.createFixed(f, f3, f2, f3, layoutInfo);
        }
        return super.getButtonLabelInsets(buttonLayoutConfiguration);
    }
}

