/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.vappearances.VAppearance;

public class AquaPixelsKey
implements ImageCache.PixelsKey {
    private final int pixelCount;
    private final int hash;
    private final int scaleFactor;
    private final int w;
    private final int h;
    @NotNull
    private final Configuration g;
    @NotNull
    private final VAppearance appearance;

    public AquaPixelsKey(int n, int n2, int n3, @NotNull Configuration configuration, @NotNull VAppearance vAppearance) {
        this.pixelCount = n2 * n3;
        this.scaleFactor = n;
        this.w = n2;
        this.h = n3;
        this.g = configuration;
        this.appearance = vAppearance;
        this.hash = this.hash();
    }

    @Override
    public int getPixelCount() {
        return this.pixelCount;
    }

    private int hash() {
        int n = this.scaleFactor;
        n = 31 * n + this.w;
        n = 31 * n + this.h;
        n = 31 * n + this.g.hashCode();
        n = 31 * n + this.appearance.hashCode();
        return n;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object object) {
        if (object != null && object.getClass() == AquaPixelsKey.class) {
            AquaPixelsKey aquaPixelsKey = (AquaPixelsKey)object;
            return this.scaleFactor == aquaPixelsKey.scaleFactor && this.w == aquaPixelsKey.w && this.h == aquaPixelsKey.h && this.g.equals(aquaPixelsKey.g) && this.appearance.equals(aquaPixelsKey.appearance);
        }
        return false;
    }
}

