/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.RenderInsets;
import org.violetlib.jnr.aqua.impl.SegmentButtonRenderingConfiguration1;
import org.violetlib.jnr.aqua.impl.SegmentButtonRenderingConfiguration4;
import org.violetlib.jnr.aqua.impl.SegmentedControl1LayoutInfo;
import org.violetlib.jnr.aqua.impl.SegmentedControl4LayoutInfo;
import org.violetlib.jnr.aqua.impl.SegmentedControlConfiguration;
import org.violetlib.jnr.aqua.impl.SegmentedControlConfiguration1;
import org.violetlib.jnr.aqua.impl.SegmentedControlConfiguration4;
import org.violetlib.jnr.aqua.impl.SegmentedControlDescriptions;
import org.violetlib.jnr.aqua.impl.SegmentedControlLayoutInfo;
import org.violetlib.jnr.impl.AnnotatedSegmentedControlImage;
import org.violetlib.jnr.impl.BasicImageSupport;
import org.violetlib.jnr.impl.PixelRaster;
import org.violetlib.jnr.impl.PixelRasterImpl;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDebugInfo;
import org.violetlib.jnr.impl.ReusableCompositor;

public class AquaNativeSegmentedControlPainter {
    protected final SegmentedControlDescriptions scds = new SegmentedControlDescriptions();
    private static final int SELECT_SEGMENT_1 = 8;
    private static final int SELECT_SEGMENT_2 = 4;
    private static final int SELECT_SEGMENT_3 = 2;
    private static final int SELECT_SEGMENT_4 = 1;
    private static final int CONTEXT_WINDOW = 1;
    private static final int CONTEXT_TOOLBAR = 2;

    @NotNull
    public Renderer createSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration) {
        return new SegmentedButtonRenderer(segmentedButtonConfiguration);
    }

    @NotNull
    private static Rectangle2D extractBounds(@NotNull float[] fArray, int n) {
        return new Rectangle2D.Float(fArray[n], fArray[n + 1], fArray[n + 2], fArray[n + 3]);
    }

    @Nullable
    public RendererDebugInfo getSegmentedButtonRendererDebugInfo(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, int n, int n2, int n3) {
        RenderInsets renderInsets = this.scds.getInsets(segmentedButtonConfiguration, n);
        if (segmentedButtonConfiguration.getPosition() == AquaUIPainter.Position.ONLY) {
            SegmentedControl1LayoutInfo segmentedControl1LayoutInfo = this.scds.getSegment1LayoutInfo(segmentedButtonConfiguration, n);
            SegmentButtonRenderingConfiguration1 segmentButtonRenderingConfiguration1 = this.getRenderConfiguration(segmentedButtonConfiguration.isSelected(), renderInsets, segmentedControl1LayoutInfo, n, n2, n3);
            SegmentedControlConfiguration1 segmentedControlConfiguration1 = this.createControlConfiguration(segmentedButtonConfiguration, segmentButtonRenderingConfiguration1);
            int n4 = Math.round(n * segmentButtonRenderingConfiguration1.rasterWidth);
            int n5 = Math.round(n * segmentButtonRenderingConfiguration1.rasterHeight);
            int[] nArray = new int[n4 * n5];
            return this.paintSegmentedControl1(nArray, n4, n5, n, segmentedControlConfiguration1, true);
        }
        SegmentedControl4LayoutInfo segmentedControl4LayoutInfo = this.scds.getSegment4LayoutInfo(segmentedButtonConfiguration, n);
        SegmentButtonRenderingConfiguration4 segmentButtonRenderingConfiguration4 = this.getRenderConfiguration(segmentedButtonConfiguration, renderInsets, segmentedControl4LayoutInfo, n, n2, n3);
        SegmentedControlConfiguration4 segmentedControlConfiguration4 = this.createControlConfiguration(segmentedButtonConfiguration, segmentButtonRenderingConfiguration4);
        int n6 = Math.round(n * segmentButtonRenderingConfiguration4.rasterWidth);
        int n7 = Math.round(n * segmentButtonRenderingConfiguration4.rasterHeight);
        int[] nArray = new int[n6 * n7];
        return this.paintSegmentedControl4(nArray, n6, n7, n, segmentedControlConfiguration4, true);
    }

    @Nullable
    public float[] getSegmentedButtonLayoutParameters(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration) {
        float[] fArray;
        int n = AquaNativePainter.toSize(segmentedButtonLayoutConfiguration.getSize());
        int n2 = AquaNativePainter.toSegmentedStyle(segmentedButtonLayoutConfiguration.getWidget());
        int n3 = AquaNativeSegmentedControlPainter.nativeDetermineSegmentedButtonLayoutParameters(n2, n, fArray = new float[8]);
        return (float[])(n3 == 0 ? fArray : null);
    }

    @NotNull
    public SegmentedControlLayoutInfo getSegmentLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration, int n) {
        return this.scds.getSegmentLayoutInfo(segmentedButtonLayoutConfiguration, n);
    }

    @NotNull
    public RenderInsets getSegmentedControlInsets(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration, int n) {
        return this.scds.getInsets(segmentedButtonLayoutConfiguration, n);
    }

    @NotNull
    public SegmentButtonRenderingConfiguration1 getRenderConfiguration(boolean bl, @NotNull RenderInsets renderInsets, @NotNull SegmentedControl1LayoutInfo segmentedControl1LayoutInfo, int n, int n2, int n3) {
        float f = (float)n2 - segmentedControl1LayoutInfo.widthAdjustment;
        int n4 = (int)Math.ceil((float)n2 + renderInsets.widthAdjust);
        int n5 = (int)Math.ceil((float)n3 + renderInsets.heightAdjust);
        return new SegmentButtonRenderingConfiguration1(n, bl, f, n4, n5);
    }

    @NotNull
    public SegmentButtonRenderingConfiguration4 getRenderConfiguration(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @NotNull RenderInsets renderInsets, @NotNull SegmentedControl4LayoutInfo segmentedControl4LayoutInfo, int n, int n2, int n3) {
        boolean bl = segmentedButtonConfiguration.getWidget().isSeparated();
        boolean bl2 = segmentedButtonConfiguration.isSelected();
        AquaUIPainter.Position position = segmentedButtonConfiguration.getPosition();
        SegmentedButtonConfiguration.DividerState dividerState = segmentedButtonConfiguration.getLeftDividerState();
        SegmentedButtonConfiguration.DividerState dividerState2 = segmentedButtonConfiguration.getRightDividerState();
        return this.getRenderConfiguration(bl, bl2, position, dividerState, dividerState2, renderInsets, segmentedControl4LayoutInfo, n, n2, n3);
    }

    @NotNull
    public SegmentButtonRenderingConfiguration4 getRenderConfiguration(boolean bl, boolean bl2, @NotNull AquaUIPainter.Position position, @NotNull SegmentedButtonConfiguration.DividerState dividerState, @NotNull SegmentedButtonConfiguration.DividerState dividerState2, @NotNull RenderInsets renderInsets, @NotNull SegmentedControl4LayoutInfo segmentedControl4LayoutInfo, int n, int n2, int n3) {
        int n4;
        int n5;
        boolean bl3;
        float f;
        int n6;
        SegmentedControl4LayoutInfo.DividerPosition dividerPosition = segmentedControl4LayoutInfo.dividerPosition;
        float f2 = segmentedControl4LayoutInfo.dividerVisualWidth;
        float f3 = segmentedControl4LayoutInfo.firstSegmentWidthAdjustment;
        float f4 = segmentedControl4LayoutInfo.middleSegmentWidthAdjustment;
        float f5 = segmentedControl4LayoutInfo.lastSegmentWidthAdjustment;
        float f6 = 20.0f;
        int n7 = -1;
        float f7 = 0.0f;
        float f8 = 0.0f;
        if (position == AquaUIPainter.Position.FIRST) {
            n6 = 0;
            f = (float)n2 - f3;
        } else if (position == AquaUIPainter.Position.MIDDLE) {
            n6 = 1;
            f = (float)n2 - f4;
        } else if (position == AquaUIPainter.Position.LAST) {
            n6 = 3;
            f = (float)n2 - f5;
        } else {
            throw new AssertionError((Object)"Unexpected segment position");
        }
        if (bl2) {
            n7 = n6;
        } else if (dividerState == SegmentedButtonConfiguration.DividerState.SELECTED) {
            if (n6 > 0) {
                n7 = n6 - 1;
            }
        } else if (dividerState2 == SegmentedButtonConfiguration.DividerState.SELECTED) {
            if (n6 == 1) {
                n6 = 2;
                n7 = 3;
            } else if (n6 == 0) {
                n7 = 1;
            }
        }
        if (n6 > 0) {
            f7 = (float)n6 * (f6 + f4) + (f3 - f4);
            f8 += f3;
        }
        if (n6 < 3) {
            f8 += f5;
        }
        f8 = n6 == 0 || n6 == 3 ? (f8 += 2.0f * f4) : (f8 += f4);
        boolean bl4 = bl3 = bl && n != 1 && dividerPosition == SegmentedControl4LayoutInfo.DividerPosition.CENTER;
        if (!bl3 && f2 > 0.0f) {
            if (n6 > 0 && dividerPosition != SegmentedControl4LayoutInfo.DividerPosition.LEFT) {
                f7 += f2;
                f += f2;
                f8 += f2;
            }
            if (n6 < 3 && dividerPosition != SegmentedControl4LayoutInfo.DividerPosition.RIGHT) {
                f += f2;
                f8 += f2;
            }
            boolean bl5 = n6 > 0 && dividerState != SegmentedButtonConfiguration.DividerState.NONE;
            int n8 = n5 = n6 < 3 && dividerState2 != SegmentedButtonConfiguration.DividerState.NONE ? 1 : 0;
            if (bl5) {
                f7 -= f2;
                n4 = (int)Math.ceil(f2);
                if (dividerPosition == SegmentedControl4LayoutInfo.DividerPosition.CENTER) {
                    f7 -= f2;
                    n4 = (int)((float)n4 + f2);
                }
                f -= (float)n4;
                f8 -= (float)n4;
            }
            if (n5 != 0) {
                f -= f2;
                f8 -= f2;
                if (dividerPosition == SegmentedControl4LayoutInfo.DividerPosition.CENTER) {
                    f -= f2;
                    f8 -= f2;
                }
            }
        }
        float f9 = 3.0f * f6 + (float)n2 + f8;
        n5 = (int)Math.ceil(f9 + renderInsets.widthAdjust);
        n4 = (int)Math.ceil((float)n3 + renderInsets.heightAdjust);
        Rectangle2D rectangle2D = AquaNativeSegmentedControlPainter.createPixelBounds(n, renderInsets.left + f7, renderInsets.top, n2, n3);
        return new SegmentButtonRenderingConfiguration4(n, n6 + 1, n7 + 1, f, f6, n5, n4, rectangle2D);
    }

    @NotNull
    private static Rectangle2D createPixelBounds(int n, double d, double d2, double d3, double d4) {
        double d5 = AquaNativeSegmentedControlPainter.round(d + d3, n);
        double d6 = AquaNativeSegmentedControlPainter.round(d2 + d4, n);
        d = AquaNativeSegmentedControlPainter.round(d, n);
        d2 = AquaNativeSegmentedControlPainter.round(d2, n);
        d3 = d5 - d;
        d4 = d6 - d2;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private static double round(double d, int n) {
        if (n == 1) {
            return Math.round(d);
        }
        return (double)Math.round(d * (double)n) / (double)n;
    }

    @NotNull
    public SegmentedControlConfiguration1 createControlConfiguration(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @Nullable SegmentButtonRenderingConfiguration1 segmentButtonRenderingConfiguration1) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        boolean bl = segmentedButtonWidget.isToolbar();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        AquaUIPainter.State state = segmentedButtonConfiguration.getState();
        AquaUIPainter.SwitchTracking switchTracking = segmentedButtonConfiguration.getTracking();
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget2 = segmentedButtonWidget.toBasicWidget();
        float f = segmentButtonRenderingConfiguration1 != null ? segmentButtonRenderingConfiguration1.segmentWidth : 20.0f;
        boolean bl2 = segmentButtonRenderingConfiguration1 != null && segmentButtonRenderingConfiguration1.isSelected;
        return new SegmentedControlConfiguration1(segmentedButtonWidget2, bl, size, state, f, bl2);
    }

    @NotNull
    public SegmentedControlConfiguration4 createControlConfiguration(@NotNull SegmentedButtonConfiguration segmentedButtonConfiguration, @Nullable SegmentButtonRenderingConfiguration4 segmentButtonRenderingConfiguration4) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonConfiguration.getWidget();
        boolean bl = segmentedButtonWidget.isToolbar();
        AquaUIPainter.Size size = segmentedButtonConfiguration.getSize();
        AquaUIPainter.State state = segmentedButtonConfiguration.getState();
        AquaUIPainter.SwitchTracking switchTracking = segmentedButtonConfiguration.getTracking();
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget2 = segmentedButtonWidget.toBasicWidget();
        float f = segmentButtonRenderingConfiguration4 != null ? segmentButtonRenderingConfiguration4.otherSegmentWidth : 20.0f;
        float f2 = segmentButtonRenderingConfiguration4 != null ? segmentButtonRenderingConfiguration4.otherSegmentWidth : 20.0f;
        float f3 = segmentButtonRenderingConfiguration4 != null ? segmentButtonRenderingConfiguration4.otherSegmentWidth : 20.0f;
        float f4 = segmentButtonRenderingConfiguration4 != null ? segmentButtonRenderingConfiguration4.otherSegmentWidth : 20.0f;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (segmentButtonRenderingConfiguration4 != null) {
            int n = segmentButtonRenderingConfiguration4.designatedSegment;
            if (n == 1) {
                f = segmentButtonRenderingConfiguration4.segmentWidth;
            } else if (n == 2) {
                f2 = segmentButtonRenderingConfiguration4.segmentWidth;
            } else if (n == 3) {
                f3 = segmentButtonRenderingConfiguration4.segmentWidth;
            } else if (n == 4) {
                f4 = segmentButtonRenderingConfiguration4.segmentWidth;
            }
            int n2 = segmentedButtonConfiguration.getLeftDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED && segmentButtonRenderingConfiguration4.selectedSegment > 0 ? segmentButtonRenderingConfiguration4.selectedSegment - 1 : 0;
            int n3 = segmentedButtonConfiguration.getRightDividerState() == SegmentedButtonConfiguration.DividerState.SELECTED && segmentButtonRenderingConfiguration4.selectedSegment > 0 ? segmentButtonRenderingConfiguration4.selectedSegment + 1 : 0;
            n = segmentButtonRenderingConfiguration4.selectedSegment;
            if (n == 1 || n2 == 1) {
                bl2 = true;
            }
            if (n == 2 || n2 == 2 || n3 == 2) {
                bl3 = true;
            }
            if (n == 3 || n2 == 3 || n3 == 3) {
                bl4 = true;
            }
            if (n == 4 || n3 == 4) {
                bl5 = true;
            }
        }
        return new SegmentedControlConfiguration4(segmentedButtonWidget2, bl, size, state, switchTracking, f, f2, f3, f4, bl2, bl3, bl4, bl5);
    }

    @Nullable
    public AnnotatedSegmentedControlImage paintSegmentedControl(@NotNull int[] nArray, int n, int n2, float f, SegmentedControlConfiguration segmentedControlConfiguration, boolean bl) {
        if (segmentedControlConfiguration instanceof SegmentedControlConfiguration1) {
            return this.paintSegmentedControl1(nArray, n, n2, f, (SegmentedControlConfiguration1)segmentedControlConfiguration, bl);
        }
        return this.paintSegmentedControl4(nArray, n, n2, f, (SegmentedControlConfiguration4)segmentedControlConfiguration, bl);
    }

    @Nullable
    private AnnotatedSegmentedControlImage paintSegmentedControl1(@NotNull int[] nArray, int n, int n2, float f, SegmentedControlConfiguration1 segmentedControlConfiguration1, boolean bl) {
        if (n < 1 || n2 < 1 || nArray.length < n * n2) {
            throw new IllegalArgumentException("Invalid raster size or length");
        }
        if ((double)f < 0.01 || f > 100.0f) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        int n3 = AquaNativePainter.toSize(segmentedControlConfiguration1.size);
        int n4 = AquaNativePainter.toState(segmentedControlConfiguration1.state);
        int n5 = AquaNativePainter.toSegmentedStyle(segmentedControlConfiguration1.widget);
        boolean bl2 = segmentedControlConfiguration1.isSelected;
        int n6 = segmentedControlConfiguration1.isToolbar ? 2 : 1;
        float[] fArray = bl ? new float[4] : null;
        AquaNativeSegmentedControlPainter.nativePaintSegmentedControl1(nArray, n, n2, f, segmentedControlConfiguration1.w, n5, bl2, n6, n3, n4, fArray);
        if (fArray != null) {
            int n7 = fArray.length / 4;
            Rectangle2D[] rectangle2DArray = new Rectangle2D[n7];
            int n8 = 0;
            for (int i = 0; i < n7; ++i) {
                rectangle2DArray[i] = AquaNativeSegmentedControlPainter.extractBounds(fArray, n8);
                n8 += 4;
            }
            BufferedImage bufferedImage = BasicImageSupport.createImage(nArray, n, n2);
            return new AnnotatedSegmentedControlImage(bufferedImage, rectangle2DArray);
        }
        return null;
    }

    @Nullable
    private AnnotatedSegmentedControlImage paintSegmentedControl4(@NotNull int[] nArray, int n, int n2, float f, SegmentedControlConfiguration4 segmentedControlConfiguration4, boolean bl) {
        if (n < 1 || n2 < 1 || nArray.length < n * n2) {
            throw new IllegalArgumentException("Invalid raster size or length");
        }
        if ((double)f < 0.01 || f > 100.0f) {
            throw new IllegalArgumentException("Invalid or unsupported scale factor");
        }
        int n3 = AquaNativePainter.toSize(segmentedControlConfiguration4.size);
        int n4 = AquaNativePainter.toState(segmentedControlConfiguration4.state);
        int n5 = AquaNativePainter.toSegmentedStyle(segmentedControlConfiguration4.widget);
        int n6 = AquaNativePainter.toTracking(segmentedControlConfiguration4.tracking);
        int n7 = AquaNativeSegmentedControlPainter.toSelectionFlags(segmentedControlConfiguration4.s1, segmentedControlConfiguration4.s2, segmentedControlConfiguration4.s3, segmentedControlConfiguration4.s4);
        int n8 = segmentedControlConfiguration4.isToolbar ? 2 : 1;
        float[] fArray = bl ? new float[16] : null;
        AquaNativeSegmentedControlPainter.nativePaintSegmentedControl4(nArray, n, n2, f, segmentedControlConfiguration4.w1, segmentedControlConfiguration4.w2, segmentedControlConfiguration4.w3, segmentedControlConfiguration4.w4, n5, n6, n7, n8, n3, n4, fArray);
        if (fArray != null) {
            int n9 = fArray.length / 4;
            Rectangle2D[] rectangle2DArray = new Rectangle2D[n9];
            int n10 = 0;
            for (int i = 0; i < n9; ++i) {
                rectangle2DArray[i] = AquaNativeSegmentedControlPainter.extractBounds(fArray, n10);
                n10 += 4;
            }
            BufferedImage bufferedImage = BasicImageSupport.createImage(nArray, n, n2);
            return new AnnotatedSegmentedControlImage(bufferedImage, rectangle2DArray);
        }
        return null;
    }

    private static int toSelectionFlags(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return (bl ? 8 : 0) | (bl2 ? 4 : 0) | (bl3 ? 2 : 0) | (bl4 ? 1 : 0);
    }

    private static native int nativePaintSegmentedControl4(int[] var0, int var1, int var2, float var3, float var4, float var5, float var6, float var7, int var8, int var9, int var10, int var11, int var12, int var13, @Nullable float[] var14);

    private static native int nativePaintSegmentedControl1(int[] var0, int var1, int var2, float var3, float var4, int var5, boolean var6, int var7, int var8, int var9, @Nullable float[] var10);

    private static native int nativeDetermineSegmentedButtonLayoutParameters(int var0, int var1, float[] var2);

    public static native int nativeDetermineSegmentedButtonRenderingVersion();

    private static native int nativeDetermineSegmentedButtonFixedHeight(int var0, int var1);

    private class SegmentedButtonRenderer
    extends Renderer {
        @NotNull
        private final SegmentedButtonConfiguration g;

        public SegmentedButtonRenderer(SegmentedButtonConfiguration segmentedButtonConfiguration) {
            this.g = segmentedButtonConfiguration;
        }

        @Override
        public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray;
            int n5;
            int n6;
            Object object;
            int n7 = reusableCompositor.getScaleFactor();
            int n8 = Math.round(reusableCompositor.getWidth());
            int n9 = Math.round(reusableCompositor.getHeight());
            RenderInsets renderInsets = AquaNativeSegmentedControlPainter.this.scds.getInsets(this.g, n7);
            if (this.g.getPosition() == AquaUIPainter.Position.ONLY) {
                object = AquaNativeSegmentedControlPainter.this.scds.getSegment1LayoutInfo(this.g, n7);
                SegmentButtonRenderingConfiguration1 segmentButtonRenderingConfiguration1 = AquaNativeSegmentedControlPainter.this.getRenderConfiguration(this.g.isSelected(), renderInsets, (SegmentedControl1LayoutInfo)object, n7, n8, n9);
                SegmentedControlConfiguration1 segmentedControlConfiguration1 = AquaNativeSegmentedControlPainter.this.createControlConfiguration(this.g, segmentButtonRenderingConfiguration1);
                n6 = Math.round(n7 * segmentButtonRenderingConfiguration1.rasterWidth);
                n5 = Math.round(n7 * segmentButtonRenderingConfiguration1.rasterHeight);
                nArray = new int[n6 * n5];
                AquaNativeSegmentedControlPainter.this.paintSegmentedControl1(nArray, n6, n5, n7, segmentedControlConfiguration1, false);
                n4 = Math.round((float)n7 * renderInsets.left);
                n3 = Math.round((float)n7 * renderInsets.top);
                n2 = Math.round(n7 * n8);
                n = Math.round(n7 * n9);
            } else {
                object = AquaNativeSegmentedControlPainter.this.scds.getSegment4LayoutInfo(this.g, n7);
                SegmentButtonRenderingConfiguration4 segmentButtonRenderingConfiguration4 = AquaNativeSegmentedControlPainter.this.getRenderConfiguration(this.g, renderInsets, (SegmentedControl4LayoutInfo)object, n7, n8, n9);
                SegmentedControlConfiguration4 segmentedControlConfiguration4 = AquaNativeSegmentedControlPainter.this.createControlConfiguration(this.g, segmentButtonRenderingConfiguration4);
                n6 = Math.round(n7 * segmentButtonRenderingConfiguration4.rasterWidth);
                n5 = Math.round(n7 * segmentButtonRenderingConfiguration4.rasterHeight);
                nArray = new int[n6 * n5];
                AquaNativeSegmentedControlPainter.this.paintSegmentedControl4(nArray, n6, n5, n7, segmentedControlConfiguration4, false);
                Rectangle2D rectangle2D = segmentButtonRenderingConfiguration4.bounds;
                n4 = Math.round((float)n7 * (float)rectangle2D.getX());
                n3 = Math.round((float)n7 * (float)rectangle2D.getY());
                n2 = Math.round((float)n7 * (float)rectangle2D.getWidth());
                n = Math.round((float)n7 * (float)rectangle2D.getHeight());
            }
            object = new PixelRasterImpl(nArray, n6, n5);
            reusableCompositor.composeFrom((PixelRaster)object, n4, n3, 0, 0, n2, n);
        }
    }
}

