/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class LinearSliderTickMark10Renderer
extends Renderer {
    @NotNull
    protected final SliderConfiguration g;
    @NotNull
    protected final Renderer tickRenderer;

    public LinearSliderTickMark10Renderer(@NotNull SliderConfiguration sliderConfiguration, @NotNull Renderer renderer) {
        this.g = sliderConfiguration;
        this.tickRenderer = renderer;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        int n = this.g.getNumberOfTickMarks();
        if (n < 2) {
            return;
        }
        float f = reusableCompositor.getWidth();
        float f2 = reusableCompositor.getHeight();
        AquaUIPainter.SliderWidget sliderWidget = this.g.getWidget();
        AquaUIPainter.Size size = this.g.getSize();
        boolean bl = this.g.isHorizontal();
        double d = JNRUtils.size(size, 2, 2, 1);
        double d2 = JNRUtils.size(size, 4, 3, 3);
        if (bl) {
            f = (float)((double)f - d);
            double d3 = ((double)f2 - d2) / 2.0;
            double d4 = 0.0;
            double d5 = f / (float)(n - 1);
            for (int i = 0; i < n; ++i) {
                this.drawTick(reusableCompositor, d4, d3, d, d2);
                d4 += d5;
            }
        } else {
            double d6 = d2;
            d2 = d;
            d = d6;
            f2 = (float)((double)f2 - d2);
            double d7 = (f - 2.0f) / 2.0f;
            double d8 = 0.0;
            double d9 = f2 / (float)(n - 1);
            for (int i = 0; i < n; ++i) {
                this.drawTick(reusableCompositor, d7, d8, d, d2);
                d8 += d9;
            }
        }
    }

    private void drawTick(@NotNull ReusableCompositor reusableCompositor, double d, double d2, double d3, double d4) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Renderer renderer = Renderer.createOffsetRenderer(this.tickRenderer, double_);
        renderer.composeTo(reusableCompositor);
    }
}

