/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.ColorModel;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ColorWellButtonConfiguration;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.ReusableCompositor;

public class ColorWellRenderer
extends Renderer {
    @NotNull
    private final ButtonConfiguration bg;
    @NotNull
    private final Renderer basic;
    private final boolean isDark;

    public ColorWellRenderer(@NotNull ButtonConfiguration buttonConfiguration, @NotNull Renderer renderer, boolean bl) {
        this.bg = buttonConfiguration;
        this.basic = renderer;
        this.isDark = bl;
    }

    @Override
    public void composeTo(@NotNull ReusableCompositor reusableCompositor) {
        int n;
        int n2;
        int n3 = JNRPlatformUtils.getPlatformVersion();
        int n4 = reusableCompositor.getRasterWidth();
        int n5 = reusableCompositor.getRasterHeight();
        int n6 = reusableCompositor.getScaleFactor();
        if (n3 < 130000) {
            int n7 = n6;
            n2 = 4 * n6;
            n = n7 * 2 + n2;
        } else {
            n = 5 * n6;
        }
        this.basic.composeTo(reusableCompositor);
        if (this.bg instanceof ColorWellButtonConfiguration) {
            ColorWellButtonConfiguration colorWellButtonConfiguration = (ColorWellButtonConfiguration)this.bg;
            Color color = colorWellButtonConfiguration.getSelectedColor();
            ColorWellPainter colorWellPainter = new ColorWellPainter(color, this.isDark);
            reusableCompositor.composePainter(colorWellPainter, 0.0f, 0.0f);
            return;
        }
        if (n3 < 130000) {
            BorderPainter borderPainter = new BorderPainter(n6);
            reusableCompositor.renderFrom(borderPainter);
            n2 = n;
            int n8 = n;
            int n9 = n4 - 2 * n;
            int n10 = n5 - 2 * n;
            reusableCompositor.erase(n2, n8, n9, n10);
        }
    }

    protected class ColorWellPainter
    implements PainterExtension {
        @NotNull
        private final Color c;
        private final boolean isDark;

        public ColorWellPainter(Color color, boolean bl) {
            this.c = color;
            this.isDark = bl;
        }

        @Override
        public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
            RectangularShape rectangularShape;
            int n = JNRPlatformUtils.getPlatformVersion();
            boolean bl = false;
            boolean bl2 = false;
            float f3 = 6.0f;
            float f4 = 6.0f;
            float f5 = (float)bl + f4;
            float f6 = f - 2.0f * f4;
            float f7 = f5 + f6;
            float f8 = (float)bl2 + f3;
            float f9 = f2 - 2.0f * f3;
            float f10 = f8 + f9;
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
            if (n >= 130000) {
                graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                rectangularShape = new RoundRectangle2D.Float(f5, f8, f6, f9, 4.0f, 4.0f);
            } else {
                rectangularShape = new Rectangle2D.Float(f5, f8, f6, f9);
            }
            if (this.c.getAlpha() != 255) {
                graphics2D2.setColor(Color.BLACK);
                graphics2D2.fill(rectangularShape);
                Path2D.Float float_ = new Path2D.Float();
                float_.moveTo(f5, f10);
                float_.lineTo(f7, f8);
                float_.lineTo(f7, f10);
                float_.closePath();
                graphics2D2.clip(rectangularShape);
                graphics2D2.setColor(Color.WHITE);
                graphics2D2.fill(float_);
                graphics2D2.setClip(null);
            }
            graphics2D2.setColor(this.c);
            graphics2D2.fill(rectangularShape);
            if (n >= 130000 && this.c.getAlpha() != 255) {
                graphics2D2.setColor(this.isDark ? new Color(255, 255, 255, 52) : new Color(0, 0, 0, 52));
                graphics2D2.draw(rectangularShape);
            }
            graphics2D2.dispose();
        }
    }

    protected class BorderPainter
    implements PainterExtension,
    BasicRenderer {
        private final Color outer;
        private final Color inner;
        private final int scaleFactor;

        public BorderPainter(int n) {
            this.scaleFactor = n;
            switch (ColorWellRenderer.this.bg.getState()) {
                case DISABLED: 
                case DISABLED_INACTIVE: {
                    this.outer = new Color(170, 170, 170, 127);
                    this.inner = new Color(168, 168, 168);
                    break;
                }
                case PRESSED: {
                    this.outer = new Color(175, 175, 175);
                    this.inner = new Color(86, 86, 86);
                    break;
                }
                default: {
                    this.outer = new Color(175, 175, 175);
                    this.inner = new Color(138, 138, 138);
                }
            }
        }

        @Override
        public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
            int n = (int)f;
            int n2 = (int)f2;
            graphics2D.setColor(this.outer);
            graphics2D.drawRect(0, 0, n, n2);
            graphics2D.setColor(this.inner);
            graphics2D.drawRect(5, 5, n - 10, n2 - 10);
        }

        @Override
        public void render(int @NotNull [] nArray, int n, int n2, float f, float f2) {
            this.drawRect(nArray, n, n2, this.outer, 0, 0, n, n2);
            this.drawRect(nArray, n, n2, this.inner, 5 * this.scaleFactor, 5 * this.scaleFactor, n - 10 * this.scaleFactor, n2 - 10 * this.scaleFactor);
        }

        protected void drawRect(int[] nArray, int n, int n2, Color color, int n3, int n4, int n5, int n6) {
            if (n5 > 0 && n6 > 0) {
                ColorModel colorModel = ReusableCompositor.getColorModel();
                ColorSpace colorSpace = colorModel.getColorSpace();
                float[] fArray = color.getComponents(colorSpace, null);
                float f = fArray[3];
                int n7 = 0;
                while (n7 < 3) {
                    int n8 = n7++;
                    fArray[n8] = fArray[n8] * f;
                }
                n7 = colorModel.getDataElement(fArray, 0);
                for (int i = 0; i < this.scaleFactor; ++i) {
                    this.drawRect1(nArray, n, n2, n7, n3 + i, n4 + i, n5 - 2 * i, n6 - 2 * i);
                }
            }
        }

        protected void drawRect1(int[] nArray, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
            if (n6 > 0 && n7 > 0) {
                int n8;
                for (n8 = n4; n8 < n4 + n6; ++n8) {
                    nArray[n5 * n + n8] = n3;
                    nArray[(n5 + n7 - 1) * n + n8] = n3;
                }
                for (n8 = n5 + 1; n8 < n5 + n7 - 1; ++n8) {
                    nArray[n8 * n + n4] = n3;
                    nArray[n8 * n + n4 + n6 - 1] = n3;
                }
            }
        }
    }
}

