/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class SegmentedButtonLayoutConfiguration
extends LayoutConfiguration {
    @NotNull
    private final AquaUIPainter.SegmentedButtonWidget bw;
    @NotNull
    private final AquaUIPainter.Size size;
    @NotNull
    private final AquaUIPainter.Position position;

    public SegmentedButtonLayoutConfiguration(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.Position position) {
        int n = JNRPlatformUtils.getPlatformVersion();
        if (n >= 101600) {
            switch (segmentedButtonWidget) {
                case BUTTON_TAB: 
                case BUTTON_SEGMENTED_TEXTURED: {
                    segmentedButtonWidget = AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SLIDER;
                    break;
                }
                case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                    segmentedButtonWidget = AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED;
                    break;
                }
                case BUTTON_SEGMENTED_TOOLBAR: {
                    segmentedButtonWidget = AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE;
                }
            }
        }
        if (size == AquaUIPainter.Size.LARGE) {
            if (n < 101600) {
                size = AquaUIPainter.Size.REGULAR;
            } else {
                segmentedButtonWidget = segmentedButtonWidget.toToolbarWidget();
            }
        }
        this.bw = segmentedButtonWidget;
        this.size = size;
        this.position = position;
    }

    @Override
    @NotNull
    public AquaUIPainter.SegmentedButtonWidget getWidget() {
        return this.bw;
    }

    @NotNull
    public AquaUIPainter.Size getSize() {
        return this.size;
    }

    @NotNull
    public AquaUIPainter.Position getPosition() {
        return this.position;
    }

    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration = (SegmentedButtonLayoutConfiguration)object;
        return this.layoutEquals(segmentedButtonLayoutConfiguration);
    }

    protected boolean layoutEquals(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration) {
        return this.bw == segmentedButtonLayoutConfiguration.bw && this.size == segmentedButtonLayoutConfiguration.size && this.position == segmentedButtonLayoutConfiguration.position;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bw, this.size, this.position});
    }

    @NotNull
    public String toString() {
        return this.bw + " " + (Object)((Object)this.size) + " " + (Object)((Object)this.position);
    }
}

