/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.ScrollBarLayoutConfiguration;
import org.violetlib.jnr.impl.JNRUtils;

public class ScrollBarConfiguration
extends ScrollBarLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.ScrollBarKnobWidget kw;
    @NotNull
    private final AquaUIPainter.State state;
    private final float thumbPosition;
    private final float thumbExtent;
    private final boolean noTrack;

    public ScrollBarConfiguration(@NotNull AquaUIPainter.ScrollBarWidget scrollBarWidget, @NotNull AquaUIPainter.ScrollBarKnobWidget scrollBarKnobWidget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.Orientation orientation, float f, float f2, boolean bl) {
        super(scrollBarWidget, size, orientation);
        this.kw = scrollBarKnobWidget;
        this.state = state;
        this.thumbPosition = f;
        this.thumbExtent = f2;
        this.noTrack = bl;
    }

    public ScrollBarConfiguration(@NotNull ScrollBarConfiguration scrollBarConfiguration) {
        this(scrollBarConfiguration.getWidget(), scrollBarConfiguration.getKnobWidget(), scrollBarConfiguration.getSize(), scrollBarConfiguration.getState(), scrollBarConfiguration.getOrientation(), scrollBarConfiguration.getThumbPosition(), scrollBarConfiguration.getThumbExtent(), scrollBarConfiguration.isTrackSuppressed());
    }

    @NotNull
    public AquaUIPainter.ScrollBarKnobWidget getKnobWidget() {
        return this.kw;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public float getThumbPosition() {
        return this.thumbPosition;
    }

    public float getThumbExtent() {
        return this.thumbExtent;
    }

    public boolean isTrackSuppressed() {
        return this.noTrack;
    }

    @Override
    public boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ScrollBarConfiguration scrollBarConfiguration = (ScrollBarConfiguration)object;
        return this.kw == scrollBarConfiguration.kw && this.state == scrollBarConfiguration.state && this.thumbPosition == scrollBarConfiguration.thumbPosition && this.thumbExtent == scrollBarConfiguration.thumbExtent && this.noTrack == scrollBarConfiguration.noTrack;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.kw, this.state, Float.valueOf(this.thumbPosition), Float.valueOf(this.thumbExtent), this.noTrack});
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + " " + (Object)((Object)this.kw) + " " + (Object)((Object)this.state) + " " + JNRUtils.format2(this.thumbPosition) + " " + JNRUtils.format2(this.thumbExtent) + (this.noTrack ? " [no track]" : "");
    }
}

