/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JTree;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaBackgroundBorder;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.AquaUtils;

public class AquaTreeEditorBorder
implements AquaBackgroundBorder,
UIResource {
    @Override
    public void paintBackground(@NotNull Component component, Graphics graphics, @Nullable Color color) {
        Color color2 = this.getBackground(component);
        if (color2 != null) {
            int n = component.getWidth();
            int n2 = component.getHeight();
            graphics.setColor(color2);
            graphics.fillRect(0, 0, n, n2);
        }
    }

    @Nullable
    private Color getBackground(@NotNull Component component) {
        Color color;
        AquaAppearance aquaAppearance;
        AquaTreeUI aquaTreeUI;
        JTree jTree = this.getTree(component);
        if (jTree != null && (aquaTreeUI = AquaUtils.getUI(jTree, AquaTreeUI.class)) != null && (aquaAppearance = AppearanceManager.getAppearance(jTree)).isDark() && (color = AquaColors.getCellEditorBackground(jTree)) != null) {
            return color;
        }
        return component.getBackground();
    }

    @Nullable
    private JTree getTree(@NotNull Component component) {
        Container container = component.getParent();
        if (container instanceof JTree) {
            return (JTree)container;
        }
        if (container == null) {
            return null;
        }
        return (container = container.getParent()) instanceof JTree ? (JTree)container : null;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return new Insets(0, 0, 0, 0);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

