/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JScrollBar;
import javax.swing.Timer;
import org.violetlib.aqua.AnimationController;
import org.violetlib.aqua.AquaScrollBarUI;
import org.violetlib.aqua.AquaUtils;

public class AquaOverlayScrollPaneController {
    protected final Timer deactivationTimer = new Timer(750, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaOverlayScrollPaneController.this.fadeOutController.start();
        }
    });
    protected final AnimationController fadeOutController;
    protected JScrollBar vsb;
    protected JScrollBar hsb;
    protected JScrollBar activeScrollBar;
    protected boolean isMouseOverActiveScrollBar;
    protected final MouseListener scrollBarMouseListener;
    protected static final int FADE_OUT_TIME = 250;
    protected static final int DEACTIVATE_DELAY_TIME = 750;

    public AquaOverlayScrollPaneController() {
        this.deactivationTimer.setRepeats(false);
        this.fadeOutController = new AnimationController(new FadeOutAnimation(), 250);
        this.scrollBarMouseListener = new ScrollBarMouseListener();
    }

    public void dispose() {
        this.deactivationTimer.stop();
        if (this.hsb != null) {
            this.hsb.removeMouseListener(this.scrollBarMouseListener);
            this.hsb = null;
        }
        if (this.vsb != null) {
            this.vsb.removeMouseListener(this.scrollBarMouseListener);
            this.vsb = null;
        }
    }

    public int getActiveAxis() {
        if (this.activeScrollBar == this.vsb && this.vsb != null) {
            return 1;
        }
        if (this.activeScrollBar == this.hsb && this.hsb != null) {
            return 0;
        }
        return -1;
    }

    public void activateScrollBar(MouseEvent mouseEvent, boolean bl) {
        boolean bl2;
        JScrollBar jScrollBar = bl ? this.vsb : this.hsb;
        boolean bl3 = bl2 = jScrollBar != this.activeScrollBar;
        if (this.activeScrollBar != jScrollBar && this.activeScrollBar != null) {
            this.deactivateImmediately();
        }
        this.activeScrollBar = jScrollBar;
        if (this.activeScrollBar != null) {
            AquaScrollBarUI aquaScrollBarUI;
            this.activeScrollBar.setVisible(true);
            Rectangle rectangle = this.activeScrollBar.getBounds();
            this.isMouseOverActiveScrollBar = rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
            if (bl2 && (aquaScrollBarUI = AquaUtils.getUI(this.activeScrollBar, AquaScrollBarUI.class)) != null) {
                aquaScrollBarUI.setRolloverDisplayState(this.isMouseOverActiveScrollBar);
            }
            if (!this.isMouseOverActiveScrollBar) {
                this.scheduleOrPostponeDeactivation();
            }
        }
    }

    public void setVerticalScrollBar(JScrollBar jScrollBar) {
        if (jScrollBar != this.vsb) {
            if (this.vsb != null) {
                this.disconnect(this.vsb);
            }
            this.vsb = jScrollBar;
            this.disconnect(this.vsb);
            if (this.vsb != null) {
                this.initialize(this.vsb, "VERTICAL_SCROLLBAR");
            }
        }
    }

    public void setHorizontalScrollBar(JScrollBar jScrollBar) {
        if (jScrollBar != this.hsb) {
            if (this.hsb != null) {
                this.disconnect(this.hsb);
            }
            this.hsb = jScrollBar;
            if (this.hsb != null) {
                this.initialize(this.hsb, "HORIZONTAL_SCROLLBAR");
            }
        }
    }

    protected void disconnect(JScrollBar jScrollBar) {
        jScrollBar.removeMouseListener(this.scrollBarMouseListener);
        jScrollBar.setVisible(false);
        if (jScrollBar == this.activeScrollBar) {
            this.isMouseOverActiveScrollBar = false;
            this.activeScrollBar = null;
        }
    }

    protected void initialize(JScrollBar jScrollBar, String string) {
        this.reconfigure(jScrollBar, string);
        jScrollBar.addMouseListener(this.scrollBarMouseListener);
        jScrollBar.setVisible(false);
        AquaScrollBarUI aquaScrollBarUI = AquaUtils.getUI(jScrollBar, AquaScrollBarUI.class);
        if (aquaScrollBarUI != null) {
            aquaScrollBarUI.setRolloverDisplayState(false);
            aquaScrollBarUI.setAlpha(1.0f);
        }
    }

    protected void reconfigure(JScrollBar jScrollBar, String string) {
    }

    public void scheduleOrPostponeDeactivation() {
        this.deactivationTimer.stop();
        this.fadeOutController.stop();
        this.setAlpha(this.activeScrollBar, 1.0f);
        this.deactivationTimer.start();
    }

    public void cancelDeactivation() {
        this.deactivationTimer.stop();
        this.fadeOutController.stop();
        this.setAlpha(this.activeScrollBar, 1.0f);
    }

    public void deactivateImmediately() {
        this.deactivationTimer.stop();
        this.fadeOutController.stop();
        if (this.activeScrollBar != null) {
            this.activeScrollBar.setVisible(false);
            AquaScrollBarUI aquaScrollBarUI = AquaUtils.getUI(this.activeScrollBar, AquaScrollBarUI.class);
            if (aquaScrollBarUI != null) {
                aquaScrollBarUI.setRolloverDisplayState(false);
                aquaScrollBarUI.setAlpha(1.0f);
            }
            this.activeScrollBar = null;
        }
    }

    protected void setAlpha(JScrollBar jScrollBar, float f) {
        if (jScrollBar != null) {
            if (f == 0.0f) {
                this.deactivateImmediately();
            } else {
                AquaScrollBarUI aquaScrollBarUI = AquaUtils.getUI(jScrollBar, AquaScrollBarUI.class);
                if (aquaScrollBarUI != null) {
                    aquaScrollBarUI.setAlpha(f);
                }
            }
        }
    }

    protected class FadeOutAnimation
    implements AnimationController.Animation {
        protected FadeOutAnimation() {
        }

        @Override
        public void setAnimationState(float f) {
            AquaScrollBarUI aquaScrollBarUI;
            if (AquaOverlayScrollPaneController.this.activeScrollBar != null && (aquaScrollBarUI = AquaUtils.getUI(AquaOverlayScrollPaneController.this.activeScrollBar, AquaScrollBarUI.class)) != null) {
                if (aquaScrollBarUI.isDragging()) {
                    AquaOverlayScrollPaneController.this.scheduleOrPostponeDeactivation();
                    return;
                }
                AquaOverlayScrollPaneController.this.setAlpha(AquaOverlayScrollPaneController.this.activeScrollBar, 1.0f - f);
            }
        }
    }

    protected class ScrollBarMouseListener
    extends MouseAdapter {
        protected ScrollBarMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            JScrollBar jScrollBar = this.getScrollBar(mouseEvent);
            if (jScrollBar == AquaOverlayScrollPaneController.this.activeScrollBar) {
                AquaOverlayScrollPaneController.this.cancelDeactivation();
                AquaOverlayScrollPaneController.this.isMouseOverActiveScrollBar = true;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            JScrollBar jScrollBar = this.getScrollBar(mouseEvent);
            if (jScrollBar == AquaOverlayScrollPaneController.this.activeScrollBar) {
                AquaOverlayScrollPaneController.this.scheduleOrPostponeDeactivation();
                AquaOverlayScrollPaneController.this.isMouseOverActiveScrollBar = false;
            }
        }

        protected JScrollBar getScrollBar(MouseEvent mouseEvent) {
            Component component = mouseEvent.getComponent();
            if (component instanceof JScrollBar) {
                return (JScrollBar)component;
            }
            return null;
        }
    }
}

