/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceColorsBuilder;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Colors;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.SystemPropertyChangeManager;
import org.violetlib.aqua.Utils;
import org.violetlib.jnr.aqua.AquaNativeRendering;
import org.violetlib.vappearances.VAppearance;
import org.violetlib.vappearances.VAppearances;

public class AquaAppearances {
    @NotNull
    private static final Map<String, AquaAppearance> appearances = new HashMap<String, AquaAppearance>();
    @NotNull
    private static final String defaultAppearanceName = "NSAppearanceNameAqua";
    public static final Object APPEARANCE_CHANGE_TYPE = "AppearanceChange";

    @NotNull
    public static AquaAppearance get(@NotNull String string) throws UnsupportedOperationException {
        AquaAppearance aquaAppearance = AquaAppearances.getOptional(string);
        return aquaAppearance != null ? aquaAppearance : AquaAppearances.getDefaultAppearance();
    }

    @Nullable
    public static AquaAppearance getOptional(@NotNull String string) {
        AquaAppearance aquaAppearance = appearances.get(string);
        if (aquaAppearance == null) {
            try {
                VAppearance vAppearance = VAppearances.getAppearance(string);
                return AquaAppearances.getAquaAppearance(vAppearance);
            }
            catch (IOException iOException) {
                AquaUtils.syslog("Unable to get " + string + ": " + iOException.getMessage());
            }
        }
        return aquaAppearance;
    }

    @NotNull
    public static AquaAppearance getDefaultAppearance() throws UnsupportedOperationException {
        AquaAppearance aquaAppearance = appearances.get(defaultAppearanceName);
        if (aquaAppearance == null) {
            try {
                VAppearance vAppearance = VAppearances.getAppearance(defaultAppearanceName);
                aquaAppearance = AquaAppearances.getAquaAppearance(vAppearance);
            }
            catch (IOException iOException) {
                AquaUtils.syslog("Unable to get NSAppearanceNameAqua: " + iOException.getMessage());
                iOException.printStackTrace();
                throw new UnsupportedOperationException("Default appearance NSAppearanceNameAqua is not available");
            }
        }
        return aquaAppearance;
    }

    @NotNull
    public static AquaAppearance getVibrantAppearance(@NotNull AquaAppearance aquaAppearance) {
        String string = aquaAppearance.getName();
        if (string.contains("Vibrant")) {
            return aquaAppearance;
        }
        if (string.contains("Dark")) {
            return AquaAppearances.get("NSAppearanceNameVibrantDark");
        }
        return AquaAppearances.get("NSAppearanceNameVibrantLight");
    }

    public static void register(@NotNull JComponent jComponent) {
        SystemPropertyChangeManager.register(jComponent);
    }

    public static void unregister(@NotNull JComponent jComponent) {
        SystemPropertyChangeManager.unregister(jComponent);
    }

    private static void appearanceChanged(@NotNull ChangeEvent changeEvent) {
        VAppearance vAppearance;
        if (changeEvent instanceof VAppearances.AppearanceChangeEvent) {
            VAppearances.AppearanceChangeEvent appearanceChangeEvent = (VAppearances.AppearanceChangeEvent)changeEvent;
            vAppearance = appearanceChangeEvent.getAppearance();
            String string = vAppearance.getName();
            try {
                AquaNativeRendering.invalidateAppearances();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        } else {
            throw new RuntimeException("Unexpected change event: " + changeEvent);
        }
        AquaAppearance aquaAppearance = AquaAppearances.getAquaAppearance(vAppearance);
        SwingUtilities.invokeLater(() -> SystemPropertyChangeManager.notifyChange(APPEARANCE_CHANGE_TYPE));
    }

    @NotNull
    private static AquaAppearance getAquaAppearance(@NotNull VAppearance vAppearance) {
        Map<String, Color> map = AquaNativeRendering.createPainter().getColors(vAppearance);
        Colors colors = new AppearanceColorsBuilder(vAppearance, OSXSystemProperties.OSVersion, map, null, Utils::logDebug).getResult();
        AquaAppearance aquaAppearance = new AquaAppearance(vAppearance, colors, Utils::logDebug);
        appearances.put(vAppearance.getName(), aquaAppearance);
        return aquaAppearance;
    }

    static {
        VAppearances.addChangeListener(AquaAppearances::appearanceChanged);
    }
}

