/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class JavaSupport {
    private static final JavaSupportImpl impl = JavaSupport.findImpl();

    public static int getScaleFactor(@NotNull Graphics g) {
        return impl.getScaleFactor(g);
    }

    @NotNull
    public static Image createMultiResolutionImage(int baseImageWidth, int baseImageHeight, @NotNull BufferedImage im) {
        return impl.createMultiResolutionImage(baseImageWidth, baseImageHeight, im);
    }

    private static JavaSupportImpl findImpl() {
        int version = JavaSupport.obtainJavaVersion();
        System.err.println("Java version: " + version);
        String className = version >= 900000 ? "Java9Support" : "Java8Support";
        try {
            Class<?> c = Class.forName("org.violetlib.jnr.impl." + className);
            return (JavaSupportImpl)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            throw new UnsupportedOperationException("Unsupported Java version: " + version, ex);
        }
    }

    private static int obtainJavaVersion() {
        String s = System.getProperty("java.version");
        if (s.startsWith("1.")) {
            s = s.substring(2);
        }
        int version = 0;
        int tokenCount = 0;
        StringTokenizer st = new StringTokenizer(s, "._");
        try {
            while (st.hasMoreTokens()) {
                int limit;
                String token = st.nextToken();
                int pos = token.indexOf("-");
                if (pos > 0) {
                    token = token.substring(0, pos);
                }
                int n = Integer.parseInt(token);
                int n2 = limit = ++tokenCount < 3 ? 100 : 1000;
                if (n < 0 || n >= limit) {
                    return 0;
                }
                version = version * limit + n;
                if (tokenCount != 3) continue;
                return version;
            }
        }
        catch (NumberFormatException ex) {
            return 0;
        }
        while (tokenCount < 3) {
            int limit = ++tokenCount < 3 ? 100 : 1000;
            version *= limit;
        }
        return version;
    }

    public static interface JavaSupportImpl {
        public int getScaleFactor(@NotNull Graphics var1);

        public Image createMultiResolutionImage(int var1, int var2, @NotNull BufferedImage var3);
    }
}

