/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageObserver;
import java.awt.image.RGBImageFilter;
import org.jetbrains.annotations.NotNull;

public class ImageUtils {
    @NotNull
    public static Image invertForDarkMode(@NotNull Image source) {
        return ImageUtils.createFilteredImage(source, new InvertImageForDarkModeFilter());
    }

    private static Image createFilteredImage(Image image, ImageFilter filter) {
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return ImageUtils.waitForImage(Toolkit.getDefaultToolkit().createImage(prod));
    }

    public static int toGray(int pixel) {
        int gray = (int)((0.3 * (double)ImageUtils.red(pixel) + 0.59 * (double)ImageUtils.green(pixel) + 0.11 * (double)ImageUtils.blue(pixel)) / 3.0);
        if ((gray = (int)((double)(255 - gray) * 0.7)) < 0) {
            gray = 0;
        }
        if (gray > 255) {
            gray = 255;
        }
        return ImageUtils.createPixel(ImageUtils.alpha(pixel), gray, gray, gray);
    }

    public static int createPixel(int alpha, int red, int green, int blue) {
        return ((alpha & 0xFF) << 24) + ((red & 0xFF) << 16) + ((green & 0xFF) << 8) + (blue & 0xFF);
    }

    public static int alpha(int pixel) {
        return pixel >> 24 & 0xFF;
    }

    public static int red(int pixel) {
        return pixel >> 16 & 0xFF;
    }

    public static int green(int pixel) {
        return pixel >> 8 & 0xFF;
    }

    public static int blue(int pixel) {
        return pixel >> 0 & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Image waitForImage(@NotNull Image image) {
        boolean[] mutex = new boolean[]{false};
        ImageObserver observer = (img, infoflags, x, y, width, height) -> {
            if (width != -1 && height != -1 && (infoflags & 0x20) != 0 || (infoflags & 0x80) != 0) {
                boolean[] blArray = mutex;
                synchronized (mutex) {
                    mutex[0] = true;
                    mutex.notify();
                    // ** MonitorExit[var7_7] (shouldn't be in output)
                    return false;
                }
            }
            return true;
        };
        boolean[] blArray = mutex;
        synchronized (mutex) {
            while (!mutex[0] && image.getWidth(observer) == -1) {
                try {
                    mutex.wait();
                }
                catch (InterruptedException e) {
                    // empty catch block
                    break;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return image;
        }
    }

    private static class InvertImageForDarkModeFilter
    extends RGBImageFilter {
        public InvertImageForDarkModeFilter() {
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            return ImageUtils.toGray(rgb);
        }
    }
}

