/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Image;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public final class ImageCache {
    protected static boolean debugFlag = false;
    private static int hitCount;
    private static int missCount;
    private final LinkedHashMap<PixelsKey, ImageSoftReference> map = new LinkedHashMap(16, 0.75f, true);
    private final int maxPixelCount;
    private int currentPixelCount = 0;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReferenceQueue<Image> referenceQueue = new ReferenceQueue();
    private static final ImageCache INSTANCE;

    public static ImageCache getInstance() {
        return INSTANCE;
    }

    ImageCache(int maxPixelCount) {
        this.maxPixelCount = maxPixelCount;
    }

    ImageCache() {
        this(0x200000);
    }

    public void flush() {
        this.lock.writeLock().lock();
        try {
            this.map.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Image getImage(@NotNull PixelsKey key) {
        Image result;
        ImageSoftReference ref;
        this.lock.readLock().lock();
        try {
            ref = this.map.get(key);
        }
        finally {
            this.lock.readLock().unlock();
        }
        Image image = result = ref == null ? null : (Image)ref.get();
        if (result != null) {
            ++hitCount;
        } else {
            ++missCount;
        }
        if (debugFlag && (hitCount + missCount) % 1000 == 0) {
            System.err.println("Image cache hit rate: " + (float)hitCount / (float)(hitCount + missCount));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(@NotNull PixelsKey key, @NotNull Image image) {
        this.lock.writeLock().lock();
        try {
            ImageSoftReference ref = this.map.get(key);
            if (ref != null) {
                if (ref.get() != null) {
                    return;
                }
                this.currentPixelCount -= key.getPixelCount();
                this.map.remove(key);
            }
            int newPixelCount = key.getPixelCount();
            this.currentPixelCount += newPixelCount;
            if (this.currentPixelCount > this.maxPixelCount) {
                while ((ref = (ImageSoftReference)this.referenceQueue.poll()) != null) {
                    this.map.remove(ref.key);
                    this.currentPixelCount -= ref.key.getPixelCount();
                }
            }
            if (this.currentPixelCount > this.maxPixelCount) {
                Iterator<Map.Entry<PixelsKey, ImageSoftReference>> mapIter = this.map.entrySet().iterator();
                while (this.currentPixelCount > this.maxPixelCount && mapIter.hasNext()) {
                    Map.Entry<PixelsKey, ImageSoftReference> entry = mapIter.next();
                    mapIter.remove();
                    Image img = (Image)entry.getValue().get();
                    if (img != null) {
                        img.flush();
                    }
                    this.currentPixelCount -= entry.getValue().key.getPixelCount();
                }
            }
            this.map.put(key, new ImageSoftReference(key, image, this.referenceQueue));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    static {
        INSTANCE = new ImageCache();
    }

    private static class ImageSoftReference
    extends SoftReference<Image> {
        final PixelsKey key;

        ImageSoftReference(PixelsKey key, Image referent, ReferenceQueue<? super Image> q) {
            super(referent, q);
            this.key = key;
        }
    }

    public static interface PixelsKey {
        public int getPixelCount();
    }
}

