/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class ThinSplitPaneDividerPainterExtension
implements PainterExtension {
    @NotNull
    protected final SplitPaneDividerConfiguration dg;
    @NotNull
    protected final Color dividerColor;
    protected static final Color DEFAULT_COLOR = new Color(128, 128, 128, 80);

    public ThinSplitPaneDividerPainterExtension(@NotNull SplitPaneDividerConfiguration g, @Nullable VAppearance appearance) {
        this.dg = g;
        this.dividerColor = this.determineDividerColor(g, appearance);
    }

    @NotNull
    private Color determineDividerColor(@NotNull SplitPaneDividerConfiguration g, @Nullable VAppearance appearance) {
        return appearance != null ? appearance.getColors().get("separator") : DEFAULT_COLOR;
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        Rectangle2D.Double s;
        float d = 1.0f;
        if (this.dg.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            float x = (width - d) / 2.0f;
            s = new Rectangle2D.Double(x, 0.0, d, height);
        } else {
            float y = (height - d) / 2.0f;
            s = new Rectangle2D.Double(0.0, y, width, d);
        }
        g.setColor(this.dividerColor);
        g.fill(s);
    }
}

