/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SliderVerticalTickPainter {
    @NotNull
    protected final Color color;
    protected final double w;
    protected final double h;
    protected final double x;
    protected final double y0;
    protected final double y1;
    protected final int tickCount;

    public SliderVerticalTickPainter(@NotNull Color color, double w, double h, double x, double y0, double y1, int tickCount) {
        this.color = color;
        this.w = w;
        this.h = h;
        this.x = x;
        this.y0 = y0;
        this.y1 = y1;
        this.tickCount = tickCount;
    }

    public void paint(@NotNull Graphics2D g) {
        g.setColor(this.color);
        if (this.tickCount == 1) {
            this.drawTick(g, this.y0);
        } else {
            double spacing = (this.y1 - this.y0) / (double)(this.tickCount - 1);
            double y = this.y0;
            for (int i = 0; i < this.tickCount; ++i) {
                this.drawTick(g, y);
                y += spacing;
            }
        }
    }

    protected void drawTick(@NotNull Graphics2D g, double y) {
        Rectangle2D.Double s = new Rectangle2D.Double(this.x, y - this.w / 2.0, this.h, this.w);
        g.fill(s);
    }
}

