/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.text.DecimalFormat;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RenderInsets {
    @NotNull
    protected static final DecimalFormat df = new DecimalFormat("0.#");
    public final float left;
    public final float top;
    public final float widthAdjust;
    public final float heightAdjust;

    public RenderInsets(float left, float top, float widthAdjust, float heightAdjust) {
        if (left < 0.0f) {
            throw new IllegalArgumentException("Invalid left inset");
        }
        if (top < 0.0f) {
            throw new IllegalArgumentException("Invalid top inset");
        }
        this.left = left;
        this.top = top;
        this.widthAdjust = widthAdjust;
        this.heightAdjust = heightAdjust;
    }

    public RenderInsets(double left, double top, double widthAdjust, double heightAdjust) {
        this((float)left, (float)top, (float)widthAdjust, (float)heightAdjust);
    }

    @NotNull
    public RenderInsets scale(float scale) {
        if (scale == 1.0f) {
            return this;
        }
        float left = (float)Math.round(this.left * scale) / scale;
        float top = (float)Math.round(this.top * scale) / scale;
        return new RenderInsets(left, top, this.widthAdjust, this.heightAdjust);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RenderInsets)) {
            return false;
        }
        RenderInsets that = (RenderInsets)o;
        return Float.compare(that.left, this.left) == 0 && Float.compare(that.top, this.top) == 0 && Float.compare(that.widthAdjust, this.widthAdjust) == 0 && Float.compare(that.heightAdjust, this.heightAdjust) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.left), Float.valueOf(this.top), Float.valueOf(this.widthAdjust), Float.valueOf(this.heightAdjust));
    }

    @NotNull
    public String toString() {
        String s;
        StringBuilder sb = new StringBuilder();
        if (this.left != 0.0f) {
            sb.append(" Left=");
            sb.append(df.format(this.left));
        }
        if (this.top != 0.0f) {
            sb.append(" Top=");
            sb.append(df.format(this.top));
        }
        if (this.widthAdjust != 0.0f) {
            sb.append(" W=");
            if (this.widthAdjust > 0.0f) {
                sb.append("+");
            }
            sb.append(df.format(this.widthAdjust));
        }
        if (this.heightAdjust != 0.0f) {
            sb.append(" H=");
            if (this.heightAdjust > 0.0f) {
                sb.append("+");
            }
            sb.append(df.format(this.heightAdjust));
        }
        return (s = sb.toString().trim()).isEmpty() ? "NULL" : s;
    }

    static {
        df.setDecimalSeparatorAlwaysShown(false);
    }
}

