/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.ElCapitanLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.CenteredInsetter1;
import org.violetlib.jnr.impl.CombinedInsetter;
import org.violetlib.jnr.impl.DynamicInsetter1;
import org.violetlib.jnr.impl.FixedInsetter1;
import org.violetlib.jnr.impl.Insetter1;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class BigSurLayoutInfo
extends ElCapitanLayoutInfo {
    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            float left;
            float top = JNRUtils.size(sz, 2, 1, 1);
            float bottom = JNRUtils.size(sz, 2, 2, 2);
            float right = left = (float)JNRUtils.size(sz, 4, 4, 3);
            return Insetters.createFixed(top, left, bottom, right, layoutInfo);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            float top = JNRUtils.size(sz, 2, 1, 1);
            float bottom = JNRUtils.size(sz, 2, 1, 1);
            float side = JNRUtils.size(sz, 4, 4, 3);
            return Insetters.createFixed(top, side, bottom, side, layoutInfo);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
            float topBottom = 4.5f;
            float side = 3.5f;
            return Insetters.createFixed(topBottom, side, topBottom, side, layoutInfo);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            float top = 1.0f;
            float bottom = 1.0f;
            float side = 3.0f;
            return Insetters.createFixed(top, side, bottom, side, layoutInfo);
        }
        return super.getButtonLabelInsets(g);
    }

    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellLayoutConfiguration tg = new ToolBarItemWellLayoutConfiguration();
            return this.getToolBarItemWellLayoutInfo(tg);
        }
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 31, 23, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 20, 18, 14, 10), JNRUtils.size(sz, 20, 18, 15, 11));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 20, 18, 14, 10), JNRUtils.size(sz, 20, 18, 15, 10));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 26, 22, 18, 15), JNRUtils.size(sz, 27, 23, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 28, 22, 18, 15), JNRUtils.size(sz, 29, 23, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(sz, 23, 21, 19, 17));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 19, 19, 17, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return BasicLayoutInfo.createFixedHeight(16.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 18, 16, 14));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 20, 20, 16, 13));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 28, 22, 18, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 30, 22, 18, 15), JNRUtils.size(sz, 31, 23, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return BasicLayoutInfo.createFixed(18.0f, 18.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 18, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
            return BasicLayoutInfo.createFixed(28.0f, 28.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return BasicLayoutInfo.createFixed(13.0f, 13.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 19, 17, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return BasicLayoutInfo.createMinimum(44.0f, 23.0f);
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getSegmentedButtonLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SEPARATED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 31, 23, 19, 16));
            }
            case BUTTON_SEGMENTED_INSET: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 23, 21, 19, 17));
            }
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_SCURVE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 20, 16, 13));
            }
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 28, 23, 20, 16));
            }
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 29, 23, 19, 16));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getSegmentedButtonLabelInsets(@NotNull SegmentedButtonLayoutConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED) {
            boolean isRightEnd;
            float left;
            AquaUIPainter.Position pos = g.getPosition();
            float top = 1.0f;
            float bottom = 2.0f;
            float right = left = 1.0f;
            float endAdjust = 2.0f;
            boolean isLeftEnd = pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.ONLY;
            boolean bl = isRightEnd = pos == AquaUIPainter.Position.LAST || pos == AquaUIPainter.Position.ONLY;
            if (bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                left = JNRUtils.size2D(sz, 2.0, 2.0, 1.5);
                right = JNRUtils.size2D(sz, 3.0, 3.0, 2.5);
                top = 1.51f;
                bottom = 2.51f;
            } else if (bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED || bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED) {
                bottom = 1.0f;
            }
            if (isLeftEnd) {
                left += endAdjust;
            }
            if (isRightEnd) {
                right += endAdjust;
            }
            return Insetters.createFixed(top, left, bottom, right, layoutInfo);
        }
        return super.getSegmentedButtonLabelInsets(g);
    }

    @Override
    @NotNull
    protected LayoutInfo getPopUpButtonLayoutInfo(@NotNull PopupButtonLayoutConfiguration g) {
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        switch (bw) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN: {
                float fixedHeight = JNRUtils.size(sz, 31, 23, 19, 16);
                float minWidth = JNRUtils.size(sz, 44, 34, 26, 24);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_UP_GRADIENT: 
            case BUTTON_POP_DOWN_GRADIENT: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 23, 21, 19, 17));
            }
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: 
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: {
                float fixedHeight = JNRUtils.size(sz, 23, 20, 16);
                float minWidth = JNRUtils.size(sz, 39, 32, 25);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                float fixedHeight = JNRUtils.size(sz, 18, 16, 14);
                float minWidth = JNRUtils.size(sz, 26, 23, 23);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
        }
        return super.getPopUpButtonLayoutInfo(g);
    }

    @Override
    @NotNull
    public Insetter getPopupButtonContentInsets(@NotNull PopupButtonLayoutConfiguration g) {
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN | bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED | bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED) {
            AquaUIPainter.Size sz = g.getSize();
            float top = 1.0f;
            float bottom = 1.0f;
            float far = JNRUtils.size2D(sz, 6.0, 5.0, 4.0, 3.0);
            float near = JNRUtils.size2D(sz, 30.0, 22.0, 18.0, 15.0);
            switch (bw) {
                default: {
                    bottom = JNRUtils.size2D(sz, 2.5, 2.5, 1.5, 2.0);
                    top = JNRUtils.size2D(sz, 1.5, 2.0, 1.51, 1.0);
                    break;
                }
                case BUTTON_POP_DOWN: {
                    bottom = JNRUtils.size2D(sz, 1.5, 2.0, 2.0, 2.0);
                    top = JNRUtils.size2D(sz, 1.5, 1.0, 1.0, 1.0);
                    break;
                }
                case BUTTON_POP_UP_TEXTURED: 
                case BUTTON_POP_DOWN_TEXTURED: {
                    top = JNRUtils.size2D(sz, 1.0, 1.0, 2.0, 1.0);
                    bottom = 2.0f;
                }
            }
            LayoutInfo layoutInfo = this.getLayoutInfo(g);
            return g.isLeftToRight() ? Insetters.createFixed(top, far, bottom, near, layoutInfo) : Insetters.createFixed(top, near, bottom, far, layoutInfo);
        }
        return super.getPopupButtonContentInsets(g);
    }

    @Override
    @NotNull
    protected LayoutInfo getComboBoxLayoutInfo(@NotNull ComboBoxLayoutConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(sz, 14, 11, 11));
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED) {
            float fixedHeight = JNRUtils.size(sz, 22, 18, 15);
            float minWidth = JNRUtils.size(sz, 27, 24, 22);
            return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            float fixedHeight = JNRUtils.size(sz, 24, 20, 17);
            float minWidth = JNRUtils.size(sz, 27, 24, 22);
            return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
        }
        float fixedHeight = JNRUtils.size(sz, 22, 19, 15);
        float minWidth = JNRUtils.size(sz, 34, 27, 24);
        return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
    }

    @Override
    @NotNull
    public Insetter getComboBoxEditorInsets(@NotNull ComboBoxLayoutConfiguration g) {
        float bottom;
        float top;
        float far;
        float near;
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            float inset = JNRUtils.size(sz, 18, 18, 13);
            return g.isLeftToRight() ? Insetters.createFixed(0.0f, 0.0f, 0.0f, inset) : Insetters.createFixed(0.0f, inset, 0.0f, 0.0f);
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED) {
            near = JNRUtils.size(sz, 20, 15, 13);
            far = 2.5f;
            top = 1.0f;
            bottom = 2.0f;
        } else if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            near = JNRUtils.size(sz, 23, 18, 15);
            far = 2.5f;
            top = 1.0f;
            bottom = 2.0f;
        } else {
            near = JNRUtils.size2D(sz, 21.0, 17.5, 14.5);
            far = 0.5f;
            top = 1.0f;
            bottom = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
        }
        return g.isLeftToRight() ? Insetters.createFixed(top, far, bottom, near, layoutInfo) : Insetters.createFixed(top, near, bottom, far, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getProgressIndicatorLayoutInfo(@NotNull ProgressIndicatorLayoutConfiguration g) {
        AquaUIPainter.ProgressWidget pw = g.getWidget();
        AquaUIPainter.Orientation o = g.getOrientation();
        AquaUIPainter.Size sz = g.getSize();
        if (pw == AquaUIPainter.ProgressWidget.BAR || pw == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR) {
            int size = JNRUtils.size(sz, 6, 3, 3);
            if (o == AquaUIPainter.Orientation.HORIZONTAL) {
                return BasicLayoutInfo.createFixedHeight(size);
            }
            return BasicLayoutInfo.createFixedWidth(size);
        }
        if (pw == AquaUIPainter.ProgressWidget.SPINNER || pw == AquaUIPainter.ProgressWidget.INDETERMINATE_SPINNER) {
            int d = JNRUtils.size(sz, 32, 16, 12);
            return BasicLayoutInfo.createFixed(d, d);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected LayoutInfo getTextFieldLayoutInfo(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (w.isRound()) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 28, 22, 19, 17));
        }
        if (w.isSearch()) {
            int minimumWidth = w.hasMenu() ? JNRUtils.size(sz, 28, 26, 26) : JNRUtils.size(sz, 24, 22, 20);
            int fixedHeight = JNRUtils.size(sz, 28, 22, 19, 17);
            return BasicLayoutInfo.create(false, minimumWidth, true, fixedHeight);
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getSliderLayoutInfo(@NotNull SliderLayoutConfiguration g) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderLayoutInfo(g);
        }
        return this.getLinearSlider11LayoutInfo(g);
    }

    @Override
    protected double getSliderExtension(@NotNull AquaUIPainter.Size sz) {
        switch (sz) {
            case SMALL: 
            case MINI: {
                return 6.5;
            }
        }
        return 10.0;
    }

    @NotNull
    private LayoutInfo getLinearSlider11LayoutInfo(@NotNull SliderLayoutConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        if (g.isHorizontal()) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 24, 20, 20));
        }
        if (g.isVertical()) {
            return BasicLayoutInfo.createFixedWidth(JNRUtils.size(sz, 24, 20, 20));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getSliderTrackPaintingInsets(@NotNull SliderLayoutConfiguration g) {
        if (AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderTrackPaintingInsets(g);
        }
        return this.getSlider11TrackPaintingInsets(g);
    }

    @NotNull
    private Insetter getSlider11TrackPaintingInsets(@NotNull SliderLayoutConfiguration g) {
        Insetter1 vertical;
        Insetter1 horizontal;
        boolean isCircle;
        AquaUIPainter.Size sz = g.getSize();
        float trackWidth = JNRUtils.size(sz, 4, 4, 3);
        float majorInset = JNRUtils.size(sz, 10, 8, 6);
        boolean bl = isCircle = !g.hasTickMarks();
        if (isCircle) {
            majorInset += 2.0f;
        }
        if (g.isHorizontal()) {
            horizontal = new FixedInsetter1(majorInset, majorInset);
            vertical = CenteredInsetter1.createCentered(trackWidth, 0.0f);
        } else if (g.isVertical()) {
            vertical = new FixedInsetter1(majorInset, majorInset);
            horizontal = CenteredInsetter1.createCentered(trackWidth, 0.0f);
        } else {
            horizontal = new FixedInsetter1(0.0f, 0.0f);
            vertical = new FixedInsetter1(0.0f, 0.0f);
        }
        return new CombinedInsetter(horizontal, vertical);
    }

    @Override
    @NotNull
    protected LayoutInfo getSliderThumbLayoutInfo(@NotNull SliderLayoutConfiguration g, boolean isForPainting) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderThumbLayoutInfo(g, isForPainting);
        }
        return this.getSlider11ThumbLayoutInfo(g, isForPainting);
    }

    @NotNull
    private LayoutInfo getSlider11ThumbLayoutInfo(@NotNull SliderLayoutConfiguration g, boolean isForPainting) {
        AquaUIPainter.Size sz = g.getSize();
        if (g.hasTickMarks()) {
            float height;
            float width;
            if (g.isHorizontal()) {
                width = JNRUtils.size(sz, 13, 12, 11);
                height = JNRUtils.size(sz, 24, 20, 17);
                if (!isForPainting) {
                    height += -1.0f;
                }
            } else {
                width = JNRUtils.size(sz, 24, 20, 17);
                height = JNRUtils.size(sz, 13, 12, 11);
            }
            return BasicLayoutInfo.createFixed(width, height);
        }
        float width = JNRUtils.size(sz, 24, 20, 20);
        float height = isForPainting ? width : width - 1.0f;
        return BasicLayoutInfo.createFixed(width, height);
    }

    @Override
    @NotNull
    protected Insetter getSliderThumbInsets(@NotNull SliderLayoutConfiguration g, double thumbPosition, boolean isForPainting) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderThumbInsets(g, thumbPosition, isForPainting);
        }
        return this.getSlider11ThumbInsets(g, thumbPosition, isForPainting);
    }

    @NotNull
    private Insetter getSlider11ThumbInsets(final @NotNull SliderLayoutConfiguration g, final double thumbPosition, boolean isForPainting) {
        LayoutInfo visualLayoutInfo;
        LayoutInfo layoutInfo = this.getSliderThumbLayoutInfo(g, isForPainting);
        LayoutInfo layoutInfo2 = visualLayoutInfo = isForPainting ? this.getSliderThumbLayoutInfo(g, false) : layoutInfo;
        if (g.isHorizontal()) {
            float offset = this.getPointerOffset(g);
            CenteredInsetter1 vertical = CenteredInsetter1.createCentered(layoutInfo.getFixedVisualHeight(), visualLayoutInfo.getFixedVisualHeight(), offset);
            DynamicInsetter1 horizontal = new DynamicInsetter1(layoutInfo.getFixedVisualWidth()){

                @Override
                protected float getCenterPosition(float componentSize) {
                    Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, componentSize, 30.0f);
                    return (float)BigSurLayoutInfo.this.getSlider11ThumbCenter(bounds, g, thumbPosition);
                }
            };
            return new CombinedInsetter(horizontal, vertical);
        }
        float offset = this.getPointerOffset(g);
        CenteredInsetter1 horizontal = CenteredInsetter1.createCentered(layoutInfo.getFixedVisualWidth(), visualLayoutInfo.getFixedVisualWidth(), offset);
        DynamicInsetter1 vertical = new DynamicInsetter1(layoutInfo.getFixedVisualHeight()){

            @Override
            protected float getCenterPosition(float componentSize) {
                Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, 30.0f, componentSize);
                return (float)BigSurLayoutInfo.this.getSlider11ThumbCenter(bounds, g, thumbPosition);
            }
        };
        return new CombinedInsetter(horizontal, vertical);
    }

    @Override
    protected float getPointerOffset(@NotNull SliderLayoutConfiguration g) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getPointerOffset(g);
        }
        return 0.0f;
    }

    @Override
    public double getSliderThumbCenter(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, double thumbPosition) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderThumbCenter(bounds, g, thumbPosition);
        }
        return this.getSlider11ThumbCenter(bounds, g, thumbPosition);
    }

    private double getSlider11ThumbCenter(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, double thumbPosition) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = bounds.getX();
        double top = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double extension = 0.0;
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            thumbPosition = 1.0 - thumbPosition;
            sw = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
        } else if (sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            thumbPosition = 1.0 - thumbPosition;
            sw = AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            double width = w - 2.0 * extension;
            return left + extension + thumbPosition * width;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            double height = h - 2.0 * extension;
            return top + extension + thumbPosition * height;
        }
        return 0.0;
    }

    @Override
    @NotNull
    public Insetter getSliderTickMarkPaintingInsets(@NotNull SliderLayoutConfiguration g) {
        int style = AquaUIPainterBase.internalGetSliderRenderingVersion();
        if (style == 2 && g.isLinear() && g.hasTickMarks()) {
            float FAKE_LENGTH = 100.0f;
            LayoutInfo sliderLayout = this.getSliderLayoutInfo(g);
            LayoutInfo tickLayout = this.getSliderTickLayoutInfo(g);
            Insetter trackInsets = this.getSliderTrackPaintingInsets(g);
            if (g.isHorizontal()) {
                float sliderHeight = sliderLayout.getFixedVisualHeight();
                Rectangle2D trackBounds = trackInsets.apply2D(FAKE_LENGTH, sliderHeight);
                float trackHeight = (float)trackBounds.getHeight();
                float tickHeight = tickLayout.getFixedVisualHeight();
                float trackOffset = (float)trackBounds.getY();
                float tickTopOffset = trackOffset - (tickHeight - trackHeight) / 2.0f;
                float tickBottomOffset = sliderHeight - (tickTopOffset + tickHeight);
                float trackLeftInset = (float)trackBounds.getX();
                float trackRightInset = (float)((double)FAKE_LENGTH - ((double)trackLeftInset + trackBounds.getWidth()));
                return new CombinedInsetter(new FixedInsetter1(trackLeftInset, trackRightInset), new FixedInsetter1(tickTopOffset, tickBottomOffset));
            }
            float sliderWidth = sliderLayout.getFixedVisualWidth();
            Rectangle2D trackBounds = trackInsets.apply2D(sliderWidth, FAKE_LENGTH);
            float trackWith = (float)trackBounds.getWidth();
            float tickWidth = tickLayout.getFixedVisualWidth();
            float trackOffset = (float)trackBounds.getX();
            float tickLeftOffset = trackOffset - (tickWidth - trackWith) / 2.0f;
            float tickRightOffset = sliderWidth - (tickLeftOffset + tickWidth);
            float trackTopInset = (float)trackBounds.getY();
            float trackBottomInset = (float)((double)FAKE_LENGTH - ((double)trackTopInset + trackBounds.getHeight()));
            return new CombinedInsetter(new FixedInsetter1(tickLeftOffset, tickRightOffset), new FixedInsetter1(trackTopInset, trackBottomInset));
        }
        return super.getSliderTickMarkPaintingInsets(g);
    }
}

