/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.RendererDescriptionsBase;
import org.violetlib.jnr.impl.BasicRendererDescription;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.JNRUtils;
import org.violetlib.jnr.impl.MultiResolutionRendererDescription;
import org.violetlib.jnr.impl.RendererDescription;

public class CoreUIRendererDescriptions
extends RendererDescriptionsBase {
    @Override
    @NotNull
    public RendererDescription getSplitPaneDividerRendererDescription(@NotNull SplitPaneDividerConfiguration g) {
        AquaUIPainter.DividerWidget dw = g.getWidget();
        AquaUIPainter.Orientation o = g.getOrientation();
        switch (g.getWidget()) {
            case THIN_DIVIDER: 
            case THICK_DIVIDER: {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            case PANE_SPLITTER: {
                return o == AquaUIPainter.Orientation.HORIZONTAL ? new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f) : new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
        }
        return null;
    }

    @Override
    @NotNull
    public RendererDescription getButtonRendererDescription(@NotNull ButtonConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.ButtonWidget bw = this.toCanonicalButtonStyle(g.getButtonWidget());
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: 
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.0f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -0.49f, 0.0f, 1.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            if (platformVersion >= 101600) {
                return new BasicRendererDescription(0.0f, -0.51f, 0.0f, 0.0f);
            }
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 4.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            if (platformVersion >= 101600) {
                switch (sz) {
                    case LARGE: {
                        return new BasicRendererDescription(0.49f, 0.0f, 0.0f, 6.0f);
                    }
                    case REGULAR: {
                        return new BasicRendererDescription(-0.49f, 0.0f, 0.0f, 2.0f);
                    }
                    case SMALL: {
                        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    case MINI: {
                        return new BasicRendererDescription(0.49f, 0.0f, 0.0f, 0.0f);
                    }
                }
                throw new UnsupportedOperationException();
            }
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, platformVersion < 101200 ? 3.0f : 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return platformVersion < 101200 ? new BasicRendererDescription(0.0f, -0.5f, 1.0f, 0.0f) : new BasicRendererDescription(-0.49f, 0.0f, 1.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
            if ((bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) && sz == AquaUIPainter.Size.LARGE && platformVersion >= 101600) {
                return new BasicRendererDescription(-5.0f, -1.0f, 10.0f, 2.0f);
            }
            if (platformVersion >= 101600) {
                if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED && (sz == AquaUIPainter.Size.MINI || sz == AquaUIPainter.Size.SMALL)) {
                    return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 1.0f);
                }
                return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
            }
            if (platformVersion >= 101100) {
                BasicRendererDescription x1 = new BasicRendererDescription(0.0f, -1.0f, 0.0f, 2.0f);
                BasicRendererDescription x2 = new BasicRendererDescription(-0.5f, -1.0f, 1.0f, 2.0f);
                return new MultiResolutionRendererDescription(x1, x2);
            }
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            if (platformVersion >= 101600) {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
            }
            switch (sz) {
                case LARGE: 
                case REGULAR: 
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 2.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
            if (platformVersion >= 101600) {
                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
            }
            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            if (platformVersion >= 120000) {
                if (sz == AquaUIPainter.Size.MINI) {
                    return new BasicRendererDescription(-1.0f, -1.0f, 2.0f, 1.0f);
                }
                return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
            }
            return new BasicRendererDescription(-2.0f, -2.0f, 4.0f, 4.0f);
        }
        return super.getButtonRendererDescription(g);
    }

    @Override
    @NotNull
    public RendererDescription getSegmentedButtonRendererDescription(@NotNull SegmentedButtonConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        RendererDescription rd = super.getSegmentedButtonRendererDescription(g);
        float extraWidth = 0.0f;
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        float leftOffset = 0.0f;
        float leftExtraWidth = 0.0f;
        float rightExtraWidth = 0.0f;
        float extraHeight = 0.0f;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_SLIDER: {
                if (platformVersion >= 101600 && bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    leftOffset = JNRUtils.size(sz, -4, -1, -1, -1);
                    leftExtraWidth = JNRUtils.size(sz, 4, 1, 1, 1);
                    rightExtraWidth = JNRUtils.size(sz, 4, 1, 1, 1);
                    break;
                }
                if (platformVersion >= 101500 && bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    AquaUIPainter.Position pos = g.getPosition();
                    xOffset = pos == AquaUIPainter.Position.MIDDLE ? 0.0f : (float)JNRUtils.size(sz, -2, -2, -1);
                    leftExtraWidth = JNRUtils.size(sz, 2, 2, 1);
                    rightExtraWidth = JNRUtils.size(sz, 2, 2, 1);
                    yOffset = JNRUtils.size2D(sz, 0.0, -1.0, 0.51);
                    extraHeight = JNRUtils.size(sz, 0, 0, -5);
                    break;
                }
                if (platformVersion >= 101400 && bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    AquaUIPainter.Position pos = g.getPosition();
                    xOffset = pos == AquaUIPainter.Position.MIDDLE ? 0.0f : (float)JNRUtils.size(sz, -2, -2, -1);
                    leftExtraWidth = JNRUtils.size(sz, 2, 2, 1);
                    rightExtraWidth = JNRUtils.size(sz, 2, 2, 1);
                    yOffset = JNRUtils.size2D(sz, 0.0, -0.49, 0.51);
                    extraHeight = JNRUtils.size(sz, 0, -2, -5);
                    break;
                }
                if (platformVersion >= 101300 && bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    xOffset = -0.49f;
                    leftOffset = JNRUtils.size2D(sz, -2.0f, -2.0f, -1.0f);
                    extraWidth = 1.0f;
                    leftExtraWidth = JNRUtils.size(sz, 2, 2, 1);
                    rightExtraWidth = JNRUtils.size2D(sz, 1.49, 1.49, 1.0);
                    yOffset = JNRUtils.size2D(sz, 0.0, -0.98, 0.51);
                    extraHeight = JNRUtils.size(sz, -1, -2, -5);
                    break;
                }
                if (platformVersion >= 101200 && bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
                    xOffset = -0.49f;
                    leftOffset = JNRUtils.size2D(sz, -2.0f, -2.0f, -1.0f);
                    extraWidth = 1.0f;
                    leftExtraWidth = JNRUtils.size(sz, 2, 2, 1);
                    rightExtraWidth = JNRUtils.size2D(sz, 1.49, 1.49, 0.49);
                    yOffset = JNRUtils.size2D(sz, 0.0, -1.98, 0.51);
                    extraHeight = JNRUtils.size(sz, 0, 0, -5);
                    break;
                }
                if (platformVersion <= 101600) {
                    yOffset = JNRUtils.size2D(sz, -0.51f, -1.49f, -2.0f);
                }
                leftOffset = JNRUtils.size(sz, -5, -2, -2, -1);
                leftExtraWidth = JNRUtils.size(sz, 5, 2, 2, 1);
                rightExtraWidth = JNRUtils.size(sz, 4, 2, 2, 1);
                if (!this.shouldUseSpecialSeparatedDescription(g)) break;
                rd = this.getSegmentedSeparatedRendererDescription(g, rd, yOffset, leftOffset);
                yOffset = 0.0f;
                leftOffset = 0.0f;
                break;
            }
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                yOffset = JNRUtils.size2D(sz, -1.0, 0.0, -0.49f, -1.49f);
                leftOffset = JNRUtils.size(sz, -6, -1, -1, -1);
                leftExtraWidth = JNRUtils.size(sz, 6, 1, 1, 1);
                rightExtraWidth = JNRUtils.size(sz, 5, 1, 1, 1);
                extraHeight = JNRUtils.size(sz, -1, 0, 0, 0);
                if (!this.shouldUseSpecialSeparatedDescription(g)) break;
                rd = this.getSegmentedSeparatedRendererDescription(g, rd, yOffset, leftOffset);
                yOffset = 0.0f;
                leftOffset = 0.0f;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                yOffset = platformVersion >= 101600 ? JNRUtils.size2D(sz, -1.0f, -2.0f, -2.0f) : JNRUtils.size2D(sz, -1.0f, -1.51f, -2.0f);
                leftOffset = -1.0f;
                leftExtraWidth = 1.0f;
                rightExtraWidth = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                if (platformVersion >= 101600) {
                    if (!bw.isToolbar()) {
                        switch (g.getPosition()) {
                            case FIRST: {
                                return new BasicRendererDescription(-1.0f, 0.0f, 1.0f, 1.0f);
                            }
                            case MIDDLE: {
                                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 1.0f);
                            }
                            case LAST: {
                                return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 1.0f);
                            }
                            case ONLY: {
                                return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 1.0f);
                            }
                        }
                        throw new UnsupportedOperationException("Unknown position");
                    }
                    if (bw.isSeparated()) {
                        if (sz == AquaUIPainter.Size.LARGE) {
                            AquaUIPainter.Position pos = g.getPosition();
                            int x = pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.ONLY ? -6 : 0;
                            AquaUIPainter.State st = g.getState();
                            int y = st == AquaUIPainter.State.PRESSED || st == AquaUIPainter.State.ROLLOVER || g.isSelected() ? -6 : 0;
                            BasicRendererDescription srd = new BasicRendererDescription(x, y, 0.0f, 11.0f);
                            return this.adjustSegmentedRendererDescription(g, srd, 0.0f, 0.0f, 0.0f, 0.0f, 6.0f, 5.0f, 0.0f);
                        }
                        AquaUIPainter.State st = g.getState();
                        int y = g.isSelected() && st != AquaUIPainter.State.PRESSED && st != AquaUIPainter.State.ROLLOVER ? -2 : -1;
                        switch (g.getPosition()) {
                            case FIRST: {
                                return new BasicRendererDescription(-1.0f, y, 1.0f, 3.0f);
                            }
                            case MIDDLE: {
                                return new BasicRendererDescription(0.0f, y, 0.0f, 3.0f);
                            }
                            case LAST: {
                                return new BasicRendererDescription(0.0f, y, 1.0f, 3.0f);
                            }
                            case ONLY: {
                                return new BasicRendererDescription(-1.0f, y, 2.0f, 3.0f);
                            }
                        }
                        throw new UnsupportedOperationException("Unknown position");
                    }
                    if (sz == AquaUIPainter.Size.LARGE) {
                        switch (g.getPosition()) {
                            case FIRST: {
                                return new BasicRendererDescription(-6.0f, 0.0f, 6.0f, 0.0f);
                            }
                            case MIDDLE: {
                                return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                            }
                            case LAST: {
                                return new BasicRendererDescription(0.0f, 0.0f, 6.0f, 0.0f);
                            }
                            case ONLY: {
                                return new BasicRendererDescription(-6.0f, 0.0f, 11.0f, 0.0f);
                            }
                        }
                        throw new UnsupportedOperationException("Unknown position");
                    }
                    switch (g.getPosition()) {
                        case FIRST: {
                            return new BasicRendererDescription(-1.0f, 0.0f, 1.0f, 0.0f);
                        }
                        case MIDDLE: {
                            return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                        }
                        case LAST: {
                            return new BasicRendererDescription(0.0f, 0.0f, 1.0f, 0.0f);
                        }
                        case ONLY: {
                            return new BasicRendererDescription(-1.0f, 0.0f, 2.0f, 0.0f);
                        }
                    }
                    throw new UnsupportedOperationException("Unknown position");
                }
                if (sz == AquaUIPainter.Size.MINI) {
                    rd = this.createVertical(0.0f, 4.0f);
                }
                float smallYOffset = platformVersion >= 101100 ? (bw.isToolbar() ? -0.49f : -1.49f) : -1.0f;
                yOffset = JNRUtils.size2D(sz, 0.0f, smallYOffset, -2.0f);
                if (!bw.isSeparated()) break;
                return this.getTexturedSeparatedRendererDescription(g, rd, yOffset);
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                yOffset = -1.0f;
                extraHeight = JNRUtils.size(sz, 0, -1, -2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.adjustSegmentedRendererDescription(g, rd, extraWidth, xOffset, yOffset, leftOffset, leftExtraWidth, rightExtraWidth, extraHeight);
    }

    protected boolean shouldUseSpecialSeparatedDescription(@NotNull SegmentedButtonConfiguration g) {
        if (g.getPosition() == AquaUIPainter.Position.ONLY) {
            return false;
        }
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        if (bw == AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED) {
            return true;
        }
        return g.isSelected() && bw.isSlider();
    }

    @NotNull
    protected RendererDescription getTexturedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration g, @NotNull RendererDescription rd, float yOffset) {
        float extraWidth1 = 0.0f;
        float extraWidth2 = -0.5f;
        float xOffset1 = 0.0f;
        float xOffset2 = 0.0f;
        boolean hasLeft = g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean hasRight = g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        AquaUIPainter.Position pos = g.getPosition();
        if (pos == AquaUIPainter.Position.FIRST) {
            if (!hasRight) {
                extraWidth1 = 1.0f;
                extraWidth2 = 0.5f;
            } else {
                extraWidth2 = 0.0f;
            }
        } else if (pos == AquaUIPainter.Position.MIDDLE) {
            if (hasRight && !hasLeft) {
                extraWidth2 = 0.5f;
                xOffset2 = -0.5f;
            } else if (hasLeft && !hasRight) {
                extraWidth1 = 1.0f;
                extraWidth2 = 0.5f;
            } else if (!hasLeft && !hasRight) {
                extraWidth1 = 1.0f;
                extraWidth2 = 1.0f;
                xOffset2 = -0.5f;
            } else {
                extraWidth2 = 0.0f;
            }
        } else if (pos == AquaUIPainter.Position.LAST) {
            if (!hasLeft) {
                extraWidth2 = 0.5f;
                xOffset2 = -0.5f;
            } else {
                extraWidth2 = 0.0f;
            }
        }
        RendererDescription d1 = this.adjustSegmentedRendererDescription(g, rd, extraWidth1, xOffset1, yOffset, 0.0f, 0.0f, 0.0f, 0.0f);
        RendererDescription d2 = this.adjustSegmentedRendererDescription(g, rd, extraWidth2, xOffset2, yOffset, 0.0f, 0.0f, 0.0f, 0.0f);
        return new MultiResolutionRendererDescription(d1, d2);
    }

    @NotNull
    protected RendererDescription getSegmentedSeparatedRendererDescription(@NotNull SegmentedButtonConfiguration g, @NotNull RendererDescription rd, float yOffset, float xOffset) {
        boolean hasLeft = g.getLeftDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        boolean hasRight = g.getRightDividerState() != SegmentedButtonConfiguration.DividerState.NONE;
        float extraWidth = hasRight ? 2.0f : 2.5f;
        AquaUIPainter.Position pos = g.getPosition();
        if (pos != AquaUIPainter.Position.FIRST) {
            if (pos == AquaUIPainter.Position.MIDDLE) {
                xOffset = 0.0f;
                extraWidth = 0.51f;
                if (hasRight && !hasLeft) {
                    xOffset = -0.49f;
                    extraWidth = 0.49f;
                } else if (hasLeft && hasRight) {
                    extraWidth = 0.0f;
                } else if (!hasLeft && !hasRight) {
                    extraWidth = 1.0f;
                    xOffset = -0.49f;
                }
            } else if (pos == AquaUIPainter.Position.LAST) {
                extraWidth = 2.0f;
                xOffset = hasLeft ? 0.0f : -0.49f;
            }
        }
        try {
            return JNRUtils.adjustRendererDescription(rd, xOffset, yOffset, extraWidth, 0.0f);
        }
        catch (UnsupportedOperationException ex) {
            NativeSupport.log("Unable to adjust segmented button renderer description for " + g);
            return rd;
        }
    }

    @Override
    @NotNull
    public RendererDescription getComboBoxRendererDescription(@NotNull ComboBoxConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, -3.0f, 2.0f, 3.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, -1.5f, 2.0f, 2.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        switch (sz) {
            case LARGE: 
            case REGULAR: {
                return new BasicRendererDescription(-0.5f, 0.0f, 2.0f, 1.0f);
            }
            case SMALL: {
                return new BasicRendererDescription(-0.5f, 0.0f, 1.0f, 0.0f);
            }
            case MINI: {
                return new BasicRendererDescription(-0.5f, -0.51f, 2.0f, 1.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public RendererDescription getPopupButtonRendererDescription(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL) {
            switch (sz) {
                case LARGE: 
                case REGULAR: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case SMALL: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
                case MINI: {
                    return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            throw new UnsupportedOperationException();
        }
        return super.getPopupButtonRendererDescription(g);
    }

    @Nullable
    public RendererDescription getPopUpArrowRendererDescription(@NotNull PopupButtonConfiguration g, @NotNull AquaUIPainter.Size arrowSize) {
        float left = JNRUtils.size2D(arrowSize, 1.0f, 0.0f, 2.0f);
        float top = JNRUtils.size2D(arrowSize, 3.0f, 1.0f, 1.0f);
        int w = JNRUtils.size(arrowSize, 1, 0, 1);
        int h = JNRUtils.size(arrowSize, 3, 1, 0);
        return new BasicRendererDescription(-left, -top, w, h);
    }

    @NotNull
    public RendererDescription getPullDownArrowRendererDescription(@NotNull PopupButtonConfiguration g) {
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, 0.0f);
    }

    @NotNull
    public RendererDescription getScrollBarThumbRendererDescription(@NotNull ScrollBarConfiguration g) {
        int extra;
        int n = extra = g.getWidget() == AquaUIPainter.ScrollBarWidget.LEGACY ? 2 : 1;
        if (g.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            return new BasicRendererDescription(0.0f, extra, 0.0f, -2 * extra);
        }
        return new BasicRendererDescription(extra, 0.0f, -2 * extra, 0.0f);
    }

    @Override
    @NotNull
    public RendererDescription getSliderThumbRendererDescription(@NotNull SliderConfiguration g) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderThumbRendererDescription(g);
        }
        return this.getSlider11ThumbRendererDescription(g);
    }

    @NotNull
    private RendererDescription getSlider11ThumbRendererDescription(@NotNull SliderConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        float h = g.hasTickMarks() ? JNRUtils.size2D(sz, 3.5, 0.0, 0.0) : JNRUtils.size2D(sz, 4.0f, 0.0f, 0.0f);
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, h);
    }

    @Override
    @NotNull
    public RendererDescription getSliderTickMarkRendererDescription(@NotNull SliderConfiguration g) {
        if (!g.isLinear() || AquaUIPainterBase.internalGetSliderRenderingVersion() == 0) {
            return super.getSliderTickMarkRendererDescription(g);
        }
        AquaUIPainter.Size sz = g.getSize();
        float h = g.hasTickMarks() ? JNRUtils.size2D(sz, 4.0f, 0.0f, 0.0f) : 0.0f;
        return new BasicRendererDescription(0.0f, 0.0f, 0.0f, h);
    }
}

