/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.impl.JNRUtils;

public class SliderConfiguration
extends SliderLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isFocused;
    private final double value;

    public SliderConfiguration(@NotNull AquaUIPainter.SliderWidget sw, @NotNull AquaUIPainter.Size sz, @NotNull AquaUIPainter.State state, boolean isFocused, double value, int numberOfTickMarks, @NotNull AquaUIPainter.TickMarkPosition position) {
        super(sw, sz, numberOfTickMarks, position);
        this.state = state;
        this.isFocused = isFocused;
        this.value = value;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SliderConfiguration that = (SliderConfiguration)o;
        return this.state == that.state && this.isFocused == that.isFocused && this.value == that.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isFocused, this.value});
    }

    @Override
    @NotNull
    public String toString() {
        String fs = this.isFocused ? " focused" : "";
        return super.toString() + " " + (Object)((Object)this.state) + fs + " " + JNRUtils.format2(this.value);
    }
}

