/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.ScrollBarLayoutConfiguration;
import org.violetlib.jnr.impl.JNRUtils;

public class ScrollBarConfiguration
extends ScrollBarLayoutConfiguration
implements Configuration {
    @NotNull
    private final AquaUIPainter.ScrollBarKnobWidget kw;
    @NotNull
    private final AquaUIPainter.State state;
    private final float thumbPosition;
    private final float thumbExtent;
    private final boolean noTrack;

    public ScrollBarConfiguration(@NotNull AquaUIPainter.ScrollBarWidget bw, @NotNull AquaUIPainter.ScrollBarKnobWidget kw, @NotNull AquaUIPainter.Size sz, @NotNull AquaUIPainter.State state, @NotNull AquaUIPainter.Orientation o, float thumbPosition, float thumbExtent, boolean noTrack) {
        super(bw, sz, o);
        this.kw = kw;
        this.state = state;
        this.thumbPosition = thumbPosition;
        this.thumbExtent = thumbExtent;
        this.noTrack = noTrack;
    }

    public ScrollBarConfiguration(@NotNull ScrollBarConfiguration g) {
        this(g.getWidget(), g.getKnobWidget(), g.getSize(), g.getState(), g.getOrientation(), g.getThumbPosition(), g.getThumbExtent(), g.isTrackSuppressed());
    }

    @NotNull
    public AquaUIPainter.ScrollBarKnobWidget getKnobWidget() {
        return this.kw;
    }

    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    public float getThumbPosition() {
        return this.thumbPosition;
    }

    public float getThumbExtent() {
        return this.thumbExtent;
    }

    public boolean isTrackSuppressed() {
        return this.noTrack;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScrollBarConfiguration that = (ScrollBarConfiguration)o;
        return this.kw == that.kw && this.state == that.state && this.thumbPosition == that.thumbPosition && this.thumbExtent == that.thumbExtent && this.noTrack == that.noTrack;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.kw, this.state, Float.valueOf(this.thumbPosition), Float.valueOf(this.thumbExtent), this.noTrack});
    }

    @Override
    @NotNull
    public String toString() {
        return super.toString() + " " + (Object)((Object)this.kw) + " " + (Object)((Object)this.state) + " " + JNRUtils.format2(this.thumbPosition) + " " + JNRUtils.format2(this.thumbExtent) + (this.noTrack ? " [no track]" : "");
    }
}

