/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.GenericButtonConfiguration;
import org.violetlib.jnr.impl.JNRPlatformUtils;

public class ComboBoxConfiguration
extends ComboBoxLayoutConfiguration
implements GenericButtonConfiguration {
    @NotNull
    private final AquaUIPainter.State state;
    private final boolean isFocused;

    public ComboBoxConfiguration(@NotNull AquaUIPainter.ComboBoxWidget widget, @NotNull AquaUIPainter.Size size, @NotNull AquaUIPainter.State state, boolean isFocused, @NotNull AquaUIPainter.UILayoutDirection ld) {
        super(widget, size, ld);
        if (state.isInactive() && !ComboBoxConfiguration.isSensitiveToInactiveState(widget)) {
            state = state.toActive();
        }
        this.isFocused = isFocused;
        this.state = state;
    }

    public ComboBoxConfiguration(@NotNull ComboBoxLayoutConfiguration g, @NotNull AquaUIPainter.State state, boolean isFocused) {
        this(g.getWidget(), g.getSize(), state, isFocused, g.getLayoutDirection());
    }

    @Override
    @NotNull
    public AquaUIPainter.State getState() {
        return this.state;
    }

    @Override
    public boolean isTextured() {
        AquaUIPainter.ComboBoxWidget w = this.getWidget();
        return w.isTextured();
    }

    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComboBoxConfiguration that = (ComboBoxConfiguration)o;
        return this.isFocused == that.isFocused && this.state == that.state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.state, this.isFocused});
    }

    @Override
    @NotNull
    public String toString() {
        String fs = this.isFocused ? " focused" : "";
        return super.toString() + " " + (Object)((Object)this.state) + fs;
    }

    private static boolean isSensitiveToInactiveState(@NotNull AquaUIPainter.ComboBoxWidget widget) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        if (widget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX) {
            return true;
        }
        if (widget.isTextured()) {
            return platformVersion < 101500;
        }
        return false;
    }
}

