/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jetbrains.annotations.NotNull;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.geom.GeneralRoundRectIterator;

public class GeneralRoundRectangle
extends RectangularShape
implements ExpandableOutline.ExpandableShape {
    private double x;
    private double y;
    private double width;
    private double height;
    private double tlaw;
    private double tlah;
    private double traw;
    private double trah;
    private double braw;
    private double brah;
    private double blaw;
    private double blah;

    public GeneralRoundRectangle() {
    }

    public GeneralRoundRectangle(double x, double y, double w, double h, double tlaw, double tlah, double traw, double trah, double braw, double brah, double blaw, double blah) {
        this.set(x, y, w, h, tlaw, tlah, traw, trah, braw, brah, blaw, blah);
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public double getTopLeftArcWidth() {
        return this.tlaw;
    }

    public double getTopLeftArcHeight() {
        return this.tlah;
    }

    public double getTopRightArcWidth() {
        return this.traw;
    }

    public double getTopRightArcHeight() {
        return this.trah;
    }

    public double getBottomRightArcWidth() {
        return this.braw;
    }

    public double getBottomRightArcHeight() {
        return this.brah;
    }

    public double getBottomLeftArcWidth() {
        return this.blaw;
    }

    public double getBottomLeftArcHeight() {
        return this.blah;
    }

    @Override
    public boolean isEmpty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public void set(double x, double y, double w, double h, double tlaw, double tlah, double traw, double trah, double braw, double brah, double blaw, double blah) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        this.tlaw = tlaw;
        this.tlah = tlah;
        this.traw = traw;
        this.trah = trah;
        this.braw = braw;
        this.brah = brah;
        this.blaw = blaw;
        this.blah = blah;
    }

    public void set(GeneralRoundRectangle rr) {
        this.x = rr.getX();
        this.y = rr.getY();
        this.width = rr.getWidth();
        this.height = rr.getHeight();
        this.tlaw = rr.getTopLeftArcWidth();
        this.tlah = rr.getTopLeftArcHeight();
        this.traw = rr.getTopRightArcWidth();
        this.trah = rr.getTopRightArcHeight();
        this.braw = rr.getBottomRightArcWidth();
        this.brah = rr.getBottomRightArcHeight();
        this.blaw = rr.getBottomLeftArcWidth();
        this.blah = rr.getBottomLeftArcHeight();
    }

    @Override
    @NotNull
    public Shape createExpandedShape(float offset) {
        return new GeneralRoundRectangle(this.x - (double)offset, this.y - (double)offset, this.width + (double)(2.0f * offset), this.height + (double)(2.0f * offset), this.tlaw > 0.0 ? this.tlaw + (double)offset : 0.0, this.tlah > 0.0 ? this.tlah + (double)offset : 0.0, this.traw > 0.0 ? this.traw + (double)offset : 0.0, this.trah > 0.0 ? this.trah + (double)offset : 0.0, this.braw > 0.0 ? this.braw + (double)offset : 0.0, this.brah > 0.0 ? this.brah + (double)offset : 0.0, this.blaw > 0.0 ? this.blaw + (double)offset : 0.0, this.blah > 0.0 ? this.blah + (double)offset : 0.0);
    }

    @Override
    @NotNull
    public Shape createTranslatedShape(double x, double y) {
        return new GeneralRoundRectangle(x + this.x, y + this.y, this.width, this.height, this.tlaw, this.tlah, this.traw, this.trah, this.braw, this.brah, this.blaw, this.blah);
    }

    @Override
    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.x, this.y, this.width, this.height);
    }

    @Override
    public void setFrame(double x, double y, double w, double h) {
        this.set(x, y, w, h, this.getTopLeftArcWidth(), this.getTopLeftArcHeight(), this.getTopRightArcWidth(), this.getTopRightArcHeight(), this.getBottomRightArcWidth(), this.getBottomRightArcHeight(), this.getBottomLeftArcWidth(), this.getBottomLeftArcHeight());
    }

    @Override
    public boolean contains(double x, double y) {
        return false;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return false;
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        return this.contains(x, y) && this.contains(x + w, y) && this.contains(x, y + h) && this.contains(x + w, y + h);
    }

    @Override
    public PathIterator getPathIterator(AffineTransform at) {
        return new GeneralRoundRectIterator(this, at);
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.getX());
        bits += Double.doubleToLongBits(this.getY()) * 37L;
        bits += Double.doubleToLongBits(this.getWidth()) * 43L;
        bits += Double.doubleToLongBits(this.getHeight()) * 47L;
        bits += Double.doubleToLongBits(this.getTopLeftArcWidth()) * 53L;
        bits += Double.doubleToLongBits(this.getTopLeftArcHeight()) * 59L;
        bits += Double.doubleToLongBits(this.getTopRightArcWidth()) * 61L;
        bits += Double.doubleToLongBits(this.getTopRightArcHeight()) * 67L;
        bits += Double.doubleToLongBits(this.getBottomRightArcWidth()) * 71L;
        bits += Double.doubleToLongBits(this.getBottomRightArcHeight()) * 73L;
        bits += Double.doubleToLongBits(this.getBottomLeftArcWidth()) * 79L;
        return (int)(bits += Double.doubleToLongBits(this.getBottomLeftArcHeight()) * 83L) ^ (int)(bits >> 32);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GeneralRoundRectangle) {
            GeneralRoundRectangle rr2d = (GeneralRoundRectangle)obj;
            return this.getX() == rr2d.getX() && this.getY() == rr2d.getY() && this.getWidth() == rr2d.getWidth() && this.getHeight() == rr2d.getHeight() && this.getTopLeftArcWidth() == rr2d.getTopLeftArcWidth() && this.getTopLeftArcHeight() == rr2d.getTopLeftArcHeight() && this.getTopRightArcWidth() == rr2d.getTopRightArcWidth() && this.getTopRightArcHeight() == rr2d.getTopRightArcHeight() && this.getBottomRightArcWidth() == rr2d.getBottomRightArcWidth() && this.getBottomRightArcHeight() == rr2d.getBottomRightArcHeight() && this.getBottomLeftArcWidth() == rr2d.getBottomLeftArcWidth() && this.getBottomLeftArcHeight() == rr2d.getBottomLeftArcHeight();
        }
        return false;
    }
}

