/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.geom;

import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.geom.ExpandableOutline;

public final class ExpandableRoundRectOutline
extends ExpandableOutline {
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    private final double arcWidth;
    private final double arcHeight;

    public ExpandableRoundRectOutline(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public ExpandableRoundRectOutline(@NotNull RoundRectangle2D source) {
        this.x = source.getX();
        this.y = source.getY();
        this.width = source.getWidth();
        this.height = source.getHeight();
        this.arcWidth = source.getArcWidth();
        this.arcHeight = source.getArcHeight();
    }

    @Override
    @NotNull
    public Shape getShape(float offset) {
        double nx = this.x - (double)offset;
        double ny = this.y - (double)offset;
        double nwidth = this.width + (double)(2.0f * offset);
        double nheight = this.height + (double)(2.0f * offset);
        double narcWidth = this.arcWidth + (double)offset;
        double narcHeight = this.arcHeight + (double)offset;
        return new RoundRectangle2D.Double(nx, ny, nwidth, nheight, narcWidth, narcHeight);
    }
}

