/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Taskbar;
import java.awt.color.ColorSpace;
import java.awt.event.FocusEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.MultiResolutionImage;
import java.awt.image.WritableRaster;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import org.jetbrains.annotations.NotNull;
import org.violetlib.aqua.Aqua9MultiResolutionImage;
import org.violetlib.aqua.Aqua9MultiResolutionImage2;
import org.violetlib.aqua.Aqua9PopupFactory;
import org.violetlib.aqua.AquaMultiResolutionImage;
import org.violetlib.aqua.AquaPopupFactory;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.JavaSupport;

public class Java9Support
implements JavaSupport.JavaSupportImpl {
    @Override
    public int getScaleFactor(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        AffineTransform affineTransform = graphicsConfiguration != null ? graphicsConfiguration.getDefaultTransform() : graphics2D.getTransform();
        double d = affineTransform.getScaleX();
        double d2 = affineTransform.getScaleY();
        return (int)Math.max(d, d2);
    }

    @Override
    public boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        boolean bl = AquaUtils.nativeHasOpaqueBeenExplicitlySet(jComponent);
        if (bl) {
            // empty if block
        }
        return bl;
    }

    @Override
    public Image getDockIconImage() {
        Taskbar taskbar = Taskbar.getTaskbar();
        return taskbar.getIconImage();
    }

    @Override
    public void drawString(JComponent jComponent, Graphics2D graphics2D, String string, float f, float f2) {
        BasicGraphicsUtils.drawString(jComponent, graphics2D, string, f, f2);
    }

    @Override
    public void drawStringUnderlineCharAt(JComponent jComponent, Graphics2D graphics2D, String string, int n, float f, float f2) {
        BasicGraphicsUtils.drawStringUnderlineCharAt(jComponent, graphics2D, string, n, f, f2);
    }

    @Override
    public String getClippedString(JComponent jComponent, FontMetrics fontMetrics, String string, int n) {
        return BasicGraphicsUtils.getClippedString(jComponent, fontMetrics, string, n);
    }

    @Override
    public float getStringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) {
        return BasicGraphicsUtils.getStringWidth(jComponent, fontMetrics, string);
    }

    @Override
    public void installAATextInfo(UIDefaults uIDefaults) {
        AquaUtils.nativeInstallAATextInfo(uIDefaults);
    }

    @Override
    public AquaMultiResolutionImage createMultiResolutionImage(BufferedImage bufferedImage) {
        return new Aqua9MultiResolutionImage(bufferedImage);
    }

    @Override
    public AquaMultiResolutionImage createMultiResolutionImage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return new Aqua9MultiResolutionImage2(bufferedImage, bufferedImage2);
    }

    @Override
    @NotNull
    public AquaMultiResolutionImage createImage(int n, int n2, int[] nArray, float f) {
        BufferedImage bufferedImage = this.createImage(n, n2, nArray);
        int n3 = (int)(((float)n + f - 1.0f) / f);
        int n4 = (int)(((float)n2 + f - 1.0f) / f);
        return new Aqua9MultiResolutionImage(n3, n4, bufferedImage);
    }

    @Override
    public Image applyFilter(Image image, ImageFilter imageFilter) {
        return Aqua9MultiResolutionImage.apply(image, imageFilter);
    }

    @Override
    public Image applyMapper(Image image, Function<Image, Image> function) {
        return Aqua9MultiResolutionImage.apply(image, function);
    }

    @Override
    public Image applyMapper(Image image, AquaMultiResolutionImage.Mapper mapper) {
        return Aqua9MultiResolutionImage.apply(image, mapper);
    }

    @Override
    @NotNull
    public Image getResolutionVariant(@NotNull Image image, double d, double d2) {
        if (image instanceof MultiResolutionImage) {
            MultiResolutionImage multiResolutionImage = (MultiResolutionImage)((Object)image);
            return multiResolutionImage.getResolutionVariant(d, d2);
        }
        return image;
    }

    @Override
    @NotNull
    public BufferedImage createImage(int n, int n2, int[] nArray) {
        DirectColorModel directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 32, 0xFF0000, 65280, 255, -16777216, true, 3);
        WritableRaster writableRaster = ((ColorModel)directColorModel).createCompatibleWritableRaster(n, n2);
        writableRaster.setDataElements(0, 0, n, n2, nArray);
        BufferedImage bufferedImage = new BufferedImage(directColorModel, writableRaster, true, null);
        return bufferedImage;
    }

    @Override
    public void preload(Image image, int n) {
    }

    @Override
    public void lockRenderQueue() {
    }

    @Override
    public void unlockRenderQueue() {
    }

    @Override
    public AquaPopupFactory createPopupFactory() {
        return new Aqua9PopupFactory();
    }

    @Override
    public int getFocusEventCause(@NotNull FocusEvent focusEvent) {
        FocusEvent.Cause cause = focusEvent.getCause();
        switch (cause) {
            case UNKNOWN: {
                return 0;
            }
            case MOUSE_EVENT: {
                return 1;
            }
            case TRAVERSAL: {
                return 2;
            }
            case TRAVERSAL_UP: {
                return 3;
            }
            case TRAVERSAL_DOWN: {
                return 4;
            }
            case TRAVERSAL_FORWARD: {
                return 5;
            }
            case TRAVERSAL_BACKWARD: {
                return 6;
            }
            case ROLLBACK: {
                return 7;
            }
            case ACTIVATION: {
                return 9;
            }
            case CLEAR_GLOBAL_FOCUS_OWNER: {
                return 10;
            }
        }
        return 0;
    }

    @Override
    public void requestFocusInWindowFromMouseEvent(@NotNull Component component) {
        component.requestFocusInWindow(FocusEvent.Cause.MOUSE_EVENT);
    }
}

