/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaTreeUI;
import org.violetlib.aqua.AquaUtils;

public class AquaTreeCellEditor
extends DefaultTreeCellEditor {
    public AquaTreeCellEditor(@NotNull JTree jTree, @Nullable DefaultTreeCellRenderer defaultTreeCellRenderer) {
        super(jTree, defaultTreeCellRenderer);
    }

    @Override
    protected Container createContainer() {
        return new AquaEditorContainer();
    }

    private class AquaEditorContainer
    extends Container {
        private AquaEditorContainer() {
        }

        @Override
        public void paint(Graphics graphics) {
            Color color;
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (AquaTreeCellEditor.this.editingIcon != null) {
                int n3 = this.calculateIconY(AquaTreeCellEditor.this.editingIcon);
                if (this.getComponentOrientation().isLeftToRight()) {
                    this.paintIcon(graphics, AquaTreeCellEditor.this.editingIcon, 0, n3);
                } else {
                    this.paintIcon(graphics, AquaTreeCellEditor.this.editingIcon, n - AquaTreeCellEditor.this.editingIcon.getIconWidth(), n3);
                }
            }
            if ((color = AquaTreeCellEditor.this.getBorderSelectionColor()) != null) {
                graphics.setColor(color);
                graphics.drawRect(0, 0, n - 1, n2 - 1);
            }
            super.paint(graphics);
            super.paint(graphics);
        }

        protected void paintIcon(@NotNull Graphics graphics, @NotNull Icon icon, int n, int n2) {
            TreePath treePath = AquaTreeCellEditor.this.tree.getEditingPath();
            assert (treePath != null);
            AquaTreeUI aquaTreeUI = AquaUtils.getUI(AquaTreeCellEditor.this.tree, AquaTreeUI.class);
            if (aquaTreeUI != null) {
                aquaTreeUI.paintEditorIcon(graphics, treePath, icon, n, n2);
            } else {
                icon.paintIcon(this, graphics, n, n2);
            }
        }

        @Override
        public void doLayout() {
            if (AquaTreeCellEditor.this.editingComponent != null) {
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (this.getComponentOrientation().isLeftToRight()) {
                    AquaTreeCellEditor.this.editingComponent.setBounds(AquaTreeCellEditor.this.offset, 0, n - AquaTreeCellEditor.this.offset, n2);
                } else {
                    AquaTreeCellEditor.this.editingComponent.setBounds(0, 0, n - AquaTreeCellEditor.this.offset, n2);
                }
            }
        }

        private int calculateIconY(Icon icon) {
            int n = icon.getIconHeight();
            int n2 = AquaTreeCellEditor.this.editingComponent.getFontMetrics(AquaTreeCellEditor.this.editingComponent.getFont()).getHeight();
            int n3 = n / 2 - n2 / 2;
            int n4 = Math.min(0, n3);
            int n5 = Math.max(n, n3 + n2) - n4;
            return this.getHeight() / 2 - (n4 + n5 / 2);
        }

        @Override
        public Dimension getPreferredSize() {
            if (AquaTreeCellEditor.this.editingComponent != null) {
                Dimension dimension;
                Dimension dimension2 = AquaTreeCellEditor.this.editingComponent.getPreferredSize();
                dimension2.width += AquaTreeCellEditor.this.offset + 5;
                Dimension dimension3 = dimension = AquaTreeCellEditor.this.renderer != null ? AquaTreeCellEditor.this.renderer.getPreferredSize() : null;
                if (dimension != null) {
                    dimension2.height = Math.max(dimension2.height, dimension.height);
                }
                if (AquaTreeCellEditor.this.editingIcon != null) {
                    dimension2.height = Math.max(dimension2.height, AquaTreeCellEditor.this.editingIcon.getIconHeight());
                }
                dimension2.width = Math.max(dimension2.width, 100);
                return dimension2;
            }
            return new Dimension(0, 0);
        }
    }
}

