/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.violetlib.aqua.AquaExtendedPopup;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaScrollPaneUI;
import org.violetlib.aqua.BackgroundPainter;

public class AquaScrollingPopupMenuWrapper
extends JPanel {
    private static final int kInitialDelay = 20;
    private static final int kNormalDelay = 20;
    protected final ArrowPane topArrowPane;
    protected final JComponent originalContent;
    protected final JComponent scrollableView;
    protected final ArrowPane bottomArrowPane;
    protected final JViewport viewport;
    protected int width;
    protected int height;
    protected boolean isTopArrowInstalled;
    protected boolean isBottomArrowInstalled;
    protected int topArrowHeight;
    protected int bottomArrowHeight;
    protected int unitScroll = 12;
    protected Timer fScrollTimer;
    protected ActionListener fScrollListener;

    public AquaScrollingPopupMenuWrapper(JComponent jComponent, Rectangle rectangle, Point point, int n, int n2, Border border) {
        super(null);
        Serializable serializable;
        this.originalContent = jComponent;
        this.width = n;
        this.height = n2;
        this.setOpaque(false);
        this.setBorder(border);
        this.setLayout(new MyLayoutManager());
        this.setPreferredSize(new Dimension(n, n2));
        jComponent.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (mouseWheelEvent.getScrollType() == 0) {
                    AquaScrollingPopupMenuWrapper.this.mouseWheelScroll(mouseWheelEvent);
                }
                mouseWheelEvent.consume();
            }
        });
        if (jComponent instanceof JPopupMenu) {
            serializable = new JPanel();
            ((Component)serializable).setName("JPopUpMenuWrapper");
            ((Container)serializable).setLayout(new BorderLayout());
            ((Container)serializable).add(jComponent);
            ((JComponent)serializable).setOpaque(false);
            this.scrollableView = serializable;
        } else {
            this.scrollableView = jComponent;
        }
        serializable = this.scrollableView.getPreferredSize();
        this.scrollableView.setSize((Dimension)serializable);
        this.topArrowPane = this.createArrowPane(true);
        this.bottomArrowPane = this.createArrowPane(false);
        this.viewport = new JViewport();
        this.viewport.setView(this.scrollableView);
        this.viewport.setLayout(null);
        this.add(this.viewport);
        this.add(this.topArrowPane);
        this.add(this.bottomArrowPane);
        this.topArrowHeight = this.topArrowPane.getPreferredSize().height;
        this.bottomArrowHeight = this.bottomArrowPane.getPreferredSize().height;
        int n3 = 0;
        if (rectangle != null) {
            int n4;
            Insets insets = this.getInsets();
            boolean bl = false;
            boolean bl2 = false;
            int n5 = n2 - insets.top - insets.bottom;
            if (((Dimension)serializable).height > n5) {
                bl2 = true;
                n5 -= this.bottomArrowHeight;
            }
            int n6 = rectangle.y;
            int n7 = rectangle.height;
            if (point != null && (n3 = Math.max(0, n6 - (n4 = point.y - insets.top))) > 0) {
                bl = true;
                n3 += this.topArrowHeight;
                n5 -= this.topArrowHeight;
                if (bl2) {
                    bl2 = false;
                    n5 += this.bottomArrowHeight;
                }
                if (((Dimension)serializable).height - n3 > n5) {
                    bl2 = true;
                    n5 -= this.bottomArrowHeight;
                }
            }
            if ((n4 = n6 - n3) + n7 > n5) {
                if (!bl) {
                    bl = true;
                    n3 += this.topArrowHeight;
                    n5 -= this.topArrowHeight;
                    if (bl2) {
                        bl2 = false;
                        n5 += this.bottomArrowHeight;
                    }
                    if (((Dimension)serializable).height - n3 > n5) {
                        bl2 = true;
                        n5 -= this.bottomArrowHeight;
                    }
                }
                int n8 = n4 + n7 - n5;
                if (bl2 && ((Dimension)serializable).height - (n3 += n8) <= n5 + this.bottomArrowHeight) {
                    n3 -= this.bottomArrowHeight;
                }
            }
        }
        this.viewport.setBorder(null);
        this.viewport.setOpaque(false);
        this.viewport.setViewPosition(new Point(0, n3));
        this.configure(true);
        this.fScrollListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AquaScrollingPopupMenuWrapper.this.topArrowPane.isActive) {
                    AquaScrollingPopupMenuWrapper.this.topArrowPane.actionPerformed(actionEvent);
                } else if (AquaScrollingPopupMenuWrapper.this.bottomArrowPane.isActive) {
                    AquaScrollingPopupMenuWrapper.this.bottomArrowPane.actionPerformed(actionEvent);
                } else {
                    AquaScrollingPopupMenuWrapper.this.stopTimer();
                }
            }
        };
        this.fScrollTimer = new Timer(20, this.fScrollListener);
        this.fScrollTimer.setInitialDelay(20);
    }

    protected final boolean scrollIfPossible(MouseEvent mouseEvent, int n) {
        int n2 = Math.max(0, this.scrollableView.getHeight() - this.viewport.getExtentSize().height);
        Point point = this.viewport.getViewPosition();
        int n3 = point.y + n;
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 > n2) {
            n3 = n2;
        }
        int n4 = n3 - point.y;
        if (n4 != 0) {
            this.scroll(mouseEvent, n4);
            return true;
        }
        return false;
    }

    protected void scroll(MouseEvent mouseEvent, int n) {
        Point point = this.viewport.getViewPosition();
        this.viewport.setViewPosition(new Point(point.x, point.y + n));
        this.configure(false);
        this.repaint();
    }

    protected void mouseWheelScroll(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation() < 0 ? -1 : 1;
        double d = AquaScrollPaneUI.getUnitsToScroll(mouseWheelEvent, true);
        int n2 = (int)(d * (double)this.unitScroll * (double)n);
        this.scrollIfPossible(mouseWheelEvent, n2);
    }

    protected void startTimer() {
        if (this.originalContent instanceof AquaExtendedPopup) {
            AquaExtendedPopup aquaExtendedPopup = (AquaExtendedPopup)((Object)this.originalContent);
            aquaExtendedPopup.startArrowScroll();
        }
        this.fScrollTimer.setInitialDelay(20);
        this.fScrollTimer.start();
    }

    protected void stopTimer() {
        this.fScrollTimer.stop();
        if (this.originalContent instanceof AquaExtendedPopup) {
            AquaExtendedPopup aquaExtendedPopup = (AquaExtendedPopup)((Object)this.originalContent);
            aquaExtendedPopup.stopArrowScroll();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        this.configure(false);
        Border border = this.getBorder();
        if (border instanceof BackgroundPainter) {
            BackgroundPainter backgroundPainter = (BackgroundPainter)((Object)border);
            Rectangle rectangle = this.getBounds();
            backgroundPainter.paintBackground(this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        super.paintComponent(graphics);
    }

    protected void configure(boolean bl) {
        int n;
        int n2 = this.viewport.getViewPosition().y;
        boolean bl2 = n2 > 0;
        Insets insets = this.getInsets();
        int n3 = this.height - insets.top - insets.bottom;
        if (bl2) {
            n3 -= this.topArrowHeight;
        }
        boolean bl3 = n2 < (n = this.scrollableView.getHeight() - n3);
        this.configure(bl2, bl3, bl);
    }

    protected void configure(boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (bl != this.isTopArrowInstalled) {
            this.isTopArrowInstalled = bl;
            bl4 = true;
        }
        if (bl2 != this.isBottomArrowInstalled) {
            this.isBottomArrowInstalled = bl2;
            bl4 = true;
        }
        if (bl4 || bl3) {
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    protected ArrowPane createArrowPane(boolean bl) {
        return new ArrowPane(bl);
    }

    protected Icon getArrowIcon(boolean bl) {
        return bl ? AquaImageFactory.getMenuUpArrowIcon() : AquaImageFactory.getMenuDownArrowIcon();
    }

    protected class MyLayoutManager
    implements LayoutManager {
        protected MyLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return null;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return null;
        }

        @Override
        public void layoutContainer(Container container) {
            Point point = AquaScrollingPopupMenuWrapper.this.viewport.getViewPosition();
            Insets insets = container.getInsets();
            int n = insets.left;
            int n2 = insets.right;
            int n3 = insets.top;
            int n4 = insets.bottom;
            int n5 = AquaScrollingPopupMenuWrapper.this.width - n - n2;
            int n6 = AquaScrollingPopupMenuWrapper.this.height - n3 - n4;
            int n7 = AquaScrollingPopupMenuWrapper.this.isTopArrowInstalled ? AquaScrollingPopupMenuWrapper.this.topArrowHeight : 0;
            int n8 = AquaScrollingPopupMenuWrapper.this.isBottomArrowInstalled ? AquaScrollingPopupMenuWrapper.this.bottomArrowHeight : 0;
            AquaScrollingPopupMenuWrapper.this.topArrowPane.setBounds(n, n3, n5, n7);
            AquaScrollingPopupMenuWrapper.this.viewport.setBounds(n, n3 + n7, n5, n6 - n7 - n8);
            AquaScrollingPopupMenuWrapper.this.bottomArrowPane.setBounds(n, n3 + n6 - n8, n5, n8);
            AquaScrollingPopupMenuWrapper.this.viewport.setViewPosition(point);
        }
    }

    protected class ArrowPane
    extends JPanel
    implements ActionListener,
    MouseListener {
        private final boolean isTop;
        private final Icon icon;
        private boolean isActive;

        public ArrowPane(boolean bl) {
            super(new BorderLayout());
            this.setOpaque(false);
            this.isTop = bl;
            this.icon = AquaScrollingPopupMenuWrapper.this.getArrowIcon(bl);
            this.add((Component)new JLabel(this.icon), "Center");
            this.setBorder(bl ? new EmptyBorder(2, 0, 6, 0) : new EmptyBorder(6, 0, 2, 0));
            this.addMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.isActive = true;
            AquaScrollingPopupMenuWrapper.this.startTimer();
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.isActive = false;
            AquaScrollingPopupMenuWrapper.this.stopTimer();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.isActive) {
                AquaScrollingPopupMenuWrapper.this.stopTimer();
            } else {
                int n;
                int n2 = n = this.isTop ? -AquaScrollingPopupMenuWrapper.this.unitScroll : AquaScrollingPopupMenuWrapper.this.unitScroll;
                if (!AquaScrollingPopupMenuWrapper.this.scrollIfPossible(null, n)) {
                    this.isActive = false;
                    AquaScrollingPopupMenuWrapper.this.stopTimer();
                }
            }
        }
    }
}

