/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaButtonExtendedTypes;
import org.violetlib.aqua.AquaCellEditorPolicy;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComboBoxButton;
import org.violetlib.aqua.AquaComboBoxPopup;
import org.violetlib.aqua.AquaComboBoxRenderer;
import org.violetlib.aqua.AquaComboBoxType;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaContextualPopup;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaIcon;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaTextFieldUI;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicAquaAppearance;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.ClientPropertyApplicator;
import org.violetlib.aqua.FocusRingOutlineProvider;
import org.violetlib.aqua.ImageIconUIResource;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.SystemPropertyChangeManager;
import org.violetlib.aqua.ToolbarSensitiveUI;
import org.violetlib.geom.ExpandableOutline;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AbstractComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.LayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxUI
extends BasicComboBoxUI
implements AquaUtilControlSize.Sizeable,
FocusRingOutlineProvider,
ToolbarSensitiveUI,
AquaComponentUI,
SystemPropertyChangeManager.SystemPropertyChangeListener {
    public static final String POPDOWN_CLIENT_PROPERTY_KEY = "JComboBox.isPopDown";
    public static final String ISSQUARE_CLIENT_PROPERTY_KEY = "JComboBox.isSquare";
    public static final String STYLE_CLIENT_PROPERTY_KEY = "JComboBox.style";
    public static final String TITLE_CLIENT_PROPERTY_KEY = "JComboBox.title";
    private static final AquaUIPainter painter = AquaPainting.create();
    private int oldMaximumRowCount;
    protected Dimension cachedPreferredSize = new Dimension(0, 0);
    protected AquaComboBoxButton arrowButton;
    protected HierarchyListener hierarchyListener;
    @NotNull
    protected BasicContextualColors colors;
    @Nullable
    protected AppearanceContext appearanceContext;
    @NotNull
    protected JList<Object> buttonList;
    private final PropertyChangeListener propertyChangeListener = new AquaPropertyChangeListener();
    private final DocumentListener documentListener = new MyDocumentListener();
    private final HierarchyListener popupListener = new MyPopupListener();
    @Nullable
    private AquaComboBoxRenderer buttonRenderer;
    @Nullable
    private AquaComboBoxRenderer listRenderer;
    protected AquaUIPainter.Size sizeVariant;
    protected boolean isPopDown;
    protected String style;
    @Nullable
    protected AquaCellEditorPolicy.CellStatus cellStatus;
    protected boolean isDefaultStyle;
    protected boolean isTextured;
    protected boolean isToolbar;
    protected AbstractComboBoxLayoutConfiguration layoutConfiguration;
    @NotNull
    private final Action highlightNextAction = new ComboBoxAction(){

        @Override
        public void performComboBoxAction(@NotNull AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n < AquaComboBoxUI.this.comboBox.getModel().getSize() - 1) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n + 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n + 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    @NotNull
    private final Action highlightPreviousAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(@NotNull AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n > 0) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n - 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n - 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    @NotNull
    private final Action highlightFirstAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(@NotNull AquaComboBoxUI aquaComboBoxUI) {
            AquaComboBoxUI.this.listBox.setSelectedIndex(0);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(0);
        }
    };
    @NotNull
    private final Action highlightLastAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(@NotNull AquaComboBoxUI aquaComboBoxUI) {
            int n = AquaComboBoxUI.this.listBox.getModel().getSize();
            AquaComboBoxUI.this.listBox.setSelectedIndex(n - 1);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n - 1);
        }
    };
    @NotNull
    private final Action highlightPageUpAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(@NotNull AquaComboBoxUI aquaComboBoxUI) {
            int n;
            int n2 = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n2 != (n = AquaComboBoxUI.this.listBox.getFirstVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n);
                return;
            }
            int n3 = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int n4 = n - n3;
            if (n4 < 0) {
                n4 = 0;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n4);
            AquaComboBoxUI.this.listBox.setSelectedIndex(n4);
        }
    };
    @NotNull
    private final Action highlightPageDownAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(@NotNull AquaComboBoxUI aquaComboBoxUI) {
            int n;
            int n2 = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (n2 != (n = AquaComboBoxUI.this.listBox.getLastVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(n);
                return;
            }
            int n3 = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int n4 = n + n3;
            int n5 = AquaComboBoxUI.this.listBox.getModel().getSize() - 1;
            if (n4 > n5) {
                n4 = n5;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(n4);
            AquaComboBoxUI.this.listBox.setSelectedIndex(n4);
        }
    };
    @NotNull
    private final Action triggerSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AquaComboBoxUI.triggerSelectionEvent(AquaComboBoxUI.this.comboBox, AquaComboBoxUI.this.cellStatus, actionEvent);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    @NotNull
    private static final Action toggleSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            if (!jComboBox.isEnabled()) {
                return;
            }
            if (jComboBox.isEditable()) {
                return;
            }
            AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)jComboBox.getUI();
            if (jComboBox.isPopupVisible()) {
                ComboPopup comboPopup = aquaComboBoxUI.getPopup();
                assert (comboPopup != null);
                jComboBox.setSelectedIndex(comboPopup.getList().getSelectedIndex());
                jComboBox.setPopupVisible(false);
                return;
            }
            jComboBox.setPopupVisible(true);
        }
    };
    @NotNull
    private final Action hideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            jComboBox.firePopupMenuCanceled();
            jComboBox.setPopupVisible(false);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    static final AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>> APPLICATOR = new AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>>(){

        @Override
        protected ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getInstance() {
            return new ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<AquaComboBoxUI>("editable"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("background"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    Color color = (Color)object;
                    if (aquaComboBoxUI.arrowButton != null) {
                        aquaComboBoxUI.arrowButton.setBackground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("foreground"){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    Color color = (Color)object;
                    if (aquaComboBoxUI.arrowButton != null) {
                        aquaComboBoxUI.arrowButton.setForeground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.POPDOWN_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.ISSQUARE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.STYLE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    aquaComboBoxUI.configure(null);
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.TITLE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI aquaComboBoxUI, Object object) {
                    AquaComboBoxType aquaComboBoxType;
                    if (aquaComboBoxUI.comboBox != null && (aquaComboBoxType = AquaComboBoxUI.getComboBoxType(aquaComboBoxUI.comboBox)) == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
                        aquaComboBoxUI.comboBox.setPrototypeDisplayValue(object);
                        aquaComboBoxUI.comboBox.repaint();
                    }
                }
            }}){

                @Override
                public AquaComboBoxUI convertJComponentToTarget(JComboBox<?> jComboBox) {
                    ComboBoxUI comboBoxUI = jComboBox.getUI();
                    if (comboBoxUI instanceof AquaComboBoxUI) {
                        return (AquaComboBoxUI)comboBoxUI;
                    }
                    return null;
                }
            };
        }
    };

    @NotNull
    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaComboBoxUI();
    }

    public AquaComboBoxUI() {
        this.colors = AquaColors.CLEAR_CONTROL_COLORS;
        this.buttonList = new JList();
    }

    @Override
    public void installUI(@NotNull JComponent jComponent) {
        super.installUI(jComponent);
        this.sizeVariant = AquaUtilControlSize.getUserSizeFrom(this.comboBox);
        if (this.buttonRenderer == null) {
            this.buttonRenderer = new AquaComboBoxRenderer(this.comboBox, false, this.sizeVariant);
        }
        if (this.listRenderer == null) {
            this.listRenderer = new AquaComboBoxRenderer(this.comboBox, true, this.sizeVariant);
        }
        this.buttonList.setCellRenderer(this.buttonRenderer);
        LookAndFeel.installProperty(jComponent, "opaque", false);
        this.oldMaximumRowCount = this.comboBox.getMaximumRowCount();
        int n = UIManager.getInt("ComboBox.maximumRowCount");
        if (n > 0) {
            this.comboBox.setMaximumRowCount(n);
        }
        this.comboBox.setRequestFocusEnabled(false);
        this.isToolbar = AquaUtils.isOnToolbar(this.comboBox);
        this.updateFromRenderer();
        this.configure(this.sizeVariant);
        this.configureFocusable(this.comboBox);
    }

    @Override
    public void uninstallUI(@NotNull JComponent jComponent) {
        this.comboBox.setMaximumRowCount(this.oldMaximumRowCount);
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AquaUtilControlSize.addSizePropertyListener(this.comboBox);
        OSXSystemProperties.register(this.comboBox);
        this.hierarchyListener = new MyHierarchyListener();
        this.comboBox.addHierarchyListener(this.hierarchyListener);
        this.comboBox.addPropertyChangeListener(this.propertyChangeListener);
        ComboPopup comboPopup = this.getPopup();
        if (comboPopup instanceof AquaComboBoxPopup) {
            ((AquaComboBoxPopup)comboPopup).addHierarchyListener(this.popupListener);
        }
        AppearanceManager.installListeners(this.comboBox);
        AquaUtils.installToolbarSensitivity(this.comboBox);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtils.uninstallToolbarSensitivity(this.comboBox);
        AppearanceManager.uninstallListeners(this.comboBox);
        ComboPopup comboPopup = this.getPopup();
        if (comboPopup instanceof AquaComboBoxPopup) {
            ((AquaComboBoxPopup)comboPopup).removeHierarchyListener(this.popupListener);
        }
        this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        this.hierarchyListener = null;
        AquaUtilControlSize.removeSizePropertyListener(this.comboBox);
        OSXSystemProperties.unregister(this.comboBox);
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        AquaComboBoxUI.getApplicator().attachAndApplyClientProperties(this.comboBox);
    }

    @Override
    protected void uninstallComponents() {
        AquaComboBoxUI.getApplicator().removeFrom(this.comboBox);
        super.uninstallComponents();
    }

    @Override
    public void systemPropertyChanged(JComponent jComponent, Object object) {
        if (object.equals(OSXSystemProperties.USER_PREFERENCE_CHANGE_TYPE)) {
            this.configureFocusable((JComboBox)jComponent);
        }
    }

    private void configureFocusable(JComboBox jComboBox) {
        boolean bl = OSXSystemProperties.isFullKeyboardAccessEnabled();
        if (!jComboBox.isEditable()) {
            jComboBox.setFocusable(bl);
        }
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.comboBox);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        if (this.cellStatus == null) {
            AquaColors.installColors(this.comboBox, this.appearanceContext, this.colors);
        }
        this.comboBox.repaint();
    }

    protected void updateFromRenderer() {
        ListCellRenderer<Object> listCellRenderer = this.getCustomRenderer();
        if (this.buttonRenderer != null) {
            this.buttonRenderer.setCustomRenderer(listCellRenderer);
        }
        if (this.listRenderer != null) {
            this.listRenderer.setCustomRenderer(listCellRenderer);
        }
    }

    @Nullable
    protected ListCellRenderer<?> getCustomRenderer() {
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer == null || listCellRenderer instanceof UIResource) {
            return null;
        }
        return listCellRenderer;
    }

    @NotNull
    protected AquaUIPainter.State getState() {
        Object object;
        boolean bl = AquaFocusHandler.isActive(this.comboBox);
        if (!this.comboBox.isEnabled()) {
            return bl ? AquaUIPainter.State.DISABLED : AquaUIPainter.State.DISABLED_INACTIVE;
        }
        if (bl && this.arrowButton != null) {
            if (AquaComboBoxUI.isPopupReallyVisible(this.popup)) {
                return AquaUIPainter.State.PRESSED;
            }
            object = this.arrowButton.getModel();
            if (object.isArmed() && object.isPressed()) {
                return AquaUIPainter.State.PRESSED;
            }
            if (this.arrowButton.isRollover) {
                return AquaUIPainter.State.ROLLOVER;
            }
        }
        if (!bl && ((object = this.getWidget()) == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN || object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP || object == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX || this.isTextured)) {
            return AquaUIPainter.State.INACTIVE;
        }
        return AquaUIPainter.State.ACTIVE;
    }

    private static boolean isPopupReallyVisible(@NotNull ComboPopup comboPopup) {
        if (!comboPopup.isVisible()) {
            return false;
        }
        if (comboPopup instanceof Component) {
            Component component = (Component)((Object)comboPopup);
            return component.isShowing();
        }
        return true;
    }

    @Override
    public void addEditor() {
        super.addEditor();
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void removeEditor() {
        super.removeEditor();
        this.isMinimumSizeDirty = true;
    }

    @Override
    public void update(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public void paint(@NotNull Graphics graphics, @NotNull JComponent jComponent) {
        int n = this.comboBox.getWidth();
        int n2 = this.comboBox.getHeight();
        if (n2 <= 0 || n <= 0) {
            return;
        }
        Configuration configuration = this.getConfiguration();
        AquaUtils.configure(painter, this.comboBox, n, n2);
        if (configuration != null) {
            painter.getPainter(configuration).paint(graphics, 0.0f, 0.0f);
        }
        if (!this.comboBox.isEditable()) {
            this.paintButtonValue(graphics);
        }
    }

    @Nullable
    public Configuration getConfiguration() {
        AquaUIPainter.State state = this.getState();
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            return new PopupButtonConfiguration(popupButtonLayoutConfiguration, state);
        }
        if (abstractComboBoxLayoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration comboBoxLayoutConfiguration = (ComboBoxLayoutConfiguration)abstractComboBoxLayoutConfiguration;
            boolean bl = false;
            return new ComboBoxConfiguration(comboBoxLayoutConfiguration, state, bl);
        }
        return null;
    }

    private boolean determineIsDefaultStyle() {
        Object object = this.getWidget();
        return object == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX || object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN || object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP;
    }

    private boolean determineIsTextured() {
        Object object = this.getWidget();
        return object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED || object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED || object == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR || object == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR || object == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
    }

    @Nullable
    private AquaCellEditorPolicy.CellStatus determineCellStatus() {
        return AquaCellEditorPolicy.getInstance().getCellStatus(this.comboBox);
    }

    @NotNull
    public Icon getIcon(@NotNull Icon icon) {
        Color color;
        Object object;
        AquaUIPainter.State state = this.getState();
        if (icon instanceof ImageIcon && AquaImageFactory.isTemplateImage(((ImageIcon)(object = (ImageIcon)icon)).getImage()) && (color = this.comboBox.getForeground()) != null) {
            Image image = ((ImageIcon)object).getImage();
            image = AquaImageFactory.getProcessedImage(image, (Object)color);
            return new ImageIconUIResource(image);
        }
        if (state == AquaUIPainter.State.PRESSED) {
            return AquaIcon.createPressedDarkIcon(icon);
        }
        if (this.shouldUseDisabledIcon()) {
            object = AppearanceManager.getAppearance(this.comboBox);
            return ((BasicAquaAppearance)object).isDark() ? AquaIcon.createPressedDarkIcon(icon) : AquaIcon.createDisabledLightIcon(icon);
        }
        return icon;
    }

    protected boolean shouldUseDisabledIcon() {
        AquaUIPainter.State state = this.getState();
        if (state == AquaUIPainter.State.DISABLED || state == AquaUIPainter.State.DISABLED_INACTIVE) {
            return true;
        }
        if (state == AquaUIPainter.State.INACTIVE && this.isTextured) {
            return OSXSystemProperties.OSVersion < 1015;
        }
        return false;
    }

    @Override
    @Nullable
    public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration != null) {
            AquaUtils.configure(painter, this.comboBox, jComponent.getWidth(), jComponent.getHeight());
            return painter.getOutline(abstractComboBoxLayoutConfiguration);
        }
        return null;
    }

    private void paintButtonValue(@NotNull Graphics graphics) {
        Serializable serializable;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        Object object = null;
        AquaComboBoxType aquaComboBoxType = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (aquaComboBoxType == AquaComboBoxType.PULL_DOWN_MENU_BUTTON) {
            Object object2 = this.comboBox.getClientProperty(TITLE_CLIENT_PROPERTY_KEY);
            if (object2 != null) {
                if (object2 instanceof Icon) {
                    object2 = this.getIcon((Icon)object2);
                }
                object = object2;
            }
        } else {
            object = this.comboBox.getSelectedItem();
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.comboBox.getWidth();
        int n4 = this.comboBox.getHeight();
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        if (abstractComboBoxLayoutConfiguration != null && (serializable = this.getContentBounds(abstractComboBoxLayoutConfiguration)) != null) {
            n2 = ((Rectangle)serializable).x;
            n = ((Rectangle)serializable).y;
            n3 = ((Rectangle)serializable).width;
            n4 = ((Rectangle)serializable).height;
        }
        if (this.padding != null) {
            n2 += this.padding.left;
            n += this.padding.top;
            n3 -= this.padding.left;
            n4 -= this.padding.top;
        }
        this.buttonList.setBackground(AquaColors.CLEAR);
        this.buttonList.setForeground(this.comboBox.getForeground());
        serializable = listCellRenderer.getListCellRendererComponent(this.buttonList, object, -1, false, false);
        ((Component)serializable).setFont(this.currentValuePane.getFont());
        this.updateRendererStyle((Component)serializable);
        boolean bl = false;
        if (serializable instanceof JPanel) {
            bl = true;
        }
        this.currentValuePane.paintComponent(graphics, (Component)serializable, this.comboBox, n2, n, n3, n4, bl);
    }

    @Nullable
    protected Rectangle getContentBounds(@NotNull LayoutConfiguration layoutConfiguration) {
        AquaUtils.configure(painter, this.comboBox, this.comboBox.getWidth(), this.comboBox.getHeight());
        if (layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            return AquaUtils.toMinimumRectangle(painter.getComboBoxEditorBounds((ComboBoxLayoutConfiguration)layoutConfiguration));
        }
        if (layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            return AquaUtils.toMinimumRectangle(painter.getPopupButtonContentBounds((PopupButtonLayoutConfiguration)layoutConfiguration));
        }
        return null;
    }

    @Nullable
    protected Insetter getContentInsets(@NotNull LayoutConfiguration layoutConfiguration) {
        if (layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            return painter.getLayoutInfo().getComboBoxEditorInsets((ComboBoxLayoutConfiguration)layoutConfiguration);
        }
        if (layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            return painter.getLayoutInfo().getPopupButtonContentInsets((PopupButtonLayoutConfiguration)layoutConfiguration);
        }
        return null;
    }

    @Override
    @NotNull
    protected ListCellRenderer<Object> createRenderer() {
        if (this.buttonRenderer == null) {
            this.buttonRenderer = new AquaComboBoxRenderer(this.comboBox, false, AquaUtilControlSize.getUserSizeFrom(this.comboBox));
        }
        return this.buttonRenderer;
    }

    @Override
    @NotNull
    protected ComboPopup createPopup() {
        return new AquaComboBoxPopup(this.comboBox);
    }

    @Override
    @NotNull
    protected JButton createArrowButton() {
        this.arrowButton = new AquaComboBoxButton(this, this.comboBox);
        return this.arrowButton;
    }

    @Override
    @NotNull
    protected ComboBoxEditor createEditor() {
        return new AquaComboBoxEditor();
    }

    @NotNull
    public ListCellRenderer<Object> getListCellRenderer() {
        if (this.listRenderer == null) {
            this.listRenderer = new AquaComboBoxRenderer(this.comboBox, true, AquaUtilControlSize.getUserSizeFrom(this.comboBox));
        }
        return this.listRenderer;
    }

    protected void popupVisibilityChanged() {
        if (!AquaComboBoxUI.isPopupReallyVisible(this.popup) && this.arrowButton != null) {
            this.arrowButton.isRollover = false;
        }
        this.configureAppearanceContext(null);
    }

    @Override
    protected void configureEditor() {
        JTextComponent jTextComponent;
        super.configureEditor();
        this.comboBox.setFocusable(true);
        if (this.editor instanceof JTextField) {
            jTextComponent = (JTextField)this.editor;
            if (!(this.editor instanceof AquaCustomComboTextField)) {
                jTextComponent.setUI(new AquaComboBoxEditorUI());
                jTextComponent.setBorder(null);
            }
        }
        if (this.editor instanceof JTextComponent) {
            jTextComponent = (JTextComponent)this.editor;
            jTextComponent.getDocument().addDocumentListener(this.documentListener);
        }
    }

    @Override
    protected void unconfigureEditor() {
        super.unconfigureEditor();
        if (!this.comboBox.isEditable()) {
            this.comboBox.setFocusable(OSXSystemProperties.isFullKeyboardAccessEnabled());
        }
        if (this.editor instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)this.editor;
            jTextComponent.getDocument().removeDocumentListener(this.documentListener);
        }
    }

    public boolean updateListSelectionFromEditor() {
        if (this.editor instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)this.editor;
            this.updateListSelectionFromEditor(jTextComponent);
            return true;
        }
        return false;
    }

    protected void updateListSelectionFromEditor(@NotNull JTextComponent jTextComponent) {
        String string = jTextComponent.getText();
        ListModel listModel = this.listBox.getModel();
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            String string2;
            Object e = listModel.getElementAt(i);
            if (e == null || (string2 = e.toString()) == null || !string2.equals(string)) continue;
            JList<Object> jList = this.popup.getList();
            jList.setSelectedIndex(i);
            jList.ensureIndexIsVisible(i);
            return;
        }
        this.popup.getList().clearSelection();
    }

    protected void updateRendererStyle(@NotNull Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            BasicContextualColors basicContextualColors = this.getRendererStyleColors();
            jComponent.putClientProperty("Aqua.componentColors", basicContextualColors);
        }
    }

    protected void updateEditorStyle(@NotNull Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            BasicContextualColors basicContextualColors = this.getEditorStyleColors();
            jComponent.putClientProperty("Aqua.componentColors", basicContextualColors);
        }
    }

    @NotNull
    protected BasicContextualColors getRendererStyleColors() {
        if (this.isToolbar) {
            return AquaColors.TEXTURED_TOOLBAR_COLORS;
        }
        if (this.isTextured) {
            return AquaColors.TEXTURED_COLORS;
        }
        return AquaColors.CLEAR_CONTROL_COLORS;
    }

    @NotNull
    protected BasicContextualColors getEditorStyleColors() {
        if (this.isToolbar) {
            return AquaColors.TEXTURED_TOOLBAR_COLORS;
        }
        if (this.isTextured) {
            return AquaColors.TEXTURED_COLORS;
        }
        if (this.cellStatus == AquaCellEditorPolicy.CellStatus.CELL_EDITOR) {
            return AquaColors.CELL_TEXT_COLORS;
        }
        return AquaColors.CLEAR_CONTROL_COLORS;
    }

    protected void editorTextChanged() {
        if (this.popup.isVisible() && !this.isTextured) {
            this.updateListSelectionFromEditor((JTextComponent)this.editor);
        }
    }

    @Override
    @NotNull
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (AquaComboBoxUI.this.editor != null && focusEvent.getSource() == AquaComboBoxUI.this.editor && AquaComboBoxUI.this.arrowButton != null) {
                    AquaComboBoxUI.this.arrowButton.repaint();
                }
                super.focusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (AquaComboBoxUI.this.editor != null && focusEvent.getSource() == AquaComboBoxUI.this.editor && AquaComboBoxUI.this.arrowButton != null) {
                    AquaComboBoxUI.this.arrowButton.repaint();
                }
                super.focusLost(focusEvent);
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("aquaSelectNext", this.highlightNextAction);
        actionMapUIResource.put("aquaSelectPrevious", this.highlightPreviousAction);
        actionMapUIResource.put("enterPressed", this.triggerSelectionAction);
        actionMapUIResource.put("aquaSpacePressed", toggleSelectionAction);
        actionMapUIResource.put("aquaSelectHome", this.highlightFirstAction);
        actionMapUIResource.put("aquaSelectEnd", this.highlightLastAction);
        actionMapUIResource.put("aquaSelectPageUp", this.highlightPageUpAction);
        actionMapUIResource.put("aquaSelectPageDown", this.highlightPageDownAction);
        actionMapUIResource.put("aquaHidePopup", this.hideAction);
        SwingUtilities.replaceUIActionMap(this.comboBox, actionMapUIResource);
    }

    @Nullable
    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    @NotNull
    protected LayoutManager createLayoutManager() {
        return new AquaComboBoxLayoutManager();
    }

    @NotNull
    public static AquaComboBoxType getComboBoxType(JComboBox<?> jComboBox) {
        if (jComboBox.isEditable()) {
            return AquaComboBoxType.EDITABLE_COMBO_BOX;
        }
        if (Boolean.TRUE.equals(jComboBox.getClientProperty(POPDOWN_CLIENT_PROPERTY_KEY))) {
            return AquaComboBoxType.PULL_DOWN_MENU_BUTTON;
        }
        return AquaComboBoxType.POP_UP_MENU_BUTTON;
    }

    protected static void triggerSelectionEvent(@NotNull JComboBox<?> jComboBox, @Nullable AquaCellEditorPolicy.CellStatus cellStatus, ActionEvent actionEvent) {
        if (!jComboBox.isEnabled()) {
            return;
        }
        AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)jComboBox.getUI();
        ComboPopup comboPopup = aquaComboBoxUI.getPopup();
        assert (comboPopup != null);
        if (comboPopup.getList().getSelectedIndex() < 0) {
            jComboBox.setPopupVisible(false);
        }
        if (cellStatus == null) {
            jComboBox.setSelectedItem(jComboBox.getSelectedItem());
            return;
        }
        if (jComboBox.isPopupVisible()) {
            jComboBox.setSelectedIndex(aquaComboBoxUI.getPopup().getList().getSelectedIndex());
            jComboBox.setPopupVisible(false);
            return;
        }
        JRootPane jRootPane = SwingUtilities.getRootPane(jComboBox);
        if (jRootPane == null) {
            return;
        }
        InputMap inputMap = jRootPane.getInputMap(2);
        ActionMap actionMap = jRootPane.getActionMap();
        if (inputMap == null || actionMap == null) {
            return;
        }
        Object object = inputMap.get(KeyStroke.getKeyStroke(10, 0));
        if (object == null) {
            return;
        }
        Action action = actionMap.get(object);
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent(jRootPane, actionEvent.getID(), actionEvent.getActionCommand(), actionEvent.getWhen(), actionEvent.getModifiers()));
    }

    @Override
    public void applySizeFor(@NotNull JComponent jComponent, @NotNull AquaUIPainter.Size size, boolean bl) {
        this.sizeVariant = size;
        if (bl) {
            size = this.determineDefaultSize(size);
        }
        this.configure(size);
    }

    @NotNull
    public AquaUIPainter.Size getSizeVariant() {
        if (this.sizeVariant == null) {
            return AquaUIPainter.Size.REGULAR;
        }
        return this.sizeVariant;
    }

    @NotNull
    protected AquaUIPainter.Size determineDefaultSize(@NotNull AquaUIPainter.Size size) {
        if (size == AquaUIPainter.Size.REGULAR && this.cellStatus != null && this.comboBox.getHeight() < 16) {
            return AquaUIPainter.Size.SMALL;
        }
        return size;
    }

    @Override
    @NotNull
    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.isMinimumSizeDirty) {
            this.calculateLayoutSizes();
        }
        return new Dimension(this.cachedMinimumSize);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.isMinimumSizeDirty) {
            this.calculateLayoutSizes();
        }
        return new Dimension(this.cachedPreferredSize);
    }

    protected void calculateLayoutSizes() {
        Cloneable cloneable;
        int n;
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        assert (abstractComboBoxLayoutConfiguration != null);
        LayoutInfo layoutInfo = painter.getLayoutInfo().getLayoutInfo(abstractComboBoxLayoutConfiguration);
        int n2 = n = (int)layoutInfo.getFixedVisualHeight();
        int n3 = n;
        Dimension dimension = null;
        if (this.arrowButton != null) {
            Insetter insetter;
            if (abstractComboBoxLayoutConfiguration.isCell()) {
                n3 += 6;
            }
            if ((insetter = this.getContentInsets(abstractComboBoxLayoutConfiguration)) != null) {
                cloneable = this.getDisplaySize();
                dimension = insetter.expand((Dimension)cloneable);
            }
        }
        if (dimension == null) {
            boolean bl = this.comboBox.isEditable();
            if (bl && this.arrowButton != null && this.editor != null) {
                dimension = super.getMinimumSize(this.comboBox);
                cloneable = this.arrowButton.getMargin();
                dimension.height += ((Insets)cloneable).top + ((Insets)cloneable).bottom;
            } else {
                dimension = super.getMinimumSize(this.comboBox);
            }
        }
        if (n == 0) {
            if (dimension.height > n2) {
                n2 = dimension.height;
            }
            if (dimension.height > n3) {
                n3 = dimension.height;
            }
        }
        this.cachedMinimumSize.setSize(dimension.width, n2);
        this.cachedPreferredSize.setSize(dimension.width, n3);
        this.isMinimumSizeDirty = false;
    }

    @Override
    @NotNull
    protected Dimension getDefaultSize() {
        DefaultListCellRenderer defaultListCellRenderer = this.comboBox.getRenderer();
        if (defaultListCellRenderer == null) {
            defaultListCellRenderer = new DefaultListCellRenderer();
        }
        try {
            Dimension dimension = this.getSizeForComponent(defaultListCellRenderer.getListCellRendererComponent(this.listBox, " ", -1, false, false));
            return new Dimension(dimension.width, dimension.height);
        }
        catch (RuntimeException runtimeException) {
            return new Dimension(20, 20);
        }
    }

    protected void respondToHierarchyChange() {
        if (this.cellStatus == null) {
            this.configure(null);
        }
    }

    protected void configure(@Nullable AquaUIPainter.Size size) {
        Object object;
        if (this.comboBox == null) {
            return;
        }
        if (size == null) {
            size = AquaUtilControlSize.getUserSizeFrom(this.comboBox);
        }
        this.sizeVariant = size;
        if (this.buttonRenderer != null) {
            this.buttonRenderer.setSize(size);
        }
        if (this.listRenderer != null) {
            this.listRenderer.setSize(size);
        }
        Object object2 = this.comboBox.getClientProperty(POPDOWN_CLIENT_PROPERTY_KEY);
        this.isPopDown = Boolean.TRUE.equals(object2);
        object2 = null;
        Object object3 = this.comboBox.getClientProperty(STYLE_CLIENT_PROPERTY_KEY);
        if (object3 instanceof String) {
            object2 = (String)object3;
        } else {
            object3 = this.comboBox.getClientProperty(ISSQUARE_CLIENT_PROPERTY_KEY);
            if (Boolean.TRUE.equals(object3)) {
                object2 = "old_square";
            }
        }
        if ("textured".equals(object2) && this.isToolbar) {
            object2 = "textured-onToolbar";
        }
        this.style = object2;
        boolean bl = this.comboBox.isEditable();
        object3 = AquaUtils.getLayoutDirection(this.comboBox);
        this.cellStatus = this.determineCellStatus();
        if (bl) {
            object = this.determineComboBoxWidget(this.cellStatus);
            this.layoutConfiguration = new ComboBoxLayoutConfiguration((AquaUIPainter.ComboBoxWidget)object, this.sizeVariant, (AquaUIPainter.UILayoutDirection)((Object)object3));
            this.colors = this.getRendererStyleColors();
            this.updateEditorStyle(this.editor);
        } else {
            object = this.determinePopupButtonWidget(this.cellStatus);
            this.layoutConfiguration = new PopupButtonLayoutConfiguration((AquaUIPainter.PopupButtonWidget)object, this.sizeVariant, (AquaUIPainter.UILayoutDirection)((Object)object3));
            AquaButtonExtendedTypes.WidgetInfo widgetInfo = AquaButtonExtendedTypes.getWidgetInfo(object);
            this.colors = widgetInfo.getColors();
        }
        if (AquaUtilControlSize.isOKToInstallDefaultFont(this.comboBox)) {
            object = this.getDefaultFont();
            this.comboBox.setFont((Font)object);
        }
        this.isDefaultStyle = this.determineIsDefaultStyle();
        this.isTextured = this.determineIsTextured();
        this.configureAppearanceContext(null);
        this.comboBox.revalidate();
        this.comboBox.repaint();
        this.isMinimumSizeDirty = true;
    }

    @Nullable
    public AbstractComboBoxLayoutConfiguration getLayoutConfiguration() {
        return this.layoutConfiguration;
    }

    @NotNull
    protected Font getDefaultFont() {
        Font font = this.comboBox.getFont();
        Object object = this.getWidget();
        AbstractComboBoxLayoutConfiguration abstractComboBoxLayoutConfiguration = this.getLayoutConfiguration();
        assert (abstractComboBoxLayoutConfiguration != null);
        AquaUIPainter.Size size = abstractComboBoxLayoutConfiguration.getSize();
        return AquaButtonExtendedTypes.getFont(object, size, font);
    }

    public int getNominalPopupYOffset() {
        AquaComboBoxType aquaComboBoxType = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (aquaComboBoxType == AquaComboBoxType.POP_UP_MENU_BUTTON) {
            int n;
            JList<Object> jList = this.popup.getList();
            if (jList != null && (n = this.comboBox.getSelectedIndex()) >= 0) {
                Rectangle rectangle = jList.getCellBounds(n, n);
                Border border = AquaContextualPopup.getContextualMenuBorder();
                Insets insets = border.getBorderInsets(null);
                return -(rectangle.y + insets.top);
            }
        } else {
            Object object = this.getWidget();
            AquaButtonExtendedTypes.WidgetInfo widgetInfo = AquaButtonExtendedTypes.getWidgetInfo(object);
            int n = widgetInfo.getBottomMenuGap();
            if (OSXSystemProperties.OSVersion >= 1014 && this.isTextured) {
                n -= 2;
            }
            return this.comboBox.getHeight() + n;
        }
        return this.comboBox.getHeight() + 2;
    }

    @NotNull
    protected Object getWidget() {
        if (this.layoutConfiguration instanceof ComboBoxLayoutConfiguration) {
            ComboBoxLayoutConfiguration comboBoxLayoutConfiguration = (ComboBoxLayoutConfiguration)this.layoutConfiguration;
            return comboBoxLayoutConfiguration.getWidget();
        }
        if (this.layoutConfiguration instanceof PopupButtonLayoutConfiguration) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)this.layoutConfiguration;
            return popupButtonLayoutConfiguration.getPopupButtonWidget();
        }
        return AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP;
    }

    @NotNull
    protected AquaUIPainter.ComboBoxWidget determineComboBoxWidget(@Nullable AquaCellEditorPolicy.CellStatus cellStatus) {
        if (cellStatus != null) {
            return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL;
                }
                case "textured": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED;
                }
                case "textured-onToolbar": {
                    return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
                }
            }
        }
        if (this.isToolbar) {
            return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR;
        }
        return AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX;
    }

    @NotNull
    protected AquaUIPainter.PopupButtonWidget determinePopupButtonWidget(@Nullable AquaCellEditorPolicy.CellStatus cellStatus) {
        if (cellStatus != null) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
        }
        if (this.style != null) {
            switch (this.style) {
                case "tableHeader": 
                case "cell": 
                case "borderless": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL;
                }
                case "square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
                case "old_square": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE;
                }
                case "bevel": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL;
                }
                case "roundRect": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT;
                }
                case "recessed": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
                }
                case "textured": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED;
                }
                case "textured-onToolbar": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR;
                }
                case "gradient": {
                    return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT;
                }
            }
        }
        if (this.isToolbar) {
            return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR;
        }
        return this.isPopDown ? AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN : AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP;
    }

    @Override
    public void toolbarStatusChanged(@NotNull JComponent jComponent) {
        boolean bl = AquaUtils.isOnToolbar(this.comboBox);
        if (bl != this.isToolbar) {
            this.isToolbar = bl;
            this.configure(null);
        }
    }

    @Nullable
    public Point getPopupButtonLabelOffset() {
        int n = 0;
        int n2 = 0;
        AquaComboBoxType aquaComboBoxType = AquaComboBoxUI.getComboBoxType(this.comboBox);
        if (aquaComboBoxType == AquaComboBoxType.POP_UP_MENU_BUTTON) {
            n -= 8;
            n2 = 1;
            Object object = this.getWidget();
            if (object != AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP) {
                n -= 2;
                n2 = 2;
            }
        }
        return n != 0 || n2 != 0 ? new Point(n, n2) : null;
    }

    @NotNull
    static ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getApplicator() {
        return APPLICATOR.get();
    }

    class AquaPropertyChangeListener
    implements PropertyChangeListener {
        AquaPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("enabled")) {
                AquaComboBoxUI.this.configureAppearanceContext(null);
            } else if (string.equals("renderer")) {
                AquaComboBoxUI.this.updateFromRenderer();
            }
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(@NotNull DocumentEvent documentEvent) {
            AquaComboBoxUI.this.editorTextChanged();
        }

        @Override
        public void removeUpdate(@NotNull DocumentEvent documentEvent) {
            AquaComboBoxUI.this.editorTextChanged();
        }

        @Override
        public void changedUpdate(@NotNull DocumentEvent documentEvent) {
            AquaComboBoxUI.this.editorTextChanged();
        }
    }

    private class MyPopupListener
    implements HierarchyListener {
        private MyPopupListener() {
        }

        @Override
        public void hierarchyChanged(@NotNull HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 4L) != 0L) {
                AquaComboBoxUI.this.popupVisibilityChanged();
            }
        }
    }

    private class MyHierarchyListener
    implements HierarchyListener {
        private MyHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(AquaComboBoxUI.this.comboBox, AquaComboBoxUI.class);
            if (aquaComboBoxUI != null) {
                aquaComboBoxUI.respondToHierarchyChange();
            }
        }
    }

    final class AquaComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource {
        AquaComboBoxEditor() {
        }

        @Override
        @NotNull
        protected JTextField createEditorComponent() {
            return new AquaCustomComboTextField();
        }
    }

    class AquaCustomComboTextField
    extends JTextField {
        public AquaCustomComboTextField() {
            this.setUI(new AquaComboBoxEditorUI());
            this.setBorder(null);
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("HOME"), AquaComboBoxUI.this.highlightFirstAction);
            inputMap.put(KeyStroke.getKeyStroke("END"), AquaComboBoxUI.this.highlightLastAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), AquaComboBoxUI.this.highlightPageUpAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), AquaComboBoxUI.this.highlightPageDownAction);
            final Action action = this.getActionMap().get("notify-field-accept");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AquaComboBoxUI.this.popup.isVisible()) {
                        AquaComboBoxUI.triggerSelectionEvent(AquaComboBoxUI.this.comboBox, AquaComboBoxUI.this.cellStatus, actionEvent);
                        if (AquaComboBoxUI.this.editor instanceof AquaCustomComboTextField) {
                            ((AquaCustomComboTextField)AquaComboBoxUI.this.editor).selectAll();
                        }
                    } else {
                        action.actionPerformed(actionEvent);
                    }
                }
            });
        }

        @Override
        @Nullable
        public Color getForeground() {
            if (!AquaComboBoxUI.this.hasFocus && AquaComboBoxUI.this.cellStatus != null) {
                return AquaComboBoxUI.this.comboBox.getForeground();
            }
            return super.getForeground();
        }

        @Override
        public void setText(@Nullable String string) {
            if (this.getText().equals(string)) {
                return;
            }
            super.setText(string);
        }
    }

    final class AquaComboBoxEditorUI
    extends AquaTextFieldUI
    implements FocusRingOutlineProvider {
        AquaComboBoxEditorUI() {
        }

        @Override
        public void installUI(@NotNull JComponent jComponent) {
            super.installUI(jComponent);
            assert (this.appearanceContext != null);
            AquaColors.installColors(this.editor, this.appearanceContext, this.colors);
            this.editor.repaint();
        }

        @Override
        protected void installDefaults() {
            super.installDefaults();
            JTextComponent jTextComponent = this.getComponent();
            Border border = jTextComponent.getBorder();
            if (border == null || border instanceof UIDefaults) {
                jTextComponent.setBorder(null);
            }
        }

        @Override
        public void updateStyle() {
            super.updateStyle();
            this.updateEditorStyle();
        }

        protected void updateEditorStyle() {
            AquaComboBoxUI.this.updateEditorStyle(this.editor);
        }

        @Override
        protected void paintBackgroundSafely(@NotNull Graphics graphics, @Nullable Color color) {
            int n = this.editor.getWidth();
            int n2 = this.editor.getHeight();
            if (color != null && color.getAlpha() > 0) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n, n2);
            }
        }

        @Override
        public int getTextMargin() {
            return 3;
        }

        @Override
        @Nullable
        public Shape getFocusRingOutline(@NotNull JComponent jComponent) {
            Container container = jComponent.getParent();
            if (container instanceof JComboBox) {
                Shape shape;
                JComboBox jComboBox = (JComboBox)container;
                AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(jComboBox, AquaComboBoxUI.class);
                if (aquaComboBoxUI != null && (shape = aquaComboBoxUI.getFocusRingOutline(jComboBox)) != null) {
                    Rectangle rectangle = jComponent.getBounds();
                    return ExpandableOutline.createTranslatedShape(shape, -rectangle.x, -rectangle.y);
                }
                int n = jComboBox.getWidth();
                int n2 = jComboBox.getHeight();
                Rectangle rectangle = jComponent.getBounds();
                int n3 = -rectangle.x;
                int n4 = -rectangle.y;
                return new RoundRectangle2D.Double((float)n3 + 0.0f, (float)n4 + 0.0f, (float)n - 0.0f, (float)n2 - 0.0f, 9.0, 9.0);
            }
            return null;
        }
    }

    class AquaComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        AquaComboBoxLayoutManager() {
            super(AquaComboBoxUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = AquaComboBoxUI.this.comboBox.getWidth();
            int n2 = AquaComboBoxUI.this.comboBox.getHeight();
            if (AquaComboBoxUI.this.comboBox.isEditable()) {
                Rectangle rectangle;
                ComboBoxConfiguration comboBoxConfiguration = (ComboBoxConfiguration)AquaComboBoxUI.this.getConfiguration();
                assert (comboBoxConfiguration != null);
                AquaUtils.configure(painter, AquaComboBoxUI.this.comboBox, n, n2);
                if (AquaComboBoxUI.this.editor != null) {
                    rectangle = AquaUtils.toMinimumRectangle(painter.getComboBoxEditorBounds(comboBoxConfiguration));
                    AquaComboBoxUI.this.editor.setBounds(rectangle);
                }
                if (AquaComboBoxUI.this.arrowButton != null) {
                    rectangle = AquaUtils.toMinimumRectangle(painter.getComboBoxIndicatorBounds(comboBoxConfiguration));
                    AquaComboBoxUI.this.arrowButton.setBounds(rectangle);
                }
            } else {
                AquaComboBoxUI.this.arrowButton.setBounds(0, 0, n, n2);
            }
        }
    }

    private abstract class ComboBoxAction
    extends AbstractAction {
        private ComboBoxAction() {
        }

        @Override
        public void actionPerformed(@NotNull ActionEvent actionEvent) {
            if (!AquaComboBoxUI.this.comboBox.isEnabled() || !AquaComboBoxUI.this.comboBox.isShowing()) {
                return;
            }
            if (AquaComboBoxUI.this.comboBox.isPopupVisible()) {
                AquaComboBoxUI aquaComboBoxUI = (AquaComboBoxUI)AquaComboBoxUI.this.comboBox.getUI();
                this.performComboBoxAction(aquaComboBoxUI);
            } else {
                AquaComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }

        abstract void performComboBoxAction(@NotNull AquaComboBoxUI var1);
    }
}

