/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.Insets2D;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.InsetterNotInvertibleException;
import org.violetlib.jnr.impl.FixedInsetter1;
import org.violetlib.jnr.impl.Insetter1;

public class CombinedInsetter
implements Insetter {
    @NotNull
    private static final CombinedInsetter TRIVIAL = new CombinedInsetter(new FixedInsetter1(0.0f, 0.0f), new FixedInsetter1(0.0f, 0.0f));
    @NotNull
    private final Insetter1 horizontal;
    @NotNull
    private final Insetter1 vertical;

    @NotNull
    public static Insetter trivial() {
        return TRIVIAL;
    }

    public CombinedInsetter(@NotNull Insetter1 insetter1, @NotNull Insetter1 insetter12) {
        this.horizontal = insetter1;
        this.vertical = insetter12;
    }

    @Override
    @NotNull
    public Rectangle2D applyToBounds2D(@NotNull Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)rectangle2D.getHeight();
        return this.apply(f, f2, f3, f4);
    }

    @Override
    @NotNull
    public Rectangle2D apply2D(double d, double d2) {
        return this.apply(0.0f, 0.0f, (float)d, (float)d2);
    }

    @NotNull
    protected Rectangle2D apply(float f, float f2, float f3, float f4) {
        float f5 = f + this.horizontal.getRegionOrigin(f3);
        float f6 = f2 + this.vertical.getRegionOrigin(f4);
        float f7 = this.horizontal.getRegionSize(f3);
        float f8 = this.vertical.getRegionSize(f4);
        return new Rectangle2D.Float(f5, f6, f7, f8);
    }

    @Override
    @NotNull
    public Rectangle applyToBounds(@NotNull Rectangle rectangle) {
        return this.apply(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    @Override
    @NotNull
    public Rectangle apply(int n, int n2) {
        return this.apply(0, 0, n, n2);
    }

    @NotNull
    protected Rectangle apply(int n, int n2, int n3, int n4) {
        double d = (float)n + this.horizontal.getRegionOrigin(n3);
        double d2 = this.horizontal.getRegionSize(n3);
        int n5 = (int)Math.ceil(d);
        int n6 = (int)Math.floor(d2 -= (double)n5 - d);
        double d3 = (float)n2 + this.vertical.getRegionOrigin(n4);
        double d4 = this.vertical.getRegionSize(n4);
        int n7 = (int)Math.ceil(d3);
        int n8 = (int)Math.floor(d4 -= (double)n7 - d3);
        return new Rectangle(n5, n7, n6, n8);
    }

    @Override
    public boolean isInvertible() {
        return this.horizontal.isInvertible() && this.vertical.isInvertible();
    }

    @Override
    @NotNull
    public Dimension2D expand2D(@NotNull Dimension2D dimension2D) throws InsetterNotInvertibleException {
        int n = (int)Math.ceil(this.horizontal.getComponentSize((float)dimension2D.getWidth()));
        int n2 = (int)Math.ceil(this.vertical.getComponentSize((float)dimension2D.getHeight()));
        return new Dimension(n, n2);
    }

    @Override
    @NotNull
    public Dimension expand(@NotNull Dimension dimension) throws InsetterNotInvertibleException {
        int n = (int)Math.ceil(this.horizontal.getComponentSize(dimension.width));
        int n2 = (int)Math.ceil(this.vertical.getComponentSize(dimension.height));
        return new Dimension(n, n2);
    }

    @Override
    @Nullable
    public Insets2D asInsets2D() {
        float f = this.horizontal.getFixedInset1();
        if (f < 0.0f) {
            return null;
        }
        float f2 = this.horizontal.getFixedInset2();
        if (f2 < 0.0f) {
            return null;
        }
        float f3 = this.vertical.getFixedInset1();
        if (f3 < 0.0f) {
            return null;
        }
        float f4 = this.vertical.getFixedInset2();
        if (f4 < 0.0f) {
            return null;
        }
        return new Insets2D(f3, f, f4, f2);
    }

    @Override
    @Nullable
    public Insets asInsets() {
        float f = this.horizontal.getFixedInset1();
        if (f < 0.0f) {
            return null;
        }
        float f2 = this.horizontal.getFixedInset2();
        if (f2 < 0.0f) {
            return null;
        }
        float f3 = this.vertical.getFixedInset1();
        if (f3 < 0.0f) {
            return null;
        }
        float f4 = this.vertical.getFixedInset2();
        if (f4 < 0.0f) {
            return null;
        }
        int n = (int)Math.ceil(f3);
        int n2 = (int)Math.ceil(f);
        int n3 = (int)Math.ceil(f4);
        int n4 = (int)Math.ceil(f2);
        return new Insets(n, n2, n3, n4);
    }

    public float getFixedRegionWidth() {
        return this.horizontal.getFixedRegionSize();
    }

    public float getFixedRegionHeight() {
        return this.vertical.getFixedRegionSize();
    }
}

