/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFileChooser;
import org.violetlib.aqua.fc.SubtreeFileChooserUI;

public class FileTransferHandler
implements DropTargetListener {
    private JFileChooser fileChooser;

    public FileTransferHandler(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
    }

    public void setFileChooser(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDrag(dropTargetDragEvent);
    }

    private void handleDrag(DropTargetDragEvent dropTargetDragEvent) {
        if (!dropTargetDragEvent.getCurrentDataFlavorsAsList().contains(DataFlavor.javaFileListFlavor)) {
            dropTargetDragEvent.rejectDrag();
        }
        if (dropTargetDragEvent.getDropAction() != 1) {
            if ((dropTargetDragEvent.getSourceActions() & 1) != 0) {
                dropTargetDragEvent.acceptDrag(1);
            } else {
                dropTargetDragEvent.rejectDrag();
            }
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDrag(dropTargetDragEvent);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        this.handleDrag(dropTargetDragEvent);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        dropTargetDropEvent.acceptDrop(1);
        boolean bl = false;
        try {
            List list;
            File[] fileArray;
            if (this.fileChooser != null && (fileArray = (list = (List)dropTargetDropEvent.getTransferable().getTransferData(DataFlavor.javaFileListFlavor)).toArray(new File[list.size()])).length > 0) {
                if (this.fileChooser.getUI() instanceof SubtreeFileChooserUI) {
                    File file = fileArray[0];
                    if (file.isDirectory() && fileArray.length == 1 && this.fileChooser.getFileSelectionMode() == 0) {
                        ((SubtreeFileChooserUI)((Object)this.fileChooser.getUI())).selectDirectory(file);
                    } else {
                        if ((file = file.getParentFile()) != null) {
                            ((SubtreeFileChooserUI)((Object)this.fileChooser.getUI())).selectDirectory(file);
                        }
                        this.fileChooser.setSelectedFiles(fileArray);
                    }
                } else {
                    this.fileChooser.setSelectedFiles(fileArray);
                }
            }
            bl = true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dropTargetDropEvent.dropComplete(bl);
    }
}

