/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Point;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.MenuSelectionBoundsTracker;
import org.violetlib.aqua.VisualEffectView;

public class MenuVibrantEffects
extends VisualEffectView {
    @Nullable
    protected MenuSelectionBoundsTracker bt;
    protected final int style;

    public MenuVibrantEffects(final @NotNull JComponent jComponent, @NotNull JPopupMenu jPopupMenu, int n) {
        super(jComponent, n, true);
        this.style = n;
        this.bt = new MenuSelectionBoundsTracker(jPopupMenu, this::updateSelectionBackgrounds){

            @Override
            protected int convertRowYCoordinateToSelectionDescription(int n) {
                if (jComponent != this.menu) {
                    Point point = SwingUtilities.convertPoint(this.menu, 0, n, jComponent);
                    return point.y;
                }
                return n;
            }
        };
        jPopupMenu.putClientProperty("Aqua.PopupMenu.Tracker", this.bt);
    }

    public void update() {
        if (this.bt != null) {
            this.bt.update();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bt != null) {
            this.bt.dispose();
            this.bt = null;
        }
    }

    @Override
    protected void windowChanged(Window window) {
        super.windowChanged(window);
        if (this.bt != null) {
            this.bt.reset();
        }
    }
}

