/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Window;
import java.security.AccessControlException;
import org.violetlib.aqua.AquaNativeSupport;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.Utils;

public class KeyWindowPatch {
    private static Boolean isInstalled;
    private static Boolean isNeeded;

    public static void installIfNeeded() {
        if (isInstalled == null && KeyWindowPatch.isNeeded()) {
            KeyWindowPatch.loadNativeSupport();
        }
    }

    public static void applyPatchIfNeeded(Window window) {
        if (KeyWindowPatch.isNeededAndIsInstalled()) {
            AquaUtils.ensureWindowPeer(window);
            AquaUtils.execute(window, l -> KeyWindowPatch.ensureWindowDelegateInstalled(window, l));
        }
    }

    private static boolean isNeeded() {
        if (isNeeded == null) {
            isNeeded = KeyWindowPatch.computeIfNeeded();
        }
        return Boolean.TRUE.equals(isNeeded);
    }

    private static boolean isNeededAndIsInstalled() {
        if (KeyWindowPatch.isNeeded()) {
            if (isInstalled == null) {
                KeyWindowPatch.loadNativeSupport();
            }
            return Boolean.TRUE.equals(isInstalled);
        }
        return false;
    }

    private static Boolean computeIfNeeded() {
        int n = Utils.getJavaVersion();
        return n < 1100000;
    }

    private static void loadNativeSupport() {
        isInstalled = false;
        try {
            String string = AquaNativeSupport.findNativeLibrary(AquaNativeSupport.class, "keywindowpatch");
            if (string == null) {
                KeyWindowPatch.reportError("Library not found");
                return;
            }
            System.load(string);
            isInstalled = true;
            Utils.logDebug("VAqua: installed patch for main/key window support");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            KeyWindowPatch.reportError(unsatisfiedLinkError.getMessage());
        }
        catch (AccessControlException accessControlException) {
            KeyWindowPatch.reportError("permission denied: " + accessControlException.getMessage());
        }
        catch (Throwable throwable) {
            KeyWindowPatch.reportError(throwable.toString());
            throwable.printStackTrace();
        }
    }

    private static void reportError(String string) {
        String string2 = "KeyWindowPatch: Unable to load library: " + string;
        Utils.logError(string2);
    }

    private static long ensureWindowDelegateInstalled(Window window, long l) {
        return KeyWindowPatch.nativeEnsureWindowDelegateInstalled(l);
    }

    private static native int nativeEnsureWindowDelegateInstalled(long var0);
}

