/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaMenuBarUI
extends BasicMenuBarUI
implements AquaComponentUI {
    @NotNull
    protected BasicContextualColors colors = AquaColors.CONTROL_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaMenuBarUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListeners(this.menuBar);
    }

    @Override
    protected void uninstallListeners() {
        AppearanceManager.uninstallListeners(this.menuBar);
        super.uninstallListeners();
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.menuBar);
        }
        AquaUIPainter.State state = AquaUIPainter.State.ACTIVE;
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        AquaColors.installColors(this.menuBar, this.appearanceContext, this.colors);
        this.menuBar.repaint();
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        super.update(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
    }
}

