/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaSheetSupport;
import org.violetlib.aqua.AquaToolBarUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.WindowDraggingMouseListener;

public class AquaCustomStyledWindow {
    public static final int STYLE_OVERLAY = 0;
    public static final int STYLE_TRANSPARENT = 1;
    public static final int STYLE_HIDDEN = 2;
    public static final int STYLE_UNIFIED = 3;
    public static final int STYLE_TEXTURED_HIDDEN = 4;
    public static final int STYLE_COMBINED = 5;
    public static final int STYLE_UNDECORATED = 6;
    protected final int TITLE_BAR_HEIGHT = OSXSystemProperties.OSVersion >= 1016 ? 27 : 22;
    protected final int TITLE_BAR_BUTTONS_WIDTH = 78;
    @Nullable
    protected Window w;
    @Nullable
    protected JRootPane rp;
    protected final int style;
    protected int declaredTopMarginHeight;
    protected int declaredBottomMarginHeight;
    protected int fixedTopMarginHeight;
    protected int fixedBottomMarginHeight;
    protected int topMarginHeight;
    protected int bottomMarginHeight;
    protected final int titleBarStyle;
    protected final boolean isTextured;
    protected JComponent contentPane;
    protected JComponent windowToolBar;
    protected WindowPropertyChangeListener propertyChangeListener;
    protected WindowDraggingMouseListener windowDraggingMouseListener;
    protected WindowMarginDraggingMouseListener windowMarginDraggingMouseListener;
    protected HierarchyListener toolbarHierarchyListener;

    public AquaCustomStyledWindow(@NotNull Window window, int n, int n2, int n3) throws IllegalArgumentException {
        boolean bl = AquaUtils.isDecorated(window);
        if (n == 6) {
            if (bl) {
                throw new IllegalArgumentException("Window is decorated");
            }
        } else if (!bl) {
            throw new IllegalArgumentException("Window is not decorated");
        }
        this.w = window;
        JRootPane jRootPane = AquaUtils.getRootPane(window);
        if (jRootPane == null) {
            throw new IllegalArgumentException("Window lacks a root pane");
        }
        this.rp = jRootPane;
        this.style = n;
        this.declaredTopMarginHeight = n2;
        this.declaredBottomMarginHeight = n3;
        this.fixedTopMarginHeight = this.getFixedTopMarginHeight();
        this.fixedBottomMarginHeight = this.getFixedBottomMarginHeight();
        this.contentPane = this.getContentPane();
        if (this.contentPane == null) {
            throw new IllegalArgumentException("Window content pane is not a Swing component");
        }
        this.windowToolBar = this.getWindowToolbar();
        this.titleBarStyle = AquaCustomStyledWindow.getTitleBarStyleForWindowStyle(n);
        this.isTextured = this.getTexturedStyleForWindowStyle(n);
        if (this.isTextured) {
            if (this.windowToolBar == null) {
                throw new RequiredToolBarNotFoundException();
            }
            this.setupToolbar(this.windowToolBar);
        }
        this.setupContentPane(this.contentPane);
        this.propertyChangeListener = new WindowPropertyChangeListener();
        this.rp.addPropertyChangeListener("Frame.active", this.propertyChangeListener);
        if (n == 5) {
            AquaUtils.setWindowTitle(window, "");
        }
        AquaUtils.setTitleBarStyle(window, this.titleBarStyle);
    }

    public static void preconfigureWindowStyle(@NotNull Window window, int n) {
        int n2 = AquaCustomStyledWindow.getTitleBarStyleForWindowStyle(n);
        AquaUtils.preconfigureTitleBarStyle(window, n2);
    }

    public static int getTitleBarStyleForWindowStyle(int n) {
        switch (n) {
            case 0: {
                return 4;
            }
            case 1: 
            case 3: 
            case 5: {
                return 2;
            }
            case 2: 
            case 4: {
                return 3;
            }
            case 6: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid style");
    }

    public boolean getTexturedStyleForWindowStyle(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 6: {
                return false;
            }
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        throw new IllegalArgumentException("Invalid style");
    }

    @NotNull
    public AquaCustomStyledWindow reconfigure(int n, int n2, int n3) {
        assert (this.w != null);
        AquaCustomStyledWindow aquaCustomStyledWindow = new AquaCustomStyledWindow(this.w, n, n2, n3);
        this.removeListeners();
        return aquaCustomStyledWindow;
    }

    public int getStyle() {
        return this.style;
    }

    public boolean isValid(int n, int n2, int n3) {
        return n == this.style && n2 == this.declaredTopMarginHeight && n3 == this.declaredBottomMarginHeight;
    }

    public boolean isTextured() {
        return this.isTextured;
    }

    public void dispose() {
        if (this.w != null) {
            this.removeListeners();
            this.propertyChangeListener = null;
            this.toolbarHierarchyListener = null;
            this.windowDraggingMouseListener = null;
            this.windowMarginDraggingMouseListener = null;
            AquaUtils.setTitleBarStyle(this.w, 1);
            if (this.windowToolBar != null) {
                this.resetBorder(this.windowToolBar);
            }
            if (this.contentPane != null) {
                this.resetBorder(this.contentPane);
            }
            this.w = null;
            this.rp = null;
            this.contentPane = null;
            this.windowToolBar = null;
        }
    }

    private void removeListeners() {
        if (this.rp != null && this.propertyChangeListener != null) {
            this.rp.removePropertyChangeListener("Frame.active", this.propertyChangeListener);
        }
        if (this.windowToolBar != null && this.toolbarHierarchyListener != null) {
            this.windowToolBar.removeHierarchyListener(this.toolbarHierarchyListener);
        }
        if (this.windowDraggingMouseListener != null) {
            this.windowDraggingMouseListener.detach();
        }
        if (this.windowMarginDraggingMouseListener != null) {
            this.windowMarginDraggingMouseListener.detach();
        }
    }

    protected void setupContentPane(JComponent jComponent) {
        if (this.style == 0 || this.style == 1 && this.declaredTopMarginHeight < 0) {
            this.installContentPaneBorder(jComponent, this.TITLE_BAR_HEIGHT, 0, 0, 0);
        } else {
            this.installContentPaneBorder(jComponent, 0, 0, 0, 0);
        }
        if (this.fixedTopMarginHeight != 0 || this.fixedBottomMarginHeight != 0 || this.style == 0) {
            assert (this.rp != null);
            jComponent.setOpaque(false);
            this.rp.getLayeredPane().setOpaque(false);
            this.attachWindowMarginDraggingMouseListener(jComponent);
        }
    }

    protected void setupToolbar(JComponent jComponent) {
        jComponent.setOpaque(false);
        Container container = jComponent;
        while ((container = container.getParent()) != this.contentPane && container != null) {
            if (!(container instanceof JComponent)) continue;
            ((JComponent)container).setOpaque(false);
        }
        this.installToolbarBorder(jComponent);
        this.attachWindowDraggingMouseListener(jComponent);
        this.attachHierarchyListener(jComponent);
    }

    protected void installToolbarBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            int n;
            boolean bl = AquaToolBarUI.isTallFormatToolBar(jComponent);
            int n2 = 4;
            int n3 = 4;
            int n4 = n = bl ? 0 : 4;
            if (this.style == 3) {
                jComponent.setBorder(new CustomToolbarBorder(n2, this.TITLE_BAR_HEIGHT, n));
            } else if (this.style == 5) {
                jComponent.setBorder(new CustomToolbarBorder(78, n3, n));
            } else if (this.style == 4) {
                jComponent.setBorder(new CustomToolbarBorder(n2, n3, n));
            }
        }
    }

    protected void installContentPaneBorder(JComponent jComponent, int n, int n2, int n3, int n4) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            jComponent.setBorder(new CustomContentPaneBorder(n, n2, n3, n4));
        }
    }

    protected void resetBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        if (border == null || border instanceof UIResource) {
            if (jComponent instanceof JToolBar) {
                jComponent.setBorder(AquaToolBarUI.getToolBarBorder((JToolBar)jComponent));
            } else {
                jComponent.setBorder(null);
            }
        }
    }

    protected void attachWindowDraggingMouseListener(JComponent jComponent) {
        if (jComponent != null && this.windowDraggingMouseListener == null) {
            int n = this.titleBarStyle == 2 ? this.TITLE_BAR_HEIGHT : 0;
            this.windowDraggingMouseListener = new WindowDraggingMouseListener(n);
            this.windowDraggingMouseListener.attach(jComponent);
        }
    }

    protected void attachWindowMarginDraggingMouseListener(JComponent jComponent) {
        if (jComponent != null && this.windowMarginDraggingMouseListener == null) {
            this.windowMarginDraggingMouseListener = new WindowMarginDraggingMouseListener();
            this.windowMarginDraggingMouseListener.attach(jComponent);
        }
    }

    protected void attachHierarchyListener(JComponent jComponent) {
        if (this.toolbarHierarchyListener == null) {
            this.toolbarHierarchyListener = new ToolbarHierarchyListener();
        }
        jComponent.addHierarchyListener(this.toolbarHierarchyListener);
    }

    public void paintMarginBackgrounds(@NotNull Graphics graphics) {
        this.topMarginHeight = this.calculateTopMarginHeight();
        this.bottomMarginHeight = this.calculateBottomMarginHeight();
        assert (this.rp != null);
        if (this.topMarginHeight > 0) {
            this.paintMarginBackground(graphics, 0, this.topMarginHeight, true);
        }
        if (this.bottomMarginHeight > 0) {
            int n = this.rp.getHeight() - this.bottomMarginHeight;
            this.paintMarginBackground(graphics, n, this.bottomMarginHeight, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintMarginBackground(@NotNull Graphics graphics, int n, int n2, boolean bl) {
        if (n2 > 0) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                boolean bl2 = AquaFocusHandler.isActive(this.rp);
                boolean bl3 = AquaSheetSupport.isSheet(this.rp);
                Color color = bl3 ? AquaColors.CLEAR : AquaUtils.getWindowMarginBackground(this.rp, bl);
                AquaUtils.fillRect(graphics, color, 0, n, this.rp.getWidth(), n2);
                int n3 = bl ? n + n2 - 1 : n;
                int n4 = this.rp.getHeight();
                if (n3 < n4) {
                    int n5 = this.rp.getWidth();
                    this.paintUnifiedDivider(graphics2D, n3, n5, bl2, bl);
                }
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    protected void paintUnifiedDivider(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2) {
        assert (this.rp != null);
        Color color = AquaUtils.getWindowMarginDividerColor(this.rp, bl2);
        AquaUtils.fillRect(graphics2D, color, 0, n, n2, 1);
    }

    protected int getFixedTopMarginHeight() {
        switch (this.style) {
            case 0: {
                if (this.declaredTopMarginHeight >= 0) {
                    return this.declaredTopMarginHeight + this.TITLE_BAR_HEIGHT;
                }
                return -1;
            }
            case 1: 
            case 2: 
            case 6: {
                return this.declaredTopMarginHeight > 0 ? this.declaredTopMarginHeight : 0;
            }
        }
        return -1;
    }

    protected int getFixedBottomMarginHeight() {
        switch (this.style) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.declaredBottomMarginHeight > 0 ? this.declaredBottomMarginHeight : 0;
            }
        }
        return -1;
    }

    protected int calculateTopMarginHeight() {
        if (this.fixedTopMarginHeight >= 0) {
            return this.fixedTopMarginHeight;
        }
        int n = this.windowToolBar != null ? this.windowToolBar.getHeight() : 0;
        switch (this.style) {
            case 3: 
            case 4: {
                return n;
            }
            case 5: {
                return Math.max(n, this.TITLE_BAR_HEIGHT);
            }
        }
        return 0;
    }

    protected int calculateBottomMarginHeight() {
        return this.fixedBottomMarginHeight;
    }

    protected JComponent getContentPane() {
        Container container = this.rp.getContentPane();
        return container instanceof JComponent ? (JComponent)container : null;
    }

    @Nullable
    public JComponent getWindowToolbar() {
        Container container = this.rp.getContentPane();
        return this.getWindowToolbar(container);
    }

    @Nullable
    protected JComponent getWindowToolbar(Container container) {
        Component component;
        int n;
        int n2 = container.getComponentCount();
        for (n = 0; n < n2; ++n) {
            component = container.getComponent(n);
            if (!AquaUtils.isToolBar(component)) continue;
            return (JComponent)component;
        }
        for (n = 0; n < n2; ++n) {
            JComponent jComponent;
            component = container.getComponent(n);
            if (!(component instanceof Container) || (jComponent = this.getWindowToolbar((Container)component)) == null) continue;
            return jComponent;
        }
        return null;
    }

    public static class RequiredToolBarNotFoundException
    extends IllegalArgumentException {
        public RequiredToolBarNotFoundException() {
            super("Window content pane must contain a non-floatable JToolBar or a toolbar panel identified by Aqua.isToolBarPanel=true");
        }
    }

    protected class WindowPropertyChangeListener
    implements PropertyChangeListener {
        protected WindowPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaCustomStyledWindow.this.rp.repaint();
        }
    }

    protected class WindowMarginDraggingMouseListener
    extends WindowDraggingMouseListener {
        public WindowMarginDraggingMouseListener() {
            super(0);
        }

        @Override
        protected boolean isDragArea(Component component, Point point) {
            int n = point.y;
            if (AquaCustomStyledWindow.this.topMarginHeight > 0 && n < AquaCustomStyledWindow.this.topMarginHeight) {
                return true;
            }
            return AquaCustomStyledWindow.this.bottomMarginHeight > 0 && n >= component.getHeight() - AquaCustomStyledWindow.this.bottomMarginHeight;
        }
    }

    protected class CustomToolbarBorder
    extends CustomBorderBase {
        protected int extraTop;
        protected int extraLeft;
        protected int extraBottom;

        public CustomToolbarBorder(int n, int n2, int n3) {
            this.extraLeft = n;
            this.extraTop = n2;
            this.extraBottom = n3;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            Insets insets2 = component instanceof JToolBar ? ((JToolBar)component).getMargin() : new Insets(0, 0, 0, 0);
            insets.left = insets2.left + this.extraLeft;
            insets.top = insets2.top + this.extraTop;
            insets.right = insets2.right;
            insets.bottom = insets2.bottom + this.extraBottom + 1;
            return insets;
        }
    }

    protected class CustomContentPaneBorder
    extends CustomBorderBase {
        private int top;
        private int left;
        private int bottom;
        private int right;

        public CustomContentPaneBorder(int n, int n2, int n3, int n4) {
            this.top = n;
            this.left = n2;
            this.bottom = n3;
            this.right = n4;
        }

        @Override
        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.top;
            insets.left = this.left;
            insets.bottom = this.bottom;
            insets.right = this.right;
            return insets;
        }
    }

    protected class ToolbarHierarchyListener
    implements HierarchyListener {
        protected ToolbarHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            JComponent jComponent;
            if ((hierarchyEvent.getChangeFlags() & 1L) != 0L && SwingUtilities.getWindowAncestor(jComponent = (JComponent)hierarchyEvent.getComponent()) != AquaCustomStyledWindow.this.w) {
                AquaCustomStyledWindow.this.resetBorder(jComponent);
                if (jComponent == AquaCustomStyledWindow.this.windowToolBar) {
                    AquaCustomStyledWindow.this.windowToolBar = null;
                }
                jComponent.removeHierarchyListener(AquaCustomStyledWindow.this.toolbarHierarchyListener);
                if (AquaCustomStyledWindow.this.windowDraggingMouseListener != null) {
                    AquaCustomStyledWindow.this.windowDraggingMouseListener.detach();
                    AquaCustomStyledWindow.this.windowDraggingMouseListener = null;
                }
            }
        }
    }

    protected class CustomBorderBase
    extends AbstractBorder
    implements UIResource {
        protected CustomBorderBase() {
        }
    }
}

