/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaButtonBorder;
import org.violetlib.aqua.AquaButtonToggleUI;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaNamedButtonBorder;
import org.violetlib.aqua.AquaSegmentedButtonBorder;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.VAquaRenderingAccess;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaButtonExtendedTypes {
    protected static final AquaUtils.RecyclableSingleton<Map<String, TypeSpecifier>> typeDefinitions = new AquaUtils.RecyclableSingleton<Map<String, TypeSpecifier>>(){

        @Override
        protected Map<String, TypeSpecifier> getInstance() {
            return AquaButtonExtendedTypes.getAllTypes();
        }
    };
    protected static final WidgetInfo defaultButtonWidgetInfo = new WidgetInfo(AquaColors.CLEAR_CONTROL_COLORS);
    protected static final WidgetInfo defaultSegmentedButtonWidgetInfo = new WidgetInfo(AquaColors.CLEAR_CONTROL_COLORS).withSegmented();
    protected static final AquaUtils.RecyclableSingleton<Map<Object, WidgetInfo>> widgetDefinitions = new AquaUtils.RecyclableSingleton<Map<Object, WidgetInfo>>(){

        @Override
        protected Map<Object, WidgetInfo> getInstance() {
            return AquaButtonExtendedTypes.getAllWidgets();
        }
    };

    @Nullable
    public static String getBasicButtonType(@NotNull AbstractButton abstractButton, boolean bl) {
        Object object = abstractButton.getClientProperty("JButton.buttonType");
        if (object == null) {
            if (abstractButton.getUI().getClass() == AquaButtonToggleUI.class || AquaButtonExtendedTypes.getValidSegmentPosition(abstractButton) != null) {
                object = "segmented";
            } else {
                return null;
            }
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.equals("segmented")) {
                if (bl) {
                    string = "segmentedTextured";
                }
            } else if (string.equals("segmentedSeparated")) {
                if (bl) {
                    string = "segmentedTexturedSeparated";
                }
            } else if (string.equals("round") && bl) {
                string = "roundTextured";
            }
            return string;
        }
        return null;
    }

    @Nullable
    public static String getExtendedButtonType(@NotNull AbstractButton abstractButton, boolean bl) {
        String string;
        String string2 = AquaButtonExtendedTypes.getBasicButtonType(abstractButton, bl);
        if (string2 != null && (string = AquaButtonExtendedTypes.getValidSegmentPosition(abstractButton)) != null) {
            string = AquaButtonExtendedTypes.getRealPositionForLogicalPosition(string, abstractButton.getComponentOrientation().isLeftToRight());
            return string2 + "-" + string;
        }
        return string2;
    }

    @Nullable
    public static String getValidSegmentPosition(@NotNull AbstractButton abstractButton) {
        String string;
        Object object = abstractButton.getClientProperty("JButton.segmentPosition");
        if (object instanceof String && ((string = (String)object).equals("first") || string.equals("last") || string.equals("middle") || string.equals("only"))) {
            return string;
        }
        return null;
    }

    @Nullable
    public static TypeSpecifier getTypeSpecifier(@NotNull AbstractButton abstractButton, boolean bl) {
        String string = AquaButtonExtendedTypes.getExtendedButtonType(abstractButton, bl);
        if (string == null) {
            return null;
        }
        TypeSpecifier typeSpecifier = AquaButtonExtendedTypes.getSpecifierByName(abstractButton, string, bl);
        if (typeSpecifier != null) {
            return typeSpecifier;
        }
        if (string.contains("-")) {
            String string2 = AquaButtonExtendedTypes.getBasicButtonType(abstractButton, bl);
            assert (string2 != null);
            return AquaButtonExtendedTypes.getSpecifierByName(abstractButton, string2, bl);
        }
        return null;
    }

    public static WidgetInfo getTabWidgetInfo(@NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget, AquaUIPainter.Size size, AquaUIPainter.Position position) {
        return AquaButtonExtendedTypes.getWidgetDefinitions().get(segmentedButtonWidget);
    }

    @NotNull
    protected static String getRealPositionForLogicalPosition(@NotNull String string, boolean bl) {
        if (!bl) {
            if ("first".equals(string)) {
                return "last";
            }
            if ("last".equals(string)) {
                return "first";
            }
        }
        return string;
    }

    private static TypeSpecifier getSpecifierByName(AbstractButton abstractButton, String string, boolean bl) {
        if (bl) {
            String string2 = string + "-onToolbar";
            TypeSpecifier typeSpecifier = typeDefinitions.get().get(string2);
            if (typeSpecifier != null) {
                return typeSpecifier;
            }
        }
        return typeDefinitions.get().get(string);
    }

    @NotNull
    public static Font getFont(@NotNull Object object, @NotNull AquaUIPainter.Size size, @NotNull Font font) {
        WidgetInfo widgetInfo = AquaButtonExtendedTypes.getWidgetInfo(object);
        Font font2 = widgetInfo.getFont(size);
        if (font2 != null) {
            return font2;
        }
        if (size != AquaUIPainter.Size.REGULAR) {
            float f = AquaButtonExtendedTypes.getFontSize(size);
            return font.deriveFont(f);
        }
        return font;
    }

    public static float getFontSize(AquaUIPainter.Size size) {
        switch (size) {
            case SMALL: {
                return 11.0f;
            }
            case MINI: {
                return 9.0f;
            }
            case LARGE: {
                return 13.0f;
            }
        }
        return 13.0f;
    }

    @NotNull
    public static WidgetInfo getWidgetInfo(Object object) {
        WidgetInfo widgetInfo = AquaButtonExtendedTypes.getWidgetDefinitions().get(object);
        if (widgetInfo != null) {
            return widgetInfo;
        }
        if (object instanceof AquaUIPainter.SegmentedButtonWidget) {
            return defaultSegmentedButtonWidgetInfo;
        }
        if (object instanceof AquaUIPainter.ButtonWidget) {
            return defaultButtonWidgetInfo;
        }
        return defaultButtonWidgetInfo;
    }

    @NotNull
    private static Map<Object, WidgetInfo> getWidgetDefinitions() {
        Map<Object, WidgetInfo> map = widgetDefinitions.get();
        assert (map != null);
        return map;
    }

    protected static Map<Object, WidgetInfo> getAllWidgets() {
        HashMap<Object, WidgetInfo> hashMap = new HashMap<Object, WidgetInfo>();
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX, new WidgetInfo(AquaColors.LABELLED_BUTTON_COLORS));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_RADIO, new WidgetInfo(AquaColors.LABELLED_BUTTON_COLORS));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_PUSH, new WidgetInfo(AquaColors.PUSH_BUTTON_COLORS).withMargin(5));
        WidgetInfo widgetInfo = new WidgetInfo(AquaColors.SEGMENTED_BUTTON_COLORS).withSegmented().withNonexclusiveSelectionColors(AquaColors.SEGMENTED_NONEXCLUSIVE_BUTTON_COLORS).withMargin(9);
        WidgetInfo widgetInfo2 = widgetInfo.copy().withNonexclusiveSelectionColors(AquaColors.SEGMENTED_SEPARATED_NONEXCLUSIVE_BUTTON_COLORS).withColors(AquaColors.SEGMENTED_SEPARATED_BUTTON_COLORS);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, widgetInfo);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_TAB, widgetInfo);
        if (VAquaRenderingAccess.SLIDER_WIDGET != null) {
            hashMap.put(VAquaRenderingAccess.SLIDER_WIDGET, widgetInfo);
        }
        if (VAquaRenderingAccess.SLIDER_TOOLBAR_WIDGET != null) {
            hashMap.put(VAquaRenderingAccess.SLIDER_TOOLBAR_WIDGET, widgetInfo);
        }
        if (VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET != null) {
            hashMap.put(VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET, widgetInfo);
        }
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, widgetInfo2);
        WidgetInfo widgetInfo3 = new WidgetInfo(AquaColors.GRADIENT_BUTTON_COLORS);
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_GRADIENT, widgetInfo3.copy().withMargin(2));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_BEVEL, widgetInfo3.copy().withMargin(4));
        WidgetInfo widgetInfo4 = new WidgetInfo(AquaColors.ROUNDED_RECT_BUTTON_COLORS).withMargin(4).withFontFinder(size -> UIManager.getFont("Button.font").deriveFont(AquaButtonExtendedTypes.fontSize(size, 12.0f, 12.0f, 11.0f, 9.0f)));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT, widgetInfo4);
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND, new WidgetInfo(AquaColors.BEVEL_BUTTON_COLORS).withMargin(6));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_ROUND, new WidgetInfo(AquaColors.ROUND_BUTTON_COLORS));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM, new WidgetInfo(AquaColors.TOOLBAR_ITEM_COLORS).withIconTextGap(2));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_INLINE, new WidgetInfo(AquaColors.INLINE_BUTTON_COLORS).withFontFinder(size -> UIManager.getFont("Button.inline.font")));
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_RECESSED, new WidgetInfo(AquaColors.RECESSED_BUTTON_COLORS).withRolloverEnabled().withFontFinder(size -> {
            Font font = UIManager.getFont("Button.recessed.font");
            if (size == AquaUIPainter.Size.MINI) {
                font = font.deriveFont(0);
            }
            float f = size == AquaUIPainter.Size.MINI ? 9.0f : 12.0f;
            return font.deriveFont(f);
        }));
        WidgetInfo widgetInfo5 = new WidgetInfo(AquaColors.TEXTURED_COLORS).withTextured().withNonexclusiveSelectionColors(AquaColors.TEXTURED_NONEXCLUSIVE_COLORS);
        WidgetInfo widgetInfo6 = new WidgetInfo(AquaColors.TEXTURED_TOOLBAR_COLORS).withTextured().withNonexclusiveSelectionColors(AquaColors.TEXTURED_TOOLBAR_NONEXCLUSIVE_COLORS);
        if (OSXSystemProperties.OSVersion >= 1016) {
            widgetInfo6 = widgetInfo6.withRolloverEnabled();
        }
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_TEXTURED, widgetInfo5);
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR, widgetInfo6);
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED, widgetInfo5);
        hashMap.put(AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR, widgetInfo6);
        WidgetInfo widgetInfo7 = widgetInfo5.copy().withSegmented().withColors(AquaColors.TEXTURED_SEGMENTED_BUTTON_COLORS).withMargin(9);
        WidgetInfo widgetInfo8 = widgetInfo7.copy().withColors(AquaColors.TEXTURED_SEGMENTED_TOOLBAR_BUTTON_COLORS).withNonexclusiveSelectionColors(AquaColors.TEXTURED_TOOLBAR_NONEXCLUSIVE_COLORS).withRolloverEnabled();
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, widgetInfo7);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, widgetInfo7);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, widgetInfo8);
        if (VAquaRenderingAccess.SEGMENTED_TEXTURED_TOOLBAR_ICONS_WIDGET != null) {
            hashMap.put(VAquaRenderingAccess.SEGMENTED_TEXTURED_TOOLBAR_ICONS_WIDGET, widgetInfo8);
        }
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, widgetInfo8);
        if (VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET != null) {
            hashMap.put(VAquaRenderingAccess.TEXTURED_SEPARATED_TOOLBAR_ICONS_WIDGET, widgetInfo8);
        }
        WidgetInfo widgetInfo9 = widgetInfo3.copy().withSegmented().withColors(AquaColors.GRADIENT_SEGMENTED_BUTTON_COLORS).withMargin(9);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, widgetInfo9);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, widgetInfo9);
        WidgetInfo widgetInfo10 = widgetInfo4.copy().withSegmented().withColors(AquaColors.GRADIENT_SEGMENTED_BUTTON_COLORS).withMargin(9);
        hashMap.put(AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, widgetInfo10);
        WidgetInfo widgetInfo11 = new WidgetInfo(AquaColors.POP_UP_DOWN_BUTTON_COLORS).withMargin(5);
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN, widgetInfo11);
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP, widgetInfo11);
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_BEVEL, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_BEVEL));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_BEVEL));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_ROUND_RECT, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_ROUND_RECT, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_RECESSED));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_RECESSED));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_TEXTURED));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_TEXTURED));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_TEXTURED_TOOLBAR, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_GRADIENT, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_GRADIENT));
        hashMap.put(AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT, (WidgetInfo)hashMap.get(AquaUIPainter.ButtonWidget.BUTTON_GRADIENT));
        WidgetInfo widgetInfo12 = new WidgetInfo(AquaColors.CONTROL_COLORS);
        hashMap.put(AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX, widgetInfo12.copy().withBottomMenuGap(5));
        hashMap.put(AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL, widgetInfo12.copy().withBottomMenuGap(6));
        hashMap.put(AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED, widgetInfo12.copy().withBottomMenuGap(6));
        hashMap.put(AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR, widgetInfo12.copy().withBottomMenuGap(5));
        return hashMap;
    }

    protected static Map<String, TypeSpecifier> getAllTypes() {
        TypeSpecifier[] typeSpecifierArray;
        HashMap<String, TypeSpecifier> hashMap = new HashMap<String, TypeSpecifier>();
        for (TypeSpecifier typeSpecifier : typeSpecifierArray = new TypeSpecifier[]{new FixedBorderTypeSpecifier("toolbar", AquaButtonBorder.getToolBarToggleButtonBorder()), new FixedBorderTypeSpecifier("icon", AquaButtonBorder.getIconToggleButtonBorder()), new FixedBorderTypeSpecifier("text", (AquaButtonBorder)UIManager.getBorder("Button.border")), new FixedBorderTypeSpecifier("toggle", AquaButtonBorder.getToggleButtonBorder()), new FixedBorderTypeSpecifier("disclosureTriangle", AquaButtonBorder.getDisclosureTriangleButtonBorder()), new FixedBorderTypeSpecifier("disclosure", AquaButtonBorder.getDisclosureButtonBorder()), new BorderDefinedTypeSpecifier("checkbox", AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX), new BorderDefinedTypeSpecifier("radio", AquaUIPainter.ButtonWidget.BUTTON_RADIO), new BorderDefinedTypeSpecifier("square", AquaUIPainter.ButtonWidget.BUTTON_BEVEL), new BorderDefinedTypeSpecifier("gradient", AquaUIPainter.ButtonWidget.BUTTON_GRADIENT), new BorderDefinedTypeSpecifier("bevel", AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND), new BorderDefinedTypeSpecifier("textured", AquaUIPainter.ButtonWidget.BUTTON_TEXTURED), new BorderDefinedTypeSpecifier("textured-onToolbar", AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR), new BorderDefinedTypeSpecifier("roundRect", AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT), new BorderDefinedTypeSpecifier("recessed", AquaUIPainter.ButtonWidget.BUTTON_RECESSED), new BorderDefinedTypeSpecifier("inline", AquaUIPainter.ButtonWidget.BUTTON_INLINE), new BorderDefinedTypeSpecifier("well", AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM), new BorderDefinedTypeSpecifier("toolbarItem", AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM), new BorderDefinedTypeSpecifier("help", AquaUIPainter.ButtonWidget.BUTTON_HELP), new BorderDefinedTypeSpecifier("round", AquaUIPainter.ButtonWidget.BUTTON_ROUND), new BorderDefinedTypeSpecifier("round-onToolbar", OSXSystemProperties.OSVersion >= 1011 ? AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR : AquaUIPainter.ButtonWidget.BUTTON_ROUND), new BorderDefinedTypeSpecifier("texturedRound", AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET), new BorderDefinedTypeSpecifier("roundTextured", AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED), new BorderDefinedTypeSpecifier("roundTextured-onToolbar", OSXSystemProperties.OSVersion >= 1011 ? AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR : AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED), new BorderDefinedTypeSpecifier("roundInset", AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET), new BorderDefinedTypeSpecifier("colorWell", AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL), new SegmentedTypeSpecifier("segmented-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmented-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmented-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmented-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedSeparated-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedSeparated-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedSeparated-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedSeparated-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SEPARATED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedRoundRect-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedRoundRect-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedRoundRect-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedRoundRect-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_INSET, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedRounded-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedRounded-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedRounded-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedRounded-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SCURVE, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTextured-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTextured-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTextured-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTextured-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTextured-first-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTextured-middle-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTextured-last-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTextured-only-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_TOOLBAR, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedCapsule-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedCapsule-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedCapsule-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedCapsule-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TOOLBAR, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedGradient-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedGradient-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedGradient-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedGradient-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_SMALL_SQUARE, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedSeparated-first", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-middle", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedSeparated-last", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-only", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED, AquaUIPainter.Position.ONLY), new SegmentedTypeSpecifier("segmentedTexturedSeparated-first-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.FIRST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-middle-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.MIDDLE), new SegmentedTypeSpecifier("segmentedTexturedSeparated-last-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.LAST), new SegmentedTypeSpecifier("segmentedTexturedSeparated-only-onToolbar", AquaUIPainter.SegmentedButtonWidget.BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR, AquaUIPainter.Position.ONLY)}) {
            hashMap.put(typeSpecifier.name, typeSpecifier);
        }
        return hashMap;
    }

    private static float fontSize(@NotNull AquaUIPainter.Size size, float f, float f2, float f3, float f4) {
        if (size == AquaUIPainter.Size.LARGE) {
            return f;
        }
        if (size == AquaUIPainter.Size.SMALL) {
            return f3;
        }
        if (size == AquaUIPainter.Size.MINI) {
            return f4;
        }
        return f2;
    }

    public static abstract class TypeSpecifier {
        final String name;

        protected TypeSpecifier(String string) {
            this.name = string;
        }

        public abstract Border getBorder();
    }

    public static class WidgetInfo
    implements Cloneable {
        private boolean isSegmented;
        private boolean isTextured;
        @NotNull
        private BasicContextualColors colors;
        @Nullable
        private BasicContextualColors nonExclusiveSelectionColors;
        private Font font;
        private FontFinder fontFinder;
        private boolean isRolloverEnabled;
        private int iconTextGap;
        private int margin;
        private int bottomMenuGap;

        WidgetInfo(@NotNull BasicContextualColors basicContextualColors) {
            this.colors = basicContextualColors;
        }

        @NotNull
        WidgetInfo copy() {
            try {
                return (WidgetInfo)this.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException("Unable to clone WidgetInfo");
            }
        }

        @NotNull
        WidgetInfo withSegmented() {
            this.isSegmented = true;
            return this;
        }

        @NotNull
        WidgetInfo withTextured() {
            this.isTextured = true;
            return this;
        }

        @NotNull
        WidgetInfo withColors(@NotNull BasicContextualColors basicContextualColors) {
            this.colors = basicContextualColors;
            return this;
        }

        @NotNull
        WidgetInfo withFont(@NotNull Font font) {
            this.font = font;
            return this;
        }

        @NotNull
        WidgetInfo withFontFinder(@NotNull FontFinder fontFinder) {
            this.fontFinder = fontFinder;
            return this;
        }

        @NotNull
        WidgetInfo withIconTextGap(int n) {
            this.iconTextGap = n;
            return this;
        }

        @NotNull
        WidgetInfo withMargin(int n) {
            this.margin = n;
            return this;
        }

        @NotNull
        WidgetInfo withNonexclusiveSelectionColors(@NotNull BasicContextualColors basicContextualColors) {
            this.nonExclusiveSelectionColors = basicContextualColors;
            return this;
        }

        @NotNull
        WidgetInfo withRolloverEnabled() {
            this.isRolloverEnabled = true;
            return this;
        }

        @NotNull
        WidgetInfo withBottomMenuGap(int n) {
            this.bottomMenuGap = n;
            return this;
        }

        public int getIconTextGap() {
            return this.iconTextGap;
        }

        public int getMargin() {
            return this.margin;
        }

        @Nullable
        public Font getFont(@NotNull AquaUIPainter.Size size) {
            if (this.fontFinder != null) {
                return this.fontFinder.getFont(size);
            }
            if (this.font != null && size != AquaUIPainter.Size.REGULAR) {
                float f = AquaButtonExtendedTypes.getFontSize(size);
                return this.font.deriveFont(f);
            }
            return this.font;
        }

        @NotNull
        public BasicContextualColors getColors() {
            return this.colors;
        }

        @NotNull
        public Color getForeground(AquaUIPainter.State state, AquaUIPainter.ButtonState buttonState, AquaAppearance aquaAppearance, boolean bl, boolean bl2) {
            BasicContextualColors basicContextualColors = bl && this.nonExclusiveSelectionColors != null ? this.nonExclusiveSelectionColors : this.colors;
            boolean bl3 = buttonState == AquaUIPainter.ButtonState.ON;
            AppearanceContext appearanceContext = new AppearanceContext(aquaAppearance, state, bl3, bl2);
            return basicContextualColors.getForeground(appearanceContext);
        }

        public boolean isSegmented() {
            return this.isSegmented;
        }

        public boolean isTextured() {
            return this.isTextured;
        }

        public boolean isRolloverEnabled() {
            return this.isRolloverEnabled;
        }

        public boolean usesNonexclusiveSelectionStyle() {
            return this.nonExclusiveSelectionColors != null && this.isSegmented;
        }

        public int getBottomMenuGap() {
            return this.bottomMenuGap;
        }
    }

    @FunctionalInterface
    protected static interface FontFinder {
        @Nullable
        public Font getFont(@NotNull AquaUIPainter.Size var1);
    }

    public static class FixedBorderTypeSpecifier
    extends TypeSpecifier {
        private final AquaButtonBorder border;

        public FixedBorderTypeSpecifier(String string, AquaButtonBorder aquaButtonBorder) {
            super(string);
            this.border = aquaButtonBorder;
        }

        @Override
        public AquaButtonBorder getBorder() {
            return this.border;
        }
    }

    public static class BorderDefinedTypeSpecifier
    extends TypeSpecifier {
        private final AquaUIPainter.ButtonWidget widget;
        private final WidgetInfo info;

        public BorderDefinedTypeSpecifier(String string, AquaUIPainter.ButtonWidget buttonWidget) {
            super(string);
            this.widget = buttonWidget;
            this.info = AquaButtonExtendedTypes.getWidgetInfo(buttonWidget);
        }

        @Override
        public AquaButtonBorder getBorder() {
            return new AquaNamedButtonBorder(this.widget, this.info);
        }
    }

    public static class SegmentedTypeSpecifier
    extends TypeSpecifier {
        @NotNull
        private final AquaUIPainter.SegmentedButtonWidget widget;
        @NotNull
        private final WidgetInfo info;
        @NotNull
        private final AquaUIPainter.Position position;

        public SegmentedTypeSpecifier(@NotNull String string, @NotNull AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget, @NotNull AquaUIPainter.Position position) {
            super(string);
            this.widget = segmentedButtonWidget;
            this.info = AquaButtonExtendedTypes.getWidgetInfo(segmentedButtonWidget);
            this.position = position;
        }

        @Override
        @NotNull
        public AquaButtonBorder getBorder() {
            return new AquaSegmentedButtonBorder(this.widget, this.info, this.position);
        }
    }
}

