/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.impl;

import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.InsetterNotInvertibleException;
import org.violetlib.jnr.impl.Insetter1;

public class FloatingInsetter1
implements Insetter1 {
    private final float regionSize;
    @NotNull
    private final Alignment alignment;
    private final float d1;
    private final float d2;

    @NotNull
    public static FloatingInsetter1 createLeftTopAligned(float regionSize, float d1) {
        if (regionSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        if (d1 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        return new FloatingInsetter1(regionSize, Alignment.LEFT, d1, 0.0f);
    }

    @NotNull
    public static FloatingInsetter1 createRightBottomAligned(float regionSize, float d2) {
        if (regionSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        if (d2 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        return new FloatingInsetter1(regionSize, Alignment.RIGHT, 0.0f, d2);
    }

    @NotNull
    public static FloatingInsetter1 createCentered(float regionSize, float d1, float d2) {
        if (regionSize < 0.0f) {
            throw new IllegalArgumentException("Invalid negative region size");
        }
        if (d1 < 0.0f || d2 < 0.0f) {
            throw new IllegalArgumentException("Invalid negative offset");
        }
        return new FloatingInsetter1(regionSize, Alignment.CENTER, d1, d2);
    }

    private FloatingInsetter1(float regionSize, @NotNull Alignment alignment, float d1, float d2) {
        this.regionSize = regionSize;
        this.alignment = alignment;
        this.d1 = d1;
        this.d2 = d2;
    }

    @Override
    public float getRegionOrigin(float componentSize) {
        switch (this.alignment) {
            case LEFT: {
                return this.d1;
            }
            case RIGHT: {
                return componentSize - (this.regionSize + this.d2);
            }
            case CENTER: {
                float extra = componentSize - (this.regionSize + this.d1 + this.d2);
                return this.d1 + extra / 2.0f;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public float getRegionSize(float componentSize) {
        return this.regionSize;
    }

    @Override
    public boolean isInvertible() {
        return true;
    }

    @Override
    public float getComponentSize(float regionSize) throws InsetterNotInvertibleException {
        return regionSize + this.d1 + this.d2;
    }

    @Override
    public float getFixedInset1() {
        switch (this.alignment) {
            case LEFT: 
            case CENTER: {
                return this.d1;
            }
        }
        return -1.0f;
    }

    @Override
    public float getFixedInset2() {
        switch (this.alignment) {
            case RIGHT: 
            case CENTER: {
                return this.d2;
            }
        }
        return -1.0f;
    }

    @Override
    public float getFixedRegionSize() {
        return this.regionSize;
    }

    private static enum Alignment {
        LEFT,
        RIGHT,
        CENTER;

    }
}

