/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.jrs;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.ComboBoxButtonCellPainterExtension;
import org.violetlib.jnr.aqua.impl.LegacyScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.OverlayScrollBarPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThickSplitPaneDividerPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.aqua.jrs.JRSPainter;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;

public class AugmentedJRSPainter
extends JRSPainter {
    @Override
    @NotNull
    public AugmentedJRSPainter copy() {
        return new AugmentedJRSPainter();
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        TableColumnHeaderCellPainterExtension px = new TableColumnHeaderCellPainterExtension(g, this.appearance);
        return Renderer.create(px);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        if (g.getWidget() == AquaUIPainter.DividerWidget.THICK_DIVIDER) {
            ThickSplitPaneDividerPainterExtension px = new ThickSplitPaneDividerPainterExtension(g, this.appearance);
            return Renderer.create(px);
        }
        if (g.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension px = new ThinSplitPaneDividerPainterExtension(g, this.appearance);
            return Renderer.create(px);
        }
        return super.getSplitPaneDividerRenderer(g);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            ComboBoxButtonCellPainterExtension px = new ComboBoxButtonCellPainterExtension(g, this.appearance);
            return Renderer.create(px);
        }
        return super.getComboBoxButtonRenderer(g);
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration g) {
        Renderer r = super.getPopupArrowRenderer(g);
        if (this.isArrowNeeded(g)) {
            if (g.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(g, this.appearance));
            }
            return Renderer.create(new PullDownArrowPainter(g, this.appearance));
        }
        return r;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration g) {
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        if (g.isPopUp()) {
            return w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED;
        }
        switch (w) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return false;
            }
        }
        return true;
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration g) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.ScrollBarWidget sw = g.getWidget();
        if (platformVersion < 101400) {
            return super.getScrollBarRenderer(g);
        }
        if (sw == AquaUIPainter.ScrollBarWidget.LEGACY) {
            return Renderer.create(new LegacyScrollBarPainterExtension(this.uiLayout, g, this.appearance));
        }
        return Renderer.create(new OverlayScrollBarPainterExtension(this.uiLayout, g, this.appearance));
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        Renderer r = super.getSliderRenderer(g);
        if (g.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer pr = Renderer.create(new CircularSliderPainterExtension(g, this.appearance));
            return Renderer.createCompositeRenderer(r, pr);
        }
        return r;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration g) {
        int style = this.getSliderRenderingVersion();
        if (style == 0 && g.isLinear() && g.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(this.uiLayout, g, this.appearance));
        }
        return null;
    }

    @Override
    @NotNull
    public String toString() {
        return "Augmented " + super.toString();
    }
}

