/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.geom.LinearBounds;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.GroupBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.ListBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsLayoutConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerLayoutConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.TitleBarLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.CenteredInsetter1;
import org.violetlib.jnr.impl.CombinedInsetter;
import org.violetlib.jnr.impl.DynamicInsetter1;
import org.violetlib.jnr.impl.FixedInsetter1;
import org.violetlib.jnr.impl.FloatingInsetter1;
import org.violetlib.jnr.impl.Insetter1;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class YosemiteLayoutInfo
extends AquaUILayoutInfo {
    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellLayoutConfiguration tg = new ToolBarItemWellLayoutConfiguration();
            return this.getToolBarItemWellLayoutInfo(tg);
        }
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 14, 12, 10), JNRUtils.size(sz, 14, 12, 10));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 16, 14, 10), JNRUtils.size(sz, 16, 14, 10));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 19, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 18, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return BasicLayoutInfo.getInstance();
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return BasicLayoutInfo.createFixedHeight(17.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 23, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 20, 17, 14), JNRUtils.size(sz, 21, 18, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return BasicLayoutInfo.createFixed(18.0f, 18.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(sz, 21, 18, 15), JNRUtils.size(sz, 22, 19, 16));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return BasicLayoutInfo.createFixed(9.0f, 9.0f);
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 19, 17, 15));
        }
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return BasicLayoutInfo.createMinimum(44.0f, 23.0f);
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration g) {
        AquaUIPainter.ButtonWidget bw = g.getButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        float top = 0.0f;
        float bottom = 0.0f;
        float left = 0.0f;
        float right = 0.0f;
        if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            top = JNRUtils.size(sz, 1, 2, 1);
            bottom = JNRUtils.size(sz, 2, 2, 2);
            right = left = (float)JNRUtils.size(sz, 4, 4, 3);
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            top = 1.0f;
            bottom = 1.0f;
            left = 1.0f;
            right = 1.0f;
        } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            top = JNRUtils.size(sz, 1, 2, 1);
            bottom = JNRUtils.size(sz, 2, 2, 2);
            right = left = (float)JNRUtils.size(sz, 4, 4, 3);
        } else {
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
                return null;
            }
            if (bw == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
                top = 1.0f;
                bottom = 1.0f;
                left = 1.0f;
                right = 1.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
                bottom = 1.0f;
                top = 1.0f;
                left = right = (float)JNRUtils.size(sz, 4, 3, 3);
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                top = 2.0f;
                bottom = 2.0f;
                left = right = (float)JNRUtils.size(sz, 6, 5, 5);
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
                bottom = 1.0f;
                top = 1.0f;
                right = 4.0f;
                left = 4.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR || bw == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED_TOOLBAR_ICONS) {
                top = 0.51f;
                bottom = 1.49f;
                right = 3.0f;
                left = 3.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
                left = right = JNRUtils.size2D(sz, 4.0, 3.5, 3.0);
                top = right;
                bottom = top + 1.0f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
                right = 3.0f;
                left = 3.0f;
                bottom = top = 3.5f;
            } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED || bw == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED_TOOLBAR) {
                left = right = JNRUtils.size2D(sz, 3.5, 3.0, 2.5);
                top = right;
                bottom = top + 1.0f;
            } else {
                if (bw == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
                    return null;
                }
                if (bw == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
                    top = JNRUtils.size(sz, 1, 1, 1);
                    bottom = JNRUtils.size(sz, 1, 1, 1);
                    right = left = (float)JNRUtils.size(sz, 7, 6, 6);
                } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
                    top = 2.0f;
                    bottom = 3.0f;
                    right = 4.0f;
                    left = 4.0f;
                } else if (bw == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
                    // empty if block
                }
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        return Insetters.createFixed(top, left, bottom, right, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getSegmentedButtonLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration g) {
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SEPARATED: 
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 22, 19, 16));
            }
            case BUTTON_SEGMENTED_INSET: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 23, 19, 16));
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 21, 19, 17));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getSegmentedButtonLabelInsets(@NotNull SegmentedButtonLayoutConfiguration g) {
        float left;
        AquaUIPainter.SegmentedButtonWidget bw = g.getWidget();
        AquaUIPainter.Position pos = g.getPosition();
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        float top = 1.0f;
        float bottom = 2.0f;
        float right = left = 1.0f;
        float endAdjust = 3.0f;
        boolean isLeftEnd = pos == AquaUIPainter.Position.FIRST || pos == AquaUIPainter.Position.ONLY;
        boolean isRightEnd = pos == AquaUIPainter.Position.LAST || pos == AquaUIPainter.Position.ONLY;
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: 
            case BUTTON_SEGMENTED_SLIDER: {
                break;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                endAdjust = 0.0f;
                right = 3.0f;
                left = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                bottom = 1.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TOOLBAR: {
                endAdjust = 2.0f;
                break;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                endAdjust = 0.0f;
                right = 3.0f;
                left = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                bottom = 1.0f;
                endAdjust = 0.0f;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (isLeftEnd) {
            left += endAdjust;
        }
        if (isRightEnd) {
            right += endAdjust;
        }
        return Insetters.createFixed(top, left, bottom, right, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getComboBoxLayoutInfo(@NotNull ComboBoxLayoutConfiguration g) {
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(sz, 14, 11, 11));
        }
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            float fixedHeight = JNRUtils.size(sz, 23, 19, 16);
            float minWidth = JNRUtils.size(sz, 27, 24, 22);
            return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
        }
        float fixedHeight = JNRUtils.size(sz, 22, 19, 15);
        float minWidth = JNRUtils.size(sz, 27, 24, 22);
        return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
    }

    @Override
    @NotNull
    public Insetter getComboBoxIndicatorInsets(@NotNull ComboBoxLayoutConfiguration g) {
        int indicatorWidth;
        AquaUIPainter.ComboBoxWidget w = g.getWidget();
        if (w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || w == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            indicatorWidth = 18;
        } else {
            switch (g.getSize()) {
                case SMALL: {
                    indicatorWidth = 19;
                    break;
                }
                case MINI: {
                    indicatorWidth = 16;
                    break;
                }
                default: {
                    indicatorWidth = 21;
                }
            }
        }
        return g.isLeftToRight() ? Insetters.createRightAligned(indicatorWidth, 0.0f, 0.0f, 0.0f) : Insetters.createLeftAligned(indicatorWidth, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public Insetter getComboBoxEditorInsets(@NotNull ComboBoxLayoutConfiguration g) {
        float bottom;
        float top;
        float far;
        float near;
        AquaUIPainter.ComboBoxWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            float inset = JNRUtils.size(sz, 18, 18, 13);
            return g.isLeftToRight() ? Insetters.createFixed(0.0f, 0.0f, 0.0f, inset) : Insetters.createFixed(0.0f, inset, 0.0f, 0.0f);
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        if (bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED || bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR) {
            near = bw == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_TEXTURED_TOOLBAR ? 20.0f : 19.0f;
            far = 2.5f;
            top = 1.0f;
            bottom = 2.0f;
        } else {
            near = JNRUtils.size2D(sz, 18.5, 16.5, 14.5);
            far = 0.5f;
            top = 1.0f;
            bottom = JNRUtils.size2D(sz, 2.0f, 2.0f, 1.0f);
        }
        return g.isLeftToRight() ? Insetters.createFixed(top, far, bottom, near, layoutInfo) : Insetters.createFixed(top, near, bottom, far, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getPopUpButtonLayoutInfo(@NotNull PopupButtonLayoutConfiguration g) {
        boolean isArrowsOnly;
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        boolean isSquare = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl = isArrowsOnly = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((isSquare || isArrowsOnly) && sz == AquaUIPainter.Size.MINI) {
            sz = AquaUIPainter.Size.SMALL;
        }
        switch (bw) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN: {
                float fixedHeight = JNRUtils.size(sz, 22, 19, 16);
                float minWidth = JNRUtils.size(sz, 25, 24, 20);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_UP_CELL: 
            case BUTTON_POP_DOWN_CELL: {
                return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(sz, 12, 10, 10));
            }
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 23, 20, 17));
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                return BasicLayoutInfo.createFixedHeight(22.0f);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(sz, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                float fixedHeight = JNRUtils.size(sz, 23, 19, 16);
                float minWidth = JNRUtils.size(sz, 25, 24, 20);
                return BasicLayoutInfo.create(false, minWidth, true, fixedHeight);
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                return BasicLayoutInfo.createFixedHeight(21.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getPopUpArrowInsets(@NotNull PopupButtonConfiguration g) {
        float right;
        float bottom;
        float top;
        float height;
        AquaUIPainter.PopupButtonWidget w = g.getPopupButtonWidget();
        boolean isCell = g.isCell();
        AquaUIPainter.Size sz = g.getSize();
        float buttonHeight = isCell ? (float)JNRUtils.size(sz, 12, 10, 10) : (float)JNRUtils.size(sz, 23, 20, 17);
        float width = JNRUtils.size(sz, 7, 7, 7);
        if (g.isPopUp()) {
            height = JNRUtils.size(sz, 12, 10, 10);
            float f = top = isCell ? JNRUtils.size2D(sz, 0.0f, 0.0f, 0.0f) : JNRUtils.size2D(sz, 7.0, 5.5, 5.5);
            if (w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT) {
                top -= 1.0f;
            } else if (w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL) {
                top -= 2.0f;
            } else if (w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED) {
                top -= JNRUtils.size2D(sz, 1.5, 0.0, 2.0);
            } else if (w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED || w == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED_TOOLBAR) {
                top -= JNRUtils.size2D(sz, 2.0f, 1.0f, 2.0f);
            }
            bottom = buttonHeight - top - height;
            right = isCell ? 2.0f : 5.0f;
        } else {
            height = 5.0f;
            top = isCell ? JNRUtils.size2D(sz, 3.5, 2.5, 2.5) : JNRUtils.size2D(sz, 9.0, 7.5, 7.5);
            bottom = buttonHeight - top - height;
            right = isCell ? 3.0f : 6.0f;
        }
        FloatingInsetter1 horizontal = g.isLeftToRight() ? FloatingInsetter1.createRightBottomAligned(width, right) : FloatingInsetter1.createLeftTopAligned(width, right);
        FloatingInsetter1 vertical = FloatingInsetter1.createCentered(height, top, bottom);
        return new CombinedInsetter(horizontal, vertical);
    }

    @Override
    @NotNull
    public Insetter getPopupButtonContentInsets(@NotNull PopupButtonLayoutConfiguration g) {
        float near;
        boolean isArrowsOnly;
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        AquaUIPainter.Size sz = g.getSize();
        boolean isSquare = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl = isArrowsOnly = bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || bw == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((isSquare || isArrowsOnly) && sz == AquaUIPainter.Size.MINI) {
            sz = AquaUIPainter.Size.SMALL;
        }
        float top = 1.0f;
        float bottom = 1.0f;
        float far = 1.0f;
        switch (bw) {
            default: {
                far = 3.0f;
                near = JNRUtils.size2D(sz, 17.0f, 15.0f, 13.0f);
                bottom = JNRUtils.size2D(sz, 2.5, 2.5, 2.0);
                top = JNRUtils.size2D(sz, 0.5, 0.5, 1.0);
                break;
            }
            case BUTTON_POP_UP_SQUARE: {
                near = JNRUtils.size2D(sz, 16.0f, 15.0f, 15.0f);
                bottom = 1.0f;
                break;
            }
            case BUTTON_POP_UP_CELL: {
                float near2 = JNRUtils.size2D(sz, 10.5, 9.5, 9.5);
                return Insetters.createFixed(0.0f, 0.0f, 0.0f, near2);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                far = 3.0f;
                near = JNRUtils.size2D(sz, 17.0f, 15.0f, 13.0f);
                break;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                near = JNRUtils.size2D(sz, 17.0f, 15.0f, 13.0f);
                break;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                near = 16.0f;
                break;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                far = 3.0f;
                bottom = 2.0f;
                near = 15.0f;
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: 
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                top = 1.0f;
                bottom = 2.0f;
                far = 2.0f;
                near = JNRUtils.size2D(sz, 17.0f, 15.0f, 13.0f);
                break;
            }
            case BUTTON_POP_DOWN: {
                far = 3.0f;
                near = JNRUtils.size2D(sz, 17.0f, 15.0f, 13.0f);
                bottom = 2.0f;
                top = 1.0f;
                break;
            }
            case BUTTON_POP_DOWN_SQUARE: {
                near = JNRUtils.size2D(sz, 18.0f, 18.0f, 16.0f);
                break;
            }
            case BUTTON_POP_DOWN_CELL: {
                float near3 = JNRUtils.size2D(sz, 13.0, 12.5, 12.0);
                return Insetters.createFixed(0.0f, 0.0f, 0.0f, near3);
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        return g.isLeftToRight() ? Insetters.createFixed(top, far, bottom, near, layoutInfo) : Insetters.createFixed(top, near, bottom, far, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getToolBarItemWellLayoutInfo(@NotNull ToolBarItemWellLayoutConfiguration g) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getTitleBarLayoutInfo(@NotNull TitleBarLayoutConfiguration g) {
        switch (g.getWidget()) {
            case DOCUMENT_WINDOW: {
                return BasicLayoutInfo.createFixedHeight(22.0f);
            }
            case UTILITY_WINDOW: {
                return BasicLayoutInfo.createFixedHeight(16.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getTitleBarButtonInsets(@NotNull TitleBarLayoutConfiguration g, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        TitleBarLayoutInfo layoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return layoutInfo.getButtonInsets(g, bw);
    }

    @Override
    @NotNull
    public Shape getTitleBarButtonShape(@NotNull Rectangle2D bounds, @NotNull TitleBarLayoutConfiguration g, @NotNull AquaUIPainter.TitleBarButtonWidget bw) {
        TitleBarLayoutInfo layoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return layoutInfo.getButtonShape(bounds, g, bw);
    }

    @Override
    @Nullable
    public Insetter getTitleBarLabelInsets(@NotNull TitleBarLayoutConfiguration g) {
        TitleBarLayoutInfo layoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return layoutInfo.getLabelInsets(g);
    }

    @Override
    @Nullable
    public AquaUIPainter.TitleBarButtonWidget identifyTitleBarButton(@NotNull Rectangle2D bounds, @NotNull TitleBarLayoutConfiguration g, int x, int y) {
        TitleBarLayoutInfo layoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return layoutInfo.identifyButton(bounds, g, x, y);
    }

    @Override
    @NotNull
    protected LayoutInfo getSliderLayoutInfo(@NotNull SliderLayoutConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        boolean hasTickMarks = g.hasTickMarks();
        switch (g.getWidget()) {
            case SLIDER_HORIZONTAL: 
            case SLIDER_HORIZONTAL_RIGHT_TO_LEFT: {
                return BasicLayoutInfo.createFixedHeight(hasTickMarks ? (float)JNRUtils.size(sz, 24, 18, 16) : (float)JNRUtils.size(sz, 18, 14, 12));
            }
            case SLIDER_VERTICAL: 
            case SLIDER_UPSIDE_DOWN: {
                return BasicLayoutInfo.createFixedWidth(hasTickMarks ? (float)JNRUtils.size(sz, 24, 18, 16) : (float)JNRUtils.size(sz, 18, 14, 12));
            }
            case SLIDER_CIRCULAR: {
                int width = hasTickMarks ? JNRUtils.size(sz, 36, 25, 25) : JNRUtils.size(sz, 28, 21, 21);
                int height = hasTickMarks ? JNRUtils.size(sz, 36, 25, 25) : JNRUtils.size(sz, 28, 21, 21);
                return BasicLayoutInfo.createFixed(width, height);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Rectangle2D getSliderThumbBounds(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, double thumbPosition) {
        Insetter insets = this.getSliderThumbInsets(g, thumbPosition);
        return insets.applyToBounds2D(bounds);
    }

    @Override
    @NotNull
    public Insetter getSliderTrackPaintingInsets(@NotNull SliderLayoutConfiguration g) {
        Insetter1 vertical;
        Insetter1 horizontal;
        float trackWidth = 3.0f;
        if (g.isHorizontal()) {
            float majorInset = JNRUtils.size(g.getSize(), 3, 1, 1);
            float minorOffset = this.getTrackOffset(g);
            horizontal = new FixedInsetter1(majorInset, majorInset);
            vertical = CenteredInsetter1.createCentered(trackWidth, minorOffset);
        } else if (g.isVertical()) {
            float majorInset = JNRUtils.size(g.getSize(), 3, 1, 1);
            float minorOffset = this.getTrackOffset(g);
            vertical = new FixedInsetter1(majorInset, majorInset);
            horizontal = CenteredInsetter1.createCentered(trackWidth, minorOffset);
        } else {
            horizontal = new FixedInsetter1(0.0f, 0.0f);
            vertical = new FixedInsetter1(0.0f, 0.0f);
        }
        return new CombinedInsetter(horizontal, vertical);
    }

    protected float getTrackOffset(@NotNull SliderLayoutConfiguration g) {
        if (g.hasTickMarks()) {
            AquaUIPainter.TickMarkPosition position = g.getTickMarkPosition();
            AquaUIPainter.Size sz = g.getSize();
            switch (position) {
                case ABOVE: 
                case LEFT: {
                    return JNRUtils.size(sz, 5, 3, 3);
                }
                case BELOW: 
                case RIGHT: {
                    return JNRUtils.size(sz, -5, -3, -3);
                }
            }
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public Insetter getSliderThumbInsets(@NotNull SliderLayoutConfiguration g, double thumbPosition) {
        return this.getSliderThumbInsets(g, thumbPosition, false);
    }

    @Override
    @NotNull
    public Insetter getSliderThumbPaintingInsets(@NotNull SliderLayoutConfiguration g, double thumbPosition) {
        return this.getSliderThumbInsets(g, thumbPosition, true);
    }

    @NotNull
    protected Insetter getSliderThumbInsets(final @NotNull SliderLayoutConfiguration g, final double thumbPosition, boolean isForPainting) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            LayoutInfo visualLayoutInfo;
            LayoutInfo layoutInfo = this.getSliderThumbLayoutInfo(g, isForPainting);
            LayoutInfo layoutInfo2 = visualLayoutInfo = isForPainting ? this.getSliderThumbLayoutInfo(g, false) : layoutInfo;
            if (g.isHorizontal()) {
                float offset = this.getPointerOffset(g);
                CenteredInsetter1 vertical = CenteredInsetter1.createCentered(layoutInfo.getFixedVisualHeight(), visualLayoutInfo.getFixedVisualHeight(), offset);
                DynamicInsetter1 horizontal = new DynamicInsetter1(layoutInfo.getFixedVisualWidth()){

                    @Override
                    protected float getCenterPosition(float componentSize) {
                        Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, componentSize, 30.0f);
                        return (float)YosemiteLayoutInfo.this.getSliderThumbCenter(bounds, g, thumbPosition);
                    }
                };
                return new CombinedInsetter(horizontal, vertical);
            }
            float offset = this.getPointerOffset(g);
            CenteredInsetter1 horizontal = CenteredInsetter1.createCentered(layoutInfo.getFixedVisualWidth(), visualLayoutInfo.getFixedVisualWidth(), offset);
            DynamicInsetter1 vertical = new DynamicInsetter1(layoutInfo.getFixedVisualHeight()){

                @Override
                protected float getCenterPosition(float componentSize) {
                    Rectangle2D.Float bounds = new Rectangle2D.Float(0.0f, 0.0f, 30.0f, componentSize);
                    return (float)YosemiteLayoutInfo.this.getSliderThumbCenter(bounds, g, thumbPosition);
                }
            };
            return new CombinedInsetter(horizontal, vertical);
        }
        return Insetters.createFixed(0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected float getPointerOffset(@NotNull SliderLayoutConfiguration g) {
        if (!g.hasTickMarks()) {
            if (g.isHorizontal()) {
                AquaUIPainter.Size sz = g.getSize();
                return JNRUtils.size2D(sz, 0.0, -0.5, 0.0);
            }
            return 0.0f;
        }
        AquaUIPainter.Size sz = g.getSize();
        switch (g.getTickMarkPosition()) {
            case LEFT: {
                return JNRUtils.size2D(sz, 2.5, 1.5, 1.5);
            }
            case RIGHT: {
                return JNRUtils.size2D(sz, -2.0, -1.5, -1.5);
            }
            case ABOVE: {
                return JNRUtils.size2D(sz, 1.5, 2.0, 2.0);
            }
            case BELOW: {
                return JNRUtils.size2D(sz, -2.0, -1.5, -1.5);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LayoutInfo getSliderThumbLayoutInfo(@NotNull SliderLayoutConfiguration g) {
        return this.getSliderThumbLayoutInfo(g, true);
    }

    @NotNull
    protected LayoutInfo getSliderThumbLayoutInfo(@NotNull SliderLayoutConfiguration g, boolean isForPainting) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return BasicLayoutInfo.createFixed(0.0f, 0.0f);
        }
        AquaUIPainter.Size sz = g.getSize();
        if (g.hasTickMarks()) {
            if (g.isHorizontal()) {
                float width = isForPainting ? (float)JNRUtils.size(sz, 17, 14, 14) : (float)JNRUtils.size(sz, 17, 13, 13);
                float height = isForPainting ? (float)JNRUtils.size(sz, 20, 14, 14) : JNRUtils.size2D(sz, 19.0f, 14.0f, 14.0f);
                return BasicLayoutInfo.createFixed(width, height);
            }
            float width = isForPainting ? (float)JNRUtils.size(sz, 19, 14, 14) : JNRUtils.size2D(sz, 19.0f, 14.0f, 14.0f);
            float height = isForPainting ? (float)JNRUtils.size(sz, 18, 14, 14) : (float)JNRUtils.size(sz, 17, 13, 13);
            return BasicLayoutInfo.createFixed(width, height);
        }
        float width = JNRUtils.size(sz, 17, 13, 13);
        float height = isForPainting ? (float)JNRUtils.size(sz, 18, 14, 14) : width;
        return BasicLayoutInfo.createFixed(width, height);
    }

    @Override
    @NotNull
    public Insetter getSliderTickMarkPaintingInsets(@NotNull SliderLayoutConfiguration g) {
        return Insetter.trivial();
    }

    @Override
    @NotNull
    public LayoutInfo getSliderTickLayoutInfo(@NotNull SliderLayoutConfiguration g) {
        if (g.isLinear() && g.hasTickMarks()) {
            AquaUIPainter.Size sz = g.getSize();
            float thickness = JNRUtils.size(sz, 2, 2, 1);
            float length = JNRUtils.size(sz, 8, 8, 7);
            if (g.isHorizontal()) {
                return BasicLayoutInfo.createFixed(thickness, length);
            }
            return BasicLayoutInfo.createFixed(length, thickness);
        }
        return BasicLayoutInfo.createFixed(0.0f, 0.0f);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderLabelBounds(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, double thumbPosition, @NotNull Dimension size) {
        double offset;
        AquaUIPainter.SliderWidget sw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.TickMarkPosition position = g.getTickMarkPosition();
        double left = bounds.getX();
        double top = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        switch (sz) {
            case SMALL: {
                offset = 6.5;
                break;
            }
            case MINI: {
                offset = 5.0;
                break;
            }
            default: {
                offset = 9.0;
            }
        }
        int separation = 2;
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            thumbPosition = 1.0 - thumbPosition;
            sw = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
        } else if (sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            thumbPosition = 1.0 - thumbPosition;
            sw = AquaUIPainter.SliderWidget.SLIDER_VERTICAL;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            double width = w - 2.0 * offset;
            double centerX = offset + thumbPosition * width;
            double topY = position == AquaUIPainter.TickMarkPosition.BELOW ? h + (double)separation : (double)(-(separation + size.height));
            double leftX = centerX - (double)(size.width / 2);
            return new Rectangle2D.Double(left + leftX, top + topY, size.width, size.height);
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            double height = h - 2.0 * offset;
            double centerY = offset + (1.0 - thumbPosition) * height;
            double leftX = position == AquaUIPainter.TickMarkPosition.RIGHT ? w + (double)separation : (double)(-(separation + size.width));
            double topY = centerY - (double)(size.height / 2);
            return new Rectangle2D.Double(left + leftX, top + topY, size.width, size.height);
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return new Rectangle2D.Double(left, top, size.width, size.height);
        }
        return new Rectangle2D.Double(left, top, 0.0, 0.0);
    }

    @Override
    public double getSliderThumbCenter(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, double thumbPosition) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = bounds.getX();
        double top = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double extension = this.getSliderExtension(sz);
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            thumbPosition = 1.0 - thumbPosition;
            sw = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
        } else if (sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            thumbPosition = 1.0 - thumbPosition;
            sw = AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            double width = w - 2.0 * extension;
            return left + extension + thumbPosition * width;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            double height = h - 2.0 * extension;
            return top + extension + thumbPosition * height;
        }
        return 0.0;
    }

    @Override
    public double getSliderThumbPosition(@NotNull Rectangle2D bounds, @NotNull SliderLayoutConfiguration g, int x, int y) {
        AquaUIPainter.SliderWidget sw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        double left = bounds.getX();
        double top = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        double extension = this.getSliderExtension(sz);
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            if ((double)x < (left += extension)) {
                return -10.0;
            }
            double right = left + w - 2.0 * extension;
            if ((double)x > right) {
                return 10.0;
            }
            double range = right - left;
            if (range == 0.0) {
                return 0.0;
            }
            return ((double)x - left) / range;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            if ((double)x < (left += extension)) {
                return 10.0;
            }
            double right = left + w - 2.0 * extension;
            if ((double)x > right) {
                return -10.0;
            }
            double range = right - left;
            if (range == 0.0) {
                return 0.0;
            }
            return 1.0 - ((double)x - left) / range;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            if ((double)y < (top += extension)) {
                return 10.0;
            }
            double bottom = top + h - 2.0 * extension;
            if ((double)y > bottom) {
                return -10.0;
            }
            double range = bottom - top;
            if (range == 0.0) {
                return 0.0;
            }
            return 1.0 - ((double)y - top) / range;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            if ((double)y < (top += extension)) {
                return -10.0;
            }
            double bottom = top + h - 2.0 * extension;
            if ((double)y > bottom) {
                return 10.0;
            }
            double range = bottom - top;
            if (range == 0.0) {
                return 0.0;
            }
            return ((double)y - top) / range;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            double xcenter = left + w / 2.0;
            double ycenter = top + h / 2.0;
            double angle = Math.atan2((double)y - ycenter, (double)x - xcenter);
            if ((angle += 1.5707963267948966) < 0.0) {
                angle += Math.PI * 2;
            }
            return angle / (Math.PI * 2);
        }
        return 0.0;
    }

    protected double getSliderExtension(@NotNull AquaUIPainter.Size sz) {
        switch (sz) {
            case MINI: {
                return 5.5;
            }
            case SMALL: {
                return 6.5;
            }
        }
        return 10.0;
    }

    @Override
    @NotNull
    protected LayoutInfo getSpinnerArrowsLayoutInfo(@NotNull SpinnerArrowsLayoutConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        int width = JNRUtils.size(sz, 13, 11, 9);
        int height = JNRUtils.size(sz, 23, 20, 16);
        return BasicLayoutInfo.createFixed(width, height);
    }

    @Override
    @NotNull
    protected LayoutInfo getSplitPaneDividerLayoutInfo(@NotNull SplitPaneDividerLayoutConfiguration g) {
        int d;
        AquaUIPainter.Orientation o = g.getOrientation();
        switch (g.getWidget()) {
            case THIN_DIVIDER: {
                d = 1;
                break;
            }
            case THICK_DIVIDER: {
                d = 9;
                break;
            }
            case PANE_SPLITTER: {
                d = 10;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return o == AquaUIPainter.Orientation.HORIZONTAL ? BasicLayoutInfo.createFixedHeight(d) : BasicLayoutInfo.createFixedWidth(d);
    }

    @Override
    @NotNull
    protected LayoutInfo getGroupBoxLayoutInfo(@NotNull GroupBoxLayoutConfiguration g) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getListBoxLayoutInfo(@NotNull ListBoxLayoutConfiguration g) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getTextFieldLayoutInfo(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (w.isRound() || w.isSearch()) {
            if (w.isToolbar()) {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(g.getSize(), 23, 19, 16));
            }
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(g.getSize(), 22, 19, 17));
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    public Insetter getTextFieldTextInsets(@NotNull TextFieldLayoutConfiguration g) {
        float bottom;
        float top;
        float right;
        float left;
        AquaUIPainter.TextFieldWidget tw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        int d = 0;
        float gap = 6.0f;
        if (tw.isSearch()) {
            Insetter insets;
            if (tw.hasMenu()) {
                d = 4;
                gap = 3.5f;
            }
            if (g.isLeftToRight()) {
                insets = this.getSearchButtonPaintingInsets(g);
                if (insets != null) {
                    Rectangle2D bounds = insets.apply2D(100.0, 100.0);
                    left = (float)(bounds.getX() + bounds.getWidth() + (double)gap);
                } else {
                    left = JNRUtils.size(sz, 27 + d, 26 + d, 22 + d);
                }
                right = JNRUtils.size(sz, 22, 19, 16);
            } else {
                insets = this.getSearchButtonPaintingInsets(g);
                if (insets != null) {
                    Rectangle2D bounds = insets.apply2D(100.0, 100.0);
                    right = (float)(100.0 - bounds.getX() + (double)gap);
                } else {
                    right = JNRUtils.size(sz, 27 + d, 26 + d, 22 + d);
                }
                left = JNRUtils.size(sz, 22, 19, 16);
            }
            if (tw.isToolbar()) {
                top = JNRUtils.size2D(sz, 3.0, 1.5, 1.5);
                bottom = JNRUtils.size2D(sz, 3.0, 2.0, 1.5);
            } else {
                top = JNRUtils.size2D(sz, 3.0, 1.5, 1.5);
                bottom = JNRUtils.size2D(sz, 3.0, 1.5, 1.5);
            }
        } else {
            switch (tw) {
                case TEXT_FIELD: {
                    right = 1.0f;
                    left = 1.0f;
                    bottom = 1.0f;
                    top = 1.0f;
                    break;
                }
                case TEXT_FIELD_ROUND: {
                    top = 1.0f;
                    bottom = 1.0f;
                    right = 2.5f;
                    left = 2.5f;
                    break;
                }
                case TEXT_FIELD_ROUND_TOOLBAR: {
                    top = 1.0f;
                    bottom = 2.0f;
                    right = 2.5f;
                    left = 2.5f;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(g);
        return Insetters.createFixed(top, left, bottom, right, layoutInfo);
    }

    @Override
    @Nullable
    public Insetter getSearchButtonInsets(@NotNull TextFieldLayoutConfiguration g) {
        float d = 0.0f;
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (w.isSearch()) {
            if (w.hasMenu()) {
                d = 4.0f;
            }
            float h = JNRUtils.size(g.getSize(), 27, 26, 22);
            return g.isLeftToRight() ? Insetters.createLeftAligned(d, 0.0f, 0.0f, 0.0f) : Insetters.createRightAligned(d += h, 0.0f, 0.0f, 0.0f);
        }
        return null;
    }

    @Override
    @Nullable
    public Insetter getSearchButtonPaintingInsets(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        float buttonHeight = JNRUtils.size(g.getSize(), 22, 19, 17);
        LayoutInfo layoutInfo = this.getSearchButtonLayoutInfo(g);
        if (layoutInfo != null) {
            float width = layoutInfo.getFixedVisualWidth();
            float height = layoutInfo.getFixedVisualHeight();
            if (width > 0.0f && height > 0.0f) {
                float top = JNRUtils.size2D(sz, 5.0, 4.0, 4.5);
                float left = JNRUtils.size2D(sz, 6.5, 6.0, 5.5);
                float bottom = buttonHeight - top - height;
                FloatingInsetter1 horizontal = g.isLeftToRight() ? FloatingInsetter1.createLeftTopAligned(width, left) : FloatingInsetter1.createRightBottomAligned(width, left);
                FloatingInsetter1 vertical = FloatingInsetter1.createCentered(height, top, bottom);
                return new CombinedInsetter(horizontal, vertical);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public LayoutInfo getSearchButtonLayoutInfo(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (!w.isSearch()) {
            return null;
        }
        boolean hasMenu = w.hasMenu();
        AquaUIPainter.Size sz = g.getSize();
        float height = JNRUtils.size2D(sz, 13.0f, 12.0f, 10.0f);
        float width = hasMenu ? JNRUtils.size2D(sz, 17.0f, 16.0f, 14.0f) : height;
        return BasicLayoutInfo.createFixed(width, height);
    }

    @Override
    @Nullable
    public Insetter getCancelButtonInsets(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (w.hasCancel()) {
            AquaUIPainter.Size sz = g.getSize();
            float d = JNRUtils.size(sz, 14, 11, 9);
            float right = JNRUtils.size(sz, 4, 4, 3);
            return g.isLeftToRight() ? Insetters.createRightAligned(d, right, 0.0f, 0.0f) : Insetters.createLeftAligned(d, right, 0.0f, 0.0f);
        }
        return null;
    }

    @Override
    @Nullable
    public Insetter getCancelButtonPaintingInsets(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.Size sz = g.getSize();
        float buttonHeight = JNRUtils.size(g.getSize(), 22, 19, 17);
        LayoutInfo layoutInfo = this.getCancelButtonLayoutInfo(g);
        if (layoutInfo != null) {
            float width = layoutInfo.getFixedVisualWidth();
            float height = layoutInfo.getFixedVisualHeight();
            if (width > 0.0f && height > 0.0f) {
                float top = JNRUtils.size(sz, 4, 4, 4);
                float right = JNRUtils.size(sz, 4, 4, 3);
                float bottom = buttonHeight - top - height;
                FloatingInsetter1 horizontal = g.isLeftToRight() ? FloatingInsetter1.createRightBottomAligned(width, right) : FloatingInsetter1.createLeftTopAligned(width, right);
                FloatingInsetter1 vertical = FloatingInsetter1.createCentered(height, top, bottom);
                return new CombinedInsetter(horizontal, vertical);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public LayoutInfo getCancelButtonLayoutInfo(@NotNull TextFieldLayoutConfiguration g) {
        AquaUIPainter.TextFieldWidget w = g.getWidget();
        if (w.hasCancel()) {
            AquaUIPainter.Size sz = g.getSize();
            float d = JNRUtils.size(sz, 14, 11, 9);
            return BasicLayoutInfo.createFixed(d, d);
        }
        return null;
    }

    @Override
    @NotNull
    protected LayoutInfo getScrollBarLayoutInfo(@NotNull ScrollBarLayoutConfiguration g) {
        AquaUIPainter.ScrollBarWidget bw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        AquaUIPainter.Orientation o = g.getOrientation();
        int d = 0;
        block0 : switch (bw) {
            case LEGACY: {
                switch (sz) {
                    case REGULAR: 
                    case LARGE: {
                        d = 15;
                        break;
                    }
                    case SMALL: 
                    case MINI: {
                        d = 11;
                    }
                }
                break;
            }
            case OVERLAY: {
                switch (sz) {
                    case REGULAR: 
                    case LARGE: {
                        d = 12;
                        break;
                    }
                    case SMALL: 
                    case MINI: {
                        d = 10;
                    }
                }
                break;
            }
            case OVERLAY_ROLLOVER: {
                switch (sz) {
                    case REGULAR: 
                    case LARGE: {
                        d = 16;
                        break block0;
                    }
                    case SMALL: 
                    case MINI: {
                        d = 14;
                    }
                }
            }
        }
        return o == AquaUIPainter.Orientation.VERTICAL ? BasicLayoutInfo.createFixedWidth(d) : BasicLayoutInfo.createFixedHeight(d);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull Rectangle2D bounds, @NotNull ScrollBarThumbLayoutConfiguration g, boolean useExtent) {
        double e = this.getScrollTrackEndInset(g);
        boolean isVertical = g.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        double top = isVertical ? bounds.getY() + e : bounds.getX() + e;
        double height = isVertical ? bounds.getHeight() - 2.0 * e : bounds.getWidth() - 2.0 * e;
        double fullRange = useExtent ? height - this.getVisualThumbExtent(bounds, g) : height;
        double result = ((double)g.getValue() - top) / fullRange;
        if (result >= 0.0) {
            if (result <= 1.0) {
                return (float)result;
            }
            return 10.0f;
        }
        return -10.0f;
    }

    @Override
    @NotNull
    public Rectangle2D getScrollBarThumbBounds(@NotNull Rectangle2D bounds, @NotNull ScrollBarConfiguration g) {
        LinearBounds tb = this.getThumbBounds(bounds, g);
        if (g.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            return new Rectangle2D.Double(bounds.getX(), tb.getOrigin(), bounds.getWidth(), tb.getLength());
        }
        return new Rectangle2D.Double(tb.getOrigin(), bounds.getY(), tb.getLength(), bounds.getHeight());
    }

    @NotNull
    protected LinearBounds getThumbBounds(@NotNull Rectangle2D bounds, @NotNull ScrollBarConfiguration g) {
        double e = this.getScrollTrackEndInset(g);
        int minimumThumbLength = this.getMinimumThumbLength(g);
        boolean isVertical = g.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        double trackOrigin = isVertical ? bounds.getY() + e : bounds.getX() + e;
        double trackLength = isVertical ? bounds.getHeight() - 2.0 * e : bounds.getWidth() - 2.0 * e;
        double actualExtent = Math.max((double)minimumThumbLength, (double)g.getThumbExtent() * trackLength);
        double scrollingRange = Math.max(0.0, trackLength - actualExtent);
        double thumbOrigin = trackOrigin + (double)g.getThumbPosition() * scrollingRange;
        return new LinearBounds(thumbOrigin, actualExtent);
    }

    protected double getVisualThumbExtent(@NotNull Rectangle2D bounds, @NotNull ScrollBarThumbLayoutConfiguration g) {
        double e = this.getScrollTrackEndInset(g);
        boolean isVertical = g.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        double trackLength = isVertical ? bounds.getHeight() - 2.0 * e : bounds.getWidth() - 2.0 * e;
        int minimumThumbLength = this.getMinimumThumbLength(g);
        return Math.max((double)minimumThumbLength, (double)g.getThumbExtent() * trackLength);
    }

    protected int getMinimumThumbLength(@NotNull ScrollBarLayoutConfiguration g) {
        switch (g.getSize()) {
            case SMALL: 
            case MINI: {
                return 14;
            }
        }
        return 18;
    }

    protected double getScrollTrackEndInset(@NotNull ScrollBarLayoutConfiguration g) {
        switch (g.getWidget()) {
            case LEGACY: {
                return 3.0;
            }
        }
        return 2.0;
    }

    @Override
    public int getScrollBarThumbHit(@NotNull Rectangle2D bounds, @NotNull ScrollBarThumbConfiguration g) {
        boolean isVertical;
        int c = g.getValue();
        boolean bl = isVertical = g.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        if (isVertical ? (double)c < bounds.getY() || (double)c > bounds.getY() + bounds.getHeight() : (double)c < bounds.getX() || (double)c > bounds.getX() + bounds.getWidth()) {
            return -1000;
        }
        LinearBounds tb = this.getThumbBounds(bounds, g);
        if ((double)c < tb.getOrigin()) {
            return -1;
        }
        if ((double)c > tb.getOrigin() + tb.getLength()) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    protected LayoutInfo getScrollColumnSizerLayoutInfo(@NotNull ScrollColumnSizerLayoutConfiguration g) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getProgressIndicatorLayoutInfo(@NotNull ProgressIndicatorLayoutConfiguration g) {
        AquaUIPainter.ProgressWidget pw = g.getWidget();
        AquaUIPainter.Orientation o = g.getOrientation();
        AquaUIPainter.Size sz = g.getSize();
        if (pw == AquaUIPainter.ProgressWidget.BAR || pw == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR) {
            if (o == AquaUIPainter.Orientation.HORIZONTAL) {
                return BasicLayoutInfo.createFixedHeight(6.0f);
            }
            return BasicLayoutInfo.createFixedWidth(6.0f);
        }
        if (pw == AquaUIPainter.ProgressWidget.SPINNER || pw == AquaUIPainter.ProgressWidget.INDETERMINATE_SPINNER) {
            int d = JNRUtils.size(sz, 32, 16, 12);
            return BasicLayoutInfo.createFixed(d, d);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected LayoutInfo getTableColumnHeaderLayoutInfo(@NotNull TableColumnHeaderLayoutConfiguration g) {
        int minWidth = g.isSortable() ? 31 : 0;
        return BasicLayoutInfo.createMinimum(minWidth, 15.0f);
    }

    @Override
    @Nullable
    public Insetter getTableColumnHeaderSortArrowInsets(@NotNull TableColumnHeaderLayoutConfiguration g) {
        int width = this.getTableHeaderSortIndicatorWidth(g);
        boolean top = true;
        int arrowSide = 7;
        return g.isLeftToRight() ? Insetters.createRightAligned(width, arrowSide, (float)top, (float)top) : Insetters.createLeftAligned(width, arrowSide, (float)top, (float)top);
    }

    @Override
    @NotNull
    public Insetter getTableColumnHeaderLabelInsets(@NotNull TableColumnHeaderLayoutConfiguration g) {
        int arrowSide = 7 + this.getTableHeaderSortIndicatorWidth(g);
        boolean top = true;
        int side = 3;
        return g.isLeftToRight() ? Insetters.createFixed((float)top, side, (float)top, arrowSide) : Insetters.createFixed((float)top, arrowSide, (float)top, side);
    }

    protected int getTableHeaderSortIndicatorWidth(@NotNull TableColumnHeaderLayoutConfiguration g) {
        return g.isSortable() ? 11 : 0;
    }
}

