/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.impl.Colors;
import org.violetlib.jnr.impl.PainterExtension;
import org.violetlib.vappearances.VAppearance;

public class RoundToolbarButtonPainterExtension
implements PainterExtension {
    @NotNull
    protected final ButtonConfiguration bg;
    @Nullable
    protected final VAppearance appearance;
    @NotNull
    protected final Colors colors;

    public RoundToolbarButtonPainterExtension(@NotNull ButtonConfiguration g, @Nullable VAppearance appearance) {
        this.bg = g;
        this.appearance = appearance;
        this.colors = Colors.getColors(appearance);
    }

    @Override
    public void paint(@NotNull Graphics2D g, float width, float height) {
        AquaUIPainter.State state = this.bg.getState();
        AquaUIPainter.ButtonState buttonState = this.bg.getButtonState();
        boolean isFilled = state == AquaUIPainter.State.PRESSED || buttonState == AquaUIPainter.ButtonState.ON || buttonState == AquaUIPainter.ButtonState.MIXED;
        double x = (double)width / 2.0;
        double y = (double)height / 2.0;
        double diameter = height - 2.0f;
        double radius = diameter / 2.0;
        Color c = this.getColor();
        Ellipse2D.Double s = new Ellipse2D.Double(x - radius, y - radius, diameter, diameter);
        g.setColor(c);
        if (isFilled) {
            g.fill(s);
        } else {
            g.setStroke(new BasicStroke(2.0f));
            g.draw(s);
        }
    }

    @NotNull
    protected Color getColor() {
        String colorName = "toolbarButton";
        AquaUIPainter.State state = this.bg.getState();
        AquaUIPainter.ButtonState buttonState = this.bg.getButtonState();
        if (buttonState == AquaUIPainter.ButtonState.ON || buttonState == AquaUIPainter.ButtonState.MIXED) {
            colorName = colorName + "Selected";
        }
        if (state == AquaUIPainter.State.PRESSED) {
            colorName = colorName + "Pressed";
        }
        return this.colors.get(colorName);
    }
}

