/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.impl.ImageCache;
import org.violetlib.vappearances.VAppearance;

public class AquaPixelsKey
implements ImageCache.PixelsKey {
    private final int pixelCount;
    private final int hash;
    private final int scaleFactor;
    private final int w;
    private final int h;
    @NotNull
    private final Configuration g;
    @NotNull
    private final VAppearance appearance;

    public AquaPixelsKey(int scaleFactor, int w, int h, @NotNull Configuration g, @NotNull VAppearance appearance) {
        this.pixelCount = w * h;
        this.scaleFactor = scaleFactor;
        this.w = w;
        this.h = h;
        this.g = g;
        this.appearance = appearance;
        this.hash = this.hash();
    }

    @Override
    public int getPixelCount() {
        return this.pixelCount;
    }

    private int hash() {
        int hash = this.scaleFactor;
        hash = 31 * hash + this.w;
        hash = 31 * hash + this.h;
        hash = 31 * hash + this.g.hashCode();
        hash = 31 * hash + this.appearance.hashCode();
        return hash;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj != null && obj.getClass() == AquaPixelsKey.class) {
            AquaPixelsKey that = (AquaPixelsKey)obj;
            return this.scaleFactor == that.scaleFactor && this.w == that.w && this.h == that.h && this.g.equals(that.g) && this.appearance.equals(that.appearance);
        }
        return false;
    }
}

