/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.ComboBoxConfiguration;
import org.violetlib.jnr.aqua.Configuration;
import org.violetlib.jnr.aqua.GradientConfiguration;
import org.violetlib.jnr.aqua.GroupBoxConfiguration;
import org.violetlib.jnr.aqua.IndeterminateProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ListBoxConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.TextFieldConfiguration;
import org.violetlib.jnr.aqua.TitleBarConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativeSegmentedControlPainter;
import org.violetlib.jnr.aqua.impl.AquaUIPainterBase;
import org.violetlib.jnr.aqua.impl.NativeSupport;
import org.violetlib.jnr.aqua.impl.SliderTickConfiguration;
import org.violetlib.jnr.aqua.impl.TitleBarLayoutInfo;
import org.violetlib.jnr.aqua.impl.ViewRendererDescriptions;
import org.violetlib.jnr.impl.BasicRenderer;
import org.violetlib.jnr.impl.JNRPlatformUtils;
import org.violetlib.jnr.impl.Renderer;
import org.violetlib.jnr.impl.RendererDebugInfo;
import org.violetlib.jnr.impl.RendererDescription;
import org.violetlib.vappearances.VAppearance;

public class AquaNativePainter
extends AquaUIPainterBase
implements AquaUIPainter {
    protected static final int NSRoundedBezelStyle = 1;
    protected static final int NSRegularSquareBezelStyle = 2;
    protected static final int NSThickSquareBezelStyle = 3;
    protected static final int NSThickerSquareBezelStyle = 4;
    protected static final int NSDisclosureBezelStyle = 5;
    protected static final int NSShadowlessSquareBezelStyle = 6;
    protected static final int NSCircularBezelStyle = 7;
    protected static final int NSTexturedSquareBezelStyle = 8;
    protected static final int NSHelpButtonBezelStyle = 9;
    protected static final int NSSmallSquareBezelStyle = 10;
    protected static final int NSTexturedRoundedBezelStyle = 11;
    protected static final int NSRoundRectBezelStyle = 12;
    protected static final int NSRecessedBezelStyle = 13;
    protected static final int NSRoundedDisclosureBezelStyle = 14;
    protected static final int NSInlineBezelStyle = 15;
    protected static final int NSCircularBezelStyle_Toolbar = 1007;
    protected static final int NSTexturedRoundedBezelStyle_Toolbar = 1011;
    protected static final int NSMomentaryLightButton = 0;
    protected static final int NSPushOnPushOffButton = 1;
    protected static final int NSToggleButton = 2;
    protected static final int NSSwitchButton = 3;
    protected static final int NSRadioButton = 4;
    protected static final int NSMomentaryChangeButton = 5;
    protected static final int NSOnOffButton = 6;
    protected static final int NSMomentaryPushInButton = 7;
    protected static final int NSAcceleratorButton = 8;
    protected static final int NSMultiLevelAcceleratorButton = 9;
    protected static final int NSGradientNone = 0;
    protected static final int NSGradientConcaveWeak = 1;
    protected static final int NSGradientConcaveStrong = 2;
    protected static final int NSGradientConvexWeak = 3;
    protected static final int NSGradientConvexStrong = 4;
    protected static final int TextFieldNormal = 0;
    protected static final int TextFieldRound = 1;
    protected static final int TextFieldSearch = 2;
    protected static final int TextFieldSearchWithCancel = 3;
    protected static final int TextFieldSearchWithMenu = 4;
    protected static final int TextFieldSearchWithMenuAndCancel = 5;
    protected static final int TextFieldRound_Toolbar = 1001;
    protected static final int TextFieldSearch_Toolbar = 1002;
    protected static final int TextFieldSearchWithCancel_Toolbar = 1003;
    protected static final int TextFieldSearchWithMenu_Toolbar = 1004;
    protected static final int TextFieldSearchWithMenuAndCancel_Toolbar = 1005;
    protected static final int NSSegmentStyleAutomatic = 0;
    protected static final int NSSegmentStyleRounded = 1;
    protected static final int NSSegmentStyleTexturedRounded = 2;
    protected static final int NSSegmentStyleRoundRect = 3;
    protected static final int NSSegmentStyleTexturedSquare = 4;
    protected static final int NSSegmentStyleCapsule = 5;
    protected static final int NSSegmentStyleSmallSquare = 6;
    protected static final int NSSegmentStyleSeparated = 8;
    protected static final int NSSegmentStyleSeparated_Rounded = 80;
    protected static final int NSSegmentStyleSeparated_Textured = 81;
    protected static final int NSSegmentStyleSlider = 82;
    protected static final int NSSegmentStyleTexturedSquare_Toolbar = 1004;
    protected static final int NSSegmentStyleSeparated_Toolbar = 1081;
    protected static final int NSSegmentSwitchTrackingSelectOne = 0;
    protected static final int NSSegmentSwitchTrackingSelectAny = 1;
    protected static final int NSNoTitle = 0;
    protected static final int NSAboveTop = 1;
    protected static final int NSAtTop = 2;
    protected static final int NSBelowTop = 3;
    protected static final int NSAboveBottom = 4;
    protected static final int NSAtBottom = 5;
    protected static final int NSBelowBottom = 6;
    protected static final int NSLinearSlider = 0;
    protected static final int NSCircularSlider = 1;
    protected static final int NSLinearSliderRightToLeft = 1002;
    protected static final int NSLinearSliderUpsideDown = 1003;
    protected static final int NSTickMarkBelow = 0;
    protected static final int NSTickMarkAbove = 1;
    protected static final int NSTickMarkLeft = 1;
    protected static final int NSTickMarkRight = 0;
    protected static final int NSSplitViewDividerStyleThick = 1;
    protected static final int NSSplitViewDividerStyleThin = 2;
    protected static final int NSSplitViewDividerStylePaneSplitter = 3;
    protected static final int ActiveState = 0;
    protected static final int InactiveState = 1;
    protected static final int DisabledState = 2;
    protected static final int PressedState = 3;
    protected static final int DefaultState = 4;
    protected static final int RolloverState = 5;
    protected static final int DisabledInactiveState = 6;
    protected static final int DocumentWindowType = 0;
    protected static final int UtilityWindowType = 1;
    protected static final int LegacyScrollBar = 0;
    protected static final int OverlayScrollBar = 1;
    protected static final int RolloverOverlayScrollBar = 2;
    @Nullable
    protected static TitleBarLayoutInfo titleBarLayoutInfo;
    @NotNull
    private static final ViewRendererDescriptions rendererDescriptions;
    @NotNull
    protected final AquaNativeSegmentedControlPainter segmentedControlPainter = new AquaNativeSegmentedControlPainter();

    @NotNull
    public static TitleBarLayoutInfo getTitleBarLayoutInfo() {
        if (titleBarLayoutInfo == null) {
            titleBarLayoutInfo = AquaNativePainter.obtainTitleBarLayoutInfo();
        }
        return titleBarLayoutInfo;
    }

    public AquaNativePainter() {
        super(rendererDescriptions);
    }

    @Override
    @NotNull
    public AquaNativePainter copy() {
        return new AquaNativePainter();
    }

    @Override
    public void configureAppearance(@NotNull VAppearance appearance) {
        super.configureAppearance(appearance);
        AquaNativePainter.configureNativeAppearance(appearance);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration g) {
        AquaUIPainter.ButtonWidget widget = g.getButtonWidget();
        AquaUIPainter.State st = g.getState();
        AquaUIPainter.ButtonState bs = g.getButtonState();
        if (widget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            if (bs != AquaUIPainter.ButtonState.ON) {
                return NULL_RENDERER;
            }
            ToolBarItemWellConfiguration tg = new ToolBarItemWellConfiguration(st, false);
            return this.getToolBarItemWellRenderer(tg);
        }
        RendererDescription rd = rendererDescriptions.getButtonRendererDescription(g);
        if (widget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            int state = AquaNativePainter.toState(st);
            BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintColorWell(data, rw, rh, w, h, state);
            return Renderer.create(r, rd);
        }
        if (widget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED && !this.shouldPaintRecessedBackground(st, bs)) {
            return NULL_RENDERER;
        }
        AquaUIPainter.ButtonWidget bw = this.toCanonicalButtonStyle(widget);
        int size = AquaNativePainter.toSize(g.getSize());
        int state = AquaNativePainter.toState(st);
        int value = this.toButtonValue(bs);
        int buttonType = this.toButtonType(bw);
        int bezelStyle = this.toBezelStyle(bw);
        int uiLayoutDirection = this.toUILayoutDirection(g.getLayoutDirection());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintButton(data, rw, rh, w, h, buttonType, bezelStyle, size, state, g.isFocused(), value, uiLayoutDirection);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getScrollColumnSizerRenderer(@NotNull ScrollColumnSizerConfiguration g) {
        RendererDescription rd = rendererDescriptions.getScrollColumnSizerRendererDescription(g);
        return Renderer.createCompositeRenderer(new Renderer[0]);
    }

    @Override
    @NotNull
    protected Renderer getScrollBarRenderer(@NotNull ScrollBarConfiguration g) {
        RendererDescription rd = rendererDescriptions.getScrollBarRendererDescription(g);
        AquaUIPainter.ScrollBarWidget bw = g.getWidget();
        if (bw == AquaUIPainter.ScrollBarWidget.OVERLAY || bw == AquaUIPainter.ScrollBarWidget.OVERLAY_ROLLOVER) {
            throw new UnsupportedOperationException();
        }
        int type = AquaNativePainter.toScrollBarType(bw);
        int size = AquaNativePainter.toSize(g.getSize());
        int state = AquaNativePainter.toState(g.getState());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintScrollBar(data, rw, rh, w, h, type, size, state, g.getThumbPosition(), g.getThumbExtent());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getToolBarItemWellRenderer(@NotNull ToolBarItemWellConfiguration g) {
        RendererDescription rd = rendererDescriptions.getToolBarItemWellRendererDescription(g);
        int state = AquaNativePainter.toState(g.getState());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintToolBarItemWell(data, rw, rh, w, h, state, g.isFrameOnly());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getGroupBoxRenderer(@NotNull GroupBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getGroupBoxRendererDescription(g);
        int state = AquaNativePainter.toState(g.getState());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintGroupBox(data, rw, rh, w, h, 0, state, g.isFrameOnly());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getListBoxRenderer(@NotNull ListBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getListBoxRendererDescription(g);
        int state = AquaNativePainter.toState(g.getState());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintListBox(data, rw, rh, w, h, state, g.isFocused(), g.isFrameOnly());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getTextFieldRenderer(@NotNull TextFieldConfiguration g) {
        int type;
        RendererDescription rd = rendererDescriptions.getTextFieldRendererDescription(g);
        switch (g.getWidget()) {
            case TEXT_FIELD: {
                type = 0;
                break;
            }
            case TEXT_FIELD_ROUND: {
                type = 1;
                break;
            }
            case TEXT_FIELD_SEARCH: {
                type = 2;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_CANCEL: {
                type = 3;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU: {
                type = 4;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                type = 5;
                break;
            }
            case TEXT_FIELD_ROUND_TOOLBAR: {
                type = 1001;
                break;
            }
            case TEXT_FIELD_SEARCH_TOOLBAR: {
                type = 1002;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_CANCEL_TOOLBAR: {
                type = 1003;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU_TOOLBAR: {
                type = 1004;
                break;
            }
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL_TOOLBAR: {
                type = 1005;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int size = AquaNativePainter.toSize(g.getSize());
        int state = AquaNativePainter.toState(g.getState());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintTextField(data, rw, rh, w, h, size, state, type);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getComboBoxButtonRenderer(@NotNull ComboBoxConfiguration g) {
        RendererDescription rd = rendererDescriptions.getComboBoxRendererDescription(g);
        int size = AquaNativePainter.toSize(g.getSize());
        int state = AquaNativePainter.toState(g.getState());
        int type = this.toComboBoxType(g.getWidget());
        int bezel = this.toBezelStyle(g.getWidget());
        int ld = this.toUILayoutDirection(g.getLayoutDirection());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintComboBox(data, rw, rh, w, h, type, size, state, bezel, ld);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getPopupButtonRenderer(@NotNull PopupButtonConfiguration g) {
        RendererDescription rd = rendererDescriptions.getPopupButtonRendererDescription(g);
        AquaUIPainter.PopupButtonWidget bw = g.getPopupButtonWidget();
        boolean isUp = g.isPopUp();
        int size = AquaNativePainter.toSize(g.getSize());
        int state = AquaNativePainter.toState(g.getState());
        int ld = this.toUILayoutDirection(g.getLayoutDirection());
        int bezelStyle = this.toBezelStyle(bw);
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintPopUpButton(data, rw, rh, w, h, isUp, size, state, bezelStyle, ld);
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getTitleBarRenderer(@NotNull TitleBarConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTitleBarRendererDescription(g);
        int windowType = AquaNativePainter.toWindowType(g.getWidget());
        int state = this.toActiveState(g.getTitleBarState());
        int closeState = AquaNativePainter.toState(g.getCloseButtonState());
        int minimizeState = AquaNativePainter.toState(g.getMinimizeButtonState());
        int resizeState = AquaNativePainter.toState(g.getResizeButtonState());
        TitleBarConfiguration.ResizeAction resizeAction = g.getResizeAction();
        boolean isFullScreen = resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_ENTER || resizeAction == TitleBarConfiguration.ResizeAction.FULL_SCREEN_EXIT;
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintTitleBar(data, rw, rh, w, h, windowType, state, closeState, minimizeState, resizeState, isFullScreen, g.isDirty());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getIndeterminateProgressIndicatorRenderer(@NotNull IndeterminateProgressIndicatorConfiguration g) {
        RendererDescription rd = rendererDescriptions.getIndeterminateProgressIndicatorRendererDescription(g);
        boolean isSpinner = g.getWidget() == AquaUIPainter.ProgressWidget.INDETERMINATE_SPINNER;
        AquaUIPainter.Size sz = g.getSize();
        if (isSpinner && sz != AquaUIPainter.Size.SMALL) {
            sz = AquaUIPainter.Size.LARGE;
        }
        int size = AquaNativePainter.toSize(sz);
        int state = AquaNativePainter.toState(g.getState());
        int orientation = this.toOrientation(g.getOrientation());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintIndeterminateProgressIndicator(data, rw, rh, w, h, size, state, orientation, isSpinner, g.getAnimationFrame());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getProgressIndicatorRenderer(@NotNull ProgressIndicatorConfiguration g) {
        RendererDescription rd = rendererDescriptions.getProgressIndicatorRendererDescription(g);
        boolean isSpinner = g.getWidget() == AquaUIPainter.ProgressWidget.SPINNER;
        AquaUIPainter.Size sz = g.getSize();
        if (isSpinner && sz != AquaUIPainter.Size.SMALL) {
            sz = AquaUIPainter.Size.LARGE;
        }
        int size = AquaNativePainter.toSize(g.getSize());
        int state = this.toActiveState(g.getState());
        int orientation = this.toOrientation(g.getOrientation());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintProgressIndicator(data, rw, rh, w, h, size, state, orientation, g.getValue());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSliderRendererDescription(g);
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        AquaUIPainter.SliderWidget sw = g.getWidget();
        AquaUIPainter.Size sz = g.getSize();
        if (g.getSize() == AquaUIPainter.Size.MINI && platformVersion < 101400) {
            sz = AquaUIPainter.Size.SMALL;
        }
        if (sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL || sw == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            if (this.h >= this.w) {
                this.h = Math.max(0, this.w - 1);
            }
        } else if (sw == AquaUIPainter.SliderWidget.SLIDER_VERTICAL || sw == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            if (this.w >= this.h) {
                this.w = Math.max(0, this.h - 1);
            }
            this.forceVertical = true;
        }
        int sliderType = this.toSliderType(sw);
        int size = AquaNativePainter.toSize(sz);
        int state = AquaNativePainter.toState(g.getState());
        int position = this.toTickMarkPosition(g.getTickMarkPosition());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintSlider(data, rw, rh, w, h, sliderType, size, state, g.isFocused(), g.getValue(), g.getNumberOfTickMarks(), position);
        return Renderer.create(r, rd);
    }

    @NotNull
    protected Shape getSliderThumbOutline(@NotNull Rectangle2D bounds, @NotNull SliderThumbLayoutConfiguration g) {
        SliderLayoutConfiguration sg = g.getSliderLayoutConfiguration();
        double thumbPosition = g.getThumbPosition();
        double x = bounds.getX();
        double y = bounds.getY();
        double w = bounds.getWidth();
        double h = bounds.getHeight();
        AquaUIPainter.SliderWidget sw = sg.getWidget();
        if (sw == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            int sliderType = this.toSliderType(sw);
            int size = AquaNativePainter.toSize(sg.getSize());
            int position = this.toTickMarkPosition(sg.getTickMarkPosition());
            float[] a = new float[4];
            int width = (int)Math.ceil(w);
            int height = (int)Math.ceil(h);
            AquaNativePainter.nativeGetSliderThumbBounds(a, width, height, sliderType, size, thumbPosition, sg.getNumberOfTickMarks(), position);
            float tx = a[0];
            float ty = a[1];
            float tw = a[2];
            float th = a[3];
            return new Rectangle2D.Double(tx, ty, tw, th);
        }
        return super.getOutline(bounds, g);
    }

    @Override
    @NotNull
    protected Renderer getSliderThumbRenderer(@NotNull SliderConfiguration g) {
        return NULL_RENDERER;
    }

    @Override
    @NotNull
    protected Renderer getSliderTickRenderer(@NotNull SliderTickConfiguration g) {
        return NULL_RENDERER;
    }

    @Override
    @NotNull
    protected Renderer getSpinnerArrowsRenderer(@NotNull SpinnerArrowsConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSpinnerArrowsRendererDescription(g);
        int size = AquaNativePainter.toSize(g.getSize());
        int state = AquaNativePainter.toState(g.getState());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintSpinnerArrows(data, rw, rh, w, h, size, state, g.isFocused(), g.isPressedTop());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration g) {
        RendererDescription rd = rendererDescriptions.getSplitPaneDividerRendererDescription(g);
        int dividerType = this.toDividerType(g.getWidget());
        int state = AquaNativePainter.toState(g.getState());
        int orientation = this.toOrientation(g.getOrientation());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintSplitPaneDivider(data, rw, rh, w, h, dividerType, state, orientation, g.getThickness());
        return Renderer.create(r, rd);
    }

    @Override
    @NotNull
    protected Renderer getGradientRenderer(@NotNull GradientConfiguration g) {
        RendererDescription rd = rendererDescriptions.getGradientRendererDescription(g);
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected Renderer getSegmentedButtonRenderer(@NotNull SegmentedButtonConfiguration g) {
        return this.segmentedControlPainter.createSegmentedButtonRenderer(g);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration g) {
        RendererDescription rd = rendererDescriptions.getTableColumnHeaderRendererDescription(g);
        int state = AquaNativePainter.toState(g.getState());
        int direction = this.toDirection(g.getSortArrowDirection());
        int layoutDirection = this.toUILayoutDirection(g.getLayoutDirection());
        BasicRenderer r = (data, rw, rh, w, h) -> AquaNativePainter.nativePaintTableColumnHeader(data, rw, rh, w, h, state, direction, g.isSelected(), layoutDirection);
        return Renderer.create(r, rd);
    }

    @Override
    @Nullable
    public RendererDebugInfo getRendererDebugInfo(@NotNull Configuration g, int scaleFactor, int width, int height) {
        if (g instanceof SegmentedButtonConfiguration) {
            SegmentedButtonConfiguration bg = (SegmentedButtonConfiguration)g;
            return this.segmentedControlPainter.getSegmentedButtonRendererDebugInfo(bg, scaleFactor, width, height);
        }
        return null;
    }

    protected static int toSize(@NotNull AquaUIPainter.Size sz) {
        switch (sz) {
            case MINI: {
                return 0;
            }
            case SMALL: {
                return 1;
            }
            case REGULAR: {
                return 2;
            }
            case LARGE: {
                return 3;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected static int toState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case ACTIVE: {
                return 0;
            }
            case INACTIVE: {
                return 1;
            }
            case DISABLED: {
                return 2;
            }
            case DISABLED_INACTIVE: {
                return 6;
            }
            case PRESSED: {
                return 3;
            }
            case ACTIVE_DEFAULT: {
                return 4;
            }
            case ROLLOVER: {
                return 5;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toActiveState(@NotNull AquaUIPainter.State st) {
        switch (st) {
            case ACTIVE: {
                return 0;
            }
            case INACTIVE: 
            case DISABLED: 
            case DISABLED_INACTIVE: {
                return 1;
            }
        }
        return 0;
    }

    protected int toDirection(@NotNull AquaUIPainter.ColumnSortArrowDirection d) {
        switch (d) {
            case NONE: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case DOWN: {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    protected int toDirection(@NotNull AquaUIPainter.Direction d) {
        switch (d) {
            case NONE: {
                return 0;
            }
            case UP: {
                return 1;
            }
            case DOWN: {
                return 2;
            }
            case LEFT: {
                return 3;
            }
            case RIGHT: {
                return 4;
            }
        }
        throw new IllegalArgumentException();
    }

    protected int toOrientation(@NotNull AquaUIPainter.Orientation o) {
        switch (o) {
            case HORIZONTAL: {
                return 0;
            }
            case VERTICAL: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    public int getSideInset(@NotNull AquaUIPainter.SegmentedButtonWidget bw) {
        int style = AquaNativePainter.toSegmentedStyle(bw);
        return this.getSideInsetFromSegmentStyle(style);
    }

    public int getDividerWidth(@NotNull AquaUIPainter.SegmentedButtonWidget bw) {
        int style = AquaNativePainter.toSegmentedStyle(bw);
        return this.getDividerWidthFromSegmentStyle(style);
    }

    protected int getSideInsetFromSegmentStyle(int style) {
        switch (style) {
            case 2: 
            case 4: {
                return 1;
            }
            case 6: {
                return 1;
            }
        }
        return 3;
    }

    protected int getDividerWidthFromSegmentStyle(int style) {
        switch (style) {
            case 2: {
                return 2;
            }
            case 6: {
                return 1;
            }
        }
        return 1;
    }

    protected static int toSegmentedStyle(@NotNull AquaUIPainter.SegmentedButtonWidget bw) {
        switch (bw) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: {
                return 1;
            }
            case BUTTON_SEGMENTED_INSET: {
                return 3;
            }
            case BUTTON_SEGMENTED_SCURVE: {
                return 5;
            }
            case BUTTON_SEGMENTED_TEXTURED: {
                return 4;
            }
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_TOOLBAR_ICONS: {
                return 1004;
            }
            case BUTTON_SEGMENTED_TOOLBAR: {
                return 2;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return 6;
            }
            case BUTTON_SEGMENTED_SEPARATED: {
                return 80;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                return 81;
            }
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED_TOOLBAR_ICONS: {
                return 1081;
            }
            case BUTTON_SEGMENTED_SLIDER: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR: 
            case BUTTON_SEGMENTED_SLIDER_TOOLBAR_ICONS: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toBezelStyle(@NotNull AquaUIPainter.ComboBoxWidget w) {
        switch (w) {
            case BUTTON_COMBO_BOX: {
                return 1;
            }
            case BUTTON_COMBO_BOX_CELL: {
                return 0;
            }
            case BUTTON_COMBO_BOX_TEXTURED: {
                return 11;
            }
            case BUTTON_COMBO_BOX_TEXTURED_TOOLBAR: {
                return 1011;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toBezelStyle(@NotNull AquaUIPainter.PopupButtonWidget bw) {
        switch (bw) {
            case BUTTON_POP_DOWN: 
            case BUTTON_POP_UP: {
                return 1;
            }
            case BUTTON_POP_DOWN_CELL: 
            case BUTTON_POP_UP_CELL: {
                return 0;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                return 2;
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return 12;
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                return 13;
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: {
                return 11;
            }
            case BUTTON_POP_DOWN_TEXTURED_TOOLBAR: 
            case BUTTON_POP_UP_TEXTURED_TOOLBAR: {
                return 1011;
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                return 10;
            }
            case BUTTON_POP_DOWN_SQUARE: 
            case BUTTON_POP_UP_SQUARE: {
                return 6;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toBezelStyle(@NotNull AquaUIPainter.ButtonWidget bw) {
        int platformVersion = JNRPlatformUtils.getPlatformVersion();
        switch (bw) {
            case BUTTON_PUSH: {
                return 1;
            }
            case BUTTON_BEVEL: {
                return 6;
            }
            case BUTTON_BEVEL_ROUND: {
                return 2;
            }
            case BUTTON_CHECK_BOX: {
                return 3;
            }
            case BUTTON_RADIO: {
                return 4;
            }
            case BUTTON_DISCLOSURE: {
                return 14;
            }
            case BUTTON_DISCLOSURE_TRIANGLE: {
                return 5;
            }
            case BUTTON_HELP: {
                return 9;
            }
            case BUTTON_GRADIENT: {
                return 10;
            }
            case BUTTON_RECESSED: {
                return 13;
            }
            case BUTTON_INLINE: {
                return 15;
            }
            case BUTTON_ROUNDED_RECT: {
                return 12;
            }
            case BUTTON_TEXTURED: {
                return 11;
            }
            case BUTTON_TEXTURED_TOOLBAR: 
            case BUTTON_TEXTURED_TOOLBAR_ICONS: {
                return 1011;
            }
            case BUTTON_ROUND: {
                return 7;
            }
            case BUTTON_ROUND_TEXTURED: 
            case BUTTON_ROUND_TEXTURED_TOOLBAR: {
                return platformVersion >= 101100 ? 1007 : 7;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected int toButtonType(@NotNull AquaUIPainter.ButtonWidget bw) {
        switch (bw) {
            case BUTTON_CHECK_BOX: {
                return 3;
            }
            case BUTTON_RADIO: {
                return 4;
            }
            case BUTTON_DISCLOSURE: 
            case BUTTON_DISCLOSURE_TRIANGLE: 
            case BUTTON_RECESSED: 
            case BUTTON_INLINE: {
                return 1;
            }
        }
        return 0;
    }

    protected int toButtonValue(@NotNull AquaUIPainter.ButtonState bs) {
        switch (bs) {
            case ON: {
                return 1;
            }
            case MIXED: {
                return 2;
            }
        }
        return 0;
    }

    protected static int toTracking(@NotNull AquaUIPainter.SwitchTracking t) {
        if (t == AquaUIPainter.SwitchTracking.SELECT_ANY) {
            return 1;
        }
        return 0;
    }

    protected int toUILayoutDirection(@NotNull AquaUIPainter.UILayoutDirection d) {
        switch (d) {
            case LEFT_TO_RIGHT: {
                return 0;
            }
            case RIGHT_TO_LEFT: {
                return 1;
            }
        }
        return 0;
    }

    protected int toSliderType(@NotNull AquaUIPainter.SliderWidget w) {
        switch (w) {
            case SLIDER_HORIZONTAL: {
                return 0;
            }
            case SLIDER_HORIZONTAL_RIGHT_TO_LEFT: {
                return 1002;
            }
            case SLIDER_VERTICAL: {
                return 0;
            }
            case SLIDER_UPSIDE_DOWN: {
                return 1003;
            }
            case SLIDER_CIRCULAR: {
                return 1;
            }
        }
        return 0;
    }

    protected int toTickMarkPosition(@NotNull AquaUIPainter.TickMarkPosition p) {
        switch (p) {
            case LEFT: {
                return 1;
            }
            case RIGHT: {
                return 0;
            }
            case BELOW: {
                return 0;
            }
            case ABOVE: {
                return 1;
            }
        }
        return 1;
    }

    protected int toDividerType(@NotNull AquaUIPainter.DividerWidget w) {
        switch (w) {
            case PANE_SPLITTER: {
                return 3;
            }
            case THIN_DIVIDER: {
                return 2;
            }
            case THICK_DIVIDER: {
                return 1;
            }
        }
        return 3;
    }

    protected int toComboBoxType(@NotNull AquaUIPainter.ComboBoxWidget bw) {
        switch (bw) {
            default: {
                return 0;
            }
            case BUTTON_COMBO_BOX_CELL: 
        }
        return 2;
    }

    protected static int toWindowType(@NotNull AquaUIPainter.TitleBarWidget bw) {
        switch (bw) {
            case DOCUMENT_WINDOW: {
                return 0;
            }
            case UTILITY_WINDOW: {
                return 1;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected static int toScrollBarType(@NotNull AquaUIPainter.ScrollBarWidget bw) {
        switch (bw) {
            case LEGACY: {
                return 0;
            }
            case OVERLAY: {
                return 1;
            }
            case OVERLAY_ROLLOVER: {
                return 2;
            }
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    private static TitleBarLayoutInfo obtainTitleBarLayoutInfo() {
        Rectangle[] documentButtonBounds = AquaNativePainter.obtainTitleBarButtonLayoutInfo(AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW);
        Rectangle[] utilityButtonBounds = AquaNativePainter.obtainTitleBarButtonLayoutInfo(AquaUIPainter.TitleBarWidget.UTILITY_WINDOW);
        return new TitleBarLayoutInfo(documentButtonBounds, utilityButtonBounds);
    }

    @NotNull
    private static Rectangle[] obtainTitleBarButtonLayoutInfo(@NotNull AquaUIPainter.TitleBarWidget bw) {
        int windowType = AquaNativePainter.toWindowType(bw);
        int[] data = AquaNativePainter.nativeGetTitleBarButtonLayoutInfo(windowType);
        if (data != null) {
            Rectangle close = new Rectangle(data[0], data[1], data[2], data[3]);
            Rectangle minimize = new Rectangle(data[4], data[5], data[6], data[7]);
            Rectangle resize = new Rectangle(data[8], data[9], data[10], data[11]);
            return new Rectangle[]{close, minimize, resize};
        }
        int x = bw == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 7 : 5;
        int sep = bw == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 6 : 5;
        int w = bw == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 14 : 13;
        int h = bw == AquaUIPainter.TitleBarWidget.DOCUMENT_WINDOW ? 16 : 14;
        int y = 3;
        Rectangle close = new Rectangle(x, y, w, h);
        Rectangle minimize = new Rectangle(x += w + sep, y, w, h);
        Rectangle resize = new Rectangle(x += w + sep, y, w, h);
        return new Rectangle[]{close, minimize, resize};
    }

    @NotNull
    public String toString() {
        return "NSView";
    }

    private static native void nativePaintIndeterminateProgressIndicator(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, boolean var8, int var9);

    private static native void nativePaintProgressIndicator(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, double var8);

    private static native void nativePaintButton(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, boolean var9, int var10, int var11);

    private static native void nativePaintColorWell(int[] var0, int var1, int var2, float var3, float var4, int var5);

    private static native void nativePaintToolBarItemWell(int[] var0, int var1, int var2, float var3, float var4, int var5, boolean var6);

    private static native void nativePaintGroupBox(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, boolean var7);

    private static native void nativePaintListBox(int[] var0, int var1, int var2, float var3, float var4, int var5, boolean var6, boolean var7);

    private static native void nativePaintTextField(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7);

    private static native void nativePaintComboBox(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, int var9);

    private static native void nativePaintPopUpButton(int[] var0, int var1, int var2, float var3, float var4, boolean var5, int var6, int var7, int var8, int var9);

    private static native void nativePaintTableColumnHeader(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, boolean var7, int var8);

    private static native void nativePaintSlider(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, boolean var8, double var9, int var11, int var12);

    private static native void nativePaintSpinnerArrows(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, boolean var7, boolean var8);

    private static native void nativePaintSplitPaneDivider(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8);

    private static native void nativePaintTitleBar(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, int var8, int var9, boolean var10, boolean var11);

    private static native void nativePaintScrollBar(int[] var0, int var1, int var2, float var3, float var4, int var5, int var6, int var7, float var8, float var9);

    private static native int[] nativeGetTitleBarButtonLayoutInfo(int var0);

    private static native void nativeGetSliderThumbBounds(float[] var0, float var1, float var2, int var3, int var4, double var5, int var7, int var8);

    public static native boolean isLayerPaintingEnabled();

    public static native void setLayerPaintingEnabled(boolean var0);

    public static native int nativeDetermineSliderRenderingVersion();

    private static native int nativeDetermineButtonFixedHeight(int var0, int var1, int var2);

    private static native int nativeDetermineButtonFixedWidth(int var0, int var1, int var2);

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                NativeSupport.load();
                return null;
            }
        });
        rendererDescriptions = new ViewRendererDescriptions();
    }
}

