/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicListUI;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaColors;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaListMouseBehavior;
import org.violetlib.aqua.AquaLookAndFeel;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaViewStyleContainerUI;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.JListModel;
import org.violetlib.aqua.ListSelectionBoundsTracker;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.VisualEffectView;
import org.violetlib.jnr.aqua.AquaUIPainter;

public class AquaListUI
extends BasicListUI
implements AquaComponentUI,
AquaViewStyleContainerUI {
    public static final String LIST_STYLE_KEY = "JList.style";
    public static final String QUAQUA_LIST_STYLE_KEY = "Quaqua.List.style";
    public static final String LIST_VIEW_STYLE_KEY = "JList.viewStyle";
    private boolean isSideBar;
    private boolean isStriped;
    private boolean isInset;
    private boolean isMenu;
    private boolean isVibrantMenu;
    private ListVibrantEffects vibrantEffects;
    @NotNull
    protected ContainerContextualColors colors = AquaColors.CONTAINER_COLORS;
    @Nullable
    protected AppearanceContext appearanceContext;
    private static final Border insetBorder = new BorderUIResource.EmptyBorderUIResource(5, 0, 5, 0);

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaListUI();
    }

    public void configureAsMenu(boolean bl) {
        this.isMenu = true;
        this.isVibrantMenu = bl;
        this.updateVibrantEffects();
    }

    public void setColors(@NotNull ContainerContextualColors containerContextualColors) {
        if (containerContextualColors != this.colors) {
            this.colors = containerContextualColors;
            this.configureAppearanceContext(null);
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new AquaListMouseBehavior(new JListModel(this.list));
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.list.putClientProperty("JComponent.isCellContainer", true);
        this.isStriped = this.getStripedValue();
        this.isInset = this.getInsetValue();
        this.isSideBar = this.getSideBarValue();
        this.colors = this.determineColors();
        this.updateBorderForInset();
        this.updateOpaque();
        this.updateSideBarConfiguration();
        this.updateVibrantEffects();
        this.configureAppearanceContext(null);
    }

    @Override
    protected void uninstallDefaults() {
        this.disposeVibrantEffects();
        this.removeInsetBorder();
        super.uninstallDefaults();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AppearanceManager.installListeners(this.list);
        AquaUtils.installInsetViewListener(this.list);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtils.uninstallInsetViewListener(this.list);
        AppearanceManager.uninstallListeners(this.list);
        super.uninstallListeners();
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        this.list.getActionMap().put("aquaHome", new AquaHomeEndAction(true));
        this.list.getActionMap().put("aquaEnd", new AquaHomeEndAction(false));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new AquaPropertyChangeHandler();
    }

    @NotNull
    public ContainerContextualColors getColors() {
        return this.colors;
    }

    @Override
    public void appearanceChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        this.configureAppearanceContext(aquaAppearance);
    }

    @Override
    public void activeStateChanged(@NotNull JComponent jComponent, boolean bl) {
        this.configureAppearanceContext(null);
    }

    protected void configureAppearanceContext(@Nullable AquaAppearance aquaAppearance) {
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.ensureAppearance(this.list);
        }
        AquaUIPainter.State state = this.getState();
        this.appearanceContext = new AppearanceContext(aquaAppearance, state, false, false);
        this.colors.configureForContainer();
        AquaColors.installColors(this.list, this.appearanceContext, this.colors);
        this.updateOpaque();
        this.list.repaint();
    }

    @NotNull
    protected ContainerContextualColors determineColors() {
        if (this.isSideBar()) {
            return AquaColors.SIDEBAR_CONTAINER_COLORS;
        }
        if (this.isStriped) {
            return AquaColors.STRIPED_CONTAINER_COLORS;
        }
        return AquaColors.CONTAINER_COLORS;
    }

    protected AquaUIPainter.State getState() {
        return this.list.isEnabled() ? (this.shouldDisplayAsFocused() ? AquaUIPainter.State.ACTIVE_DEFAULT : AquaUIPainter.State.ACTIVE) : AquaUIPainter.State.DISABLED;
    }

    protected boolean shouldDisplayAsFocused() {
        return AquaFocusHandler.hasFocus(this.list);
    }

    protected void updateSideBarConfiguration() {
        if (this.isSideBar()) {
            this.list.setLayoutOrientation(0);
        }
        this.updateVibrantEffects();
        if (AquaUtils.isInsetViewSupported()) {
            this.updateInsetConfiguration();
        }
    }

    protected void updateVibrantEffects() {
        if (this.list.isDisplayable()) {
            if (this.isSideBar()) {
                this.ensureVibrantEffects(2);
                return;
            }
            if (this.isVibrantMenu && AquaLookAndFeel.USE_VIBRANT_MENU) {
                this.ensureVibrantEffects(4);
                return;
            }
        }
        this.disposeVibrantEffects();
    }

    protected void ensureVibrantEffects(int n) {
        JComponent jComponent = this.getComponentForVisualEffectView();
        if (this.vibrantEffects != null && (this.vibrantEffects.getComponent() != jComponent || this.vibrantEffects.style != n)) {
            this.disposeVibrantEffects();
        }
        if (this.vibrantEffects == null) {
            this.vibrantEffects = new ListVibrantEffects(jComponent, n);
        }
    }

    protected void disposeVibrantEffects() {
        if (this.vibrantEffects != null) {
            this.vibrantEffects.dispose();
            this.vibrantEffects = null;
        }
    }

    @NotNull
    protected JComponent getComponentForVisualEffectView() {
        Container container = this.list.getParent();
        if (container instanceof JViewport) {
            return (JViewport)container;
        }
        return this.list;
    }

    private void updateStyleProperties() {
        boolean bl = false;
        boolean bl2 = this.getStripedValue();
        if (bl2 != this.isStriped) {
            this.isStriped = bl2;
            bl = true;
        }
        boolean bl3 = false;
        boolean bl4 = this.getSideBarValue();
        if (bl4 != this.isSideBar) {
            this.isSideBar = bl4;
            bl3 = true;
        }
        if (bl || bl3) {
            this.colors = this.determineColors();
            this.configureAppearanceContext(null);
        }
        if (bl3) {
            this.updateSideBarConfiguration();
        }
    }

    private void updateStriped() {
        boolean bl = this.getStripedValue();
        if (bl != this.isStriped) {
            this.isStriped = bl;
            this.colors = this.isStriped ? AquaColors.STRIPED_CONTAINER_COLORS : AquaColors.CONTAINER_COLORS;
            this.updateOpaque();
            this.configureAppearanceContext(null);
        }
    }

    private boolean getStripedValue() {
        String string = this.getStyleProperty();
        return "striped".equals(string) && this.list.getLayoutOrientation() == 0 && this.isBackgroundClear();
    }

    @Override
    public void scrollPaneAncestorChanged(@Nullable JScrollPane jScrollPane) {
    }

    private void updateInset() {
        boolean bl = this.getInsetValue();
        if (bl != this.isInset) {
            this.isInset = bl;
            this.updateInsetConfiguration();
        }
    }

    private void updateInsetConfiguration() {
        this.updateBorderForInset();
        this.configureAppearanceContext(null);
        this.updateLayoutStateNeeded |= 0x40;
        this.list.revalidate();
        this.list.repaint();
    }

    private void updateBorderForInset() {
        this.updateBorder(this.isInset() && !this.isMenu ? insetBorder : null);
    }

    private void removeInsetBorder() {
        Border border = this.list.getBorder();
        if (border == insetBorder) {
            this.list.setBorder(null);
        }
    }

    private boolean getInsetValue() {
        if (AquaUtils.isInsetViewSupported()) {
            String string = this.getViewStyleProperty();
            return "inset".equals(string);
        }
        return false;
    }

    private boolean getSideBarValue() {
        String string = this.getStyleProperty();
        return string != null && (string.equals("sideBar") || string.equals("sourceList"));
    }

    private void updateBorder(@Nullable Border border) {
        Border border2 = this.list.getBorder();
        if (border2 != border && border2 == null || border2 instanceof UIResource) {
            this.list.setBorder(border);
        }
    }

    private void updateOpaque() {
        Color color = this.list.getBackground();
        this.list.setOpaque(!this.isStriped && (this.isVibrant() || color == null || color.getAlpha() == 255));
    }

    private boolean isBackgroundClear() {
        Color color = this.list.getBackground();
        return color == null || color.getAlpha() == 0 || color instanceof ColorUIResource;
    }

    public boolean isStriped() {
        return this.isStriped;
    }

    public boolean isSideBar() {
        return this.isSideBar;
    }

    public boolean isVibrant() {
        return this.isSideBar || AquaLookAndFeel.USE_VIBRANT_MENU && this.isVibrantMenu;
    }

    @Override
    public boolean isInset() {
        return this.isInset || this.isVibrant() && OSXSystemProperties.useInsetViewStyle();
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    @Nullable
    protected String getStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_STYLE_KEY, QUAQUA_LIST_STYLE_KEY);
    }

    protected boolean isViewStyleProperty(String string) {
        return AquaUtils.isProperty(string, LIST_VIEW_STYLE_KEY);
    }

    @Nullable
    protected String getViewStyleProperty() {
        return AquaUtils.getProperty(this.list, LIST_VIEW_STYLE_KEY);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        AppearanceManager.registerCurrentAppearance(jComponent);
        if (this.list.isOpaque()) {
            Color color = this.getBackgroundColor();
            int n = this.list.getWidth();
            int n2 = this.list.getHeight();
            AquaUtils.fillRect(graphics, color, 0, 0, n, n2);
        }
        this.paint(graphics, jComponent);
    }

    @Nullable
    private Color getBackgroundColor() {
        return this.isVibrant() ? null : this.list.getBackground();
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.appearanceContext != null) {
            if (this.vibrantEffects != null) {
                this.vibrantEffects.update();
            } else {
                this.paintStripes(graphics);
            }
            super.paint(graphics, jComponent);
        }
    }

    public void paintStripes(Graphics graphics) {
        if (this.isStriped && this.list.getModel() != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            assert (this.appearanceContext != null);
            Dimension dimension = this.list.getSize();
            Insets insets = this.list.getInsets();
            int n = this.list.getFixedCellHeight();
            int n2 = this.list.getModel().getSize();
            if (n <= 0) {
                n = n2 == 0 ? 12 : this.getCellBounds(this.list, (int)0, (int)0).height;
            }
            int n3 = (int)Math.ceil(Math.abs(dimension.getHeight() / (double)n));
            int n4 = 0;
            int n5 = insets.top;
            ListSelectionModel listSelectionModel = this.list.getSelectionModel();
            while (n4 < n3) {
                boolean bl = listSelectionModel.isSelectedIndex(n4);
                this.colors.configureForRow(n4, bl && !this.isInset());
                Color color = this.colors.getBackground(this.appearanceContext);
                graphics.setColor(color);
                if (this.isInset()) {
                    AquaUtils.paintInsetStripedRow(graphics2D, 0, n5, dimension.width, n);
                } else {
                    graphics.fillRect(0, n5, dimension.width, n);
                }
                ++n4;
                n5 += n;
            }
        }
    }

    protected void paintCell(Graphics graphics, int n, Rectangle rectangle, ListCellRenderer listCellRenderer, ListModel listModel, ListSelectionModel listSelectionModel, int n2) {
        Object object;
        Object object2;
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        assert (this.appearanceContext != null);
        boolean bl = listSelectionModel.isSelectedIndex(n);
        boolean bl2 = this.shouldDisplayAsFocused();
        boolean bl3 = bl2 && n == n2;
        boolean bl4 = this.list.getLayoutOrientation() != 0;
        this.colors.configureForRow(n, bl);
        if (bl && !this.isVibrant()) {
            object2 = this.colors.getBackground(this.appearanceContext);
            graphics.setColor((Color)object2);
            if (this.isInset() && !this.isVibrantMenu) {
                object = (Graphics2D)graphics;
                if (this.isMenu) {
                    AquaUtils.paintInsetMenuItemSelection((Graphics2D)object, n3, n4, n5, n6);
                } else if (bl4) {
                    AquaUtils.paintInsetCellSelection((Graphics2D)object, n3, n4, n5, n6);
                } else {
                    boolean bl5 = n > 0 && listSelectionModel.isSelectedIndex(n - 1);
                    boolean bl6 = n < this.list.getModel().getSize() - 1 && listSelectionModel.isSelectedIndex(n + 1);
                    AquaUtils.paintInsetCellSelection((Graphics2D)object, bl5, bl6, n3, n4, n5, n6);
                }
            } else if (!this.isStriped) {
                graphics.fillRect(n3, n4, n5, n6);
            }
        }
        if ((object = listCellRenderer.getListCellRendererComponent(this.list, object2 = listModel.getElementAt(n), n, bl, bl3)) instanceof JTextComponent) {
            ((JTextComponent)object).putClientProperty("Aqua.componentColors", AquaColors.CELL_TEXT_COLORS);
        }
        if (this.isInset() && ((Component)object).isOpaque() && object instanceof JComponent) {
            JComponent jComponent = (JComponent)object;
            AquaUtils.setOpaqueCarefully(jComponent, false);
        }
        this.rendererPane.paintComponent(graphics, (Component)object, this.list, n3, n4, n5, n6, true);
        if (object instanceof JTextComponent) {
            ((JTextComponent)object).putClientProperty("Aqua.componentColors", null);
        }
    }

    protected class FocusHandler
    implements FocusListener {
        protected FocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusChanged();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusChanged();
        }

        private void focusChanged() {
            AquaListUI.this.configureAppearanceContext(null);
        }
    }

    static class AquaHomeEndAction
    extends AbstractAction {
        private boolean fHomeAction;

        protected AquaHomeEndAction(boolean bl) {
            this.fHomeAction = bl;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            if (this.fHomeAction) {
                jList.ensureIndexIsVisible(0);
            } else {
                int n = jList.getModel().getSize();
                jList.ensureIndexIsVisible(n - 1);
            }
        }
    }

    class AquaPropertyChangeHandler
    extends BasicListUI.PropertyChangeHandler {
        AquaPropertyChangeHandler() {
            super(AquaListUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                AquaListUI.this.configureAppearanceContext(null);
            } else if ("Aqua.displayAsFocused".equals(string)) {
                AquaListUI.this.configureAppearanceContext(null);
            } else {
                if (AquaListUI.this.isStyleProperty(string)) {
                    AquaListUI.this.updateStyleProperties();
                } else if ("layoutOrientation".equals(string)) {
                    AquaListUI.this.updateStriped();
                } else if (AquaListUI.this.isViewStyleProperty(string)) {
                    AquaListUI.this.updateInset();
                } else if ("ancestor".equals(string)) {
                    AquaListUI.this.updateSideBarConfiguration();
                }
                super.propertyChange(propertyChangeEvent);
            }
        }
    }

    protected class ListVibrantEffects
    extends VisualEffectView {
        @Nullable
        protected ListSelectionBoundsTracker bt;
        protected final int style;

        public ListVibrantEffects(final JComponent jComponent, int n) {
            super(jComponent, n, true);
            this.style = n;
            this.bt = new ListSelectionBoundsTracker(AquaListUI.this.list, this::updateSelectionBackgrounds){

                @Override
                protected int convertRowYCoordinateToSelectionDescription(int n) {
                    if (jComponent != this.list) {
                        Point point = SwingUtilities.convertPoint(this.list, 0, n, jComponent);
                        return point.y;
                    }
                    return n;
                }
            };
        }

        public void update() {
            if (this.bt != null) {
                this.bt.update();
            }
        }

        @Override
        public void dispose() {
            super.dispose();
            if (this.bt != null) {
                this.bt.dispose();
                this.bt = null;
            }
        }

        @Override
        protected void windowChanged(Window window) {
            super.windowChanged(window);
            if (this.bt != null) {
                this.bt.reset();
            }
        }
    }
}

