/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaAppearances;
import org.violetlib.aqua.AquaComponentUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;
import org.violetlib.aqua.Utils;

public class AppearanceManager {
    public static boolean isDebug = false;
    public static boolean isDebugShortCircuit = false;
    public static final String AQUA_APPEARANCE_NAME_KEY = "Aqua.appearanceName";
    public static final String AQUA_APPEARANCE_KEY = "Aqua.appearance";
    private static final AppearanceManagerHierarchyListener hierarchyListener = new AppearanceManagerHierarchyListener();
    private static final ActiveStateListener activeStateListener = new ActiveStateListener();
    private static final AppearanceNamePropertyListener appearanceNamePropertyListener = new AppearanceNamePropertyListener();
    @NotNull
    private static final HierarchyUpdateProcessor updateProcessor = new HierarchyUpdateProcessor();
    private static final WeakComponentSet componentsUsingSpecifiedAppearances = new WeakComponentSet();
    @Nullable
    private static AquaAppearance currentAppearance;

    @NotNull
    public static AquaAppearance getCurrentAppearance() {
        if (currentAppearance != null) {
            return currentAppearance;
        }
        return AquaAppearances.getDefaultAppearance();
    }

    @NotNull
    public static AquaAppearance registerCurrentAppearance(@NotNull JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(jComponent);
        if (aquaAppearance != currentAppearance) {
            currentAppearance = aquaAppearance;
            if (isDebug) {
                AppearanceManager.debug(jComponent, "Current appearance changed to: " + currentAppearance);
            }
        }
        return currentAppearance;
    }

    public static void installListeners(@NotNull JComponent jComponent) {
        AquaComponentUI aquaComponentUI = AquaUtils.getUI(jComponent, AquaComponentUI.class);
        if (aquaComponentUI == null && !(jComponent instanceof JLayeredPane)) {
            throw new IllegalArgumentException("Component must support AquaComponentUI");
        }
        jComponent.addHierarchyListener(hierarchyListener);
        jComponent.addPropertyChangeListener("Frame.active", activeStateListener);
        jComponent.addPropertyChangeListener(AQUA_APPEARANCE_NAME_KEY, appearanceNamePropertyListener);
    }

    public static void uninstallListeners(@NotNull Component component) {
        component.removeHierarchyListener(hierarchyListener);
        component.removePropertyChangeListener("Frame.active", activeStateListener);
        component.addPropertyChangeListener(AQUA_APPEARANCE_NAME_KEY, appearanceNamePropertyListener);
    }

    public static void setRootPaneRegisteredAppearance(@NotNull JRootPane jRootPane, @NotNull AquaAppearance aquaAppearance) {
        AppearanceManager.updateAppearancesInSubtree(jRootPane, aquaAppearance, false);
    }

    private static void setRegisteredAppearance(@NotNull Component component, @NotNull AquaAppearance aquaAppearance) {
        AppearanceManager.updateAppearancesInSubtree(component, aquaAppearance, false);
    }

    private static boolean setRegisteredAppearance(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        AquaAppearance aquaAppearance2 = AppearanceManager.getRegisteredAppearance(jComponent);
        if (aquaAppearance != aquaAppearance2) {
            try {
                jComponent.putClientProperty(AQUA_APPEARANCE_KEY, aquaAppearance);
                if (isDebug) {
                    AppearanceManager.debug(jComponent, "Registering appearance " + aquaAppearance + " for " + AquaUtils.show(jComponent));
                }
                AppearanceManager.appearanceHasChanged(jComponent, aquaAppearance);
            }
            catch (Throwable throwable) {
                Utils.logError("Unable to set appearance property on " + AquaUtils.show(jComponent) + ". Check for failure in a property change listener", throwable);
                throwable.printStackTrace();
            }
            return true;
        }
        return false;
    }

    public static void removeRegisteredAppearance(@NotNull JComponent jComponent) {
        try {
            Object object = jComponent.getClientProperty(AQUA_APPEARANCE_KEY);
            if (object != null) {
                jComponent.putClientProperty(AQUA_APPEARANCE_KEY, null);
                if (isDebug) {
                    String string = object instanceof AquaAppearance ? ((AquaAppearance)object).getName() : "?";
                    AppearanceManager.debug(jComponent, "Removing appearance " + string + " for " + AquaUtils.show(jComponent));
                }
            }
        }
        catch (Throwable throwable) {
            Utils.logError("Unable to uninstall appearance property on " + AquaUtils.show(jComponent) + ". Check for failure in a property change listener", throwable);
            throwable.printStackTrace();
        }
    }

    @NotNull
    public static AquaAppearance getApplicationAppearance() {
        String string = AquaUtils.nativeGetApplicationAppearanceName();
        if (string != null) {
            return AquaAppearances.get(string);
        }
        return AquaAppearances.getDefaultAppearance();
    }

    public static void updateAppearancesInTree(@NotNull Component component, @NotNull AquaAppearance aquaAppearance) {
        AppearanceManager.setRegisteredAppearance(component, aquaAppearance);
        if (component instanceof Container) {
            Container container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AppearanceManager.updateAppearancesInSubtree(component2, aquaAppearance, false);
            }
        }
    }

    private static void updateAppearancesInSubtree(@NotNull Component component, @NotNull AquaAppearance aquaAppearance, boolean bl) {
        Container container;
        if (component instanceof JComponent) {
            container = (JComponent)component;
            if (!bl) {
                if (AppearanceManager.matchesRegisteredAppearance((JComponent)container, aquaAppearance)) {
                    if (isDebug && isDebugShortCircuit) {
                        AppearanceManager.debug(component, "Short circuit: component " + AquaUtils.show(component) + " has the correct appearance");
                    }
                    return;
                }
                if (AppearanceManager.hasValidRegisteredSpecifiedAppearance((JComponent)container)) {
                    if (isDebug && isDebugShortCircuit) {
                        AppearanceManager.debug(component, "Short circuit: component " + AquaUtils.show(component) + " has a valid specified appearance");
                    }
                    return;
                }
            }
            AppearanceManager.setRegisteredAppearance((JComponent)container, aquaAppearance);
        }
        if (component instanceof Container) {
            container = (Container)component;
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                AppearanceManager.updateAppearancesInSubtree(component2, aquaAppearance, bl);
            }
        }
    }

    private static boolean matchesRegisteredAppearance(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        AquaAppearance aquaAppearance2;
        AquaAppearance aquaAppearance3 = AppearanceManager.getRegisteredAppearance(jComponent);
        if (aquaAppearance3 == null) {
            return false;
        }
        if (aquaAppearance3 == aquaAppearance) {
            return true;
        }
        return AppearanceManager.useVibrantAppearance(jComponent) && (aquaAppearance2 = AquaAppearances.getVibrantAppearance(aquaAppearance)) == aquaAppearance3;
    }

    @NotNull
    public static AquaAppearance ensureAppearance(@NotNull Component component) {
        AquaAppearance aquaAppearance = AppearanceManager.getKnownAppearance(component, true);
        if (aquaAppearance == null) {
            aquaAppearance = AppearanceManager.getApplicationAppearance();
            AppearanceManager.setRegisteredAppearance(component, aquaAppearance);
        }
        return aquaAppearance;
    }

    @NotNull
    public static AquaAppearance getAppearance(@NotNull Component component) {
        AquaAppearance aquaAppearance = AppearanceManager.getKnownAppearance(component, false);
        if (aquaAppearance != null) {
            return aquaAppearance;
        }
        aquaAppearance = AppearanceManager.getApplicationAppearance();
        if (isDebug) {
            AppearanceManager.debug(component, "Using application appearance " + aquaAppearance.getName() + " for " + AquaUtils.show(component));
        }
        return aquaAppearance;
    }

    @Nullable
    private static AquaAppearance getKnownAppearance(@NotNull Component component, boolean bl) {
        AquaAppearance aquaAppearance;
        JComponent jComponent;
        if (component instanceof JComponent) {
            jComponent = (JComponent)component;
            if (!bl && (aquaAppearance = AppearanceManager.getRegisteredAppearance(jComponent)) != null) {
                return aquaAppearance;
            }
            aquaAppearance = AppearanceManager.getSpecifiedAppearanceVariant(jComponent);
            if (aquaAppearance != null) {
                AppearanceManager.updateAppearancesInSubtree(jComponent, aquaAppearance, false);
                return aquaAppearance;
            }
        }
        if ((jComponent = AppearanceManager.getJComponentAncestor(component)) != null) {
            aquaAppearance = AppearanceManager.getKnownAppearance(jComponent, false);
            if (aquaAppearance != null) {
                AppearanceManager.updateAppearancesInSubtree(component, aquaAppearance, false);
                return aquaAppearance;
            }
        } else if (component instanceof JRootPane) {
            aquaAppearance = AppearanceManager.getApplicationAppearance();
            AppearanceManager.updateAppearancesInSubtree(component, aquaAppearance, false);
            return aquaAppearance;
        }
        return null;
    }

    @Nullable
    private static AquaAppearance getInheritedAppearance(@NotNull Component component) {
        for (Container container = component.getParent(); container != null; container = container.getParent()) {
            AquaAppearance aquaAppearance = AppearanceManager.getRegisteredAppearance(container);
            if (aquaAppearance != null) {
                return aquaAppearance;
            }
            aquaAppearance = AppearanceManager.getSpecifiedAppearanceVariant(container);
            if (aquaAppearance == null) continue;
            return aquaAppearance;
        }
        return null;
    }

    @Nullable
    private static JComponent getJComponentAncestor(@NotNull Component component) {
        Component component2 = component;
        Container container;
        while ((container = component2.getParent()) != null) {
            if (container instanceof JComponent) {
                return (JComponent)container;
            }
            component2 = container;
        }
        return null;
    }

    @Nullable
    public static AquaAppearance getRegisteredAppearance(@NotNull Component component) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            return AppearanceManager.getRegisteredAppearance(jComponent);
        }
        return null;
    }

    @Nullable
    public static AquaAppearance getRegisteredAppearance(@NotNull JComponent jComponent) {
        Object object = jComponent.getClientProperty(AQUA_APPEARANCE_KEY);
        if (object instanceof AquaAppearance) {
            return (AquaAppearance)object;
        }
        return null;
    }

    @Nullable
    private static AquaAppearance getSpecifiedAppearanceVariant(@NotNull Component component) {
        return component instanceof JComponent ? AppearanceManager.getSpecifiedAppearanceVariant((JComponent)component) : null;
    }

    @Nullable
    private static AquaAppearance getSpecifiedAppearanceVariant(@NotNull JComponent jComponent) {
        String string = AppearanceManager.getSpecifiedAppearanceName(jComponent);
        if (string != null) {
            AquaAppearance aquaAppearance = AquaAppearances.get(string);
            return AppearanceManager.getVariant(jComponent, aquaAppearance);
        }
        return null;
    }

    @Nullable
    private static String getSpecifiedAppearanceName(@NotNull JComponent jComponent) {
        Object object = jComponent.getClientProperty(AQUA_APPEARANCE_NAME_KEY);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    private static boolean hasValidRegisteredSpecifiedAppearance(@NotNull JComponent jComponent) {
        AquaAppearance aquaAppearance = AppearanceManager.getSpecifiedAppearanceVariant(jComponent);
        if (aquaAppearance != null) {
            AquaAppearance aquaAppearance2 = AppearanceManager.getRegisteredAppearance(jComponent);
            return aquaAppearance2 == aquaAppearance;
        }
        return false;
    }

    private static boolean validateRegistrationForSpecifiedAppearance(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        AquaAppearance aquaAppearance2 = AppearanceManager.getRegisteredAppearance(jComponent);
        if (aquaAppearance2 == null) {
            return true;
        }
        if (aquaAppearance2 != aquaAppearance) {
            AquaUtils.syslog("Registered appearance " + aquaAppearance2.getName() + " does not match specified appearance " + aquaAppearance.getName() + " for " + AquaUtils.show(jComponent));
            return false;
        }
        return true;
    }

    private static void appearanceHasChanged(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        Object object;
        if (jComponent instanceof JMenuBar) {
            Color color;
            object = (JMenuBar)jComponent;
            Color color2 = ((Component)object).getBackground();
            if (color2 instanceof ColorUIResource) {
                ((JComponent)object).setBackground(aquaAppearance.getColor("controlBackground"));
            }
            if ((color = ((Component)object).getForeground()) instanceof ColorUIResource) {
                ((JComponent)object).setForeground(aquaAppearance.getColor("control"));
            }
        }
        if ((object = AquaUtils.getUI(jComponent, AquaComponentUI.class)) != null) {
            object.appearanceChanged(jComponent, aquaAppearance);
        }
    }

    private static void specifiedAppearanceNameChanged(@NotNull JComponent jComponent, @Nullable String string) {
        if (string != null) {
            AquaAppearance aquaAppearance = AppearanceManager.getNamedAppearanceVariant(jComponent, string);
            if (aquaAppearance != null) {
                if (isDebug) {
                    AppearanceManager.debug(jComponent, "Appearance " + string + " specified for " + AquaUtils.show(jComponent));
                }
                componentsUsingSpecifiedAppearances.add(jComponent);
                AppearanceManager.updateAppearancesInTree(jComponent, aquaAppearance);
            } else if (isDebug) {
                AquaUtils.syslog("Specified appearance " + string + " for " + AquaUtils.show(jComponent) + " is not available");
            }
        } else {
            if (isDebug) {
                AppearanceManager.debug(jComponent, "Specified appearance for " + AquaUtils.show(jComponent) + " removed");
            }
            componentsUsingSpecifiedAppearances.remove(jComponent);
            jComponent.removePropertyChangeListener(appearanceNamePropertyListener);
            AquaAppearance aquaAppearance = AppearanceManager.getSpecifiedAppearanceVariant(jComponent);
            if (aquaAppearance != null) {
                AppearanceManager.validateRegistrationForSpecifiedAppearance(jComponent, aquaAppearance);
                AppearanceManager.updateAppearancesInSubtree(jComponent, aquaAppearance, false);
            }
        }
    }

    @Nullable
    private static AquaAppearance getNamedAppearanceVariant(@NotNull JComponent jComponent, @NotNull String string) {
        AquaAppearance aquaAppearance = AquaAppearances.getOptional(string);
        return aquaAppearance != null ? AppearanceManager.getVariant(jComponent, aquaAppearance) : null;
    }

    @NotNull
    private static AquaAppearance getVariant(@NotNull JComponent jComponent, @NotNull AquaAppearance aquaAppearance) {
        if (AppearanceManager.useVibrantAppearance(jComponent)) {
            aquaAppearance = AquaAppearances.getVibrantAppearance(aquaAppearance);
        }
        return aquaAppearance;
    }

    private static boolean useVibrantAppearance(@NotNull JComponent jComponent) {
        return AquaVibrantSupport.isVibrant(jComponent) && !(jComponent instanceof JRootPane);
    }

    private static void debug(@NotNull Component component, @NotNull String string) {
        String string2;
        Window window = SwingUtilities.getWindowAncestor(component);
        String string3 = string2 = window != null ? window.getName() : "";
        if (string2 != null && !string2.isEmpty()) {
            Utils.logDebug("[" + string2 + "] " + string);
        } else {
            Utils.logDebug(string);
        }
    }

    private static class HierarchyUpdateProcessor {
        @Nullable
        private Component currentTop;

        private HierarchyUpdateProcessor() {
        }

        public void acceptTop(@NotNull Component component) {
            if (component.getParent() == null) {
                this.currentTop = null;
            } else {
                if (component == this.currentTop) {
                    return;
                }
                this.currentTop = component;
                JRootPane jRootPane = SwingUtilities.getRootPane(component);
                if (jRootPane == null) {
                    return;
                }
                AquaAppearance aquaAppearance = AppearanceManager.getSpecifiedAppearanceVariant(component);
                if (aquaAppearance != null) {
                    AppearanceManager.updateAppearancesInSubtree(component, aquaAppearance, true);
                } else {
                    AquaAppearance aquaAppearance2 = AppearanceManager.getInheritedAppearance(component);
                    if (aquaAppearance2 != null) {
                        AppearanceManager.updateAppearancesInSubtree(component, aquaAppearance2, true);
                    }
                }
            }
        }
    }

    private static class AppearanceManagerHierarchyListener
    implements HierarchyListener {
        private AppearanceManagerHierarchyListener() {
        }

        @Override
        public void hierarchyChanged(@NotNull HierarchyEvent hierarchyEvent) {
            long l = hierarchyEvent.getChangeFlags();
            if ((l & 1L) != 0L) {
                Component component = hierarchyEvent.getChanged();
                updateProcessor.acceptTop(component);
            }
        }
    }

    private static class ActiveStateListener
    implements PropertyChangeListener {
        private ActiveStateListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            JComponent jComponent;
            AquaComponentUI aquaComponentUI;
            Object object2 = propertyChangeEvent.getSource();
            if (object2 instanceof JComponent && (aquaComponentUI = AquaUtils.getUI(jComponent = (JComponent)object2, AquaComponentUI.class)) != null && (object = propertyChangeEvent.getNewValue()) instanceof Boolean) {
                Boolean bl = (Boolean)object;
                aquaComponentUI.activeStateChanged(jComponent, bl);
            }
        }
    }

    private static class AppearanceNamePropertyListener
    implements PropertyChangeListener {
        private AppearanceNamePropertyListener() {
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                Object object2 = propertyChangeEvent.getNewValue();
                if (object2 == null || object2 instanceof String) {
                    String string = (String)object2;
                    AppearanceManager.specifiedAppearanceNameChanged(jComponent, string);
                }
            }
        }
    }

    private static class WeakComponentSet {
        private final WeakHashMap<JComponent, JComponent> map = new WeakHashMap();

        private WeakComponentSet() {
        }

        public void add(@NotNull JComponent jComponent) {
            this.map.put(jComponent, jComponent);
        }

        public void remove(@NotNull JComponent jComponent) {
            this.map.remove(jComponent);
        }

        public boolean contains(@NotNull Component component) {
            return component instanceof JComponent && this.map.containsKey(component);
        }

        @NotNull
        public List<JComponent> components() {
            return new ArrayList<JComponent>(this.map.keySet());
        }
    }
}

