/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.treetable;

import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeModel
implements TreeModel {
    protected EventListenerList listenerList = new EventListenerList();

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(TreeModelListener.class, treeModelListener);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(TreeModelListener.class, treeModelListener);
    }

    public void fireNodeChanged(TreePath treePath, int n, Object object) {
        AbstractTreeModel.fireNodesChanged(this.listenerList, this, treePath, new int[]{n}, new Object[]{object});
    }

    public void fireNodesChanged(TreePath treePath, int[] nArray, Object[] objectArray) {
        AbstractTreeModel.fireNodesChanged(this.listenerList, this, treePath, nArray, objectArray);
    }

    public void fireNodeInserted(TreePath treePath, int n, Object object) {
        AbstractTreeModel.fireNodesInserted(this.listenerList, this, treePath, new int[]{n}, new Object[]{object});
    }

    public void fireNodesInserted(TreePath treePath, int[] nArray, Object[] objectArray) {
        AbstractTreeModel.fireNodesInserted(this.listenerList, this, treePath, nArray, objectArray);
    }

    public void fireNodeRemoved(TreePath treePath, int n, Object object) {
        AbstractTreeModel.fireNodesRemoved(this.listenerList, this, treePath, new int[]{n}, new Object[]{object});
    }

    public void fireNodesRemoved(TreePath treePath, int[] nArray, Object[] objectArray) {
        AbstractTreeModel.fireNodesRemoved(this.listenerList, this, treePath, nArray, objectArray);
    }

    public void fireTreeStructureChanged(TreePath treePath) {
        AbstractTreeModel.fireTreeStructureChanged(this.listenerList, this, treePath);
    }

    public static void fireNodesChanged(EventListenerList eventListenerList, TreeModel treeModel, TreePath treePath, int[] nArray, Object[] objectArray) {
        Object[] objectArray2 = eventListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, treePath, nArray, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeNodesChanged(treeModelEvent);
        }
    }

    public static void fireNodesInserted(EventListenerList eventListenerList, TreeModel treeModel, TreePath treePath, int[] nArray, Object[] objectArray) {
        if (nArray == null || objectArray == null) {
            throw new NullPointerException();
        }
        Object[] objectArray2 = eventListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, treePath, nArray, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeNodesInserted(treeModelEvent);
        }
    }

    public static void fireNodesRemoved(EventListenerList eventListenerList, TreeModel treeModel, TreePath treePath, int[] nArray, Object[] objectArray) {
        if (nArray == null || objectArray == null) {
            throw new NullPointerException();
        }
        Object[] objectArray2 = eventListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray2.length - 2; i >= 0; i -= 2) {
            if (objectArray2[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, treePath, nArray, objectArray);
            }
            ((TreeModelListener)objectArray2[i + 1]).treeNodesRemoved(treeModelEvent);
        }
    }

    public static void fireTreeStructureChanged(EventListenerList eventListenerList, TreeModel treeModel, TreePath treePath) {
        Object[] objectArray = eventListenerList.getListenerList();
        TreeModelEvent treeModelEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != TreeModelListener.class) continue;
            if (treeModelEvent == null) {
                treeModelEvent = new TreeModelEvent((Object)treeModel, treePath, null, null);
            }
            ((TreeModelListener)objectArray[i + 1]).treeStructureChanged(treeModelEvent);
        }
    }
}

