/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.geom.LinearBounds;
import org.violetlib.jnr.Insetter;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUILayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ComboBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.GroupBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.ListBoxLayoutConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.ProgressIndicatorLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarConfiguration;
import org.violetlib.jnr.aqua.ScrollBarLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbConfiguration;
import org.violetlib.jnr.aqua.ScrollBarThumbLayoutConfiguration;
import org.violetlib.jnr.aqua.ScrollColumnSizerLayoutConfiguration;
import org.violetlib.jnr.aqua.SegmentedButtonLayoutConfiguration;
import org.violetlib.jnr.aqua.SliderLayoutConfiguration;
import org.violetlib.jnr.aqua.SpinnerArrowsLayoutConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerLayoutConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderLayoutConfiguration;
import org.violetlib.jnr.aqua.TextFieldLayoutConfiguration;
import org.violetlib.jnr.aqua.TitleBarLayoutConfiguration;
import org.violetlib.jnr.aqua.ToolBarItemWellLayoutConfiguration;
import org.violetlib.jnr.aqua.impl.AquaNativePainter;
import org.violetlib.jnr.aqua.impl.TitleBarLayoutInfo;
import org.violetlib.jnr.impl.BasicLayoutInfo;
import org.violetlib.jnr.impl.CenteredInsetter1;
import org.violetlib.jnr.impl.CombinedInsetter;
import org.violetlib.jnr.impl.DynamicInsetter1;
import org.violetlib.jnr.impl.FixedInsetter1;
import org.violetlib.jnr.impl.FloatingInsetter1;
import org.violetlib.jnr.impl.Insetter1;
import org.violetlib.jnr.impl.Insetters;
import org.violetlib.jnr.impl.JNRUtils;

public class YosemiteLayoutInfo
extends AquaUILayoutInfo {
    @Override
    @NotNull
    protected LayoutInfo getButtonLayoutInfo(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
            ToolBarItemWellLayoutConfiguration toolBarItemWellLayoutConfiguration = new ToolBarItemWellLayoutConfiguration();
            return this.getToolBarItemWellLayoutInfo(toolBarItemWellLayoutConfiguration);
        }
        AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            return BasicLayoutInfo.getInstance();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            return BasicLayoutInfo.getInstance();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 14, 12, 10), JNRUtils.size(size, 14, 12, 10));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 16, 14, 10), JNRUtils.size(size, 16, 14, 10));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 21, 19, 15), JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 21, 18, 15), JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
            return BasicLayoutInfo.getInstance();
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
            return BasicLayoutInfo.createFixedHeight(17.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 23, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 20, 17, 14), JNRUtils.size(size, 21, 18, 15));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
            return BasicLayoutInfo.createFixed(18.0f, 18.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
            return BasicLayoutInfo.createFixed(JNRUtils.size(size, 21, 18, 15), JNRUtils.size(size, 22, 19, 16));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
            return BasicLayoutInfo.createFixed(9.0f, 9.0f);
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
            return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 19, 17, 15));
        }
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return BasicLayoutInfo.createMinimum(44.0f, 23.0f);
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @Nullable
    public Insetter getButtonLabelInsets(@NotNull ButtonLayoutConfiguration buttonLayoutConfiguration) {
        AquaUIPainter.ButtonWidget buttonWidget = buttonLayoutConfiguration.getButtonWidget();
        AquaUIPainter.Size size = buttonLayoutConfiguration.getSize();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH) {
            f = JNRUtils.size(size, 1, 2, 1);
            f2 = JNRUtils.size(size, 2, 2, 2);
            f4 = f3 = (float)JNRUtils.size(size, 4, 4, 3);
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL) {
            f = 1.0f;
            f2 = 1.0f;
            f3 = 1.0f;
            f4 = 1.0f;
        } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_BEVEL_ROUND) {
            f = JNRUtils.size(size, 1, 2, 1);
            f2 = JNRUtils.size(size, 2, 2, 2);
            f4 = f3 = (float)JNRUtils.size(size, 4, 4, 3);
        } else {
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_CHECK_BOX) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RADIO) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_HELP) {
                return null;
            }
            if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_GRADIENT) {
                f = 1.0f;
                f2 = 1.0f;
                f3 = 1.0f;
                f4 = 1.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_RECESSED) {
                f2 = 1.0f;
                f = 1.0f;
                f3 = f4 = (float)JNRUtils.size(size, 4, 3, 3);
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_INLINE) {
                f = 2.0f;
                f2 = 2.0f;
                f3 = f4 = (float)JNRUtils.size(size, 6, 5, 5);
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUNDED_RECT) {
                f2 = 1.0f;
                f = 1.0f;
                f4 = 4.0f;
                f3 = 4.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TEXTURED) {
                f = 1.0f;
                f2 = 2.0f;
                f4 = 3.0f;
                f3 = 3.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND) {
                f3 = f4 = JNRUtils.size2D(size, 4.0f, 3.5f, 3.0f);
                f = f4;
                f2 = f + 1.0f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_INSET) {
                f4 = 3.0f;
                f3 = 3.0f;
                f2 = f = 3.5f;
            } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_ROUND_TEXTURED) {
                f3 = f4 = JNRUtils.size2D(size, 3.5f, 3.0f, 2.5f);
                f = f4;
                f2 = f + 1.0f;
            } else {
                if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_DISCLOSURE_TRIANGLE) {
                    return null;
                }
                if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_PUSH_INSET2) {
                    f = JNRUtils.size(size, 1, 1, 1);
                    f2 = JNRUtils.size(size, 1, 1, 1);
                    f4 = f3 = (float)JNRUtils.size(size, 7, 6, 6);
                } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_TOOLBAR_ITEM) {
                    f2 = 4.0f;
                    f4 = 4.0f;
                    f3 = 4.0f;
                    f = 4.0f;
                } else if (buttonWidget == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
                    // empty if block
                }
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(buttonLayoutConfiguration);
        return Insetters.createFixed(f, f3, f2, f4, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getSegmentedButtonLayoutInfo(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration) {
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonLayoutConfiguration.getSize();
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 22, 19, 16));
            }
            case BUTTON_SEGMENTED_INSET: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 23, 19, 16));
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 21, 19, 17));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getSegmentedButtonLabelInsets(@NotNull SegmentedButtonLayoutConfiguration segmentedButtonLayoutConfiguration) {
        float f;
        AquaUIPainter.SegmentedButtonWidget segmentedButtonWidget = segmentedButtonLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = segmentedButtonLayoutConfiguration.getSize();
        AquaUIPainter.Position position = segmentedButtonLayoutConfiguration.getPosition();
        LayoutInfo layoutInfo = this.getLayoutInfo(segmentedButtonLayoutConfiguration);
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = f = (float)JNRUtils.size(size, 10, 8, 6);
        float f5 = 0.0f;
        boolean bl = position == AquaUIPainter.Position.FIRST || position == AquaUIPainter.Position.ONLY;
        boolean bl2 = position == AquaUIPainter.Position.LAST || position == AquaUIPainter.Position.ONLY;
        switch (segmentedButtonWidget) {
            case BUTTON_TAB: 
            case BUTTON_SEGMENTED: {
                f2 = JNRUtils.size(size, 1, 1, 1);
                f3 = JNRUtils.size(size, 2, 2, 3);
                f5 = 3.0f;
                break;
            }
            case BUTTON_SEGMENTED_INSET: {
                f2 = JNRUtils.size(size, 1, 1, 1);
                f3 = JNRUtils.size(size, 1, 1, 1);
                f5 = 4.0f;
                break;
            }
            case BUTTON_SEGMENTED_SCURVE: 
            case BUTTON_SEGMENTED_TEXTURED: 
            case BUTTON_SEGMENTED_TOOLBAR: 
            case BUTTON_SEGMENTED_TEXTURED_SEPARATED: {
                f2 = JNRUtils.size(size, 1, 1, 1);
                f3 = JNRUtils.size(size, 1, 1, 2);
                f5 = 2.0f;
                break;
            }
            case BUTTON_SEGMENTED_SMALL_SQUARE: {
                f2 = JNRUtils.size(size, 1, 1, 1);
                f3 = JNRUtils.size(size, 1, 1, 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (bl) {
            f += f5;
        }
        if (bl2) {
            f4 += f5;
        }
        return Insetters.createFixed(f2, f, f3, f4, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getComboBoxLayoutInfo(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxLayoutConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(size, 14, 11, 11));
        }
        float f = JNRUtils.size(size, 22, 19, 15);
        float f2 = JNRUtils.size(size, 27, 24, 22);
        return BasicLayoutInfo.create(false, f2, true, f);
    }

    @Override
    @NotNull
    public Insetter getComboBoxIndicatorInsets(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        int n;
        switch (comboBoxLayoutConfiguration.getSize()) {
            case SMALL: {
                n = 19;
                break;
            }
            case MINI: {
                n = 16;
                break;
            }
            default: {
                n = 21;
            }
        }
        return comboBoxLayoutConfiguration.isLeftToRight() ? Insetters.createRightAligned(n, 0.0f, 0.0f, 0.0f) : Insetters.createLeftAligned(n, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @NotNull
    public Insetter getComboBoxEditorInsets(@NotNull ComboBoxLayoutConfiguration comboBoxLayoutConfiguration) {
        AquaUIPainter.ComboBoxWidget comboBoxWidget = comboBoxLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = comboBoxLayoutConfiguration.getSize();
        if (comboBoxWidget == AquaUIPainter.ComboBoxWidget.BUTTON_COMBO_BOX_CELL) {
            float f = JNRUtils.size(size, 18, 18, 13);
            return comboBoxLayoutConfiguration.isLeftToRight() ? Insetters.createFixed(0.0f, 0.0f, 0.0f, f) : Insetters.createFixed(0.0f, f, 0.0f, 0.0f);
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(comboBoxLayoutConfiguration);
        float f = JNRUtils.size2D(size, 18.5f, 16.5f, 14.5f);
        float f2 = 0.5f;
        float f3 = 1.0f;
        float f4 = JNRUtils.size2D(size, 2.0f, 2.0f, 1.0f);
        return comboBoxLayoutConfiguration.isLeftToRight() ? Insetters.createFixed(f3, f2, f4, f, layoutInfo) : Insetters.createFixed(f3, f, f4, f2, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getPopUpButtonLayoutInfo(@NotNull PopupButtonLayoutConfiguration popupButtonLayoutConfiguration) {
        boolean bl;
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonLayoutConfiguration.getPopupButtonWidget();
        AquaUIPainter.Size size = popupButtonLayoutConfiguration.getSize();
        boolean bl2 = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl3 = bl = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((bl2 || bl) && size == AquaUIPainter.Size.MINI) {
            size = AquaUIPainter.Size.SMALL;
        }
        switch (popupButtonWidget) {
            case BUTTON_POP_UP: 
            case BUTTON_POP_DOWN: {
                float f = JNRUtils.size(size, 22, 19, 16);
                float f2 = JNRUtils.size(size, 25, 24, 20);
                return BasicLayoutInfo.create(false, f2, true, f);
            }
            case BUTTON_POP_UP_CELL: 
            case BUTTON_POP_DOWN_CELL: {
                return BasicLayoutInfo.createMinimumHeight(JNRUtils.size(size, 12, 10, 10));
            }
            case BUTTON_POP_UP_SQUARE: 
            case BUTTON_POP_DOWN_SQUARE: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 23, 20, 17));
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                return BasicLayoutInfo.createFixedHeight(22.0f);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_UP_ROUND_RECT: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_UP_RECESSED: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(size, 18, 16, 14));
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: {
                float f = JNRUtils.size(size, 23, 19, 16);
                float f3 = JNRUtils.size(size, 25, 24, 20);
                return BasicLayoutInfo.create(false, f3, true, f);
            }
            case BUTTON_POP_DOWN_GRADIENT: 
            case BUTTON_POP_UP_GRADIENT: {
                return BasicLayoutInfo.createFixedHeight(21.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getPopUpArrowInsets(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        float f;
        float f2;
        float f3;
        float f4;
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        boolean bl = popupButtonConfiguration.isCell();
        AquaUIPainter.Size size = popupButtonConfiguration.getSize();
        float f5 = bl ? (float)JNRUtils.size(size, 12, 10, 10) : (float)JNRUtils.size(size, 23, 20, 17);
        float f6 = JNRUtils.size(size, 7, 7, 7);
        if (popupButtonConfiguration.isPopUp()) {
            f4 = JNRUtils.size(size, 12, 10, 10);
            float f7 = f3 = bl ? JNRUtils.size2D(size, 0.0f, 0.0f, 0.0f) : JNRUtils.size2D(size, 7.0f, 5.5f, 5.5f);
            if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_GRADIENT) {
                f3 -= 1.0f;
            } else if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_BEVEL) {
                f3 -= 2.0f;
            } else if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED) {
                f3 -= JNRUtils.size2D(size, 1.5f, 0.0f, 2.0f);
            } else if (popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_TEXTURED) {
                f3 -= JNRUtils.size2D(size, 2.0f, 1.0f, 2.0f);
            }
            f2 = f5 - f3 - f4;
            f = bl ? 2.0f : 5.0f;
        } else {
            f4 = 5.0f;
            f3 = bl ? JNRUtils.size2D(size, 3.5f, 2.5f, 2.5f) : JNRUtils.size2D(size, 9.0f, 7.5f, 7.5f);
            f2 = f5 - f3 - f4;
            f = bl ? 3.0f : 6.0f;
        }
        FloatingInsetter1 floatingInsetter1 = popupButtonConfiguration.isLeftToRight() ? FloatingInsetter1.createRightBottomAligned(f6, f) : FloatingInsetter1.createLeftTopAligned(f6, f);
        FloatingInsetter1 floatingInsetter12 = FloatingInsetter1.createCentered(f4, f3, f2);
        return new CombinedInsetter(floatingInsetter1, floatingInsetter12);
    }

    @Override
    @NotNull
    public Insetter getPopupButtonContentInsets(@NotNull PopupButtonLayoutConfiguration popupButtonLayoutConfiguration) {
        float f;
        boolean bl;
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonLayoutConfiguration.getPopupButtonWidget();
        AquaUIPainter.Size size = popupButtonLayoutConfiguration.getSize();
        boolean bl2 = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_SQUARE || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_SQUARE;
        boolean bl3 = bl = popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_CELL || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_CELL;
        if ((bl2 || bl) && size == AquaUIPainter.Size.MINI) {
            size = AquaUIPainter.Size.SMALL;
        }
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 1.0f;
        switch (popupButtonWidget) {
            default: {
                f4 = 3.0f;
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 13.0f);
                f3 = JNRUtils.size2D(size, 2.5f, 2.5f, 2.0f);
                f2 = JNRUtils.size2D(size, 0.0f, 0.5f, 1.0f);
                break;
            }
            case BUTTON_POP_UP_SQUARE: {
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 15.0f);
                f3 = JNRUtils.size2D(size, 1.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_POP_UP_CELL: {
                float f5 = JNRUtils.size2D(size, 10.5f, 9.5f, 9.5f);
                return Insetters.createFixed(0.0f, 0.0f, 0.0f, f5);
            }
            case BUTTON_POP_UP_ROUND_RECT: 
            case BUTTON_POP_UP_RECESSED: 
            case BUTTON_POP_UP_GRADIENT: {
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 13.0f);
                break;
            }
            case BUTTON_POP_DOWN_BEVEL: 
            case BUTTON_POP_UP_BEVEL: {
                f3 = 2.0f;
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 13.0f);
                break;
            }
            case BUTTON_POP_DOWN_TEXTURED: 
            case BUTTON_POP_UP_TEXTURED: {
                f2 = 0.0f;
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 13.0f);
                break;
            }
            case BUTTON_POP_DOWN: {
                f4 = 3.0f;
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 13.0f);
                f3 = JNRUtils.size2D(size, 2.0f, 2.0f, 2.0f);
                f2 = JNRUtils.size2D(size, 1.0f, 1.0f, 1.0f);
                break;
            }
            case BUTTON_POP_DOWN_SQUARE: {
                f = JNRUtils.size2D(size, 18.0f, 18.0f, 16.0f);
                break;
            }
            case BUTTON_POP_DOWN_CELL: {
                float f6 = JNRUtils.size2D(size, 13.0f, 12.5f, 12.0f);
                return Insetters.createFixed(0.0f, 0.0f, 0.0f, f6);
            }
            case BUTTON_POP_DOWN_ROUND_RECT: 
            case BUTTON_POP_DOWN_RECESSED: 
            case BUTTON_POP_DOWN_GRADIENT: {
                f = JNRUtils.size2D(size, 17.0f, 15.0f, 13.0f);
            }
        }
        LayoutInfo layoutInfo = this.getLayoutInfo(popupButtonLayoutConfiguration);
        return popupButtonLayoutConfiguration.isLeftToRight() ? Insetters.createFixed(f2, f4, f3, f, layoutInfo) : Insetters.createFixed(f2, f, f3, f4, layoutInfo);
    }

    @Override
    @NotNull
    protected LayoutInfo getToolBarItemWellLayoutInfo(@NotNull ToolBarItemWellLayoutConfiguration toolBarItemWellLayoutConfiguration) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getTitleBarLayoutInfo(@NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration) {
        switch (titleBarLayoutConfiguration.getWidget()) {
            case DOCUMENT_WINDOW: {
                return BasicLayoutInfo.createFixedHeight(22.0f);
            }
            case UTILITY_WINDOW: {
                return BasicLayoutInfo.createFixedHeight(16.0f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Insetter getTitleBarButtonInsets(@NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        TitleBarLayoutInfo titleBarLayoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return titleBarLayoutInfo.getButtonInsets(titleBarLayoutConfiguration, titleBarButtonWidget);
    }

    @Override
    @NotNull
    public Shape getTitleBarButtonShape(@NotNull Rectangle2D rectangle2D, @NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration, @NotNull AquaUIPainter.TitleBarButtonWidget titleBarButtonWidget) {
        TitleBarLayoutInfo titleBarLayoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return titleBarLayoutInfo.getButtonShape(rectangle2D, titleBarLayoutConfiguration, titleBarButtonWidget);
    }

    @Override
    @Nullable
    public Insetter getTitleBarLabelInsets(@NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration) {
        TitleBarLayoutInfo titleBarLayoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return titleBarLayoutInfo.getLabelInsets(titleBarLayoutConfiguration);
    }

    @Override
    @Nullable
    public AquaUIPainter.TitleBarButtonWidget identifyTitleBarButton(@NotNull Rectangle2D rectangle2D, @NotNull TitleBarLayoutConfiguration titleBarLayoutConfiguration, int n, int n2) {
        TitleBarLayoutInfo titleBarLayoutInfo = AquaNativePainter.getTitleBarLayoutInfo();
        return titleBarLayoutInfo.identifyButton(rectangle2D, titleBarLayoutConfiguration, n, n2);
    }

    @Override
    @NotNull
    protected LayoutInfo getSliderLayoutInfo(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration) {
        AquaUIPainter.Size size = sliderLayoutConfiguration.getSize() == AquaUIPainter.Size.MINI ? AquaUIPainter.Size.SMALL : sliderLayoutConfiguration.getSize();
        boolean bl = sliderLayoutConfiguration.hasTickMarks();
        switch (sliderLayoutConfiguration.getWidget()) {
            case SLIDER_HORIZONTAL: 
            case SLIDER_HORIZONTAL_RIGHT_TO_LEFT: {
                return BasicLayoutInfo.createFixedHeight(bl ? (float)JNRUtils.size(size, 24, 18, 18) : (float)JNRUtils.size(size, 18, 14, 14));
            }
            case SLIDER_VERTICAL: 
            case SLIDER_UPSIDE_DOWN: {
                return BasicLayoutInfo.createFixedWidth(bl ? (float)JNRUtils.size(size, 24, 18, 18) : (float)JNRUtils.size(size, 18, 14, 14));
            }
            case SLIDER_CIRCULAR: {
                int n = bl ? JNRUtils.size(size, 32, 22, 22) : JNRUtils.size(size, 24, 18, 18);
                int n2 = bl ? JNRUtils.size(size, 32, 22, 22) : JNRUtils.size(size, 25, 19, 19);
                return BasicLayoutInfo.createFixed(n, n2);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Rectangle2D getSliderThumbBounds(@NotNull Rectangle2D rectangle2D, @NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        Insetter insetter = this.getSliderThumbInsets(sliderLayoutConfiguration, d);
        return insetter.applyToBounds2D(rectangle2D);
    }

    @Override
    @NotNull
    public Insetter getSliderTrackPaintingInsets(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration) {
        Insetter1 insetter1;
        Insetter1 insetter12;
        float f = 3.0f;
        if (sliderLayoutConfiguration.isHorizontal()) {
            float f2 = JNRUtils.size(sliderLayoutConfiguration.getSize(), 3, 1, 1);
            float f3 = this.getTrackOffset(sliderLayoutConfiguration);
            insetter12 = new FixedInsetter1(f2, f2);
            insetter1 = CenteredInsetter1.createCentered(f, f3);
        } else if (sliderLayoutConfiguration.isVertical()) {
            float f4 = JNRUtils.size(sliderLayoutConfiguration.getSize(), 3, 1, 1);
            float f5 = this.getTrackOffset(sliderLayoutConfiguration);
            insetter1 = new FixedInsetter1(f4, f4);
            insetter12 = CenteredInsetter1.createCentered(f, f5);
        } else {
            insetter12 = new FixedInsetter1(0.0f, 0.0f);
            insetter1 = new FixedInsetter1(0.0f, 0.0f);
        }
        return new CombinedInsetter(insetter12, insetter1);
    }

    protected float getTrackOffset(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration) {
        if (sliderLayoutConfiguration.hasTickMarks()) {
            AquaUIPainter.TickMarkPosition tickMarkPosition = sliderLayoutConfiguration.getTickMarkPosition();
            AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
            switch (tickMarkPosition) {
                case ABOVE: 
                case LEFT: {
                    return JNRUtils.size(size, 5, 3, 3);
                }
                case BELOW: 
                case RIGHT: {
                    return JNRUtils.size(size, -5, -3, -3);
                }
            }
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public Insetter getSliderThumbInsets(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        return this.getSliderThumbInsets(sliderLayoutConfiguration, d, false);
    }

    @Override
    @NotNull
    public Insetter getSliderThumbPaintingInsets(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        return this.getSliderThumbInsets(sliderLayoutConfiguration, d, true);
    }

    @NotNull
    protected Insetter getSliderThumbInsets(final @NotNull SliderLayoutConfiguration sliderLayoutConfiguration, final double d, boolean bl) {
        AquaUIPainter.SliderWidget sliderWidget = sliderLayoutConfiguration.getWidget();
        if (sliderWidget != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            LayoutInfo layoutInfo;
            LayoutInfo layoutInfo2 = this.getSliderThumbLayoutInfo(sliderLayoutConfiguration, bl);
            LayoutInfo layoutInfo3 = layoutInfo = bl ? this.getSliderThumbLayoutInfo(sliderLayoutConfiguration, false) : layoutInfo2;
            if (sliderLayoutConfiguration.isHorizontal()) {
                float f = this.getPointerOffset(sliderLayoutConfiguration);
                CenteredInsetter1 centeredInsetter1 = CenteredInsetter1.createCentered(layoutInfo2.getFixedVisualHeight(), layoutInfo.getFixedVisualHeight(), f);
                DynamicInsetter1 dynamicInsetter1 = new DynamicInsetter1(layoutInfo2.getFixedVisualWidth()){

                    @Override
                    protected float getCenterPosition(float f) {
                        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, 30.0f);
                        return (float)YosemiteLayoutInfo.this.getSliderThumbCenter(float_, sliderLayoutConfiguration, d);
                    }
                };
                return new CombinedInsetter(dynamicInsetter1, centeredInsetter1);
            }
            float f = this.getPointerOffset(sliderLayoutConfiguration);
            CenteredInsetter1 centeredInsetter1 = CenteredInsetter1.createCentered(layoutInfo2.getFixedVisualWidth(), layoutInfo.getFixedVisualWidth(), f);
            DynamicInsetter1 dynamicInsetter1 = new DynamicInsetter1(layoutInfo2.getFixedVisualHeight()){

                @Override
                protected float getCenterPosition(float f) {
                    Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 30.0f, f);
                    return (float)YosemiteLayoutInfo.this.getSliderThumbCenter(float_, sliderLayoutConfiguration, d);
                }
            };
            return new CombinedInsetter(centeredInsetter1, dynamicInsetter1);
        }
        return Insetters.createFixed(0.0f, 0.0f, 0.0f, 0.0f);
    }

    protected float getPointerOffset(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration) {
        if (!sliderLayoutConfiguration.hasTickMarks()) {
            if (sliderLayoutConfiguration.isHorizontal()) {
                AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
                return JNRUtils.size2D(size, 0.0f, -0.5f, -0.5f);
            }
            return 0.0f;
        }
        AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
        switch (sliderLayoutConfiguration.getTickMarkPosition()) {
            case LEFT: {
                return JNRUtils.size2D(size, 2.5f, 1.5f, 1.5f);
            }
            case RIGHT: {
                return JNRUtils.size2D(size, -2.0f, -1.5f, -1.5f);
            }
            case ABOVE: {
                return JNRUtils.size2D(size, 1.5f, 2.0f, 2.0f);
            }
            case BELOW: {
                return JNRUtils.size2D(size, -2.0f, -1.5f, -1.5f);
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public LayoutInfo getSliderThumbLayoutInfo(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration) {
        return this.getSliderThumbLayoutInfo(sliderLayoutConfiguration, true);
    }

    @NotNull
    protected LayoutInfo getSliderThumbLayoutInfo(@NotNull SliderLayoutConfiguration sliderLayoutConfiguration, boolean bl) {
        AquaUIPainter.SliderWidget sliderWidget = sliderLayoutConfiguration.getWidget();
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return BasicLayoutInfo.createFixed(0.0f, 0.0f);
        }
        AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
        if (sliderLayoutConfiguration.hasTickMarks()) {
            if (sliderLayoutConfiguration.isHorizontal()) {
                float f = bl ? (float)JNRUtils.size(size, 17, 14, 14) : (float)JNRUtils.size(size, 17, 13, 13);
                float f2 = bl ? (float)JNRUtils.size(size, 20, 14, 14) : JNRUtils.size2D(size, 19.0f, 14.0f, 14.0f);
                return BasicLayoutInfo.createFixed(f, f2);
            }
            float f = bl ? (float)JNRUtils.size(size, 19, 14, 14) : JNRUtils.size2D(size, 19.0f, 14.0f, 14.0f);
            float f3 = bl ? (float)JNRUtils.size(size, 18, 14, 14) : (float)JNRUtils.size(size, 17, 13, 13);
            return BasicLayoutInfo.createFixed(f, f3);
        }
        float f = JNRUtils.size(size, 17, 13, 13);
        float f4 = bl ? (float)JNRUtils.size(size, 18, 14, 14) : f;
        return BasicLayoutInfo.createFixed(f, f4);
    }

    @Override
    @NotNull
    public Rectangle2D getSliderLabelBounds(@NotNull Rectangle2D rectangle2D, @NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d, @NotNull Dimension dimension) {
        double d2;
        AquaUIPainter.SliderWidget sliderWidget = sliderLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
        AquaUIPainter.TickMarkPosition tickMarkPosition = sliderLayoutConfiguration.getTickMarkPosition();
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getY();
        double d5 = rectangle2D.getWidth();
        double d6 = rectangle2D.getHeight();
        switch (size) {
            case SMALL: {
                d2 = 6.5;
                break;
            }
            case MINI: {
                d2 = 5.0;
                break;
            }
            default: {
                d2 = 9.0;
            }
        }
        int n = 2;
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            d = 1.0 - d;
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
        } else if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            d = 1.0 - d;
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_VERTICAL;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            double d7 = d5 - 2.0 * d2;
            double d8 = d2 + d * d7;
            double d9 = tickMarkPosition == AquaUIPainter.TickMarkPosition.BELOW ? d6 + (double)n : (double)(-(n + dimension.height));
            double d10 = d8 - (double)(dimension.width / 2);
            return new Rectangle2D.Double(d3 + d10, d4 + d9, dimension.width, dimension.height);
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            double d11 = d6 - 2.0 * d2;
            double d12 = d2 + (1.0 - d) * d11;
            double d13 = tickMarkPosition == AquaUIPainter.TickMarkPosition.RIGHT ? d5 + (double)n : (double)(-(n + dimension.width));
            double d14 = d12 - (double)(dimension.height / 2);
            return new Rectangle2D.Double(d3 + d13, d4 + d14, dimension.width, dimension.height);
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            return new Rectangle2D.Double(d3, d4, dimension.width, dimension.height);
        }
        return new Rectangle2D.Double(d3, d4, 0.0, 0.0);
    }

    @Override
    public double getSliderThumbCenter(@NotNull Rectangle2D rectangle2D, @NotNull SliderLayoutConfiguration sliderLayoutConfiguration, double d) {
        AquaUIPainter.SliderWidget sliderWidget = sliderLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        double d6 = this.getSliderExtension(size);
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            d = 1.0 - d;
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL;
        } else if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            d = 1.0 - d;
            sliderWidget = AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            double d7 = d4 - 2.0 * d6;
            return d2 + d6 + d * d7;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            double d8 = d5 - 2.0 * d6;
            return d3 + d6 + d * d8;
        }
        return 0.0;
    }

    @Override
    public double getSliderThumbPosition(@NotNull Rectangle2D rectangle2D, @NotNull SliderLayoutConfiguration sliderLayoutConfiguration, int n, int n2) {
        AquaUIPainter.SliderWidget sliderWidget = sliderLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = sliderLayoutConfiguration.getSize();
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        double d5 = this.getSliderExtension(size);
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL) {
            if ((double)n < (d += d5)) {
                return -10.0;
            }
            double d6 = d + d3 - 2.0 * d5;
            if ((double)n > d6) {
                return 10.0;
            }
            double d7 = d6 - d;
            if (d7 == 0.0) {
                return 0.0;
            }
            return ((double)n - d) / d7;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_HORIZONTAL_RIGHT_TO_LEFT) {
            if ((double)n < (d += d5)) {
                return 10.0;
            }
            double d8 = d + d3 - 2.0 * d5;
            if ((double)n > d8) {
                return -10.0;
            }
            double d9 = d8 - d;
            if (d9 == 0.0) {
                return 0.0;
            }
            return 1.0 - ((double)n - d) / d9;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_VERTICAL) {
            if ((double)n2 < (d2 += d5)) {
                return 10.0;
            }
            double d10 = d2 + d4 - 2.0 * d5;
            if ((double)n2 > d10) {
                return -10.0;
            }
            double d11 = d10 - d2;
            if (d11 == 0.0) {
                return 0.0;
            }
            return 1.0 - ((double)n2 - d2) / d11;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_UPSIDE_DOWN) {
            if ((double)n2 < (d2 += d5)) {
                return -10.0;
            }
            double d12 = d2 + d4 - 2.0 * d5;
            if ((double)n2 > d12) {
                return 10.0;
            }
            double d13 = d12 - d2;
            if (d13 == 0.0) {
                return 0.0;
            }
            return ((double)n2 - d2) / d13;
        }
        if (sliderWidget == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            double d14 = d + d3 / 2.0;
            double d15 = d2 + d4 / 2.0;
            double d16 = Math.atan2((double)n - d14, (double)n2 - d15);
            return (d16 + Math.PI) / (Math.PI * 2);
        }
        return 0.0;
    }

    protected double getSliderExtension(@NotNull AquaUIPainter.Size size) {
        switch (size) {
            case SMALL: 
            case MINI: {
                return 6.5;
            }
        }
        return 10.0;
    }

    @Override
    @NotNull
    protected LayoutInfo getSpinnerArrowsLayoutInfo(@NotNull SpinnerArrowsLayoutConfiguration spinnerArrowsLayoutConfiguration) {
        AquaUIPainter.Size size = spinnerArrowsLayoutConfiguration.getSize();
        int n = JNRUtils.size(size, 13, 11, 9);
        int n2 = JNRUtils.size(size, 23, 20, 16);
        return BasicLayoutInfo.createFixed(n, n2);
    }

    @Override
    @NotNull
    protected LayoutInfo getSplitPaneDividerLayoutInfo(@NotNull SplitPaneDividerLayoutConfiguration splitPaneDividerLayoutConfiguration) {
        int n;
        AquaUIPainter.Orientation orientation = splitPaneDividerLayoutConfiguration.getOrientation();
        switch (splitPaneDividerLayoutConfiguration.getWidget()) {
            case THIN_DIVIDER: {
                n = 2;
                break;
            }
            case THICK_DIVIDER: {
                n = 10;
                break;
            }
            case PANE_SPLITTER: {
                n = 10;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return orientation == AquaUIPainter.Orientation.HORIZONTAL ? BasicLayoutInfo.createFixedHeight(n) : BasicLayoutInfo.createFixedWidth(n);
    }

    @Override
    @NotNull
    protected LayoutInfo getGroupBoxLayoutInfo(@NotNull GroupBoxLayoutConfiguration groupBoxLayoutConfiguration) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getListBoxLayoutInfo(@NotNull ListBoxLayoutConfiguration listBoxLayoutConfiguration) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getTextFieldLayoutInfo(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        switch (textFieldLayoutConfiguration.getWidget()) {
            case TEXT_FIELD_ROUND: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(textFieldLayoutConfiguration.getSize(), 22, 19, 17));
            }
            case TEXT_FIELD_SEARCH: 
            case TEXT_FIELD_SEARCH_WITH_CANCEL: 
            case TEXT_FIELD_SEARCH_WITH_MENU: 
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                return BasicLayoutInfo.createFixedHeight(JNRUtils.size(textFieldLayoutConfiguration.getSize(), 22, 19, 17));
            }
        }
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    public Insetter getTextFieldTextInsets(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        float f;
        float f2;
        float f3;
        float f4;
        Object object;
        AquaUIPainter.TextFieldWidget textFieldWidget = textFieldLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        int n = 0;
        float f5 = 6.0f;
        switch (textFieldWidget) {
            case TEXT_FIELD_SEARCH_WITH_MENU: 
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                n = 4;
                f5 = 3.5f;
            }
            case TEXT_FIELD_SEARCH: 
            case TEXT_FIELD_SEARCH_WITH_CANCEL: {
                if (textFieldLayoutConfiguration.isLeftToRight()) {
                    object = this.getSearchButtonPaintingInsets(textFieldLayoutConfiguration);
                    if (object != null) {
                        Rectangle2D rectangle2D = object.apply2D(100.0, 100.0);
                        f4 = (float)(rectangle2D.getX() + rectangle2D.getWidth() + (double)f5);
                    } else {
                        f4 = JNRUtils.size(size, 27 + n, 26 + n, 22 + n);
                    }
                    f3 = JNRUtils.size(size, 22, 19, 16);
                } else {
                    object = this.getSearchButtonPaintingInsets(textFieldLayoutConfiguration);
                    if (object != null) {
                        Rectangle2D rectangle2D = object.apply2D(100.0, 100.0);
                        f3 = (float)(100.0 - rectangle2D.getX() + (double)f5);
                    } else {
                        f3 = JNRUtils.size(size, 27 + n, 26 + n, 22 + n);
                    }
                    f4 = JNRUtils.size(size, 22, 19, 16);
                }
                f2 = JNRUtils.size2D(size, 3.0f, 1.5f, 2.0f);
                f = JNRUtils.size2D(size, 3.0f, 1.5f, 1.0f);
                break;
            }
            case TEXT_FIELD: {
                f3 = 1.0f;
                f4 = 1.0f;
                f = 1.0f;
                f2 = 1.0f;
                break;
            }
            case TEXT_FIELD_ROUND: {
                f = 1.0f;
                f2 = 1.0f;
                f3 = 2.5f;
                f4 = 2.5f;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        object = this.getLayoutInfo(textFieldLayoutConfiguration);
        return Insetters.createFixed(f2, f4, f, f3, (LayoutInfo)object);
    }

    @Override
    @Nullable
    public Insetter getSearchButtonInsets(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        float f;
        float f2 = 0.0f;
        switch (textFieldLayoutConfiguration.getWidget()) {
            case TEXT_FIELD_SEARCH_WITH_MENU: 
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                f2 = 4.0f;
            }
            case TEXT_FIELD_SEARCH: 
            case TEXT_FIELD_SEARCH_WITH_CANCEL: {
                f = JNRUtils.size(textFieldLayoutConfiguration.getSize(), 27, 26, 22);
                break;
            }
            default: {
                return null;
            }
        }
        return textFieldLayoutConfiguration.isLeftToRight() ? Insetters.createLeftAligned(f2, 0.0f, 0.0f, 0.0f) : Insetters.createRightAligned(f2 += f, 0.0f, 0.0f, 0.0f);
    }

    @Override
    @Nullable
    public Insetter getSearchButtonPaintingInsets(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        float f = JNRUtils.size(textFieldLayoutConfiguration.getSize(), 22, 19, 17);
        LayoutInfo layoutInfo = this.getSearchButtonLayoutInfo(textFieldLayoutConfiguration);
        if (layoutInfo != null) {
            float f2 = layoutInfo.getFixedVisualWidth();
            float f3 = layoutInfo.getFixedVisualHeight();
            if (f2 > 0.0f && f3 > 0.0f) {
                float f4 = JNRUtils.size2D(size, 5.0f, 4.0f, 4.5f);
                float f5 = JNRUtils.size2D(size, 6.5f, 6.0f, 5.5f);
                float f6 = f - f4 - f3;
                FloatingInsetter1 floatingInsetter1 = textFieldLayoutConfiguration.isLeftToRight() ? FloatingInsetter1.createLeftTopAligned(f2, f5) : FloatingInsetter1.createRightBottomAligned(f2, f5);
                FloatingInsetter1 floatingInsetter12 = FloatingInsetter1.createCentered(f3, f4, f6);
                return new CombinedInsetter(floatingInsetter1, floatingInsetter12);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public LayoutInfo getSearchButtonLayoutInfo(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        boolean bl = false;
        switch (textFieldLayoutConfiguration.getWidget()) {
            case TEXT_FIELD_SEARCH_WITH_MENU: 
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                bl = true;
                break;
            }
            case TEXT_FIELD_SEARCH: 
            case TEXT_FIELD_SEARCH_WITH_CANCEL: {
                break;
            }
            default: {
                return null;
            }
        }
        float f = JNRUtils.size2D(size, 13.0f, 12.0f, 10.0f);
        float f2 = bl ? JNRUtils.size2D(size, 17.0f, 16.0f, 14.0f) : f;
        return BasicLayoutInfo.createFixed(f2, f);
    }

    @Override
    @Nullable
    public Insetter getCancelButtonInsets(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        float f;
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        switch (textFieldLayoutConfiguration.getWidget()) {
            case TEXT_FIELD_SEARCH_WITH_CANCEL: 
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                f = JNRUtils.size(size, 14, 11, 9);
                break;
            }
            default: {
                return null;
            }
        }
        float f2 = JNRUtils.size(size, 4, 4, 3);
        return textFieldLayoutConfiguration.isLeftToRight() ? Insetters.createRightAligned(f, f2, 0.0f, 0.0f) : Insetters.createLeftAligned(f, f2, 0.0f, 0.0f);
    }

    @Override
    @Nullable
    public Insetter getCancelButtonPaintingInsets(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        float f = JNRUtils.size(textFieldLayoutConfiguration.getSize(), 22, 19, 17);
        LayoutInfo layoutInfo = this.getCancelButtonLayoutInfo(textFieldLayoutConfiguration);
        if (layoutInfo != null) {
            float f2 = layoutInfo.getFixedVisualWidth();
            float f3 = layoutInfo.getFixedVisualHeight();
            if (f2 > 0.0f && f3 > 0.0f) {
                float f4 = JNRUtils.size(size, 4, 4, 4);
                float f5 = JNRUtils.size(size, 4, 4, 3);
                float f6 = f - f4 - f3;
                FloatingInsetter1 floatingInsetter1 = textFieldLayoutConfiguration.isLeftToRight() ? FloatingInsetter1.createRightBottomAligned(f2, f5) : FloatingInsetter1.createLeftTopAligned(f2, f5);
                FloatingInsetter1 floatingInsetter12 = FloatingInsetter1.createCentered(f3, f4, f6);
                return new CombinedInsetter(floatingInsetter1, floatingInsetter12);
            }
        }
        return null;
    }

    @Override
    @Nullable
    public LayoutInfo getCancelButtonLayoutInfo(@NotNull TextFieldLayoutConfiguration textFieldLayoutConfiguration) {
        float f;
        AquaUIPainter.Size size = textFieldLayoutConfiguration.getSize();
        switch (textFieldLayoutConfiguration.getWidget()) {
            case TEXT_FIELD_SEARCH_WITH_CANCEL: 
            case TEXT_FIELD_SEARCH_WITH_MENU_AND_CANCEL: {
                f = JNRUtils.size(size, 14, 11, 9);
                break;
            }
            default: {
                return null;
            }
        }
        return BasicLayoutInfo.createFixed(f, f);
    }

    @Override
    @NotNull
    protected LayoutInfo getScrollBarLayoutInfo(@NotNull ScrollBarLayoutConfiguration scrollBarLayoutConfiguration) {
        AquaUIPainter.ScrollBarWidget scrollBarWidget = scrollBarLayoutConfiguration.getWidget();
        AquaUIPainter.Size size = scrollBarLayoutConfiguration.getSize();
        AquaUIPainter.Orientation orientation = scrollBarLayoutConfiguration.getOrientation();
        int n = 0;
        block0 : switch (scrollBarWidget) {
            case LEGACY: {
                switch (size) {
                    case REGULAR: 
                    case LARGE: {
                        n = 15;
                        break;
                    }
                    case SMALL: 
                    case MINI: {
                        n = 11;
                    }
                }
                break;
            }
            case OVERLAY: {
                switch (size) {
                    case REGULAR: 
                    case LARGE: {
                        n = 12;
                        break;
                    }
                    case SMALL: 
                    case MINI: {
                        n = 10;
                    }
                }
                break;
            }
            case OVERLAY_ROLLOVER: {
                switch (size) {
                    case REGULAR: 
                    case LARGE: {
                        n = 16;
                        break block0;
                    }
                    case SMALL: 
                    case MINI: {
                        n = 14;
                    }
                }
            }
        }
        return orientation == AquaUIPainter.Orientation.VERTICAL ? BasicLayoutInfo.createFixedWidth(n) : BasicLayoutInfo.createFixedHeight(n);
    }

    @Override
    public float getScrollBarThumbPosition(@NotNull Rectangle2D rectangle2D, @NotNull ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration, boolean bl) {
        double d = this.getScrollTrackEndInset(scrollBarThumbLayoutConfiguration);
        boolean bl2 = scrollBarThumbLayoutConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        double d2 = bl2 ? rectangle2D.getY() + d : rectangle2D.getX() + d;
        double d3 = bl2 ? rectangle2D.getHeight() - 2.0 * d : rectangle2D.getWidth() - 2.0 * d;
        double d4 = bl ? d3 - this.getVisualThumbExtent(rectangle2D, scrollBarThumbLayoutConfiguration) : d3;
        double d5 = ((double)scrollBarThumbLayoutConfiguration.getValue() - d2) / d4;
        if (d5 >= 0.0) {
            if (d5 <= 1.0) {
                return (float)d5;
            }
            return 10.0f;
        }
        return -10.0f;
    }

    @Override
    @NotNull
    public Rectangle2D getScrollBarThumbBounds(@NotNull Rectangle2D rectangle2D, @NotNull ScrollBarConfiguration scrollBarConfiguration) {
        LinearBounds linearBounds = this.getThumbBounds(rectangle2D, scrollBarConfiguration);
        if (scrollBarConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL) {
            return new Rectangle2D.Double(rectangle2D.getX(), linearBounds.getOrigin(), rectangle2D.getWidth(), linearBounds.getLength());
        }
        return new Rectangle2D.Double(linearBounds.getOrigin(), rectangle2D.getY(), linearBounds.getLength(), rectangle2D.getHeight());
    }

    @NotNull
    protected LinearBounds getThumbBounds(@NotNull Rectangle2D rectangle2D, @NotNull ScrollBarConfiguration scrollBarConfiguration) {
        double d = this.getScrollTrackEndInset(scrollBarConfiguration);
        int n = this.getMinimumThumbLength(scrollBarConfiguration);
        boolean bl = scrollBarConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        double d2 = bl ? rectangle2D.getY() + d : rectangle2D.getX() + d;
        double d3 = bl ? rectangle2D.getHeight() - 2.0 * d : rectangle2D.getWidth() - 2.0 * d;
        double d4 = Math.max((double)n, (double)scrollBarConfiguration.getThumbExtent() * d3);
        double d5 = Math.max(0.0, d3 - d4);
        double d6 = d2 + (double)scrollBarConfiguration.getThumbPosition() * d5;
        return new LinearBounds(d6, d4);
    }

    protected double getVisualThumbExtent(@NotNull Rectangle2D rectangle2D, @NotNull ScrollBarThumbLayoutConfiguration scrollBarThumbLayoutConfiguration) {
        double d = this.getScrollTrackEndInset(scrollBarThumbLayoutConfiguration);
        boolean bl = scrollBarThumbLayoutConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        double d2 = bl ? rectangle2D.getHeight() - 2.0 * d : rectangle2D.getWidth() - 2.0 * d;
        int n = this.getMinimumThumbLength(scrollBarThumbLayoutConfiguration);
        return Math.max((double)n, (double)scrollBarThumbLayoutConfiguration.getThumbExtent() * d2);
    }

    protected int getMinimumThumbLength(@NotNull ScrollBarLayoutConfiguration scrollBarLayoutConfiguration) {
        switch (scrollBarLayoutConfiguration.getSize()) {
            case SMALL: 
            case MINI: {
                return 14;
            }
        }
        return 18;
    }

    protected double getScrollTrackEndInset(@NotNull ScrollBarLayoutConfiguration scrollBarLayoutConfiguration) {
        switch (scrollBarLayoutConfiguration.getWidget()) {
            case LEGACY: {
                return 3.0;
            }
        }
        return 2.0;
    }

    @Override
    public int getScrollBarThumbHit(@NotNull Rectangle2D rectangle2D, @NotNull ScrollBarThumbConfiguration scrollBarThumbConfiguration) {
        boolean bl;
        int n = scrollBarThumbConfiguration.getValue();
        boolean bl2 = bl = scrollBarThumbConfiguration.getOrientation() == AquaUIPainter.Orientation.VERTICAL;
        if (bl ? (double)n < rectangle2D.getY() || (double)n > rectangle2D.getY() + rectangle2D.getHeight() : (double)n < rectangle2D.getX() || (double)n > rectangle2D.getX() + rectangle2D.getWidth()) {
            return -1000;
        }
        LinearBounds linearBounds = this.getThumbBounds(rectangle2D, scrollBarThumbConfiguration);
        if ((double)n < linearBounds.getOrigin()) {
            return -1;
        }
        if ((double)n > linearBounds.getOrigin() + linearBounds.getLength()) {
            return 1;
        }
        return 0;
    }

    @Override
    @NotNull
    protected LayoutInfo getScrollColumnSizerLayoutInfo(@NotNull ScrollColumnSizerLayoutConfiguration scrollColumnSizerLayoutConfiguration) {
        return BasicLayoutInfo.getInstance();
    }

    @Override
    @NotNull
    protected LayoutInfo getProgressIndicatorLayoutInfo(@NotNull ProgressIndicatorLayoutConfiguration progressIndicatorLayoutConfiguration) {
        AquaUIPainter.ProgressWidget progressWidget = progressIndicatorLayoutConfiguration.getWidget();
        AquaUIPainter.Orientation orientation = progressIndicatorLayoutConfiguration.getOrientation();
        AquaUIPainter.Size size = progressIndicatorLayoutConfiguration.getSize();
        if (progressWidget == AquaUIPainter.ProgressWidget.BAR || progressWidget == AquaUIPainter.ProgressWidget.INDETERMINATE_BAR) {
            if (orientation == AquaUIPainter.Orientation.HORIZONTAL) {
                return BasicLayoutInfo.createFixedHeight(6.0f);
            }
            return BasicLayoutInfo.createFixedWidth(6.0f);
        }
        if (progressWidget == AquaUIPainter.ProgressWidget.SPINNER) {
            int n = JNRUtils.size(size, 32, 16, 12);
            return BasicLayoutInfo.createFixed(n, n);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    protected LayoutInfo getTableColumnHeaderLayoutInfo(@NotNull TableColumnHeaderLayoutConfiguration tableColumnHeaderLayoutConfiguration) {
        int n = tableColumnHeaderLayoutConfiguration.isSortable() ? 31 : 0;
        return BasicLayoutInfo.createMinimum(n, 15.0f);
    }

    @Override
    @Nullable
    public Insetter getTableColumnHeaderSortArrowInsets(@NotNull TableColumnHeaderLayoutConfiguration tableColumnHeaderLayoutConfiguration) {
        int n = this.getTableHeaderSortIndicatorWidth(tableColumnHeaderLayoutConfiguration);
        boolean bl = true;
        int n2 = 7;
        return tableColumnHeaderLayoutConfiguration.isLeftToRight() ? Insetters.createRightAligned(n, n2, (float)bl, (float)bl) : Insetters.createLeftAligned(n, n2, (float)bl, (float)bl);
    }

    @Override
    @NotNull
    public Insetter getTableColumnHeaderLabelInsets(@NotNull TableColumnHeaderLayoutConfiguration tableColumnHeaderLayoutConfiguration) {
        int n = 7 + this.getTableHeaderSortIndicatorWidth(tableColumnHeaderLayoutConfiguration);
        boolean bl = true;
        int n2 = 3;
        return tableColumnHeaderLayoutConfiguration.isLeftToRight() ? Insetters.createFixed((float)bl, n2, (float)bl, n) : Insetters.createFixed((float)bl, n, (float)bl, n2);
    }

    protected int getTableHeaderSortIndicatorWidth(@NotNull TableColumnHeaderLayoutConfiguration tableColumnHeaderLayoutConfiguration) {
        return tableColumnHeaderLayoutConfiguration.isSortable() ? 11 : 0;
    }
}

