/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.coreui;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.ButtonConfiguration;
import org.violetlib.jnr.aqua.PopupButtonConfiguration;
import org.violetlib.jnr.aqua.SliderConfiguration;
import org.violetlib.jnr.aqua.SplitPaneDividerConfiguration;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.aqua.coreui.ColorWellRenderer;
import org.violetlib.jnr.aqua.coreui.CoreUIPainter;
import org.violetlib.jnr.aqua.impl.CircularSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.LinearSliderPainterExtension;
import org.violetlib.jnr.aqua.impl.PopUpArrowPainter;
import org.violetlib.jnr.aqua.impl.PullDownArrowPainter;
import org.violetlib.jnr.aqua.impl.TableColumnHeaderCellPainterExtension;
import org.violetlib.jnr.aqua.impl.ThinSplitPaneDividerPainterExtension;
import org.violetlib.jnr.impl.Renderer;

public class AugmentedCoreUIPainter
extends CoreUIPainter {
    public AugmentedCoreUIPainter() {
    }

    public AugmentedCoreUIPainter(boolean bl) {
        super(bl);
    }

    @Override
    @NotNull
    public AugmentedCoreUIPainter copy() {
        return new AugmentedCoreUIPainter(this.useJRS);
    }

    @Override
    @NotNull
    protected Renderer getButtonRenderer(@NotNull ButtonConfiguration buttonConfiguration) {
        Renderer renderer = super.getButtonRenderer(buttonConfiguration);
        if (buttonConfiguration.getButtonWidget() == AquaUIPainter.ButtonWidget.BUTTON_COLOR_WELL) {
            return new ColorWellRenderer(buttonConfiguration, renderer);
        }
        return renderer;
    }

    @Override
    @NotNull
    protected Renderer getSplitPaneDividerRenderer(@NotNull SplitPaneDividerConfiguration splitPaneDividerConfiguration) {
        if (splitPaneDividerConfiguration.getWidget() == AquaUIPainter.DividerWidget.THIN_DIVIDER) {
            ThinSplitPaneDividerPainterExtension thinSplitPaneDividerPainterExtension = new ThinSplitPaneDividerPainterExtension(splitPaneDividerConfiguration);
            return Renderer.create(thinSplitPaneDividerPainterExtension);
        }
        return super.getSplitPaneDividerRenderer(splitPaneDividerConfiguration);
    }

    @Override
    @NotNull
    public Renderer getTableColumnHeaderRenderer(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        TableColumnHeaderCellPainterExtension tableColumnHeaderCellPainterExtension = new TableColumnHeaderCellPainterExtension(tableColumnHeaderConfiguration);
        return Renderer.create(tableColumnHeaderCellPainterExtension);
    }

    @Override
    @NotNull
    protected Renderer getSliderRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        Renderer renderer = super.getSliderRenderer(sliderConfiguration);
        if (sliderConfiguration.getWidget() == AquaUIPainter.SliderWidget.SLIDER_CIRCULAR) {
            Renderer renderer2 = Renderer.create(new CircularSliderPainterExtension(sliderConfiguration));
            return Renderer.createCompositeRenderer(renderer, renderer2);
        }
        return renderer;
    }

    @Override
    @Nullable
    protected Renderer getSliderTickMarkRenderer(@NotNull SliderConfiguration sliderConfiguration) {
        if (sliderConfiguration.getWidget() != AquaUIPainter.SliderWidget.SLIDER_CIRCULAR && sliderConfiguration.hasTickMarks()) {
            return Renderer.create(new LinearSliderPainterExtension(uiLayout, sliderConfiguration));
        }
        return null;
    }

    @Override
    @Nullable
    public Renderer getPopupArrowRenderer(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        Renderer renderer = super.getPopupArrowRenderer(popupButtonConfiguration);
        if (this.isArrowNeeded(popupButtonConfiguration)) {
            if (popupButtonConfiguration.isPopUp()) {
                return Renderer.create(new PopUpArrowPainter(popupButtonConfiguration));
            }
            return Renderer.create(new PullDownArrowPainter(popupButtonConfiguration));
        }
        return renderer;
    }

    private boolean isArrowNeeded(@NotNull PopupButtonConfiguration popupButtonConfiguration) {
        AquaUIPainter.PopupButtonWidget popupButtonWidget = popupButtonConfiguration.getPopupButtonWidget();
        return popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_UP_RECESSED || popupButtonWidget == AquaUIPainter.PopupButtonWidget.BUTTON_POP_DOWN_RECESSED;
    }
}

