/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Image;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileView;
import org.violetlib.aqua.fc.AquaFileView;
import org.violetlib.aqua.fc.DelegatedFileSystemViewBase;
import org.violetlib.aqua.fc.OSXFile;
import org.violetlib.aqua.fc.OSXFileSystemView;

public abstract class AquaFileSystemView
extends DelegatedFileSystemViewBase {
    private static AquaFileSystemView fileSystemView;

    public File canonicalize(File file) {
        return file;
    }

    public abstract File getComputer();

    public abstract File getSystemVolume();

    public FileView createFileView(JFileChooser jFileChooser) {
        return new AquaFileView(this);
    }

    public static AquaFileSystemView getAquaFileSystemView() {
        if (fileSystemView == null) {
            fileSystemView = new OSXFileSystemView();
        }
        return fileSystemView;
    }

    @Override
    public Icon getSystemIcon(File file) {
        if (file.equals(this.getComputer())) {
            return UIManager.getIcon("FileView.computerIcon");
        }
        if (OSXFile.isAvailable()) {
            try {
                Image image = OSXFile.getIconImage(file, 16, false);
                return new ImageIcon(image);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
        return this.target.getSystemIcon(file);
    }

    @Override
    public String getSystemTypeDescription(File file) {
        if (OSXFile.isAvailable()) {
            return OSXFile.getKindString(file);
        }
        return this.target.getSystemTypeDescription(file);
    }

    @Override
    public Boolean isTraversable(File file) {
        if (OSXFile.isAvailable()) {
            return OSXFile.isTraversable(file);
        }
        return this.target.isTraversable(file);
    }

    public Boolean isTraversable(File file, boolean bl, boolean bl2) {
        if (OSXFile.isAvailable()) {
            return OSXFile.isTraversable(file, bl, bl2);
        }
        return this.target.isTraversable(file);
    }

    @Override
    public String getSystemDisplayName(File file) {
        if (file.equals(this.getComputer())) {
            String string = OSXFile.getComputerName();
            return string != null ? string : this.getSystemVolume().getName();
        }
        if (OSXFile.isAvailable()) {
            return OSXFile.getDisplayName(file);
        }
        return this.target.getSystemDisplayName(file);
    }
}

