/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.violetlib.aqua.AquaPainting;
import org.violetlib.aqua.AquaSplitPaneDivider;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.LayoutInfo;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.SplitPaneDividerLayoutConfiguration;

public class AquaSplitPaneUI
extends BasicSplitPaneUI
implements MouseListener,
PropertyChangeListener {
    static final String DIVIDER_PAINTER_KEY = "JSplitPane.dividerPainter";
    public static final String SPLIT_PANE_STYLE_KEY = "JSplitPane.style";
    public static final String QUAQUA_SPLIT_PANE_STYLE_KEY = "Quaqua.SplitPane.style";
    final AquaUIPainter painter = AquaPainting.create();
    protected static SplitPaneStyle defaultStyle = SplitPaneStyle.THIN;
    protected SplitPaneStyle style = defaultStyle;

    public static ComponentUI createUI(JComponent jComponent) {
        return new AquaSplitPaneUI();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new AquaSplitPaneDivider(this);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.splitPane.setOneTouchExpandable(false);
        SplitPaneStyle splitPaneStyle = this.getClientSpecifiedStyle();
        if (splitPaneStyle != null) {
            this.style = splitPaneStyle;
        }
        this.updateDividerSize();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.splitPane.addPropertyChangeListener(SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.addPropertyChangeListener(QUAQUA_SPLIT_PANE_STYLE_KEY, this);
        this.divider.addMouseListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.divider.removeMouseListener(this);
        this.splitPane.removePropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.splitPane.removePropertyChangeListener(SPLIT_PANE_STYLE_KEY, this);
        this.splitPane.removePropertyChangeListener(QUAQUA_SPLIT_PANE_STYLE_KEY, this);
        super.uninstallListeners();
    }

    protected void updateStyle() {
        SplitPaneStyle splitPaneStyle = this.getClientSpecifiedStyle();
        if (splitPaneStyle == null) {
            splitPaneStyle = defaultStyle;
        }
        if (this.style != splitPaneStyle) {
            this.style = splitPaneStyle;
            this.updateDividerSize();
            this.divider.repaint();
        }
    }

    protected void updateDividerSize() {
        int n = this.getFixedDividerSize();
        if (n > 0) {
            LookAndFeel.installProperty(this.splitPane, "dividerSize", n);
            this.divider.setDividerSize(this.splitPane.getDividerSize());
            this.dividerSize = this.divider.getDividerSize();
        }
    }

    public AquaUIPainter.DividerWidget getWidget() {
        switch (this.style) {
            case PANE_SPLITTER: {
                return AquaUIPainter.DividerWidget.PANE_SPLITTER;
            }
            case THICK: {
                return AquaUIPainter.DividerWidget.THICK_DIVIDER;
            }
        }
        return AquaUIPainter.DividerWidget.THIN_DIVIDER;
    }

    public int getFixedDividerSize() {
        boolean bl = this.splitPane.getOrientation() == 1;
        AquaUIPainter.DividerWidget dividerWidget = this.getWidget();
        AquaUIPainter.Orientation orientation = bl ? AquaUIPainter.Orientation.VERTICAL : AquaUIPainter.Orientation.HORIZONTAL;
        SplitPaneDividerLayoutConfiguration splitPaneDividerLayoutConfiguration = new SplitPaneDividerLayoutConfiguration(dividerWidget, orientation, 0);
        LayoutInfo layoutInfo = this.painter.getLayoutInfo().getLayoutInfo(splitPaneDividerLayoutConfiguration);
        return (int)(bl ? layoutInfo.getFixedVisualWidth() : layoutInfo.getFixedVisualHeight());
    }

    protected SplitPaneStyle getClientSpecifiedStyle() {
        Object object = this.splitPane.getClientProperty(SPLIT_PANE_STYLE_KEY);
        if (object != null) {
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals("thin")) {
                    return SplitPaneStyle.THIN;
                }
                if (string.equals("thick")) {
                    return SplitPaneStyle.THICK;
                }
                if (string.equals("paneSplitter")) {
                    return SplitPaneStyle.PANE_SPLITTER;
                }
            }
        } else {
            object = this.splitPane.getClientProperty(QUAQUA_SPLIT_PANE_STYLE_KEY);
            if (object instanceof String) {
                String string = (String)object;
                if (string.equals("bar")) {
                    return SplitPaneStyle.PANE_SPLITTER;
                }
                if (string.equals("thumb")) {
                    return SplitPaneStyle.THICK;
                }
            }
        }
        return null;
    }

    protected boolean isStyleProperty(String string) {
        return AquaUtils.isProperty(string, SPLIT_PANE_STYLE_KEY, QUAQUA_SPLIT_PANE_STYLE_KEY);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() < 2) {
            return;
        }
        if (!this.splitPane.isOneTouchExpandable()) {
            return;
        }
        double d = this.splitPane.getResizeWeight();
        int n = this.splitPane.getWidth();
        int n2 = this.splitPane.getDividerSize();
        int n3 = this.splitPane.getDividerLocation();
        int n4 = this.splitPane.getLastDividerLocation();
        if (n - n2 <= n3 + 5) {
            this.splitPane.setDividerLocation(n4);
            return;
        }
        if (n2 >= n3 - 5) {
            this.splitPane.setDividerLocation(n4);
            return;
        }
        if (d > 0.5) {
            this.splitPane.setDividerLocation(0);
        } else {
            this.splitPane.setDividerLocation(n);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string != null) {
            if (string.equals(DIVIDER_PAINTER_KEY)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object instanceof Border) {
                    this.divider.setBorder((Border)object);
                } else {
                    this.divider.setBorder(null);
                }
            } else if (this.isStyleProperty(string)) {
                this.updateStyle();
            }
        }
    }

    public static enum SplitPaneStyle {
        THIN,
        THICK,
        PANE_SPLITTER;

    }
}

